<?php (defined('BASEPATH')) or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title><?= $page_title . ' | ' . $Settings->site_name; ?></title>
    <link rel="shortcut icon" href="<?= $assets ?>img/iconoFSFT.png" />
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/font-awesome/css/font-awesome.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/iCheck/square/yellow.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/select2/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/redactor/redactor.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/jquery-ui.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/custom.css" rel="stylesheet" type="text/css" />

    <script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
    <style>
        /**************Navbar******************** */
        .navbar-custom-menu li a,
        .logo-lg {
            color: white;
        }

        .logo-lg {
            font-weight: bolder;
        }

        .logo-lg img {
            padding-right: 30px;
        }

        .nav>li>a:hover,
        .nav>li>a:active,
        .nav>li>a:focus,
        .navbar-static-top .sidebar-toggle:hover {
            color: #ffffff;
            background: #1b609c;
        }

        .sidebar-menu li a {
            color: #004785;
            border-bottom: 2px solid #d4d6db;
        }

        .main-header .sidebar-toggle {
            color: white;
            font-size: 20px;
            float: left;
            background-color: transparent;
            background-image: none;
            padding: 9px 9px;
            font-family: fontAwesome;
        }

        @media (max-width: 991px) {

            .main-header .navbar-custom-menu a,
            .main-header .navbar-right a {
                color: #ffffff;
                background: transparent;
            }
        }

        .user-footer a {
            color: black;
        }

        @media (max-width: 767px) {
            .main-header .logo {
                display: none;
            }
        }

        .navbar-nav>.user-menu>.dropdown-menu>li.user-header>p {
            z-index: 5;
            color: #666;
            font-size: 17px;
            margin-top: 10px;
        }

        .nav .open>a,
        .nav .open>a:focus,
        .nav .open>a:hover {
            background-color: #1b609c;
            border-color: #1b609c;
        }

        @media (max-width: 767px) {

            .fixed .content-wrapper,
            .fixed .right-side {
                padding-top: 37px;
            }

            .nav.navbar-nav li a i {
                color: white !important;
            }
        }

        /***********************Fin navbar************ */
        /**************Sidebar******************** */

        .sidebar-menu .active {
            background-color: #9fc10b;
        }

        .sidebar-menu li:hover {
            background-color: #9fc10b;
        }

        .treeview-menu {
            background-color: #D0D6D6 !important;
        }

        .treeview-menu.menu-open a {
            border-bottom: 1px solid #D0D6D6;
        }

        .treeview-menu.menu-open li:hover {
            background-color: #b9cc67;
        }

        .treeview-menu .divider {
            border-top: 1px solid #BBC0C0;
            border-bottom: 1px solid #BBC0C0;
            margin: 4px 0 4px -5px !important;
            display: block;
        }

        .sidebar-menu>li>a {
            padding: 8px 5px 12px 15px;
            display: block;
        }

        @media (max-width: 767px) {

            .main-sidebar,
            .left-side {
                padding-top: 50px !important;
            }
        }

        /***********************Fin Sidebar************ */
        /*******************loading ball************* */

        #ajaxCall {
            display: none;
            color: #004785;
            background: #dadadad1;
            border-radius: 0px;
            top: 40%;
            right: 35%;
            position: fixed;
            width: 30%;
            height: 23%;
            z-index: 1000;
            text-align: center;
            font-size: 100%;
        }

        #ajaxCall i {
            font-size: 100px;
        }

        /*******************fin loading ball************* */
        /*******************datatable************* */
        .dataTables_processing {
            display: none;
        }

        .table-responsive .dataTables_wrapper tbody {
            font-size: 13.5px !important;
        }

        .table-responsive .dataTables_wrapper .select2-selection.select2-selection--single,
        .table-responsive .dataTables_wrapper .form-control.input-xs {
            border-radius: 0px;
            margin: 0px;
            height: 30px;
        }

        .select2-results__option {
            padding: 3px 12px !important;
        }

        .table-responsive {
            border: 0px;
            overflow-x: auto !important;
        }

        /*******************datatable************* */
        /*******************Colores primary & success************* */
        .btn-primary {
            border-color: #17A2B8 !important;
            border-radius: 0px !important;
            background-color: #17A2B8 !important;
            color: white !important;
        }

        .btn-success {
            border-color: #28A745 !important;
            border-radius: 0px !important;
            background-color: #28A745 !important;
            color: white !important;
        }

        .btn-danger {
            border-color: #DC3545 !important;
            border-radius: 0px !important;
            background-color: #DC3545 !important;
            color: white !important;
        }

        #suss:hover {
            border-color: #28A745 !important;
            border-radius: 0px !important;
            background-color: #28A745 !important;
            color: white !important;
        }

        #dan:hover {
            border-color: #DC3545 !important;
            border-radius: 0px !important;
            background-color: #DC3545 !important;
            color: white !important;
        }

        #suss {
            border-color: #28A745 !important;
            border-radius: 0px !important;
            background-color: #fff !important;
            color: #28A745 !important;
        }

        #dan {
            border-color: #DC3545 !important;
            border-radius: 0px !important;
            background-color: #fff !important;
            color: #DC3545 !important;
        }

        .text-success {
            color: #28A745 !important;
        }

        .text-primary {
            color: #17A2B8 !important;
        }

        .alert.alert-success {
            background-color: #fff !important;
        }

        .alert-danger {
            background-color: #fff !important;
            color: #dd4b39 !important;
        }

        .alert.alert-warning {
            background-color: #ffff !important;
        }

        /*******************Colores primary & success************* */
        .btn-app {
            border-radius: 3px;
            position: relative;
            padding: 15px 5px;
            margin: 0 0 10px 10px;
            min-width: 80px;
            height: 65px;
            text-align: center;
            color: #004785;
            border: 1px solid #ddd;
            background-color: #f4f4f4;
            font-size: 12px;
        }

        .box {
            border-radius: .35rem !important;
            box-shadow: 0 0 1px rgba(0, 0, 0, .125), 0 1px 3px rgba(0, 0, 0, .2) !important;
            margin-bottom: 1rem !important;
        }

        .btn-app:hover {
            color: #9fc10b;
            border: 1px solid #9fc10b;
        }

        label {
            display: inline-block;
            max-width: 100%;
            margin-bottom: 5px;
            font-weight: 600;
        }

        .botones {
            padding-top: 26px !important;
            padding-left: 0px !important;
        }

        @media (max-width: 992px) {
            .botones {
                padding-top: 0px !important;
                padding-left: 15px !important;
            }
        }

        .navbar-nav .tooltip.bottom .tooltip-arrow {
            top: 0;
            left: 50%;
            margin-left: -5px;
            border-width: 0 5px 5px;
            border-bottom-color: #004785;
        }

        .navbar-nav .tooltip-inner {
            max-width: 200px;
            padding: 4px 8px;
            color: #fff;
            text-align: center;
            background-color: #004785;
            border-radius: 4px;
        }

        thead {
            color: #547da0 !important;
            background-color: #f4f4f4 !important;
        }

        tbody {
            color: #6b6c6d !important;
        }

        .label-danger {
            background-color: #F50606 !important;
        }
    </style>
</head>

<body class="fixed sidebar-mini">
    <div class="wrapper">
        <!-- -----------------------------INICIO DEL HEADER------------------------>
        <header class="main-header" style="background-color: #004785;">
            <a href="<?= site_url(); ?>" class="logo">
                <span class="logo-mini"><img src="<?= $assets ?>img/iconoFSFT.png" alt="'.$Settings->site_name.'" width='30px' /></span>
                <span class="logo-lg"><img src="<?= $assets ?>img/iconoFSFT.png" alt="'.$Settings->site_name.'" width='60px' /><span>FacsiSoft</span></span>
            </a>
            <nav class="navbar navbar-static-top" role="navigation">
                <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
                    <span class="sr-only">Navegación</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </a>
                <!--ul class="nav navbar-nav pull-left">
                    <li class="dropdown hidden-xs">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown"><img src="<?= $assets; ?>images/<?= $Settings->language; ?>.png" alt="<?= $Settings->language; ?>"></a>
                        <ul class="dropdown-menu">
                            <?php $scanned_lang_dir = array_map(function ($path) {
                                return basename($path);
                            }, glob(APPPATH . 'language/*', GLOB_ONLYDIR));
                            foreach ($scanned_lang_dir as $entry) { ?>
                                <li><a href="<?= site_url('pos/language/' . $entry); ?>"><img
                                            src="<?= $assets; ?>images/<?= $entry; ?>.png"
                                            class="language-img"> &nbsp;&nbsp;<?= ucwords($entry); ?></a></li>
                            <?php } ?>
                        </ul>
                    </li>
                </ul-->
                <div class="navbar-custom-menu">
                    <ul class="nav navbar-nav">
                        <li class="hidden-xs"><a href="#"><?= $Local; ?></a></li>
                        <li class="hidden-xs hidden-sm"><a href="#" class="clock"></a></li>
                        <li class="hidden-xs"><a href="#"><?= lang('exchange') . ": " . $Exchange->sell; ?></a></li>
                        <li class="hidden-xs" data-toggle="tooltip" data-placement="bottom" title="Menú"><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i></a></li>
                        <?php if ($Admin) { ?>
                            <li class="hidden-xs" data-toggle="tooltip" data-placement="bottom" title="Ajustes"><a href="<?= site_url('settings'); ?>"><i class="fa fa-cogs"></i></a></li>
                        <?php } ?>
                        <li data-toggle="tooltip" data-placement="bottom" title="Presupuesto"><a href="<?= site_url('pos/view_bill'); ?>" target="_blank"><i class="fa fa-file-text-o"></i></a></li>
                        <li data-toggle="tooltip" data-placement="bottom" title="TPV"><a href="<?= site_url('pos'); ?>"><i class="fa fa-th"></i></a></li>
                        <?php if ($Admin && $qty_alert_num) { ?>
                            <li data-toggle="tooltip" data-placement="bottom" title="Alerta de stock">
                                <a href="<?= site_url('reports/alerts'); ?>">
                                    <i class="fa fa-bullhorn"></i>
                                    <span class="label label-danger"><?= $qty_alert_num; ?></span>
                                </a>
                            </li>
                        <?php } ?>
                        <?php if ($suspended_sales) { ?>
                            <li class="dropdown notifications-menu">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-bell-o"></i>
                                    <span class="label label-danger"><?= sizeof($suspended_sales); ?></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li class="header"><?= lang('recent_suspended_sales'); ?></li>
                                    <li>
                                        <ul class="menu">
                                            <li>
                                                <?php
                                                foreach ($suspended_sales as $ss) {
                                                    echo '<a href="' . site_url('pos/?hold=' . $ss->id) . '" class="load_suspended">' . $this->tec->hrld($ss->date) . ' (' . $ss->customer_name . ')<br><strong>' . $ss->hold_ref . '</strong></a>';
                                                }
                                                ?>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class="footer"><a href="<?= site_url('sales/opened'); ?>"><?= lang('view_all'); ?></a></li>
                                </ul>
                            </li>
                        <?php } ?>
                        <li class="dropdown user user-menu" style="padding-right:5px;">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <img src="<?= base_url('uploads/avatars/thumbs/' . ($this->session->userdata('avatar') ? $this->session->userdata('avatar') : $this->session->userdata('gender') . '.png')) ?>" class="user-image" alt="Avatar" />
                                <span class="hidden-xs"><?= $this->session->userdata('first_name') . ' ' . $this->session->userdata('last_name'); ?></span>
                            </a>
                            <ul class="dropdown-menu" style="padding-right:3px;">
                                <li class="user-header">
                                    <img src="<?= base_url('uploads/avatars/' . ($this->session->userdata('avatar') ? $this->session->userdata('avatar') : $this->session->userdata('gender') . '.png')) ?>" class="img-circle" alt="Avatar" />
                                    <p>
                                        <?= $this->session->userdata('email'); ?>
                                        <small><?= lang('member_since') . ' ' . $this->session->userdata('created_on'); ?></small>
                                    </p>
                                </li>
                                <li class="user-footer">
                                    <div class="pull-left">
                                        <a href="<?= site_url('users/profile/' . $this->session->userdata('user_id')); ?>" id="suss" class="btn btn-flat">Perfil</a>
                                    </div>
                                    <div class="pull-right">
                                        <a href="<?= site_url('logout'); ?>" id="dan" class="btn btn-flat">Salir</a>
                                    </div>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>
        <!-- -----------------------------FIN DEL HEADER------------------------>
        <!-- -----------------------------INICIO DEL MENU------------------------>
        <?php if ($this->session->userdata('modulos') == 1) { ?>
        <aside class="main-sidebar" style="background-color: #E3E8EB;">
            <section class="sidebar" style="padding-top: 8px;">
                <ul class="sidebar-menu">
                    <!-- <li class="header"><?= lang('mian_navigation'); ?></li> -->

                    <li class="mm_welcome"><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i> <span><?= lang('dashboard'); ?></span></a></li>

                    <?php if ($Admin) { ?>

                        <li id="pos_index">
                            <a href="<?= site_url('pos'); ?>">
                                <i class="fa fa-th"></i> <span><?= lang('pos'); ?></span>
                            </a>
                        </li>
                        <li class="treeview mm_products mm_warehouses mm_makers mm_brands mm_models mm_measure_units mm_categories mm_warehouses mm_referral_guide mm_guides">
                            <a href="#">
                                <i class="fa fa-folder"></i>
                                <span><?= "Módulo Almacén"; ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li class="treeview mm_products mm_makers mm_brands mm_models mm_measure_units mm_categories">
                                    <!-- <a href="#">
                                <i class="fa fa-barcode"></i>
                                <span><?= lang('products'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->

                                <li id="products_index">
                                    <a href="<?= site_url('products'); ?>">
                                        <i class="fa fa-barcode"></i> <?= lang('list_products'); ?>
                                    </a>
                                </li>
                                <!--<li id="products_add">
                                    <a href="< ?= site_url('products/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= lang('add_product'); ? >
                                    </a>
                                </li>-->
                                <li id="products_import">
                                    <a href="<?= site_url('products/import'); ?>">
                                        <i class="fa fa-download"></i> <?= lang('import_products'); ?>
                                    </a>
                                </li>
                                <li id="products_print_barcodes">
                                    <a onclick="window.open('<?= site_url('products/print_barcodes'); ?>', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;" href="#">
                                        <i class="fa fa-print"></i> <?= lang('print_barcodes'); ?>
                                    </a>
                                </li>

                                <li id="products_print_labels">
                                    <a onclick="window.open('<?= site_url('products/print_labels'); ?>', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;" href="#">
                                        <i class="fa fa-print"></i> <?= lang('print_labels'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="warehouses_index">
                                    <a href="<?= site_url('warehouses'); ?>">
                                        <i class="fa fa-building"></i> <?= lang('warehouse'); ?>
                                    </a>
                                </li>
                                <li id="warehouses_transfers">
                                    <a href="<?= site_url('warehouses/transfers'); ?>">
                                        <i class="fa fa-compress"></i> <?= lang('transfer_s'); ?>
                                    </a>
                                </li>
                                <li id="guides_entrance">
                                    <a href="<?= site_url('guides_entrance/i'); ?>">
                                        <i class="fa fa-file-text-o"></i> <?= lang('list_guides_entrance'); ?>
                                    </a>
                                </li>
                                <li id="guides_departure">
                                    <a href="<?= site_url('guides_departure/s'); ?>">
                                        <i class="fa fa-file-text-o"></i> <?= lang('list_guides_departure'); ?>
                                    </a>
                                </li>

                                <li id="makers_index_RG">
                                    <a href="<?= site_url('Referral_guide'); ?>">
                                        <i class="fa fa-file-text-o"></i> <?= lang('list_referral_guide'); ?>
                                    </a>
                                </li>
                                <li id="makers_index_RG_add">
                                    <a href="<?= site_url('Referral_guide/add'); ?>">
                                        <i class="fa fa-file-text-o"></i> <?= lang('add_referral_guide'); ?>
                                    </a>
                                </li>

                                <li id="products_movements">
                                    <a href="<?= site_url('products/movements'); ?>">
                                        <i class="fa fa-arrows-alt""></i> <?= lang('movements_search'); ?>
                                    </a>
                                </li>
                                <li class=" divider">
                                </li>
                                <li id="categories_index">
                                    <a href="<?= site_url('categories'); ?>">
                                        <i class="fa fa-folder-open"></i> <?= lang('list_categories'); ?>
                                    </a>
                                </li>
                                <!--<li id="categories_add">
                                    <a href="< ?= site_url('categories/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= lang('add_category'); ? >
                                    </a>
                                </li>-->
                                <li id="categories_import">
                                    <a href="<?= site_url('categories/import'); ?>">
                                        <i class="fa fa-download"></i> <?= lang('import_categories'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="brands_index">
                                    <a href="<?= site_url('brands'); ?>">
                                        <i class="fa fa-tag"></i> <?= lang('brands'); ?>
                                    </a>
                                </li>
                                <li id="models_index">
                                    <a href="<?= site_url('models'); ?>">
                                        <i class="fa fa-tags"></i> <?= lang('models'); ?>
                                    </a>
                                </li>
                                <?php switch ($this->session->userdata('negocio')) {
                                    case 0:
                                        $l_makers = lang('makers');
                                        $l_maker_add = lang("add_maker");
                                        break;
                                    case 1:
                                        $l_makers = lang('laboratorys');
                                        $l_maker_add = lang("add_laboratory");
                                        break;
                                } ?>
                                <li id="maker_index_m">
                                    <a href="<?= site_url('makers'); ?>">
                                        <i class="fa fa-hospital-o"></i> <?= $l_makers; ?>
                                    </a>
                                </li>
                                <!--<li id="makers_add">
                                    <a href="< ?= site_url('makers/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= $l_maker_add; ? >
                                    </a>
                                </li>-->
                                <li id="measure_units_index">
                                    <a href="<?= site_url('measure_units'); ?>">
                                        <i class="fa fa-sort-alpha-desc"></i> <?= lang('measure_units'); ?>
                                    </a>
                                </li>

                        </li>
                        <li class="treeview mm_warehouses mm_referral_guide mm_guides">
                            <!-- <a href="#">
                                <i class="fa fa-building"></i>
                                <span><?= "Almacén"; ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->

                            <!--<li id="warehouses_add">
                                    <a href="< ?= site_url('warehouses/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= lang('add_warehouse'); ? >
                                    </a>
                                </li>-->
                            <!-- <li id="warehouses_transfers">
                                    <a href="<?= site_url('warehouses/transfers'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('transfer_s'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="guides_entrance">
                                    <a href="<?= site_url('guides_entrance/i'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('list_guides_entrance'); ?>
                                    </a>
                                </li>
                                <li id="guides_departure">
                                    <a href="<?= site_url('guides_departure/s'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('list_guides_departure'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="makers_index_RG">
                                    <a href="<?= site_url('Referral_guide'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('list_referral_guide'); ?>
                                    </a>
                                </li>
                                <li id="makers_index_RG_add">
                                    <a href="<?= site_url('Referral_guide/add'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('add_referral_guide'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="products_movements">
                                    <a href="<?= site_url('products/movements'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('movements_search'); ?>
                                    </a>
                                </li> -->
                            <!-- </ul> -->
                        </li>
                </ul>
                </li>
                <li class="treeview mm_gift_cards mm_sales mm_credit_note mm_customers mm_customers_type mm_pos">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Ventas"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_sales mm_credit_note mm_customers mm_customers_type mm_pos">
                            <!-- <a href="#">
                                <i class="fa fa-shopping-cart"></i>
                                <span><?= lang('sales'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="sales_index">
                            <a href="<?= site_url('sales'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_sales'); ?>
                            </a>
                        </li>
                        <li id="sales_add">
                            <a href="<?= site_url('sales/add'); ?>">
                                <i class="fa fa-shopping-cart"></i> <?= lang('add_sale'); ?>
                            </a>
                        </li>
                        <!-- <li class="divider"></li> -->

                        <?php if ($Admin) { ?>
                            <li class="divider"></li>
                            <li id="credit_note_index">
                                <a href="<?= site_url('credit_note'); ?>">
                                    <i class="fa fa-check-square"></i> <?= lang('list_credit_note'); ?>
                                </a>
                            </li>
                            <li id="credit_note_add">
                                <a href="<?= site_url('credit_note/add'); ?>">
                                    <i class="fa fa-list-alt"></i> <?= lang('add_credit_note'); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <?php if ($this->session->userdata('traders') == 1) { ?>
                            <li class="divider"></li>
                            <li id="">
                                <a href="<?= site_url('traders'); ?>">
                                    <i class="fa fa-check-square"></i> <?= lang('list_traders'); ?>
                                </a>
                            </li>
                            <li id="traders_add">
                                <a href="<?= site_url('traders/add'); ?>">
                                    <i class="fa fa-users"></i> <?= lang('add_trader'); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <li class="divider"></li>
                        <li id="customers_index">
                            <a href="<?= site_url('customers'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_customers'); ?>
                            </a>
                        </li>
                        <li id="customers_add">
                            <a href="<?= site_url('customers/add'); ?>">
                                <i class="fa fa-users"></i> <?= lang('add_customer'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="customers_type_index">
                            <a href="<?= site_url('customers_type'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_customers_type'); ?>
                            </a>
                        </li>
                        <li id="customers_type_add">
                            <a href="<?= site_url('customers_type/add'); ?>">
                                <i class="fa fa-user"></i> <?= lang('add_customer_type'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                <li class="treeview mm_gift_cards">
                <li class="divider"></li>
                <!-- <ul class="treeview-menu"> -->
                <li id="gift_cards_index">
                    <a href="<?= site_url('gift_cards'); ?>">
                        <i class="fa fa-check-square"></i> <?= lang('list_gift_cards'); ?>
                    </a>
                </li>
                <li id="gift_cards_add">
                    <a href="<?= site_url('gift_cards/add'); ?>">
                        <i class="fa fa-credit-card"></i> <?= lang('add_gift_card'); ?>
                    </a>
                </li>
                <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_purchases mm_mpurchases mm_suppliers">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Compras"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_purchases mm_suppliers">
                            <!-- <a href="#">
                                <i class="fa fa-dollar"></i>
                                <span><?= lang('purchases'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="purchases_index">
                            <a href="<?= site_url('purchases'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_purchases'); ?>
                            </a>
                        </li>
                        <li id="purchases_add">
                            <a href="<?= site_url('purchases/add'); ?>">
                                <i class="fa fa-plus"></i> <?= lang('add_purchase'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="suppliers_index">
                            <a href="<?= site_url('suppliers'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_suppliers'); ?>
                            </a>
                        </li>
                        <li id="suppliers_add">
                            <a href="<?= site_url('suppliers/add'); ?>">
                                <i class="fa fa-building"></i> <?= lang('add_supplier'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                <li class="treeview mm_mpurchases">
                    <!-- <a href="#">
                                <i class="fa fa-plus"></i>
                                <span><?= "Gastos"; ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                    <!-- <ul class="treeview-menu"> -->
                <li class="divider"></li>
                <li id="mpurchases_expenses">
                    <a href="<?= site_url('purchases/expenses'); ?>">
                        <i class="fa fa-check-square"></i> <?= lang('list_expenses'); ?>
                    </a>
                </li>
                <li id="mpurchases_add_expense">
                    <a href="<?= site_url('purchases/add_expense'); ?>">
                        <i class="fa fa-money"></i> <?= lang('add_expense'); ?>
                    </a>
                </li>
                <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_summaries">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Fact. Electrónica"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_summaries">
                            <!-- <a href="#">
                                <i class="fa fa-money"></i>
                                <span><?= lang('accounting'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="summaries_index">
                            <a href="<?= site_url('summaries'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_summaries'); ?>
                            </a>
                        </li>
                        <li id="summaries_add">
                            <a href="<?= site_url('summaries/add'); ?>">
                                <i class="fa fa-plus"></i> <?= lang('add_summary'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_auth">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Seguridad"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_auth">


                        <li id="auth_users">
                            <a href="<?= site_url('users'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_users'); ?>
                            </a>
                        </li>
                        <li id="auth_create_user">
                            <a href="<?= site_url('users/add'); ?>">
                                <i class="fa fa-user"></i> <?= lang('add_user'); ?>
                            </a>
                        </li>

                </li>
                </ul>
                </li>
                <li class="treeview mm_reports">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Reportes"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_reports">


                        <li id="reports_daily_sales"><a href="<?= site_url('reports/daily_sales'); ?>"><i class="fa fa-shopping-cart"></i> <?= lang('daily_sales'); ?></a></li>
                        <li id="reports_monthly_sales"><a href="<?= site_url('reports/monthly_sales'); ?>"><i class="fa fa-shopping-cart"></i> <?= lang('monthly_sales'); ?></a></li>
                        <li id="reports_index"><a href="<?= site_url('reports'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('sales_report'); ?></a></li>
                        <li class="divider"></li>
                        <li id="reports_payments"><a href="<?= site_url('reports/payments'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('payments_report'); ?></a></li>
                        <li class="divider"></li>
                        <li id="reports_registers"><a href="<?= site_url('reports/registers'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('registers_report'); ?></a></li>
                        <li class="divider"></li>
                        <li id="reports_top_products"><a href="<?= site_url('reports/top_products'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('top_products'); ?></a></li>
                        <li id="reports_products"><a href="<?= site_url('reports/products'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('products_report'); ?></a></li>

                </li>
                </ul>
                </li>
                <li class="treeview mm_settings mm_locals mm_series mm_document_type mm_payment_methods">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo General"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_settings mm_locals mm_series mm_document_type mm_payment_methods">
                            <!-- <a href="#">
                                <i class="fa fa-cogs"></i>
                                <span><?= lang('settings'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="settings_index">
                            <a href="<?= site_url('settings'); ?>">
                                <i class="fa fa-cogs"></i> <?= lang('settings'); ?>

                            </a>
                        </li>
                        <li id="settings_backups">
                            <a href="<?= site_url('settings/backups'); ?>">
                                <i class="fa fa-database"></i> <?= lang('backups'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="locals_index">
                            <a href="<?= site_url('locals'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_locals'); ?>
                            </a>
                        </li>
                        <li id="locals_add">
                            <a href="<?= site_url('locals/add'); ?>">
                                <i class="fa fa-map-marker"></i> <?= lang('add_local'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="document_type_index">
                            <a href="<?= site_url('document_type'); ?>">
                                <i class="fa fa-file"></i> <?= lang('tipes_of_documents'); ?>
                            </a>
                        </li>
                        <li id="series_index">
                            <a href="<?= site_url('series'); ?>">
                                <i class="fa fa-barcode"></i> <?= lang('series_per_document'); ?>
                            </a>
                        </li>
                        <li id="payment_methods_index">
                            <a href="<?= site_url('payment_methods'); ?>">
                                <i class="fa fa-dollar"></i> <?= lang('payment_methods'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                </ul>
                </li>

            <?php } elseif ($Staff) { ?>
                <li id="pos_index">
                    <a href="<?= site_url('pos'); ?>">
                        <i class="fa fa-th"></i> <span><?= lang('pos'); ?></span>
                    </a>
                </li>
                <li class="treeview mm_products mm_warehouses mm_makers mm_brands mm_models mm_measure_units mm_categories mm_warehouses mm_referral_guide mm_guides">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Almacén"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_products mm_makers mm_brands mm_models mm_measure_units mm_categories">
                            <!-- <a href="#">
                                <i class="fa fa-barcode"></i>
                                <span><?= lang('products'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->

                        <li id="products_index">
                            <a href="<?= site_url('products'); ?>">
                                <i class="fa fa-barcode"></i> <?= lang('list_products'); ?>
                            </a>
                        </li>
                        <!--<li id="products_add">
                                    <a href="< ?= site_url('products/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= lang('add_product'); ? >
                                    </a>
                                </li>-->
                        <li id="products_import">
                            <a href="<?= site_url('products/import'); ?>">
                                <i class="fa fa-download"></i> <?= lang('import_products'); ?>
                            </a>
                        </li>
                        <li id="products_print_barcodes">
                            <a onclick="window.open('<?= site_url('products/print_barcodes'); ?>', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;" href="#">
                                <i class="fa fa-print"></i> <?= lang('print_barcodes'); ?>
                            </a>
                        </li>

                        <li id="products_print_labels">
                            <a onclick="window.open('<?= site_url('products/print_labels'); ?>', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;" href="#">
                                <i class="fa fa-print"></i> <?= lang('print_labels'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="warehouses_index">
                            <a href="<?= site_url('warehouses'); ?>">
                                <i class="fa fa-building"></i> <?= lang('warehouse'); ?>
                            </a>
                        </li>
                        <li id="warehouses_transfers">
                            <a href="<?= site_url('warehouses/transfers'); ?>">
                                <i class="fa fa-compress"></i> <?= lang('transfer_s'); ?>
                            </a>
                        </li>
                        <li id="guides_entrance">
                            <a href="<?= site_url('guides_entrance/i'); ?>">
                                <i class="fa fa-file-text-o"></i> <?= lang('list_guides_entrance'); ?>
                            </a>
                        </li>
                        <li id="guides_departure">
                            <a href="<?= site_url('guides_departure/s'); ?>">
                                <i class="fa fa-file-text-o"></i> <?= lang('list_guides_departure'); ?>
                            </a>
                        </li>

                        <li id="makers_index_RG">
                            <a href="<?= site_url('Referral_guide'); ?>">
                                <i class="fa fa-file-text-o"></i> <?= lang('list_referral_guide'); ?>
                            </a>
                        </li>
                        <li id="makers_index_RG_add">
                            <a href="<?= site_url('Referral_guide/add'); ?>">
                                <i class="fa fa-file-text-o"></i> <?= lang('add_referral_guide'); ?>
                            </a>
                        </li>

                        <li id="products_movements">
                            <a href="<?= site_url('products/movements'); ?>">
                                <i class="fa fa-arrows-alt""></i> <?= lang('movements_search'); ?>
                                    </a>
                                </li>
                                <li class=" divider">
                        </li>
                        <li id="categories_index">
                            <a href="<?= site_url('categories'); ?>">
                                <i class="fa fa-folder-open"></i> <?= lang('list_categories'); ?>
                            </a>
                        </li>
                        <!--<li id="categories_add">
                                    <a href="< ?= site_url('categories/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= lang('add_category'); ? >
                                    </a>
                                </li>-->
                        <li id="categories_import">
                            <a href="<?= site_url('categories/import'); ?>">
                                <i class="fa fa-download"></i> <?= lang('import_categories'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="brands_index">
                            <a href="<?= site_url('brands'); ?>">
                                <i class="fa fa-tag"></i> <?= lang('brands'); ?>
                            </a>
                        </li>
                        <li id="models_index">
                            <a href="<?= site_url('models'); ?>">
                                <i class="fa fa-tags"></i> <?= lang('models'); ?>
                            </a>
                        </li>
                        <?php switch ($this->session->userdata('negocio')) {
                            case 0:
                                $l_makers = lang('makers');
                                $l_maker_add = lang("add_maker");
                                break;
                            case 1:
                                $l_makers = lang('laboratorys');
                                $l_maker_add = lang("add_laboratory");
                                break;
                        } ?>
                        <li id="maker_index_m">
                            <a href="<?= site_url('makers'); ?>">
                                <i class="fa fa-hospital-o"></i> <?= $l_makers; ?>
                            </a>
                        </li>
                        <!--<li id="makers_add">
                                    <a href="< ?= site_url('makers/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= $l_maker_add; ? >
                                    </a>
                                </li>-->
                        <li id="measure_units_index">
                            <a href="<?= site_url('measure_units'); ?>">
                                <i class="fa fa-sort-alpha-desc"></i> <?= lang('measure_units'); ?>
                            </a>
                        </li>

                </li>
                <li class="treeview mm_warehouses mm_referral_guide mm_guides">
                    <!-- <a href="#">
                                <i class="fa fa-building"></i>
                                <span><?= "Almacén"; ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                    <!-- <ul class="treeview-menu"> -->

                    <!--<li id="warehouses_add">
                                    <a href="< ?= site_url('warehouses/add'); ? >">
                                        <i class="fa fa-circle-o"></i> < ?= lang('add_warehouse'); ? >
                                    </a>
                                </li>-->
                    <!-- <li id="warehouses_transfers">
                                    <a href="<?= site_url('warehouses/transfers'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('transfer_s'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="guides_entrance">
                                    <a href="<?= site_url('guides_entrance/i'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('list_guides_entrance'); ?>
                                    </a>
                                </li>
                                <li id="guides_departure">
                                    <a href="<?= site_url('guides_departure/s'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('list_guides_departure'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="makers_index_RG">
                                    <a href="<?= site_url('Referral_guide'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('list_referral_guide'); ?>
                                    </a>
                                </li>
                                <li id="makers_index_RG_add">
                                    <a href="<?= site_url('Referral_guide/add'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('add_referral_guide'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li id="products_movements">
                                    <a href="<?= site_url('products/movements'); ?>">
                                        <i class="fa fa-circle-o"></i> <?= lang('movements_search'); ?>
                                    </a>
                                </li> -->
                    <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_gift_cards mm_sales mm_credit_note mm_customers mm_customers_type mm_pos">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Ventas"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_sales mm_credit_note mm_customers mm_customers_type mm_pos">
                            <!-- <a href="#">
                                <i class="fa fa-shopping-cart"></i>
                                <span><?= lang('sales'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="sales_index">
                            <a href="<?= site_url('sales'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_sales'); ?>
                            </a>
                        </li>
                        <li id="sales_add">
                            <a href="<?= site_url('sales/add'); ?>">
                                <i class="fa fa-shopping-cart"></i> <?= lang('add_sale'); ?>
                            </a>
                        </li>
                        <!-- <li class="divider"></li> -->

                        <?php if ($Admin) { ?>
                            <li class="divider"></li>
                            <li id="credit_note_index">
                                <a href="<?= site_url('credit_note'); ?>">
                                    <i class="fa fa-check-square"></i> <?= lang('list_credit_note'); ?>
                                </a>
                            </li>
                            <li id="credit_note_add">
                                <a href="<?= site_url('credit_note/add'); ?>">
                                    <i class="fa fa-list-alt"></i> <?= lang('add_credit_note'); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <li class="divider"></li>
                        <li id="customers_index">
                            <a href="<?= site_url('customers'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_customers'); ?>
                            </a>
                        </li>
                        <li id="customers_add">
                            <a href="<?= site_url('customers/add'); ?>">
                                <i class="fa fa-users"></i> <?= lang('add_customer'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="customers_type_index">
                            <a href="<?= site_url('customers_type'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('customers_type'); ?>
                            </a>
                        </li>
                        <li id="customers_type_add">
                            <a href="<?= site_url('customers_type/add'); ?>">
                                <i class="fa fa-user"></i> <?= lang('add_customer_type'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                <li class="treeview mm_gift_cards">
                <li class="divider"></li>
                <!-- <ul class="treeview-menu"> -->
                <li id="gift_cards_index">
                    <a href="<?= site_url('gift_cards'); ?>">
                        <i class="fa fa-check-square"></i> <?= lang('list_gift_cards'); ?>
                    </a>
                </li>
                <li id="gift_cards_add">
                    <a href="<?= site_url('gift_cards/add'); ?>">
                        <i class="fa fa-credit-card"></i> <?= lang('add_gift_card'); ?>
                    </a>
                </li>
                <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_purchases mm_mpurchases mm_suppliers">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Compras"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_purchases mm_suppliers">
                            <!-- <a href="#">
                                <i class="fa fa-dollar"></i>
                                <span><?= lang('purchases'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="purchases_index">
                            <a href="<?= site_url('purchases'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_purchases'); ?>
                            </a>
                        </li>
                        <li id="purchases_add">
                            <a href="<?= site_url('purchases/add'); ?>">
                                <i class="fa fa-plus"></i> <?= lang('add_purchase'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="suppliers_index">
                            <a href="<?= site_url('suppliers'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_suppliers'); ?>
                            </a>
                        </li>
                        <li id="suppliers_add">
                            <a href="<?= site_url('suppliers/add'); ?>">
                                <i class="fa fa-building"></i> <?= lang('add_supplier'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                <li class="treeview mm_mpurchases">
                    <!-- <a href="#">
                                <i class="fa fa-plus"></i>
                                <span><?= "Gastos"; ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                    <!-- <ul class="treeview-menu"> -->
                <li class="divider"></li>
                <li id="mpurchases_expenses">
                    <a href="<?= site_url('purchases/expenses'); ?>">
                        <i class="fa fa-check-square"></i> <?= lang('list_expenses'); ?>
                    </a>
                </li>
                <li id="mpurchases_add_expense">
                    <a href="<?= site_url('purchases/add_expense'); ?>">
                        <i class="fa fa-money"></i> <?= lang('add_expense'); ?>
                    </a>
                </li>
                <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_summaries">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Fact. Electrónica"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_summaries">
                            <!-- <a href="#">
                                <i class="fa fa-money"></i>
                                <span><?= lang('accounting'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="summaries_index">
                            <a href="<?= site_url('summaries'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_summaries'); ?>
                            </a>
                        </li>
                        <li id="summaries_add">
                            <a href="<?= site_url('summaries/add'); ?>">
                                <i class="fa fa-plus"></i> <?= lang('add_summary'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                </ul>
                </li>
                <!-- <li class="treeview mm_auth">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Seguridad"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_auth">
                            
                            
                                <li id="auth_users">
                                    <a href="<?= site_url('users'); ?>">
                                        <i class="fa fa-check-square"></i> <?= lang('list_users'); ?>
                                    </a>
                                </li>
                                <li id="auth_create_user">
                                    <a href="<?= site_url('users/add'); ?>">
                                        <i class="fa fa-user"></i> <?= lang('add_user'); ?>
                                    </a>
                                </li>
                            
                        </li>
                    </ul>
                </li> -->
                <li class="treeview mm_reports">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Reportes"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_reports">


                        <li id="reports_daily_sales"><a href="<?= site_url('reports/daily_sales'); ?>"><i class="fa fa-shopping-cart"></i> <?= lang('daily_sales'); ?></a></li>
                        <li id="reports_monthly_sales"><a href="<?= site_url('reports/monthly_sales'); ?>"><i class="fa fa-shopping-cart"></i> <?= lang('monthly_sales'); ?></a></li>
                        <li id="reports_index"><a href="<?= site_url('reports'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('sales_report'); ?></a></li>
                        <li class="divider"></li>
                        <li id="reports_payments"><a href="<?= site_url('reports/payments'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('payments_report'); ?></a></li>
                        <li class="divider"></li>
                        <li id="reports_registers"><a href="<?= site_url('reports/registers'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('registers_report'); ?></a></li>
                        <li class="divider"></li>
                        <li id="reports_top_products"><a href="<?= site_url('reports/top_products'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('top_products'); ?></a></li>
                        <li id="reports_products"><a href="<?= site_url('reports/products'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('products_report'); ?></a></li>

                </li>
                </ul>
                </li>
                <li class="treeview mm_settings mm_locals mm_series mm_document_type mm_payment_methods">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo General"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_settings mm_locals mm_series mm_document_type mm_payment_methods">
                            <!-- <a href="#">
                                <i class="fa fa-cogs"></i>
                                <span><?= lang('settings'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="settings_index">
                            <a href="<?= site_url('settings'); ?>">
                                <i class="fa fa-cogs"></i> <?= lang('settings'); ?>

                            </a>
                        </li>
                        <!-- <li id="settings_backups">
                                    <a href="<?= site_url('settings/backups'); ?>">
                                        <i class="fa fa-database"></i> <?= lang('backups'); ?>
                                    </a>
                                </li> -->
                        <li class="divider"></li>
                        <li id="locals_index">
                            <a href="<?= site_url('locals'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_locals'); ?>
                            </a>
                        </li>
                        <li id="locals_add">
                            <a href="<?= site_url('locals/add'); ?>">
                                <i class="fa fa-map-marker"></i> <?= lang('add_local'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="document_type_index">
                            <a href="<?= site_url('document_type'); ?>">
                                <i class="fa fa-file"></i> <?= lang('tipes_of_documents'); ?>
                            </a>
                        </li>
                        <li id="series_index">
                            <a href="<?= site_url('series'); ?>">
                                <i class="fa fa-barcode"></i> <?= lang('series_per_document'); ?>
                            </a>
                        </li>
                        <li id="payment_methods_index">
                            <a href="<?= site_url('payment_methods'); ?>">
                                <i class="fa fa-dollar"></i> <?= lang('payment_methods'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                </ul>
                </li>


            <?php } elseif ($Caja) { ?>
                <li id="pos_index"><a href="<?= site_url('pos'); ?>"><i class="fa fa-th"></i> <span><?= lang('pos'); ?></span></a></li>
                <li class="treeview mm_products mm_categories">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Almacén"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_products mm_categories">
                            <!-- <a href="#">
                                    <i class="fa fa-barcode"></i>
                                    <span><?= lang('products'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="products_index">
                            <a href="<?= site_url('products'); ?>">
                                <i class="fa fa-barcode"></i> <?= lang('list_products'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="categories_index">
                            <a href="<?= site_url('categories'); ?>">
                                <i class="fa fa-align-justify"></i> <?= lang('list_categories'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_mpurchases mm_suppliers">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Compras"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_suppliers">
                            <!-- <a href="#">
                                    <i class="fa fa-dollar"></i>
                                    <span><?= lang('purchases'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="suppliers_index">
                            <a href="<?= site_url('suppliers'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_suppliers'); ?>
                            </a>
                        </li>
                        <li id="suppliers_add">
                            <a href="<?= site_url('suppliers/add'); ?>">
                                <i class="fa fa-building"></i> <?= lang('add_supplier'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                <li class="treeview mm_mpurchases">
                    <!-- <a href="#">
                                    <i class="fa fa-plus"></i>
                                    <span><?= "Gastos"; ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a> -->
                    <!-- <ul class="treeview-menu"> -->
                <li class="divider"></li>
                <li id="mpurchases_expenses">
                    <a href="<?= site_url('purchases/expenses'); ?>">
                        <i class="fa fa-check-square"></i> <?= lang('list_expenses'); ?>
                    </a>
                </li>
                <li id="mpurchases_add_expense">
                    <a href="<?= site_url('purchases/add_expense'); ?>">
                        <i class="fa fa-money"></i> <?= lang('add_expense'); ?>
                    </a>
                </li>
                <!-- </ul> -->
                </li>
                </ul>
                </li>
                <li class="treeview mm_gift_cards mm_sales mm_customers">
                    <a href="#">
                        <i class="fa fa-folder"></i>
                        <span><?= "Módulo Ventas"; ?></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li class="treeview mm_sales mm_customers">
                            <!-- <a href="#">
                                    <i class="fa fa-shopping-cart"></i>
                                    <span><?= lang('sales'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a> -->
                            <!-- <ul class="treeview-menu"> -->
                        <li id="sales_index">
                            <a href="<?= site_url('sales'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_sales'); ?>
                            </a>
                        </li>
                        <li id="sales_add">
                            <a href="<?= site_url('sales/add'); ?>">
                                <i class="fa fa-shopping-cart"></i> <?= lang('add_sale'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="sales_opened">
                            <a href="<?= site_url('sales/opened'); ?>">
                                <i class="fa fa-bell-o"></i> <?= lang('list_opened_bills'); ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li id="customers_index">
                            <a href="<?= site_url('customers'); ?>">
                                <i class="fa fa-check-square"></i> <?= lang('list_customers'); ?>
                            </a>
                        </li>
                        <li id="customers_add">
                            <a href="<?= site_url('customers/add'); ?>">
                                <i class="fa fa-user"></i> <?= lang('add_customer'); ?>
                            </a>
                        </li>
                        <!-- </ul> -->
                </li>
                <li class="treeview mm_gift_cards">
                    <!-- <a href="#">
                                    <i class="fa fa-credit-card"></i>
                                    <span><?= lang('gift_cards'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a> -->
                    <!-- <ul class="treeview-menu"> -->
                <li class="divider"></li>
                <li id="gift_cards_index">
                    <a href="<?= site_url('gift_cards'); ?>">
                        <i class="fa fa-check-square"></i> <?= lang('list_gift_cards'); ?>
                    </a>
                </li>
                <li id="gift_cards_add">
                    <a href="<?= site_url('gift_cards/add'); ?>">
                        <i class="fa fa-credit-card"></i> <?= lang('add_gift_card'); ?>
                    </a>
                </li>
                <!-- </ul> -->
                </li>
                </ul>
                </li>

            <?php } ?>

            </ul>
            </section>
        </aside>
        <?php }
        if ($this->session->userdata('modulos') == 0) { ?>
        <aside class="main-sidebar" style="background-color: #E3E8EB;">
            <section class="sidebar" style="padding-top: 8px;">
                <ul class="sidebar-menu">
                    <li class="mm_welcome"><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i> <span><?= lang('dashboard'); ?></span></a></li>
                    <?php if ($Admin) { ?>
                    <li id="pos_index">
                        <a href="<?= site_url('pos'); ?>">
                            <i class="fa fa-th"></i> <span><?= lang('pos'); ?></span>
                        </a>
                    </li>
                    <li class="treeview mm_products mm_warehouses mm_makers mm_brands mm_models mm_measure_units mm_warehouses mm_referral_guide mm_guides mm_categories">
                        <a href="#"><i class="fa fa-barcode"></i> <span><?= lang('warehouse_s'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_products mm_makers mm_brands mm_models mm_measure_units mm_categories">
                                <li id="products_index"><a href="<?= site_url('products'); ?>"><i class="fa fa-barcode"></i> <?= lang('list_products'); ?></a></li>
                                <!--<li id="products_add"><a href="< ?= site_url('products/add'); ? >"><i class="fa fa-circle-o"></i> < ?= lang('add_product'); ? ></a></li>-->
                                <li id="products_import"><a href="<?= site_url('products/import'); ?>"><i class="fa fa-download"></i> <?= lang('import_products'); ?></a></li>
                                <li id="products_print_barcodes"><a onclick="window.open('<?= site_url('products/print_barcodes'); ?>', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;" href="#"><i class="fa fa-print"></i> <?= lang('print_barcodes'); ?></a></li>
                                <li id="products_print_labels"><a onclick="window.open('<?= site_url('products/print_labels'); ?>', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;" href="#"><i class="fa fa-print"></i> <?= lang('print_labels'); ?></a></li>
                                <li id="categories_index"><a href="<?= site_url('categories'); ?>"><i class="fa fa-folder-open"></i> <?= lang('list_categories'); ?></a></li>
                                <!--<li id="categories_add"><a href="<?= site_url('categories/add'); ?>"><i class="fa fa-circle-o"></i> <?=lang('add_category'); ?></a></li>-->
                                <li id="categories_import"><a href="<?= site_url('categories/import'); ?>"><i class="fa fa-download"></i> <?= lang('import_categories'); ?></a></li>
                                <li id="brands_index"><a href="<?= site_url('brands'); ?>"><i class="fa fa-tag"></i> <?= lang('brands'); ?></a></li>
                                <li id="models_index"><a href="<?= site_url('models'); ?>"><i class="fa fa-tags"></i> <?= lang('models'); ?></a></li>
                                <?php switch ($this->session->userdata('negocio')) {
                                    case 0:
                                        $l_makers = lang('makers');
                                        $l_maker_add = lang("add_maker");
                                        break;
                                    case 1:
                                        $l_makers = lang('laboratorys');
                                        $l_maker_add = lang("add_laboratory");
                                        break;
                                } ?>
                                <li id="maker_index_m"><a href="<?= site_url('makers'); ?>"><i class="fa fa-hospital-o"></i> <?= $l_makers; ?></a></li>
                                <!--<li id="makers_add"><a href="< ?= site_url('makers/add'); ? >"><i class="fa fa-circle-o"></i> < ?= $l_maker_add; ? ></a></li>-->
                                <li id="measure_units_index"><a href="<?= site_url('measure_units'); ?>"><i class="fa fa-sort-alpha-desc"></i> <?= lang('measure_units'); ?></a></li>
                                <li class="divider"></li>

                                <li id="warehouses_index"><a href="<?= site_url('warehouses'); ?>"><i class="fa fa-building"></i> <?= lang('warehouse'); ?></a></li>
                                <li id="warehouses_transfers"><a href="<?= site_url('warehouses/transfers'); ?>"><i class="fa fa-compress"></i> <?= lang('transfer_s'); ?></a></li>
                                <!--<li id="guides_entrance"><a href="<?= site_url('guides_entrance/i'); ?>"><i class="fa fa-file-text-o"></i> <?= lang('list_guides_entrance'); ?></a></li>
                                <li id="guides_departure"><a href="<?= site_url('guides_departure/s'); ?>"><i class="fa fa-file-text-o"></i> <?= lang('list_guides_departure'); ?></a></li>-->
                                <li id="makers_index_RG"><a href="<?= site_url('Referral_guide'); ?>"><i class="fa fa-file-text-o"></i> <?= lang('list_referral_guide'); ?></a></li>
                                <li id="makers_index_RG_add"><a href="<?= site_url('Referral_guide/add'); ?>"><i class="fa fa-file-text-o"></i> <?= lang('add_referral_guide'); ?></a></li>
                                <li id="products_movements"><a href="<?= site_url('products/movements'); ?>"><i class="fa fa-arrows-alt""></i> <?= lang('movements_search'); ?></a></li>
                                
                            </li>
                        </ul>
                    </li>
                    
                    <li class="treeview mm_gift_cards mm_sales mm_credit_note mm_pos">
                        <a href="#"><i class="fa fa-shopping-cart"></i><span><?= lang('sales'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_sales mm_credit_note mm_customers mm_customers_type mm_pos mm_traders">
                                <li id="sales_index"><a href="<?= site_url('sales'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_sales'); ?></a></li>
                                <li id="sales_add"><a href="<?= site_url('sales/add'); ?>"><i class="fa fa-shopping-cart"></i> <?= lang('add_sale'); ?></a></li>
                                <?php if ($Admin) { ?>
                                <li class="divider"></li>
                                <li id="credit_note_index"><a href="<?= site_url('credit_note'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_credit_note'); ?></a></li>
                                <li id="credit_note_add"><a href="<?= site_url('credit_note/add'); ?>"><i class="fa fa-list-alt"></i> <?= lang('add_credit_note'); ?></a></li>
                                <?php } ?>
                                <?php if ($this->session->userdata('traders') == 1) { ?>
                                <li class="divider"></li>
                                <li id=""><a href="<?= site_url('traders'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_traders'); ?></a></li>
                                <li id="traders_add"><a href="<?= site_url('traders/add'); ?>"><i class="fa fa-users"></i> <?= lang('add_trader'); ?></a></li>
                                <?php } ?>
                                <li class="divider"></li>
                            <li id="customers_index"><a href="<?= site_url('customers'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_customers'); ?></a></li>
                            <li id="customers_add"><a href="<?= site_url('customers/add'); ?>"><i class="fa fa-users"></i> <?= lang('add_customer'); ?></a></li>
                            <li class="divider"></li>
                            <li id="customers_type_index"><a href="<?= site_url('customers_type'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_customers_type'); ?></a></li>
                            <li id="customers_type_add"><a href="<?= site_url('customers_type/add'); ?>"><i class="fa fa-user"></i> <?= lang('add_customer_type'); ?></a></li>
                            </li>
                        </ul>
                    </li>
                    <li class="treeview mm_purchases mm_mpurchases"> 
                        <a href="#"><i class="fa fa-plus"></i><span><?= lang('purchases'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_purchases mm_suppliers">
                                <li id="purchases_index"><a href="<?= site_url('purchases'); ?>"> <i class="fa fa-check-square"></i> <?= lang('list_purchases'); ?></a></li>
                                <li id="purchases_add"><a href="<?= site_url('purchases/add'); ?>"> <i class="fa fa-plus"></i> <?= lang('add_purchase'); ?></a></li>
                            </li>
                            <li class="treeview mm_mpurchases mm_suppliers">
                                <li class="divider"></li>
                                <li id="mpurchases_expenses"><a href="<?= site_url('purchases/expenses'); ?>"> <i class="fa fa-check-square"></i> <?= lang('list_expenses'); ?></a></li>
                                <li id="mpurchases_add_expense"><a href="<?= site_url('purchases/add_expense'); ?>"> <i class="fa fa-money"></i> <?= lang('add_expense'); ?></a></li>
                                <li class="divider"></li>
                                <li id="suppliers_index"><a href="<?= site_url('suppliers'); ?>"> <i class="fa fa-check-square"></i> <?= lang('list_suppliers'); ?></a></li>
                                <li id="suppliers_add"><a href="<?= site_url('suppliers/add'); ?>"> <i class="fa fa-building"></i> <?= lang('add_supplier'); ?></a></li>
                            </li>
                        </ul>
                    </li>
                    <li class="treeview mm_summaries">
                        <a href="#"><i class="fa fa-money"></i><span><?= lang('accounting'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_summaries">
                                <li id="summaries_index"><a href="<?= site_url('summaries'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_summaries'); ?></a></li>
                                <li id="summaries_add"><a href="<?= site_url('summaries/add'); ?>"><i class="fa fa-plus"></i> <?= lang('add_summary'); ?></a></li>
                            </li>
                        </ul>
                    </li>
                    <li class="treeview mm_gift_cards">
                        <a href="#"><i class="fa fa-credit-card"></i><span><?=lang('gift_cards');?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_gift_cards">
                                <li id="gift_cards_index"> <a href="<?= site_url('gift_cards'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_gift_cards'); ?></a></li>
                                <li id="gift_cards_add"> <a href="<?= site_url('gift_cards/add'); ?>"><i class="fa fa-credit-card"></i> <?= lang('add_gift_card'); ?></a></li>
                            </li>
                        </ul>
                    </li>
                    <li class="treeview mm_auth"> 
                        <a href="#"><i class="fa fa-lock"></i><span><?=lang('segurity'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_auth">
                                <li id="auth_users"> <a href="<?= site_url('users'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_users'); ?></a></li>
                                <li id="auth_create_user"> <a href="<?= site_url('users/add'); ?>"><i class="fa fa-user"></i> <?= lang('add_user'); ?></a></li>
                            </li>
                            
                            
                        </ul>
                    </li>
                    <li class="treeview mm_reports">
                        <a href="#"><i class="fa fa-bar-chart-o"></i><span><?= lang('reports'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_reports">
                                <li id="reports_daily_sales"><a href="<?= site_url('reports/daily_sales'); ?>"><i class="fa fa-shopping-cart"></i> <?= lang('daily_sales'); ?></a></li>
                                <li id="reports_monthly_sales"><a href="<?= site_url('reports/monthly_sales'); ?>"><i class="fa fa-shopping-cart"></i> <?= lang('monthly_sales'); ?></a></li>
                                <li id="reports_index"><a href="<?= site_url('reports'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('sales_report'); ?></a></li>
                                <li class="divider"></li>
                                <li id="reports_payments"><a href="<?= site_url('reports/payments'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('payments_report'); ?></a></li>
                                <li class="divider"></li>
                                <li id="reports_registers"><a href="<?= site_url('reports/registers'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('registers_report'); ?></a></li>
                                <li class="divider"></li>
                                <li id="reports_top_products"><a href="<?= site_url('reports/top_products'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('top_products'); ?></a></li>
                                <li id="reports_products"><a href="<?= site_url('reports/products'); ?>"><i class="fa fa-bar-chart-o"></i> <?= lang('products_report'); ?></a></li>
                            </li>
                        </ul>
                    </li>
                    <li class="treeview mm_settings mm_locals mm_series mm_document_type mm_payment_methods">
                        <a href="#"><i class="fa fa-cogs"></i><span><?= lang('settings'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_settings mm_locals mm_series mm_document_type mm_payment_methods">
                                <li id="settings_index"><a href="<?= site_url('settings'); ?>"><i class="fa fa-cogs"></i> <?= lang('settings'); ?></a></li>
                                <li id="settings_backups"><a href="<?= site_url('settings/backups'); ?>"><i class="fa fa-database"></i> <?= lang('backups'); ?></a></li>
                                <li class="divider"></li>
                                <li id="locals_index"><a href="<?= site_url('locals'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_locals'); ?></a></li>
                                <li id="locals_add"><a href="<?= site_url('locals/add'); ?>"><i class="fa fa-map-marker"></i> <?= lang('add_local'); ?></a></li>
                                <!--<li class="divider"></li>
                                <li id="document_type_index"><a href="<?= site_url('document_type'); ?>"><i class="fa fa-file"></i> <?= lang('tipes_of_documents'); ?></a></li>
                                <li id="series_index"><a href="<?= site_url('series'); ?>"><i class="fa fa-barcode"></i> <?= lang('series_per_document'); ?></a></li>
                                <li id="payment_methods_index"><a href="<?= site_url('payment_methods'); ?>"><i class="fa fa-dollar"></i> <?= lang('payment_methods'); ?></a></li>-->
                            </li>
                        </ul>
                    </li>

                    <?php } elseif ($Staff) { ?>
                    <li id="pos_index">
                        <a href="<?= site_url('pos'); ?>"><i class="fa fa-th"></i> <span><?= lang('pos'); ?></span></a>
                    </li>
                    <li class="mm_products"><a href="<?= site_url('products'); ?>"><i class="fa fa-barcode"></i> <span><?= lang('products'); ?></span></a></li>
                    <li class="mm_categories"><a href="<?= site_url('catagories'); ?>"><i class="fa fa-folder-open"></i> <span><?= lang('categories'); ?></span></a></li>
            
                    <li class="treeview mm_sales">
                        <a href="#"><i class="fa fa-shopping-cart"></i><span><?= lang('sales'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="sales_index"><a href="<?= site_url('sales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_sales'); ?></a></li>
                            <li id="sales_opened"><a href="<?= site_url('sales/opened'); ?>"><i class="fa fa-circle-o"></i> <?= lang('opened_bills'); ?></a></li>
                        </ul>
                    </li>
                    <li class="treeview mm_purchases">
                        <a href="#"><i class="fa fa-plus"></i><span>Gastos</span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="mpurchases_expenses"><a href="<?= site_url('purchases/expenses'); ?>"> <i class="fa fa-check-square"></i> <?= lang('list_expenses'); ?></a></li>
                            <li id="mpurchases_add_expense"><a href="<?= site_url('purchases/add_expense'); ?>"><i class="fa fa-money"></i> <?= lang('add_expense'); ?></a></li>
                        </ul>
                    </li>
                    <li class="treeview mm_gift_cards">
                        <a href="#"><i class="fa fa-credit-card"></i><span><?=lang('gift_cards');?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_gift_cards">
                                <li id="gift_cards_index"> <a href="<?= site_url('gift_cards'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_gift_cards'); ?></a></li>
                                <li id="gift_cards_add"> <a href="<?= site_url('gift_cards/add'); ?>"><i class="fa fa-credit-card"></i> <?= lang('add_gift_card'); ?></a></li>
                            </li>
                        </ul>
                    </li>
                    <li class="treeview  mm_customers"> 
                        <a href="#"><i class="fa fa-users"></i><span><?=lang('customers'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="customers_index"><a href="<?= site_url('customers'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_customers'); ?></a></li>
                            <li id="customers_add"><a href="<?= site_url('customers/add'); ?>"><i class="fa fa-users"></i> <?= lang('add_customer'); ?></a></li>
                        </ul>
                    </li>
                    <li class="treeview  mm_suppliers"> 
                        <a href="#"><i class="fa fa-users"></i><span><?=lang('suppliers'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="suppliers_index"><a href="<?= site_url('suppliers'); ?>"> <i class="fa fa-check-square"></i> <?= lang('list_suppliers'); ?></a></li>
                            <li id="suppliers_add"><a href="<?= site_url('suppliers/add'); ?>"> <i class="fa fa-building"></i> <?= lang('add_supplier'); ?></a></li>
                        </ul>
                    </li>
                    <?php } elseif ($Caja) { ?>
                    <li id="pos_index">
                        <a href="<?= site_url('pos'); ?>"><i class="fa fa-th"></i> <span><?= lang('pos'); ?></span></a>
                    </li>
                    <li class="mm_products"><a href="<?= site_url('products'); ?>"><i class="fa fa-barcode"></i> <span><?= lang('products'); ?></span></a></li>
                    <li class="mm_categories"><a href="<?= site_url('catagories'); ?>"><i class="fa fa-folder-open"></i> <span><?= lang('categories'); ?></span></a></li>
            
                    <li class="treeview mm_sales">
                        <a href="#"><i class="fa fa-shopping-cart"></i><span><?= lang('sales'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="sales_index"><a href="<?= site_url('sales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_sales'); ?></a></li>
                            <li id="sales_opened"><a href="<?= site_url('sales/opened'); ?>"><i class="fa fa-circle-o"></i> <?= lang('opened_bills'); ?></a></li>
                        </ul>
                    </li>
                    <li class="treeview mm_purchases">
                        <a href="#"><i class="fa fa-plus"></i><span>Gastos</span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="mpurchases_expenses"><a href="<?= site_url('purchases/expenses'); ?>"> <i class="fa fa-check-square"></i> <?= lang('list_expenses'); ?></a></li>
                            <li id="mpurchases_add_expense"><a href="<?= site_url('purchases/add_expense'); ?>"><i class="fa fa-money"></i> <?= lang('add_expense'); ?></a></li>
                        </ul>
                    </li>
                    <li class="treeview mm_gift_cards">
                        <a href="#"><i class="fa fa-credit-card"></i><span><?=lang('gift_cards');?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li class="treeview mm_gift_cards">
                                <li id="gift_cards_index"> <a href="<?= site_url('gift_cards'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_gift_cards'); ?></a></li>
                                <li id="gift_cards_add"> <a href="<?= site_url('gift_cards/add'); ?>"><i class="fa fa-credit-card"></i> <?= lang('add_gift_card'); ?></a></li>
                            </li>
                        </ul>
                    </li>
                    <li class="treeview  mm_customers"> 
                        <a href="#"><i class="fa fa-users"></i><span><?=lang('customers'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="customers_index"><a href="<?= site_url('customers'); ?>"><i class="fa fa-check-square"></i> <?= lang('list_customers'); ?></a></li>
                            <li id="customers_add"><a href="<?= site_url('customers/add'); ?>"><i class="fa fa-users"></i> <?= lang('add_customer'); ?></a></li>
                        </ul>
                    </li>
                    <li class="treeview  mm_suppliers"> 
                        <a href="#"><i class="fa fa-users"></i><span><?=lang('suppliers'); ?></span><i class="fa fa-angle-left pull-right"></i></a>
                        <ul class="treeview-menu">
                            <li id="suppliers_index"><a href="<?= site_url('suppliers'); ?>"> <i class="fa fa-check-square"></i> <?= lang('list_suppliers'); ?></a></li>
                            <li id="suppliers_add"><a href="<?= site_url('suppliers/add'); ?>"> <i class="fa fa-building"></i> <?= lang('add_supplier'); ?></a></li>
                        </ul>
                    </li>
                    <?php } ?>
                </ul>
            </section>
        </aside>
        <?php } ?>

        <div class="content-wrapper">
            <section class="content-header">
                <span style="font-size: 22px;"><?= $page_title; ?></span>
                <ol class="breadcrumb">
                    <li><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i> <?= lang('home'); ?></a></li>
                    <?php
                    foreach ($bc as $b) {
                        if ($b['link'] === '#') {
                            echo '<li class="active">' . $b['page'] . '</li>';
                        } else {
                            echo '<li><a href="' . $b['link'] . '">' . $b['page'] . '</a></li>';
                        }
                    }
                    ?>
                </ol>
            </section>

            <div class="col-lg-12 alerts">
                <div id="custom-alerts" style="display:none;">
                    <div class="alert alert-dismissable">
                        <div class="custom-msg"></div>
                    </div>
                </div>
                <?php if ($error) { ?>
                    <div class="alert alert-danger alert-dismissable message-error" style="border: 1px solid #ffff;border-radius: 2.25rem;">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <span style="color: red!important;">
                            <center>
                                <strong style="font-size: 17px;"><i class="icon fa fa-ban"></i> <?= lang('error'); ?></strong>&nbsp;&nbsp;
                                <span style="color:#6c757d;"><?php $error = str_replace(".", "", $error); ?><?= $error; ?></span>
                            </center>
                        </span>
                    </div>
                <?php }
                if ($warning) { ?>
                    <div class="alert alert-warning alert-dismissable message-warning" style="border: 1px solid #FFC107;border-radius: 2.25rem;">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <span style="color: #FFC107!important;">
                            <center>
                                <strong style="font-size: 17px;"><i class="icon fa fa-warning"></i> <?= lang('warning'); ?></strong>&nbsp;&nbsp;
                                <span style="color:#6c757d;"> <?= $warning; ?></span>
                            </center>
                        </span>
                    </div>
                <?php }
                if ($message) { ?>
                    <div class="alert alert-success alert-dismissable message-success" style="border: 1px solid #28A745;border-radius: 2.25rem;">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <span style="color: #28a745!important;text-align: center;">
                            <center>
                                <strong style="font-size: 17px;"><i class="icon fa fa-check"></i><?= lang('Success'); ?></strong>&nbsp;&nbsp;
                                <span style="color:#6c757d;"> <?= $message; ?></span>
                            </center>
                        </span>
                    </div>
                <?php } ?>
            </div>