
class OnlyIntegers {
    constructor(inputElement) {
        this.inputElement = inputElement;
        this.init();
    }

    init() {
        this.inputElement.addEventListener('input', this.validateInput.bind(this));
    }

    validateInput(event) {
        const value = event.target.value;
        if (!/^\d*$/.test(value)) {
            event.target.value = value.replace(/\D/g, '');
        }
    }
}

// Aplicar la clase a todos los campos de entrada con la clase "only-integers" cuando el DOM esté cargado
document.addEventListener('DOMContentLoaded', () => {
    const integerInputs = document.querySelectorAll('.only-integers');
    integerInputs.forEach(input => new OnlyIntegers(input));
});

$(document).ready(function () {
    
    

    const submitButton = document.querySelector('#update_settings_btn');

    const observer = new MutationObserver(() => {
        if (submitButton.disabled) {
            console.log('El botón de submit ha sido deshabilitado.');
    
            // Selecciona todos los elementos li dentro de .tabs y les agrega la clase 'disabled'
            document.querySelectorAll('.tabs li').forEach(tab => tab.classList.add('disabled'));
    
        } else {
            console.log('El botón de submit ha sido habilitado.');
    
            // Selecciona todos los elementos li dentro de .tabs y les quita la clase 'disabled'
            document.querySelectorAll('.tabs li').forEach(tab => tab.classList.remove('disabled'));
        }
    });

    document.addEventListener('DOMContentLoaded', function() {
        const tabs = document.querySelectorAll('.tabs li a');
    
        tabs.forEach(tab => {
            tab.addEventListener('click', function(event) {
                if (tab.classList.contains('disabled')) {
                    event.preventDefault();
                }
            });
        });
    
        // Ejemplo: Deshabilitar todas las pestañas
        tabs.forEach(tab => tab.classList.add('disabled'));
    });

    // Configurar el observer para observar cambios en los atributos
    observer.observe(submitButton, { attributes: true });

    

    // Función para manejar el evento keydown y establecer la combinación de teclas
    function handleKeydown(event) {
        const allowedKeys = new Set([
            'F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 'F10', 'F11', 'F12',
            'Control', 'Shift', 'Alt'
        ]);

        let keyCombination = '';
        if (event.ctrlKey && event.key !== 'Control') keyCombination += 'CTRL+';
        if (event.shiftKey && event.key !== 'Shift') keyCombination += 'SHIFT+';
        if (event.altKey && event.key !== 'Alt') keyCombination += 'ALT+';

        if (event.key !== 'Control' && event.key !== 'Shift' && event.key !== 'Alt') {
            keyCombination += event.key.toUpperCase();
        }

        console.log('Tecla presionada: ' + keyCombination);

        if (!allowedKeys.has(event.key)) {
            // Prevenir el comportamiento por defecto si la tecla no está permitida
            event.preventDefault();
            return;
        }

        const specialKeys = ['Tab', 'Enter', 'Escape', 'ArrowUp', 'ArrowDown', 'ArrowLeft', 'ArrowRight'];
        if (!specialKeys.includes(event.key)) {
            // Establecer la combinación de teclas como el valor del input
            event.target.value = keyCombination;

            // Disparar el evento 'input' o 'change' para que el navegador lo reconozca
            event.target.dispatchEvent(new Event('input', { bubbles: true }));
            event.target.dispatchEvent(new Event('change', { bubbles: true }));

            // Prevenir el comportamiento por defecto
            event.preventDefault();
        }
    }

    // Seleccionar todos los inputs relevantes y añadir el evento keydown
    const inputs = document.querySelectorAll('#focus_add_item, #add_customer, #toggle_category_slider, #cancel_sale, #suspend_sale, #print_order, #print_bill, #finalize_sale, #today_sale, #open_hold_bills, #close_register');
    inputs.forEach(input => {
        input.addEventListener('keydown', handleKeydown);
    });



    

});
