/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import qz.LogIt;
import qz.exception.SerialException;

public class SerialUtilities {
    private static final int WINDOWS = 1;
    private static final int LINUX = 2;
    private static final int OSX = 3;
    public static String winCmd = "%windir%\\System32\\reg.exe query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Ports\" |find \"?\"";

    public static int[] getSystemAttributes(String portName) throws IOException, SerialException {
        switch (SerialUtilities.getOS()) {
            case 1: {
                return SerialUtilities.getWindowsAttributes(portName);
            }
            case 2: {
                LogIt.log("Parsing Linux Serial Port attributes has not yet been implemented");
                break;
            }
            case 3: {
                LogIt.log("Parsing OSX Serial Port attributes has not yet been implemented");
                break;
            }
        }
        return null;
    }

    public static int[] getWindowsAttributes(String portName) throws IOException, SerialException {
        String[] command = new String[]{"cmd.exe", "/c", winCmd.replace("?", portName)};
        Process p = Runtime.getRuntime().exec(command);
        String output = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
        LogIt.log("Found windows registry settings: " + output);
        String[] split = output.split("REG_SZ");
        if (split.length > 0) {
            int[] attr = new int[]{9600, 8, 1, 0, 0};
            String settings = split[split.length - 1];
            String[] _attr = settings.split(",");
            block7: for (int i = 0; i < _attr.length; ++i) {
                String val = _attr[i];
                switch (i) {
                    case 0: {
                        attr[0] = SerialUtilities.parseBaudRate(val);
                        continue block7;
                    }
                    case 1: {
                        attr[3] = SerialUtilities.parseParity(val);
                        continue block7;
                    }
                    case 2: {
                        attr[1] = SerialUtilities.parseDataBits(val);
                        continue block7;
                    }
                    case 3: {
                        attr[2] = SerialUtilities.parseStopBits(val);
                        continue block7;
                    }
                    case 4: {
                        attr[4] = SerialUtilities.parseFlowControl(val);
                        continue block7;
                    }
                }
            }
            for (int i : attr) {
                if (i != -1) continue;
                throw new SerialException("Cannot parse system provided serial attributes: " + output);
            }
            return attr;
        }
        throw new SerialException("Cannot parse system provided serial attributes: " + output);
    }

    public static int getOS() {
        String os = System.getProperty("os.name", "Windows 7").toLowerCase();
        if (os.startsWith("windows")) {
            LogIt.log("OS Detected: Windows");
            return 1;
        }
        if (os.startsWith("linux")) {
            LogIt.log("OS Detected: Linux");
            return 2;
        }
        if (os.startsWith("mac os") || os.startsWith("freebsd")) {
            LogIt.log("OS Detected: OS X");
            return 3;
        }
        LogIt.log("Unknown OS Detected.");
        return -1;
    }

    public static int parseDataBits(String s) {
        if ((s = s.trim()).equals("")) {
            LogIt.log(Level.SEVERE, "Canot parse empty data bits value.");
        } else {
            if (s.equals("5")) {
                LogIt.log("Parsed serial setting: " + s + "=DATABITS_" + s);
                return 5;
            }
            if (s.equals("6")) {
                LogIt.log("Parsed serial setting: " + s + "=DATABITS_" + s);
                return 6;
            }
            if (s.equals("7")) {
                LogIt.log("Parsed serial setting: " + s + "=DATABITS_" + s);
                return 7;
            }
            if (s.equals("8")) {
                LogIt.log("Parsed serial setting: " + s + "=DATABITS_" + s);
                return 8;
            }
            LogIt.log(Level.SEVERE, "Data bits value of " + s + " not supported");
        }
        return -1;
    }

    public static int parseStopBits(String s) {
        if ((s = s.trim()).equals("1") || s.equals("")) {
            LogIt.log("Parsed serial setting: " + s + "=STOPBITS_" + s);
            return 1;
        }
        if (s.equals("2")) {
            LogIt.log("Parsed serial setting: " + s + "=STOPBITS_" + s);
            return 2;
        }
        if (s.equals("1.5") || s.equals("1_5")) {
            LogIt.log("Parsed serial setting: " + s + "=STOPBITS_" + s);
            return 3;
        }
        LogIt.log(Level.SEVERE, "Stop bits value of " + s + " could not be parsed");
        return -1;
    }

    public static int parseFlowControl(String s) {
        if ((s = s.trim()).equals("n") || s.equals("none") || s.equals("")) {
            LogIt.log("Parsed serial setting: " + s + "=FLOWCONTROL_NONE");
            return 0;
        }
        if (s.equals("x") || s.equals("xonxoff") || s.equals("xonxoff_out")) {
            LogIt.log("Parsed serial setting: " + s + "=FLOWCONTROL_XONXOFF_OUT");
            return 8;
        }
        if (s.equals("xonxoff_in")) {
            LogIt.log("Parsed serial setting: " + s + "=FLOWCONTROL_XONXOFF_IN");
            return 4;
        }
        if (s.equals("p") || s.equals("rtscts") || s.equals("rtscts_out")) {
            LogIt.log("Parsed serial setting: " + s + "=FLOWCONTROL_RTSCTS_OUT");
            return 2;
        }
        if (s.equals("rtscts_in")) {
            LogIt.log("Parsed serial setting: " + s + "=FLOWCONTROL_RTSCTS_IN");
            return 1;
        }
        LogIt.log(Level.SEVERE, "Flow control value of " + s + " could not be parsed");
        return -1;
    }

    public static int parseParity(String s) {
        if ((s = s.trim().toLowerCase()).startsWith("n") || s.equals("")) {
            LogIt.log("Parsed serial setting: " + s + "=PARITY_NONE");
            return 0;
        }
        if (s.startsWith("e")) {
            LogIt.log("Parsed serial setting: " + s + "=PARITY_EVEN");
            return 2;
        }
        if (s.equals("o")) {
            LogIt.log("Parsed serial setting: " + s + "=PARITY_ODD");
            return 1;
        }
        if (s.equals("m")) {
            LogIt.log("Parsed serial setting: " + s + "=PARITY_MARK");
            return 3;
        }
        if (s.equals("s")) {
            LogIt.log("Parsed serial setting: " + s + "=PARITY_SPACE");
            return 4;
        }
        LogIt.log(Level.SEVERE, "Data bits value of " + s + " not supported");
        return -1;
    }

    public static int parseBaudRate(String s) {
        if ((s = s.trim()).equals("")) {
            LogIt.log(Level.SEVERE, "Canot parse empty baud rate value.");
        } else {
            if (s.equals("110")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 110;
            }
            if (s.equals("300")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 300;
            }
            if (s.equals("600")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 600;
            }
            if (s.equals("1200")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 1200;
            }
            if (s.equals("4800")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 4800;
            }
            if (s.equals("9600")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 9600;
            }
            if (s.equals("14400")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 14400;
            }
            if (s.equals("19200")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 19200;
            }
            if (s.equals("38400")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 38400;
            }
            if (s.equals("57600")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 57600;
            }
            if (s.equals("115200")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 115200;
            }
            if (s.equals("128000")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 128000;
            }
            if (s.equals("256000")) {
                LogIt.log("Parsed serial setting: " + s + "=BAUDRATE_" + s);
                return 256000;
            }
            LogIt.log(Level.SEVERE, "Baud rate of " + s + " not supported");
        }
        return -1;
    }
}

