<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>
<script>
    $(document).ready(function () {
        $('#listados').DataTable({
            "responsive": true,
            "order": [[ 2, "desc" ]],
            "language": {
                "url": "<?= $assets ?>/dist/js/pages/es_es.lang"
            },
            "displayLength": 25,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "<?= site_url('warehouses/get_warehouses') ?>",
                "dataSrc" : "listados",
            },
            "columns": [
                //{ "data": "id" },
                { "data": "code" },
                { "data": "warehouse" },
                { "data": "edit" },
                { "data": "products" },
                { "data": "delete" }
            ],
            columnDefs: [
                { orderable: false, targets: -1 },
                { orderable: false, targets: -2 },
                { orderable: false, targets: -3 }
            ]                        
        });
    });
</script>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <a href="<?= site_url('warehouses/add'); ?>" class="btn btn-primary"> <i class="fa fa-plus-square"></i> <?= lang('btn_add_warehouse'); ?></a>
            </div>
        </div>

        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <div class="box-body">
                    <div class="table-responsive">
                        <!--<table id="listados" class="display" style="width:100%">-->
                        <table id="listados" class="table table-bordered table-hover table-striped table-condensed" style="width:100%">
                            <thead>
                                <tr>
                                    <!--<th width="20">#</th>-->
                                    <th width="70">Código</th>
                                    <th>Almac&eacute;n</th>
                                    <th width="10"></th>
                                    <th width="10"></th>
                                    <th width="10"></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>
