<style>
    .tooltip-wrap {
        position: relative;
    }

    .tooltip-wrap .tooltip-content {
        display: none;
        position: absolute;
        bottom: 10%;
        left: 10%;
        right: 10%;
        color: black;
        background-color: #A9CCE3;
        padding: .10em;
        border-radius: 5px;
        border: #5D6D7E 0.5px solid;
        width: 140px;
    }

    .tooltip-wrap:hover .tooltip-content {
        display: block;
    }

    .tooltip-wrap .tooltip-content p {
        margin-left: 2px;
    }

    #toggleFilters:hover {
        cursor: pointer;
    }
</style>


<input type="hidden" id="vurl" value="<?= site_url('purchase_orders/get_purchase_orders') ?>">

<section class="content">

    <div class="row">
        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #9fc10b;">

                <div class="box-header">
                    <h4><a id="toggleFilters">
                            Filtros <i class="fa fa-chevron-down"></i>
                        </a></>
                </div>

                <div class="box-body" id="form-filtros" style="padding-top: 0px;">
                    <div class="col-lg-12">
                        <div class="row">

                            <div class="col-md-3">
                                <label for="fechaInicio">Fecha inicio</label>
                                <div class='input-group date' id='divFechaInicio'>
                                    <input type='text' id="fechaInicio" class="input-medium form-control" placeholder="dd/mm/aaaa" readonly />
                                    <span class="input-group-addon">
                                        <span class="fa fa-calendar glyphicon glyphicon-calendar"></span>
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="fechaFin">Fecha fin</label>
                                    <div class="input-group date" id="divFechaFin">
                                        <input class="input-medium form-control" type="text" id="fechaFin" placeholder="dd/mm/aaaa" readonly>
                                        <span class="input-group-addon" id="calendarioEnvio">
                                            <span class="fa fa-calendar glyphicon glyphicon-calendar"></span>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <?= lang('status_order', 'status_order'); ?>
                                    <?php
                                    $see['1'] = lang('finished');
                                    $see['2'] = lang('in_progress');
                                    $see['3'] = lang('all');
                                    ?>
                                    <?= form_dropdown('estadof', $see, "3", 'class="form-control select2 estado" id="estadof"  required="required" style="width:100%;"'); ?>
                                </div>
                            </div>

                            <div class="col-md-2 botones">
                                <div class="form-group">
                                    <button type="button" id="btnSearch" class="btn btn-sm btn-success"><?= lang("search2") ?></button>
                                    <button type="button" id="btnAll" class="btn btn-sm btn-primary"><?= lang("see_all_fem"); ?></button>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <!-- <div class="box-header">
					<div class="btn btn-sm btn-success col-md-offset-10" onclick="exportTableToExcel()"><i class="fa fa-file-excel-o"></i> Exportar Excel</div>
					<hr>
				</div> -->
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="CuData" class="table table-striped table-bordered table-condensed table-hover" style="width:100%">
                            <thead class="text-center">
                                <tr>
                                    <th><?php echo $this->lang->line("date_of_issue"); ?></th>
                                    <th>N° Ord. de Comp.</th>
                                    <th><?php echo $this->lang->line("supplier"); ?></th>
                                    <th><?php echo $this->lang->line("currency_name"); ?></th>
                                    <th><?php echo $this->lang->line("total_items"); ?></th>
                                    <th><?php echo $this->lang->line("grand_total_order"); ?></th>
                                    <th><?php echo $this->lang->line("status"); ?></th>
                                    <th style="text-align:center; width: 100px;"><?php echo $this->lang->line("actions"); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="9" class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
    <!--    Datatables-->
    <script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>
    <script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
    <script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
    <script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
    <script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>

    <script>
        function sumarDias(fecha, dias) {
            fecha.setDate(fecha.getDate() + dias);
            return fecha;
        }

        $(document).ready(function() {
            $('#form-filtros').hide()

            $('#toggleFilters').click(function() {

                var icon = $(this).find('i');
                if (icon.hasClass('fa-chevron-down')) {
                    icon.removeClass('fa-chevron-down').addClass('fa-chevron-up');
                    $('#form-filtros').show();

                } else {
                    icon.removeClass('fa-chevron-up').addClass('fa-chevron-down');
                    $('#form-filtros').hide();

                }
            });

            var fStart = new Date().toISOString().split('T')[0];
            var fEnd = (sumarDias(new Date(), -30).toISOString().split('T')[0]);

            $('#fechaInicio').val(fEnd.split("-").reverse().join("/"));
            $('#fechaFin').val(fStart.split("-").reverse().join("/"));

            dibujarDt();

            function dibujarDt(start_date, end_date, estado) {

                var data = {
                    "start_date": start_date,
                    "end_date": end_date,
                    "estado": estado,
                }

                $('#CuData').DataTable({
                    'bProcessing': true,
                    'bServerSide': true,
                    "bDestroy": true,
                    "responsive": true,
                    "order": [
                        ['1', "desc"]
                    ],
                    "processing": true,
                    "serverSide": true,
                    
                    "DisplayLength": <?= $Settings->rows_per_page ?>,
                    "ajax": {
                        "url": $("#vurl").val(),
                        "data": data
                    }, // Se configura la fuente de datos AJAX para DataTables usando la URL almacenada en el elemento oculto "vurl"

                    "columns": [{
                            "data": "issuance_date",
                            className: "text-start"
                        },
                        {
                            "data": "num_purchase_order",
                            className: "text-center"
                        },
                        {
                            "data": "supplier_name",
                            className: "text-center"
                        },
                        {
                            "data": "currency",
                            className: "text-center"
                        },
                        {
                            "data": "total_items",
                            className: "text-center"
                        },
                        {
                            "data": "grand_total",
                            className: "text-center"
                        },
                        {
                            "data": "estado",
                            className: "text-center"
                        },
                        {
                            "data": "action",
                            className: "text-center"
                        }
                    ],
                    columnDefs: [{
                        orderable: false,
                        targets: -1
                    }],
                    oLanguage: {
                        sZeroRecords: "<center>No se encontraron resultados</center>"
                    },

                });

            } //Fin de la funcion "dibujarDt"

            $("#btnAll").click(
                function() {
                    dibujarDt();

                }
            );

            var isTableInitialized = false;

            $("#btnSearch").click(
                function() {
                    var fI = $("#fechaInicio").val();
                    var fF = $("#fechaFin").val();
                    var estado = $("#estadof").val()
                    var fechaInicio = fI.split("/").reverse().join("-");
                    var fechaFin = fF.split("/").reverse().join("-");;

                    if (fechaInicio != "" && fechaFin != "") {
                        if (fechaInicio > fechaFin) {
                            alert("La fecha de inicio no debe ser superior a la fecha de fin");
                        } else {

                            if (estado == 3) {
                                dibujarDt(fechaInicio, fechaFin);
                            } else {
                                dibujarDt(fechaInicio, fechaFin, estado);
                            }
                        }
                    } else {
                        if (estado == 3) {
                                dibujarDt(fechaInicio, fechaFin);
                            } else {
                                dibujarDt(fechaInicio, fechaFin, estado);
                            }
                    }
                    // console.log("Valor de estado:", estado);

                }
            );

        });
    </script>
</section>

<script>
    $('#divFechaInicio').datetimepicker({
        format: 'DD/MM/YYYY',
        ignoreReadonly: true,

    });
    $('#divFechaFin').datetimepicker({
        format: 'DD/MM/YYYY',
        ignoreReadonly: true
    });
</script>