<?php defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller {

    function __construct() {
        parent::__construct();
        define("DEMO", 0);
        define("PROTECT_USER", 0);
        
        $this->ruc = $this->obtenerRucPorSubdominio();
        $this->Settings = (object)$this->settings();
        // log_message('error','piero : '.json_encode( $this->Settings));
        // $this->Settings = $this->site->getSettings();
        $this->lang->load('app', $this->Settings->language);
        $this->Settings->pin_code = $this->Settings->pin_code ? md5($this->Settings->pin_code) : NULL;
        $this->theme = $this->Settings->theme.'/views/';
        $this->data['assets'] = base_url() . 'themes/default/assets/';
        $this->data['Local'] = "";
        $this->ruc = $this->obtenerRucPorSubdominio();

        //Obtener el Local
        $local_id = $this->session->userdata('local');

        if($local = $this->site->getLocalByID($local_id)){

            $this->data['Local'] = $local->code;

            //Obtener el Almacen
            if ($local->default_warehouse){
                $default_warehouse = $local->default_warehouse;
            } else {
                $default_warehouse = $this->Settings->default_warehouse;
            }
            $this->Settings->default_warehouse = $default_warehouse;

            //Obtener el Formato de Factura
            if ($local->invoice_format){
                $invoice_format = $local->invoice_format;
                $invoice_number = $local->invoice_number;
            } else {
                $invoice_format = $this->Settings->invoice_format;
                $invoice_number = $this->Settings->invoice_number;
            }
            $this->Settings->invoice_format = $invoice_format;
            $this->Settings->invoice_number = $invoice_number;

            //Obtener el Formato de Boleta
            if ($local->bill_format){
                $bill_format = $local->bill_format;
                $bill_number = $local->bill_number;
            } else {
                $bill_format = $this->Settings->bill_format;
                $bill_number = $this->Settings->bill_number;
            }
            $this->Settings->bill_format = $bill_format;
            $this->Settings->bill_number = $bill_number;

        }

        $this->data['Settings'] = $this->Settings;
        $this->loggedIn = $this->tec->logged_in();
        $this->data['loggedIn'] = $this->loggedIn;
        $this->data['categories'] = $this->site->getAllCategories();

        //$this->Admin = $this->tec->in_group('admin') ? TRUE : NULL;
        $this->Admin = $this->tec->in_group(1) ? TRUE : NULL;
        $this->data['Admin'] = $this->Admin;

        $this->Staff = $this->tec->in_group(2) ? TRUE : NULL;
        $this->data['Staff'] = $this->Staff;

        $this->Caja = $this->tec->in_group(3) ? TRUE : NULL;
        $this->data['Caja'] = $this->Caja;
        

        $this->m = strtolower($this->router->fetch_class());
        $this->v = strtolower($this->router->fetch_method());
        $this->data['m']= $this->m;
        $this->data['v'] = $this->v;
        $this->data['menuItems']= $this->get_menu();


        //Tipo de cambio
		
		//*********************TRJ013 - Alexander roca - 11/06/2019********************
		$this->Exchange = $this->site->getExchange(date("Y-m-d"));
        $this->data['Exchange'] = $this->Exchange;
		if($this->site->getExchange(date("Y-m-d")) == false){
			$this->Exchange = $this->site->getExchangeID();
			$this->data['Exchange'] = $this->Exchange;
		}
		//*********************TRJ013 - Alexander roca - 11/06/2019********************
		
    }

    function page_construct($page, $data = array(), $meta = array()) {
        if(empty($meta)) { $meta['page_title'] = $data['page_title']; }
        $meta['message'] = isset($data['message']) ? $data['message'] : $this->session->flashdata('message');
        $meta['error'] = isset($data['error']) ? $data['error'] : $this->session->flashdata('error');
        $meta['warning'] = isset($data['warning']) ? $data['warning'] : $this->session->flashdata('warning');
        $meta['ip_address'] = $this->input->ip_address();
        $meta['Admin'] = $data['Admin'];
        $meta['Caja'] = $data['Caja'];
        $meta['Staff'] = $data['Staff'];
        $meta['loggedIn'] = $data['loggedIn'];
        $meta['Settings'] = $data['Settings'];
        $meta['Exchange'] = $data['Exchange'];
        $meta['Local'] = $data['Local'];
        $meta['assets'] = $data['assets'];
        $meta['suspended_sales'] = $this->site->getUserSuspenedSales();
        $meta['qty_alert_num'] = $this->site->getQtyAlerts();
        $meta['menuItems']= $this->get_menu();
        $this->data['menuItems']= $this->get_menu();
        $this->load->view($this->theme . 'header', $meta);
        $this->load->view($this->theme . $page, $data);
        $this->load->view($this->theme . 'footer');
    }

    public function obtenerRucPorSubdominio() {
        $url = $_SERVER['HTTP_HOST'];
        if (strpos($url, "localhost") !== false) {
            $dominioArray = explode(':', $url);
            $subdominio = $dominioArray[0];
        } else {
            $dominioArray = explode('.', str_replace('https://', '', $url));
            $subdominio = $dominioArray[0];
        };

        $dataSubDom = array(
            'subdominio' => $subdominio
        );
        $context = stream_context_create(array(
            'http' => array(
            'method' => 'GET',
            'header' => "Authorization: application/json\r\n" .
            "Content-Type: application/json\r\n",
            "content"=>json_encode($dataSubDom)
            )
        ));
        $url = $this->config->item('api_admin');
        $url =$url. "client/subdominio";
        $response = file_get_contents($url, false, $context);
        $resAdmin= json_decode($response, false);
        return $rucEmpresa = $resAdmin->data->ruc;        
    }

    function settings(){
        $dataCus = array(
            "business_information"=>array(
                "ruc_number"=>$this->ruc,
            ),
        );
        $context = stream_context_create(array(
            'http' => array(
            'method' => 'GET',
            'header' => "Authorization: application/json\r\n" .
            "Content-Type: application/json\r\n",
            "content"=>json_encode($dataCus)
            )
        ));
        $url = $this->config->item('api_general');
        $url =$url. "settings";
        $response = file_get_contents($url, false, $context);
        $resSettings = json_decode($response, false);
        $data_seting = $resSettings;
        return $data_seting;
    }
    function get_menu(){
        switch ($this->session->userdata('negocio')) {
            case 0:
                $l_makers = lang('makers');
                $l_maker_add = lang("add_maker");
                break;
            case 1:
                $l_makers = lang('laboratorys');
                $l_maker_add = lang("add_l
                aboratory");
                break;
        }
        

        $aside=array(
            array(
                'id_menu'=>'1',
                'nombre' => 'Menú',
                'url' => '/',
                'icono' => 'fa fa-dashboard',
                'active'=> 1,
                'separador' =>0,
                'submenu' => null,
                'class' =>"mm_welcome",
                'id'=>null
            ),
            array(
                'id_menu'=>'2',
                'nombre' => 'TPV',
                'url' => '/pos',
                'icono' => 'fa fa-th',
                'active'=> 1,
                'separador' =>0,
                'submenu' => null,
                'id'=>'pos_index',
                'class'=>null
            ),
            array(
                'id_menu'=>'3',
                'nombre' => lang('warehouse_s'),
                'url' => '#',
                'icono' => 'fa fa-barcode',
                'class' =>'treeview mm_products mm_warehouses mm_makers mm_brands mm_models mm_measure_units mm_warehouses mm_referral_guide mm_guides mm_categories',
                'active'=> 1,
                'separador' =>0,
                'submenu' => array(
                    array(
                        'id_submenu'=>'1',
                        'id_menu'=>'3',
                        'nombre' => lang('list_products'),
                        'url' => '/products',
                        'icono' => 'fa fa-barcode',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'products_index',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'2',
                        'id_menu'=>'3',
                        'nombre' => lang('import_products'),
                        'url' => 'products/import',
                        'icono' => 'fa fa-download',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'products_import',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'3',
                        'id_menu'=>'3',
                        'nombre' => lang('print_barcodes'),
                        'url' => 'products/print_barcodes',
                        'icono' => 'fa fa-print',
                        'active'=> 1,
                        'separador' =>0,
                        'otra_ventana'=>1,
                        'submenu' => null,
                        'id'=>'products_print_barcodes',
                        'class'=>null
                    ),
                    array(
                        'id_submenu'=>'4',
                        'id_menu'=>'3',
                        'nombre' => lang('print_labels'),
                        'url' => 'products/print_labels',
                        'icono' => 'fa fa-print',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'products_print_labels',
                        'class'=>null,
                        'otra_ventana'=>1
                    ),
                    array(
                        'id_submenu'=>'5',
                        'id_menu'=>'3',
                        'nombre' => lang('list_categories'),
                        'url' => '/categories',
                        'icono' => 'fa fa-folder-open',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'categories_index',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'6',
                        'id_menu'=>'3',
                        'nombre' => lang('import_categories'),
                        'url' => '/categories/import',
                        'icono' => 'fa fa-download',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'brands_index',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'7',
                        'id_menu'=>'3',
                        'nombre' => lang('brands'),
                        'url' => '/brands',
                        'icono' => 'fa fa-tag',
                        'active'=> 0,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'models_index',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'8',
                        'id_menu'=>'3',
                        'nombre' => lang('models'),
                        'url' => '/models',
                        'icono' => 'fa fa-tags',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'maker_index_m',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'9',
                        'id_menu'=>'3',
                        'nombre' => $l_makers,
                        'url' => '/makers',
                        'icono' => 'fa fa-hospital-o',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'maker_index_m',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'10',
                        'id_menu'=>'3',
                        'nombre' => lang('measure_units'),
                        'url' => '/measure_units',
                        'icono' => 'fa fa-sort-alpha-desc',
                        'active'=> 1,
                        'separador' =>1,
                    
                        'submenu' => null,
                        'id'=>'measure_units_index',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'11',
                        'id_menu'=>'3',
                        'nombre' => lang('warehouse'),
                        'url' => '/warehouses',
                        'icono' => 'fa fa-building',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'warehouses_index',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'12',
                        'id_menu'=>'3',
                        'nombre' => lang('transfer_s'),
                        'url' => '/warehouses/transfers',
                        'icono' => 'fa fa-compress',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'warehouses_transfers',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'13',
                        'id_menu'=>'3',
                        'nombre' => lang('list_guides_entrance'),
                        'url' => '/guides_entrance/i',
                        'icono' => 'fa fa-file-text-o',
                        'active'=> 0,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'guides_entrance',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'14',
                        'id_menu'=>'3',
                        'nombre' => lang('list_guides_departure'),
                        'url' => 'guides_departure/s',
                        'icono' => 'fa fa-file-text-o',
                        'active'=> 0,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'guides_departure',
                        'class'=>null
                    ),
                    array(
                        'id_submenu'=>'15',
                        'id_menu'=>'3',
                        'nombre' => lang('list_referral_guide'),
                        'url' => 'Referral_guide',
                        'icono' => 'fa fa-file-text-o',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'makers_index_RG',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'16',
                        'id_menu'=>'3',
                        'nombre' => lang('add_referral_guide'),
                        'url' => 'Referral_guide/add',
                        'icono' => 'fa fa-file-text-o',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'makers_index_RG_add',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    array(
                        'id_submenu'=>'17',
                        'id_menu'=>'3',
                        'nombre' => lang('movements_search'),
                        'url' => 'products/movements',
                        'icono' => 'fa fa-arrows-alt',
                        'active'=> 1,
                        'separador' =>0,
                    
                        'submenu' => null,
                        'id'=>'products_movements',
                        'class'=>null,
                        'otra_ventana'=>0,
                    ),
                    
                )
            ),
            array(
                'id_menu'=>'4',
                'nombre' => lang('sales'),
                'url' => '#',
                'icono' => 'fa fa-shopping-cart',
                'class' =>'treeview mm_gift_cards mm_sales mm_credit_note mm_pos',
                'id'=>null,
                'active'=> 1,
                'separador' =>0,
                'submenu' =>array(
                    array(
                        'id_submenu'=>'1',
                        'id_menu'=>'4',
                        'nombre' => lang('list_sales'),
                        'url' => 'sales',
                        'icono' => 'fa fa-check-square',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>0,
                    
                        'id'=>'sales_index',
                    ),
                    array(
                        'id_submenu'=>'2',
                        'id_menu'=>'4',
                        'nombre' => lang('opened_bills'),
                        'url' => 'sales/opened',
                        'icono' => 'fa fa-circle-o',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>0,
                    
                        'id'=>'sales_opened',
                    ),
                    array(
                        'id_submenu'=>'3',
                        'id_menu'=>'4',
                        'nombre' => lang('add_sale'),
                        'url' => 'sales/add',
                        'icono' => 'fa fa-shopping-cart',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>1,
                    
                        'id'=>'sales_add',
                    ),
                    array(
                        'id_submenu'=>'4',
                        'id_menu'=>'4',
                        'nombre' => lang('list_credit_note'),
                        'url' => 'credit_note',
                        'icono' => 'fa fa-check-square',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>0,
                    
                        'id'=>'credit_note_index',
                    ),
                    array(
                        'id_submenu'=>'5',
                        'id_menu'=>'4',
                        'nombre' => lang('add_credit_note'),
                        'url' => 'credit_note/add',
                        'icono' => 'fa fa-list-alt',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>1,
                    
                        'id'=>'credit_note_add',
                    ),
                    array(
                        'id_submenu'=>'6',
                        'id_menu'=>'4',
                        'nombre' => lang('list_traders'),
                        'url' => 'traders',
                        'icono' => 'fa fa-check-square',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>0,
                    
                        'id'=>'traders_index',
                    ),
                    array(
                        'id_submenu'=>'7',
                        'id_menu'=>'4',
                        'nombre' => lang('add_trader'),
                        'url' => 'traders/add',
                        'icono' => 'fa fa-users',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>1,
                    
                        'id'=>'traders_add',
                    ),
                    array(
                        'id_submenu'=>'8',
                        'id_menu'=>'4',
                        'nombre' => lang('list_customers'),
                        'url' => 'customers',
                        'icono' => 'fa fa-check-square',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>0,
                    
                        'id'=>'customers_index',
                    ),
                    array(
                        'id_submenu'=>'9',
                        'id_menu'=>'4',
                        'nombre' =>lang('add_customer'),
                        'url' => 'customers/add',
                        'icono' => 'fa fa-users',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>1,
                    
                        'id'=>'customers_add',
                    ),
                    array(
                        'id_submenu'=>'10',
                        'id_menu'=>'4',
                        'nombre' => lang('list_customers_type'),
                        'url' => 'customers_type',
                        'icono' => 'fa fa-list-alt',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>0,
                    
                        'id'=>'customers_type_index',
                    ),
                    array(
                        'id_submenu'=>'11',
                        'id_menu'=>'4',
                        'nombre' => lang('add_customer_type'),
                        'url' => 'customers_type/add',
                        'icono' => 'fa fa-user',
                        'class' =>null,
                        'active'=> 1,
                        'separador' =>0,
                    
                        'id'=>'customers_type_add',
                    ),
                )
            ),
            array(
                'id_menu'=>'5',
                'nombre' => lang('purchases'),
                'url' => '#',
                'icono' => 'fa fa-plus',
                'class' =>'treeview mm_purchases mm_mpurchases',
                'active'=> 1,
                'separador' =>0,
                'submenu' =>array(
                        array(
                            'id_submenu'=>'1',
                            'id_menu'=>'5',
                            'nombre' => lang('list_purchases'),
                            "id"=>"mpurchases_expenses",
                            'url' => 'purchases',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'2',
                            'id_menu'=>'5',
                            'nombre' => lang('add_purchase'),
                            "id"=>"mpurchases_add_expense",
                            'url' => 'purchases/add',
                            'icono' => 'fa fa-plus',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'3',
                            'id_menu'=>'5',
                            'nombre' => lang('list_expenses'),
                            "id"=>"suppliers_index",
                            'url' => 'suppliers',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'4',
                            'id_menu'=>'5',
                            'nombre' => lang('add_expense'),
                            "id"=>"mpurchases_add_expense",
                            'url' => 'purchases/add_expense',
                            'icono' => 'fa fa-money',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'5',
                            'id_menu'=>'5',
                            'nombre' => lang('list_suppliers'),
                            "id"=>"suppliers_index",
                            'url' => 'suppliers',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'6',
                            'id_menu'=>'5',
                            'nombre' => lang('add_supplier'),
                            "id"=>"suppliers_add",
                            'url' => 'suppliers/add',
                            'icono' => 'fa fa-building',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'7',
                            'id_menu'=>'5',
                            'nombre' => lang('list_purchases_order'),
                            "id"=>"purchases_order_index",
                            'url' => 'purchase_orders',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'8',
                            'id_menu'=>'5',
                            'nombre' => lang('add_purchase_order'),
                            "id"=>"purchases_order_add",
                            'url' => 'purchase_orders/add',
                            'icono' => 'fa fa-plus',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                    
                )
            ),
            array(
                'id_menu'=>'6',
                'nombre' => lang('accounting'),
                'url' => '#',
                'icono' => 'fa fa-money',
                'class' =>'treeview mm_summaries',
                'active'=> 1,
                'separador' =>0,
                'submenu' =>array(
                        array(
                            'id_submenu'=>'1',
                            'id_menu'=>'6',
                            'nombre' => lang('list_summaries'),
                            "id"=>"summaries_index",
                            'url' => 'summaries',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'2',
                            'id_menu'=>'6',
                            'nombre' => lang('add_summary'),
                            "id"=>"summaries_add",
                            'url' => 'summaries/add',
                            'icono' => 'fa fa-plus',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                    
                )
            ),
            array(
                'id_menu'=>'7',
                'nombre' => lang('gift_cards'),
                'url' => '#',
                'icono' => 'fa fa-credit-card',
                'class' =>'treeview mm_gift_cards',
                'active'=> 1,
                'separador' =>0,
                'submenu' =>array(
                        array(
                            'id_submenu'=>'1',
                            'id_menu'=>'7',
                            'nombre' => lang('list_gift_cards'),
                            "id"=>"gift_cards_index",
                            'url' => 'gift_cards',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'2',
                            'id_menu'=>'7',
                            'nombre' => lang('add_gift_card'),
                            "id"=>"gift_cards_add",
                            'url' => 'gift_cards/add',
                            'icono' => 'fa fa-credit-card',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                    
                )
            ),
            array(
                'id_menu'=>'8',
                'nombre' => lang('segurity'),
                'url' => '#',
                'icono' => 'fa fa-lock',
                'class' =>'treeview mm_auth',
                'active'=> 1,
                'separador' =>0,
                'submenu' =>array(
                        array(
                            'id_submenu'=>'1',
                            'id_menu'=>'8',
                            'nombre' => lang('list_users'),
                            "id"=>"auth_users",
                            'url' => 'users',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'2',
                            'id_menu'=>'8',
                            'nombre' => lang('add_user'),
                            "id"=>"auth_create_user",
                            'url' => 'users/add',
                            'icono' => 'fa fa-user',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                    
                )
            ),
            array(
                'id_menu'=>'9',
                'nombre' => lang('reports'),
                'url' => '#',
                'icono' => 'fa fa-bar-chart-o',
                'class' =>'treeview mm_gift_cards mm_sales mm_credit_note mm_pos',
                'active'=> 1,
                'separador' =>0,
                'submenu'=>array(
                        array(
                            'id_submenu'=>'1',
                            'id_menu'=>'9',
                            'nombre' => lang('daily_sales'),
                            "id"=>"reports_daily_sales",
                            'url' => 'reports/daily_sales',
                            'icono' => 'fa fa-shopping-cart',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'2',
                            'id_menu'=>'9',
                            'nombre' => lang('monthly_sales'),
                            "id"=>"reports_monthly_sales",
                            'url' => 'reports/monthly_sales',
                            'icono' => 'fa fa-shopping-cart',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'3',
                            'id_menu'=>'9',
                            'nombre' => lang('sales_report'),
                            "id"=>"reports_index",
                            'url' => 'reports',
                            'icono' => 'fa fa-bar-chart-o',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'4',
                            'id_menu'=>'9',
                            'nombre' => lang('sire_report'),
                            "id"=>"reports_sire",
                            'url' => 'reports/sire',
                            'icono' => 'fa fa-bar-chart-o',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'5',
                            'id_menu'=>'9',
                            'nombre' => lang('payments_report'),
                            "id"=>"reports_payments",
                            'url' => 'reports/payments',
                            'icono' => 'fa fa-bar-chart-o',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'6',
                            'id_menu'=>'9',
                            'nombre' => lang('registers_report'),
                            "id"=>"reports_registers",
                            'url' => 'reports/registers',
                            'icono' => 'fa fa-bar-chart-o',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'7',
                            'id_menu'=>'9',
                            'nombre' => lang('top_products'),
                            "id"=>"reports_top_products",
                            'url' => 'reports/top_products',
                            'icono' => 'fa fa-bar-chart-o',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'8',
                            'id_menu'=>'9',
                            'nombre' => lang('products_report'),
                            "id"=>"reports_products",
                            'url' => 'reports/products',
                            'icono' => 'fa fa-bar-chart-o',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                       
                    
                )
            ),
            array(
                'id_menu'=>'10',
                'nombre' => lang('settings'),
                'url' => '#',
                'icono' => 'fa fa-cogs',
                'class' =>'treeview mm_settings mm_locals mm_series mm_document_type mm_payment_methods',
                'active'=> 1,
                'separador' =>0,
                'submenu' =>array(
                        array(
                            'id_submenu'=>'1',
                            'id_menu'=>'10',
                            'nombre' => lang('settings'),
                            "id"=>"settings_index",
                            'url' => 'settings',
                            'icono' => 'fa fa-cogs',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'2',
                            'id_menu'=>'10',
                            'nombre' => lang('backups'),
                            "id"=>"settings_backups",
                            'url' => 'settings/backups',
                            'icono' => 'fa fa-database',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'3',
                            'id_menu'=>'10',
                            'nombre' => lang('list_locals'),
                            "id"=>"locals_index",
                            'url' => 'locals',
                            'icono' => 'fa fa-check-square',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>0,
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'4', 
                            'id_menu'=>'10',
                            'nombre' => lang('add_local'),
                            "id"=>"locals_add",
                            'url' => 'locals',
                            'icono' => 'fa fa-map-marker',
                            'class' =>null,
                            'active'=> 1,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'5',
                            'id_menu'=>'10',
                            'nombre' => lang('tipes_of_documents'),
                            "id"=>"document_type_index",
                            'url' => 'document_type',
                            'icono' => 'fa fa-file',
                            'class' =>null,
                            'active'=> 0,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'6',
                            'id_menu'=>'10',
                            'nombre' => lang('series_per_document'),
                            "id"=>"series_index",
                            'url' => 'series',
                            'icono' => 'fa fa-barcode',
                            'class' =>null,
                            'active'=> 0,
                            'separador' =>1,
                        
                            'submenu'=>null
                        ),
                        array(
                            'id_submenu'=>'7',
                            'id_menu'=>'10',
                            'nombre' => lang('payment_methods'),
                            "id"=>"payment_methods_index",
                            'url' => 'payment_methods',
                            'icono' => 'fa fa-dollar',
                            'class' =>null,
                            'active'=> 0,
                            'separador' =>0,
                        
                            'submenu'=>null
                        ),
                    )
                
            )
            // Agrega más elementos de menú con submenús según necesites
        );

        $menuPermisos = $this->get_permisos_menu();
        
        // Itera sobre los elementos del menú
        foreach ($aside as $key => $item) {
            // Verifica si hay permisos asignados para este elemento del menú
            foreach ($menuPermisos as $permiso) {
                if ($permiso['id_menu'] === $item['id_menu']) {
                    // Asigna los permisos encontrados al elemento del menú
                    $aside[$key]['permiso_perfil'] = $permiso['permisos'];
                    // Si hay submenús, verifica los permisos para cada uno
                    if (!empty($item['submenu'])) {
                        foreach ($item['submenu'] as $subKey => $submenuItem) {
                            foreach ($permiso['sub_menu'] as $subPermiso) {
                                if ($permiso['id_menu'] === $item['id_menu'] && $subPermiso['id_submenu'] === $submenuItem['id_submenu']) {
                                    log_message('error',$permiso['id_menu'] .'==='. $item['id_menu'].'/'.$subPermiso['id_submenu'] .'==='. $submenuItem['id_submenu']);
                                    // Asigna los permisos encontrados al submenú correspondiente
                                    $aside[$key]['submenu'][$subKey]['permiso_perfil'] = $subPermiso['permisos'];
                                    break;
                                }
                            }
                        }
                    }
                    break; // Termina el bucle después de encontrar el permiso para este elemento del menú
                }
            }
        }

        return $aside;
    }
    public function get_permisos_menu(){
        $menuPermisos = array(
            array(
                'id_menu' => '1',
                'permisos' => [1, 2, 3] 
            ),
            array(
                'id_menu' => '2',
                'permisos' => [1, 2, 3] 
            ),
            array(
                'id_menu' => '3',
                'permisos' => [1, 2, 3],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1, 2, 3], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '3',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '4',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '5',
                        'permisos' => [1,2,3], 
                    ),
                    array(
                        'id_submenu' => '6',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '7',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '8',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '9',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '10',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '11',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '12',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '13',
                        'permisos' => [], 
                    ),
                    array(
                        'id_submenu' => '14',
                        'permisos' => [], 
                    ),
                    array(
                        'id_submenu' => '15',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '16',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '17',
                        'permisos' => [1], 
                    ),
                    
                )
            ),
            array(
                'id_menu' => '4',
                'permisos' => [1, 2, 3],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1, 2, 3], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1, 2, 3], 
                    ),
                    array(
                        'id_submenu' => '3',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '4',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '5',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '6',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '7',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '8',
                        'permisos' => [1,2,3], 
                    ),
                    array(
                        'id_submenu' => '9',
                        'permisos' => [1,2,3], 
                    ),
                    array(
                        'id_submenu' => '10',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '11',
                        'permisos' => [1], 
                    )
                    
                )
            ),
            array(
                'id_menu' => '5',
                'permisos' => [1, 2, 3],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1, 2, 3], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1, 2, 3], 
                    ),
                    array(
                        'id_submenu' => '3',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '4',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '5',
                        'permisos' => [1,2 ,3 ], 
                    ),
                    array(
                        'id_submenu' => '6',
                        'permisos' => [1,2, 3], 
                    ),
                    array(
                        'id_submenu' => '7',
                        'permisos' => [1,2 ,3 ], 
                    ),
                    array(
                        'id_submenu' => '8',
                        'permisos' => [1,2, 3], 
                    ),
                    
                )
            ),
            array(
                'id_menu' => '6',
                'permisos' => [1],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1], 
                    )
                    
                )
            ),
            array(
                'id_menu' => '7',
                'permisos' => [1, 2, 3],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1, 2, 3], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1, 2, 3], 
                    )
                    
                )
            ),
            array(
                'id_menu' => '8',
                'permisos' => [1],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1], 
                    )
                    
                )
            ),
            array(
                'id_menu' => '9',
                'permisos' => [1],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '3',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '4',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '5',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '6',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '7',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '8',
                        'permisos' => [1], 
                    ),
                    
                )
            ),
            array(
                'id_menu' => '9',
                'permisos' => [1],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '3',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '4',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '5',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '6',
                        'permisos' => [1], 
                    ),
                )
            ),
            array(
                'id_menu' => '10',
                'permisos' => [1],
                'sub_menu' => array(
                    array(
                        'id_submenu' => '1',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '2',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '3',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '4',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '5',
                        'permisos' => [1], 
                    ),
                    array(
                        'id_submenu' => '6',
                        'permisos' => [1], 
                    ),
                )
            ),
           
        );

        return $menuPermisos;
    }
}
