"use strict";

$(document).on("click", "#add_customer", function (e) {
  e.preventDefault();
  $('#ss').remove();
  var accion = $('#accion-cliente').val();
  var documentType = $("#document-type").val() || $("#input_hidden_document_type").val();
  var name = $("#name").val();
  var mail = $("#cemail").val();
  var phone = $("#phone").val();
  var dni = $("#cf1").val();
  var ruc = $("#cf2").val();
  var direction = $("#cdireccion").val();
  var customerType = $("#customer_type").val();
  var person_type;

  if ($('#person-natural').is(':checked')) {
    person_type = 1;
    $('#document-type option[value="6"]').prop('disabled', true);
  }

  if ($('#person-juridica').is(':checked')) {
    person_type = 2;
  }

  var token = $("#token").val();
  data = {
    'person': person_type,
    'document_type': documentType,
    'name': name,
    'email': mail,
    'phone': phone,
    'cf1': dni,
    'cf2': ruc,
    'direccion': direction,
    'customer_type': customerType,
    'estado': 1,
    'spos_token': token
  };

  if (accion == 1) {
    url_accion = 'add';
  }

  if (accion == 2) {
    url_accion = 'edit/' + $('#idclienteedit').val() + "?id=" + $('#idclienteedit').val();
  }

  if (ruc.substring(0, 2) == "20") {
    mensaje_alerta('El RUC ingresado pertenece a una persona jurídica.');
    return false;
  }

  console.log("guardar:", data);
  $.ajax({
    url: base_url + 'customers/' + url_accion,
    type: 'POST',
    dataType: 'json',
    data: data,
    success: function success(rs) {
      console.log(rs);

      if (rs.status == 'success') {
        $('#customerModal').modal('hide');
        clear();

        if (accion == 1) {
          //location.reload();
          $('#customer').append($("<option></option>").attr("value", rs.id).text(rs.val));
          $('#customer').select2('val', rs.id);
        }
      } else {
        mensaje_alerta(rs.msg);
        $('#alert').html(rs.msg);
        $('#alert').show();
      }
    }
  });
});
document.getElementById('openFormButton').addEventListener('click', function () {
  clear();
});

function clear() {
  $('#person-natural').attr('checked', true);
  $('#document-type').val('').trigger('change.select2');
  $('#customer_type').val("0").trigger('change.select2');
  $("#name").val("");
  $("#cemail").val("");
  $("#cphone").val("");
  $("#cf1").val("");
  $("#cf2").val("");
  $("#cdireccion").val("");
  $('#accion-cliente').val(1);
  $('#cModalLabel').text('Nuevo cliente');
  $("#idclienteedit").val("");
}