<?php (defined('BASEPATH')) or exit('No direct script access allowed'); ?>
<!DOCTYPE html>


<input type="hidden" id="vurl" value="<?= site_url('customers/get_customers') ?>">
<!--  Configura la URL de la fuente de datos AJAX para DataTables. -->
<section class="content">
    <script>
        $(document).ready(function() {



            function dibujarDt(person_type, document_type, customer_type) {

                var data = {
                    "person_type": person_type,
                    "document_type": document_type,
                    "customer_type": customer_type
                }

                $('#CuData').DataTable({
                    "aLengthMenu": [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, '<?= lang('all'); ?>']
                    ],
                    'bProcessing': true,
                    'bServerSide': true,
                    "bDestroy": true,
                    "responsive": true,
                    "order": [
                        ['0', "ASC"]
                    ],
                    "processing": true,
                    "serverSide": true,

                    "ajax": {
                        "url": $("#vurl").val(),
                        "data": data
                    }, // Se configura la fuente de datos AJAX para DataTables usando la URL almacenada en el elemento oculto "vurl"

                    "columns": [{
                            "data": "name",
                            className: "text-start"
                        },
                        {
                            "data": "person_type",
                            className: "text-center"
                        },
                        {
                            "data": "document_type_id",
                            className: "text-center"
                        },
                        {
                            "data": "phone",
                            className: "text-center"
                        },
                        {
                            "data": "email",
                            className: "text-center"
                        },
                        {
                            "data": "cf1",
                            className: "text-center"
                        },
                        {
                            "data": "cf2",
                            className: "text-center"
                        },
                        {
                            "data": "customers_type_id",
                            className: "text-center"
                        },
                        {
                            "data": "action",
                            className: "text-center"
                        }
                    ],
                    columnDefs: [
                        { orderable: false, targets: -1 }
                    ],
                    oLanguage: {
                        sZeroRecords: "<center>No se encontraron resultados</center>"
                    },

                });

            } //Fin de la funcion "dibujarDt"



            $("#btnAll").click(
                function() {
                    dibujarDt("", "", "");
                    $("#document_type").val("");
                    $("#document_type").trigger('change');

                    $("#type_person").val("");
                    $("#type_person").trigger('change');
                    
                    $("#customer_type").val("");
                    $("#customer_type").trigger('change');
                }

            );

            var isTableInitialized = false;

            $("#btnSearch").click(function() {

                dibujarDt($("#type_person").val(), $("#document_type").val(), $("#customer_type").val());



            });

            dibujarDt();

        });
    </script>


    <div class="row">
        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #9fc10b;">
            
                <div class="box-header">
                    <h3 class="box-title">Filtros</h3>
                </div>
                <div class="box-body" style="padding-top: 0px;">
                    <div class="col-lg-12">
                        <div class="row">

                            <div class="col-md-2">
                                <div class="form-group">
                                    <?= lang('type_person', 'type_person'); ?>
                                    <?php
                                    $tp['1'] = 'Natural';
                                    $tp['2'] = 'Juridica';
                                    $tp[''] = 'Cualquiera';
                                    ?>
                                    <?= form_dropdown('type_person', $tp, "", 'class="form-control select2 " id="type_person"  required="required" style="width:100%;"'); ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <?= lang('document_type', 'document_type'); ?>
                                    <?php
                                    $dti['1'] = 'Documento Nacional de Identidad';
                                    $dti['4'] = 'Carnet de Extranjeria';
                                    $dti['6'] = 'RUC';
                                    $dti['7'] = 'Pasaporte';
                                    $dti[''] = 'Cualquiera';
                                    ?>
                                    <?= form_dropdown('document_type', $dti, "", 'class="form-control select2 " id="document_type"  required="required" style="width:100%;"'); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang('customers_type', 'customers_type'); ?>
                                    <?php
                                    $type_customer_list = array();

                                    foreach ($list_customer_type as $customer_type) {
                                        $type_customer_list[$customer_type['id']] = $customer_type['customers_type'];
                                    }
                                    $type_customer_list[''] = "Todos";
                                    ?>
                                    <?= form_dropdown('customer_type', $type_customer_list, "", 'class="form-control select2" id="customer_type"  required="required" style="width:100%;"'); ?>
                                </div>
                            </div>
                            <div class="col-md-2 botones">
                                <div class="form-group">
                                    <button type="button" id="btnSearch" class="btn btn-sm btn-success"><?= lang("search2") ?></button>
                                    <button type="button" id="btnAll" class="btn btn-sm btn-primary"><?= lang("see") . " " . lang("all"); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <!--div class="box-header">
                    <h3 class="box-title"><?= lang('list_results'); ?></h3>
                </div-->
                <!-- <div class="box-header">
					<h3 class="box-title">Filtros</h3>
					<hr>
				</div> -->
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="CuData" class="table table-bordered table-hover table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line("name"); ?></th>
                                    <th><?php echo $this->lang->line("type_person"); ?></th>
                                    <!--********TRJ073 - KENY PONTE - 20/08/2019*****************-->
                                    <th><?php echo $this->lang->line("document_type"); ?></th>
                                    <!--********TRJ073 - KENY PONTE - 20/08/2019*****************-->
                                    <th><?php echo $this->lang->line("phone"); ?></th>
                                    <th><?php echo $this->lang->line("email_address"); ?></th>
                                    <th><?php echo $this->lang->line("ccf1"); ?></th>
                                    <th><?php echo $this->lang->line("ccf2"); ?></th>
                                    <th><?php echo $this->lang->line("customers_type"); ?></th>
                                    <?php switch ($this->session->userdata('negocio')) {
                                        case 0: ?>
                                        <?php break;
                                        case 1: ?>
                                            <th><?php echo $this->lang->line("digemid"); ?></th>
                                    <?php break;
                                    } ?>
                                    <th style="width:65px;"><?php echo $this->lang->line("actions"); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="6" class="dataTables_empty"><?= lang('loading_data_from_server') ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>