<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>
<script>
    $(document).ready(function () {
        function image(n) {
            if(n !== null) {
                return '<div style="width:32px; margin: 0 auto;"><a href="<?=base_url();?>uploads/'+n+'" class="open-image"><img src="<?=base_url();?>uploads/thumbs/'+n+'" alt="" class="img-responsive"></a></div>';
            }
            return '';
        }
        $('#catData').DataTable({
           'bProcessing': true,
           'bServerSide': true,
           "responsive": true,
           "order": [[ 1, "desc" ]],
           "processing": true,
           "serverSide": true,
           "ajax": {
               "url": "<?= site_url('categories/get_categories')?>",
           },
           "columns": [
               { "data": "image", className: "text-center" },
               { "data": "code", className: "text-center" },
               { "data": "name", className: "text-center" },
               <?php if($Admin || $Staff) { ?>
               { "data": "actions", className: "text-center" }
               <?php } ?>
           ],
           oLanguage: {
                sZeroRecords: "<center>No se encontraron resultados</center>"
            },
            columnDefs: [
                { orderable: false, targets: -1 },
                { orderable: false, targets: -2 },
                { orderable: false, targets: -3 }
            ]
        });
        $('#catData').on('click', '.image', function() {
            var a_href = $(this).attr('href');
            var code = $(this).attr('id');
            $('#myModalLabel').text(code);
            $('#category_image').attr('src',a_href);
            $('#picModal').modal();
            return false;
        });

        $('#catData').on('click', '.open-image', function() {
            var a_href = $(this).attr('href');
            var code = $(this).closest('tr').find('.image').attr('id');
            $('#myModalLabel').text(code);
            $('#category_image').attr('src',a_href);
            $('#picModal').modal();
            return false;
        });
    });
</script>
<!-- <script>
    $(document).ready(function() {
        function image(n) {
            if(n !== null) {
                return '<div style="width:32px; margin: 0 auto;"><a href="<?=base_url();?>uploads/'+n+'" class="open-image"><img src="<?=base_url();?>uploads/thumbs/'+n+'" alt="" class="img-responsive"></a></div>';
            }
            return '';
        }
        $('#catData').dataTable({
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, '<?= lang('all'); ?>']],
            "aaSorting": [[ 1, "asc" ]], "iDisplayLength": <?= $Settings->rows_per_page ?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= site_url('categories/get_categories') ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            "aoColumns": [{"mRender":image,"bSortable":false}, null, null, {"bSortable":false, "bSearchable": false}]
        });

        $('#catData').on('click', '.image', function() {
            var a_href = $(this).attr('href');
            var code = $(this).attr('id');
            $('#myModalLabel').text(code);
            $('#product_image').attr('src',a_href);
            $('#picModal').modal();
            return false;
        });

        $('#catData').on('click', '.open-image', function() {
            var a_href = $(this).attr('href');
            var code = $(this).closest('tr').find('.image').attr('id');
            $('#myModalLabel').text(code);
            $('#product_image').attr('src',a_href);
            $('#picModal').modal();
            return false;
        });
    });
</script> -->

<section class="content">
    <div class="row">
    <?php if($Admin || $Staff) { ?>
        <div class="col-md-12">
            <div class="from-group">
            <a href="<?= site_url('categories/add'); ?>" class="btn btn-primary"> <i class="fa fa-plus-square"></i> <?= lang('btn_add_brand'); ?></a>
            </div>
            <br>
        </div>
        <?php } ?>

        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
            
            <div class="box-body">
                <div class="table-responsive">
                    <table id="catData" class="table table-bordered table-hover table-striped table-condensed" style="width:100%">
                    <thead class="text-center">
                        <tr>
                            <th width="70">Imagen</th>
                            <th width="10">C&oacute;digo</th>
                            <th width="80">Nombre de Categoria</th>
                            <th width="10">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
                        </tr>
                    </tbody>
                    </table>
                </div>
            </div>

            </div>
        </div>
    </div>
</section>
<div class="modal fade" id="image_modal" tabindex="-1" role="dialog" aria-labelledby="picModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                        <h4 class="modal-title" id="modal_title">title</h4>
                    </div>
                    <div class="modal-body text-center">
                        <img id="modal_image" src="" alt="" style="width: 20rem;"/>
                    </div>
                </div>
            </div>
        </div>

<script type="text/javascript">
$(document).ready(function() {
    $('#catData').on('click', '.image-modal', function() {
        var image = $(this).attr('href');
        var title = $(this).data('title');
        $('#modal_title').text(title);
        $('#modal_image').attr('src',image);
        $('#image_modal').modal();
        return false;
    });

    $('#catData').on('click', '.print-modal', function() {
        var url = $(this).attr('href');
        window.open(url, 'print-popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
        return false;
    });
});
</script>

<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>

