<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Sales extends MY_Controller
{

  function __construct()
  {
    parent::__construct();

    if (!$this->loggedIn) {
      redirect('login');
    }
    $this->load->library('form_validation');
    // $this->load->library('Pdf');

    $this->load->model('sales_model');
    $this->load->model('pos_model');
    $this->load->model('mov_model');
    $this->load->model('Warehouses_model');

    // require("funciones.php");
    // include("QRCodeGenerator.class.php");

    $this->digital_file_types = 'zip|pdf|doc|docx|xls|xlsx|jpg|png|gif';
  }

  function index()
  {
    $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
    $this->data['page_title'] = lang('sales');
    $bc = array(array('link' => '#', 'page' => lang('sales')));
    $meta = array('page_title' => lang('sales'), 'bc' => $bc);
    //Obtener listado de vendedores
    $traders = [];
    $get_traders = $this->get_traders();
    $response = json_decode($get_traders, true);
    if ($response['result'] == 'ok') {
      $traders = $response['data']['list'];
    }
    $this->data['traders'] = $traders;

    $this->page_construct('sales/index', $this->data, $meta);
  }

  function get_sales($estado = null)
  {
    $vendedor = $this->input->get('traders_id');
    $estado_pago = $this->input->get('paid_status');
    $estado_comprobante = $this->input->get('status_invoice');
    $fecha_inicio = $this->input->get('fecha_inicio');
    $fecha_fin = $this->input->get('fecha_fin');

    $colWhere = null;
    $this->load->library('tabledata');
    if ($this->Admin) {
      if ($this->session->userdata('user_id') == 1) {
        $accion = "<div class='text-center'><div class='btn-group'><a href='#' onClick=\"MyWindow=window.open('" . site_url('pos/view/pid/1') . "', 'MyWindow','toolbar=no,location=no,directories=no,status=no,menubar=yes,scrollbars=yes,resizable=yes,width=350,height=600'); return false;\" title='" . lang("view_invoice") . "' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a>
                <a href='" . site_url('sales/payments/pid') . "' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a>
                <a href='" . site_url('sales/add_payment/pid') . "' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a>
                <a href='" . site_url('sales/anular/pid') . "' onClick=\"return confirm('" . lang('disable_x_sale') . "')\" title='" . lang("disable_sale") . "' class='tip btn btn-info btn-xs' ><i class='fa fa-ban'></i></a>
                <a href='" . site_url('sales/recreate_pdf/pid') . "' title='" . lang("recreate_pdf") . "' class='tip btn btn-danger btn-xs' ><i class='fa fa-file-pdf-o'></i></a>
                "/*."<a href='" . site_url('sales/reenvioSunatXml/pid') . "' onClick=\"return confirm('" . lang('forwarding_x_sale') . "')\" title='" . lang("forwarding_sale") . "' class='tip btn btn-warning btn-xs' ><i class='fa fa-paper-plane-o'></i></a>"*/ . "
                <a href='" . site_url('sales/reArmarXml/pid') . "' onClick=\"return confirm('" . lang('recreate_xml_Q') . "')\" title='" . lang("recreate_xml") . "' class='tip btn btn-success btn-xs' ><i class='fa fa-file-code-o'></i></a>
                <a href='" . site_url('sales/removeSale/pid') . "' onClick=\"return confirm('" . lang('remove_sale_Q') . "')\" title='" . lang("remove_sale") . "' class='tip btn btn-warning btn-xs' ><i class='fa fa-eye-slash'></i></a>
                <a href='" . site_url('Referral_guide/add/pid') . "' onClick=\"return confirm('" . lang('create_Referral_guide') . "')\" title='" . lang("Referral_guide_created") . "' class='tip btn btn-success btn-xs' ><i class='fa fa-truck'></i></a>
                <div class='btn-group' id='id-download-pid'>
                <a class='tip btn btn-primary btn-xs dropdown-toggle' data-toggle='dropdown' title='Descargar archivos'> 
                <i class='fa fa-download'></i></a>
                  <ul class='dropdown-menu'>
                      <li><a href='" . site_url('sales/downloadPDF/pid') . "' title='Descargar PDF'><i class='fa fa-file-pdf-o'> PDF </i></a></li>
                      <li><a href='" . site_url('sales/downloadXML/pid') . "' title='Descargar XML'><i class='fa fa-file-code-o'> XML </i></a></li>
                      <li id='id-download-cdr-pid'><a href='" . site_url('sales/downloadCDR/pid') . "' title='Descargar XML'><i class='fa fa-file-code-o'> CDR </i></a></li>
                  </ul>
                </div>
                </div></div>";
      } else {
        $accion = "<div class='text-center'><div class='btn-group'><a href='#' onClick=\"MyWindow=window.open('" . site_url('pos/view/pid/1') . "', 'MyWindow','toolbar=no,location=no,directories=no,status=no,menubar=yes,scrollbars=yes,resizable=yes,width=350,height=600'); return false;\" title='" . lang("view_invoice") . "' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a>
                <a href='" . site_url('sales/payments/pid') . "' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a>
                <a href='" . site_url('sales/add_payment/pid') . "' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a>
                <a href='" . site_url('sales/anular/pid') . "' onClick=\"return confirm('" . lang('disable_x_sale') . "')\" title='" . lang("disable_sale") . "' class='tip btn btn-info btn-xs' ><i class='fa fa-ban'></i></a>
                <a href='" . site_url('sales/recreate_pdf/pid') . "' title='" . lang("recreate_pdf") . "' class='tip btn btn-danger btn-xs' ><i class='fa fa-file-pdf-o'></i></a>
      		       "/*."<a href='" . site_url('sales/reenvioSunatXml/pid') . "' onClick=\"return confirm('" . lang('forwarding_x_sale') . "')\" title='" . lang("forwarding_sale") . "' class='tip btn btn-warning btn-xs' ><i class='fa fa-paper-plane-o'></i></a>"*/ . "
      		      <a href='" . site_url('Referral_guide/add/pid') . "' onClick=\"return confirm('" . lang('create_Referral_guide') . "')\" title='" . lang("Referral_guide_created") . "' class='tip btn btn-success btn-xs' ><i class='fa fa-truck'></i></a>
                <div class='btn-group' id='id-download'>
                <a class='tip btn btn-primary btn-xs dropdown-toggle'  data-toggle='dropdown' title='Descargar archivos'> 
                <i class='fa fa-download'></i></a>
                  <ul class='dropdown-menu'>
                  <li><a href='" . site_url('sales/downloadPDF/pid') . "' title='Descargar PDF'><i class='fa fa-file-pdf-o'> PDF </i></a></li>
                  <li><a href='" . site_url('sales/downloadXML/pid') . "' title='Descargar XML'><i class='fa fa-file-code-o'> XML </i></a></li>
                  <li id='id-downcheload-cdr-pid'><a href='" . site_url('sales/downloadCDR/pid') . "' title='Descargar XML'><i class='fa fa-file-code-o'> CDR </i></a></li>               </ul>
                </div></div></div>";
      }
    } else {
      $accion = "<div class='text-center'><div class='btn-group'><a href='#' onClick=\"MyWindow=window.open('" . site_url('pos/view/pid/1') . "', 'MyWindow','toolbar=no,location=no,directories=no,status=no,menubar=yes,scrollbars=yes,resizable=yes,width=350,height=600'); return false;\" title='" . lang("view_invoice") . "' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a>
                <a href='" . site_url('sales/payments/pid') . "' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a>
                <a href='" . site_url('sales/add_payment/pid') . "' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a>
                <a href='" . site_url('sales/anular/pid') . "' onClick=\"return confirm('" . lang('disable_x_sale') . "')\" title='" . lang("disable_sale") . "' class='tip btn btn-info btn-xs' ><i class='fa fa-ban'></i></a>
      		      <a href='" . site_url('Referral_guide/add/pid') . "' onClick=\"return confirm('" . lang('create_Referral_guide') . "')\" title='" . lang("Referral_guide_created") . "' class='tip btn btn-success btn-xs' ><i class='fa fa-truck'></i></a>
                </div></div>
                <div class='btn-group' id='id-download'>
                <a class='tip btn btn-primary btn-xs dropdown-toggle'  data-toggle='dropdown' title='Descargar archivos'> 
                <i class='fa fa-download'></i></a>
                  <ul class='dropdown-menu'>
                  <li><a href='" . site_url('sales/downloadPDF/pid') . "' title='Descargar PDF'><i class='fa fa-file-pdf-o'> PDF </i></a></li>
                  <li><a href='" . site_url('sales/downloadXML/pid') . "' title='Descargar XML'><i class='fa fa-file-code-o'> XML </i></a></li>
                  <li id='id-download-cdr-pid'><a href='" . site_url('sales/downloadCDR/pid') . "' title='Descargar XML'><i class='fa fa-file-code-o'> CDR </i></a></li>               </ul>
                </div>";
    }
    if ($estado_pago != "") {
      if ($estado_pago == "Debe" || $estado_pago == "Pagado" || $estado_pago == 'Parcial') {
        $colWhere[] = "status = '" . $estado_pago . "'";
      }
    }
    if ($vendedor != "") {
      if ($vendedor != "todos") {
        $colWhere[] = "trader = '" . $vendedor . "'";
      }
    }
    if ($estado_comprobante != "") {
      if ($estado_comprobante == 3) {
        $colWhere[] = "estado = 0";
      } else if ($estado_comprobante == 1) {
        $colWhere[] = "estado = 1";
      } else if ($estado_comprobante == 2) {
        $colWhere[] = "(estado = 1 OR  estado = 0)";
      }
    }
    if ($fecha_inicio != "" or $fecha_fin != "") {
      if ($fecha_inicio != "" && $fecha_fin != "") {
        $colWhere[] = "date between '" . $fecha_inicio . " 00:00:00' and '" . $fecha_fin . " 23:59:59'";
      } else if ($fecha_inicio != "" && $fecha_fin == "") {
        $colWhere[] = "date >= '" . $fecha_inicio . " 00:00:00'";
      }
    }
    if ($estado_comprobante == "" && $estado_pago == "" && $fecha_inicio == "") {
      $colWhere[] = "estado = 1";
    }
    if (!$this->Admin) {
      if (!$this->Caja) {
        $user_id = $this->session->userdata('user_id');
        $colWhere[] = 'created_by = ' . $user_id;
      }
    }
    $this->tabledata->get(
      'view_sales',
      'pid',
      array(
        'date',
        'vdoctype',
        'ndoc',
        'customer_name',
        'currency',
        'grand_total',
        'paid',
        'status',

        'estado',
        'Name_exp_12',
        'code'
      ),
      $colWhere,
      $accion
    );
  }

  function opened()
  {
    $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
    $this->data['page_title'] = lang('opened_bills');
    $bc = array(array('link' => '#', 'page' => lang('opened_bills')));
    $meta = array('page_title' => lang('opened_bills'), 'bc' => $bc);
    $this->page_construct('sales/opened', $this->data, $meta);
  }

  function get_opened_list()
  {

    $this->load->library('datatables');
    $this->datatables
      ->select("id, date, customer_name, hold_ref, CONCAT(total_items, ' (', total_quantity, ')') as items, grand_total", false)
      ->from('suspended_sales');
    if (!$this->Admin) {
      $user_id = $this->session->userdata('user_id');
      $this->datatables->where('created_by', $user_id);
    }
    $this->datatables->add_column(
      "Actions",
      "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/?hold=$1') . "' title='" . lang("click_to_add") . "' class='tip btn btn-info btn-xs'><i class='fa fa-th-large'></i></a>
			<a href='" . site_url('sales/delete_holded/$1') . "' onClick=\"return confirm('" . lang('alert_x_holded') . "')\" title='" . lang("delete_sale") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>",
      "id"
    )
      ->unset_column('id');

    echo $this->datatables->generate();
  }

  function recreate_pdf($id = null)
  {

    $data_inv = (array)$this->pos_model->getSaleByID($id);

    if ($data_inv['invoice_id'] != null) {

      if ($data_inv['document_type'] != 3) {

        $sale_items = (array)$this->sales_model->getSaleItemsByID($id);
        $customer_det = (array)$this->pos_model->getCustomerByID($data_inv['customer_id']);
        //***************************TRJ088 - KENY PONTE -04/09/2019*************************************

        $p = $this->site->getPDFformat();
        $pdf = $p->pdf_format;
        //***************************TRJ088 - KENY PONTE -04/09/2019*************************************

        require("funciones.php");

        //PDF
        include("app/class/QRCodeGenerator.class.php"); //****************TRJ011 - ALEXANDER ROCA - 19/03/2019 *******************

        if ($pdf == 1) { //***************************TRJ088 - KENY PONTE -04/09/2019*************************************
          if ($this->generar_pdf($id, $data_inv, $sale_items, $customer_det)) {

            $this->session->set_flashdata('message', lang("pdf_recreated"));
            redirect('sales');
          } else {
            $this->session->set_flashdata('error', lang("no_ticket"));
            redirect('sales');
          }
        }

        //***************************TRJ088 - KENY PONTE -04/09/2019*************************************
        else if ($pdf == 2) {

          if ($this->generar_pdf1($id, $data_inv, $sale_items, $customer_det)) {
            $this->session->set_flashdata('message', lang("pdf_recreated"));
            redirect('sales');
          }
        } else {
          $this->session->set_flashdata('error', lang("no_ticket"));
          redirect('sales');
        }
      }
      //***************************TRJ088 - KENY PONTE -04/09/2019*************************************
    } else {
      $this->session->set_flashdata('error', lang("not_saled"));
      redirect('sales');
    }

    $this->session->set_flashdata('error', lang("something_wrong"));
    redirect('sales');
  }
  /******************************TRJ088 - KENY PONTE - 03/09/2019*************** */
  function generar_pdf1($sale_id, $inv, $items, $customer_det)
  {
    // $inv = $this->pos_model->getSaleByID($sale_id);

    //Idioma ---------------
    $region = $this->session->userdata('region');
    $l_ruc = lang("ccf2");
    $l_dni = lang("ccf1");
    $l_address = lang("scf2");
    $arrMes = lang("months");
    $l_qty = lang("qty");
    $op_ICBPER = lang('product_tax_ICBPER') . ' (' . lang('tax_ICBPER') . ')'; //***************TRJ068 - ALEXANDER ROCA - 13/08/2019********************
    $l_description = lang("description");
    $l_importe = lang("importe");
    $l_currency = lang("currency_name");
    $op_exo = lang("op_exonerated");
    $op_exoReal = lang("op_exo"); //***************TRJ008 - ALEXANDER ROCA - 11/04/2019********************
    //----------------------
    $tipo_doc = "";
    $impRuc = "";
    if ($inv['document_type'] == 1) {
      $tipo_doc = lang('bill_title');
    } else {
      $tipo_doc = lang('invoice_title');
    }

    $numComp = $inv['invoice_id'];

    $symbol = "";
    $currency = "";
    if ($inv['currency'] == 'PEN') {
      // $symbol = "S/ ";
      $currency = strtoupper(lang("currency_pen"));
    } else if ($inv['currency'] == 'USD') {
      // $symbol = "$ ";
      $currency = lang("currency_USD");
    }

    $arrD1 = explode(" ", $inv['date']);
    $arrD2 = explode("-", $arrD1[0]);
    $ano = $arrD2[0];
    $dia = $arrD2[2];
    $mes = $arrMes[(int)$arrD2[1] - 1];
    $fecha_emision = $arrD1[0]; //********************************TRJ088 - KENY PONTE 02/09/2019******************* */
    $hora_emision = $arrD1[1]; //********************************TRJ088 - KENY PONTE 02/09/2019******************* */
    $row_items_html = "";
    //----------------------------------------------------------------
    $fecha = new DateTime($fecha_emision);
    $fecha1 = new DateTime($fecha_emision);
    $fecha->modify('first day of this month'); //muestra el primer dia del mes
    $fecha1->modify('last day of this month'); //muestra el ultimo dia del mes
    $fecha_inicio = $fecha->format('Y-m-d'); // 
    $fecha_fin = $fecha1->format('Y-m-d');
    $quantity1 = "";
    $codigo = "";
    $unidad_medida = "";
    $nombreProducto1 = "";
    $uprice1 = "";
    $subt1 = "";
    //----------------------------------------------------------------
    foreach ($items as $item) {
      $quantity = $this->tec->formatNumber($item['quantity']);
      $uprice = $this->tec->formatMoney($item['unit_price']);
      $subt = $this->tec->formatMoney($item['subtotal']);
      //***********************************TRJ024 - ALEXANDER ROCA - 01/04/2019**********************
      $nombreProducto = str_replace("<", "&lt;", $item['name']);
      $nombreProducto = str_replace(">", "&gt;", $nombreProducto);
      /*******************************TRJ088 - KENY PONTE -************************************************* */
      $code = $item['code'];
      $row = $this->site->getUMProducto($item['product_id'], $code);
      $presentation = $row->presentation;
      $quantity1 .= $quantity . '<br><br>'; //acumulador de la lista de cantidades
      $codigo .= $code . '<br><br>'; //acumulador de la lista de codigos de los productos
      $unidad_medida .= $presentation . '<br><br>'; // unidad medida
      $nombreProducto1 .= $nombreProducto . '<br><br>'; //nombre del producto
      $uprice1 .= $uprice . '<br><br>'; //precio unitario
      $subt1 .= $subt . '<br><br>'; //sub total                 
    }

    $row_items_html = '    
        <td valign="top"align="center" HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $quantity1 . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $codigo . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $unidad_medida . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $nombreProducto1 . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $uprice1 . '</td>
        <td valign="top"align="center"HEIGHT="200"style="font-size:8px;border: 1px solid #000000">' . $subt1 . '</td>';
    /*******************TRJ088 - KENY PONTE -**********************/

    $customer_name = $customer_det['name'];
    $customer_address = $customer_det['direccion'];

    if ($inv['document_type'] == 2) {
      $tipo = "RAZON SOCIAL";
      $emision = "REPRESENTACIÓN IMPRESA DE LA FACTURA ELECTRÓNICA";
      if ($customer_det['cf1'] != null) {
        $tipo = 'SEÑOR';
      }
      /**************************TRJ088 - KENY PONTE - *********************************/
      $impRuc = '<br>
							<table border="1"width="100%" cellspacing="0" cellpadding="2" >
								<tr>
									<td>
										<table>
											<tr>
												<td  style="font-size:8px;"width="20%">' . $tipo . '</td>
												<td  style="font-size:8px;"width="60%">' . $customer_name . '</td>
												<td rowspan="2" valign="top" align="right"style="font-size:8px;"width="20%">' . $l_ruc . ' : ' . $customer_det['cf2'] . '</td>
											</tr>
											<tr>
												<td align="left" style="font-size:8px;">' . $l_address . '</td>
												<td  style="font-size:8px;">' . $customer_address . '</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						<br>';
      /**********************************TRJ088 - KENY PONTE -*************************************** */
    } else {
      $emision = "REPRESENTACIÓN IMPRESA DE LA BOLETA ELECTRÓNICA";

      // $impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" >
      //             <tr>
      //                 <td align="left"  style="font-size:10px">' . $region . ', <u> '.$dia.' </u> de <u> '.$mes.' </u> del <u> '.$ano.' </u><br></td>
      //             </tr>
      //         </table>';

      $doc = $l_dni;
      $nro_doc = $customer_det['cf1'];
      $tipo = "SEÑOR(A)";
      if ($customer_det['cf1'] == null && $customer_det['cf2'] != null) {
        $doc = $l_ruc;
        $nro_doc = $customer_det['cf2'];
        $tipo = "RAZON SOCIAL";
      }
      //***************TRJ043 - ALEXANDER ROCA - 30/04/2019**************
      /*************************************TRJ088 - KENY PONTE -************************************************** */
      $impRuc = '<br>
							<table border="1"width="100%" rules="none" cellspacing="0" cellpadding="2" >
								<br>
									<td>
										<table>
											<tr>
												<td  style="font-size:8px;" width="20%">' . $tipo . '</td>
												<td  style="font-size:8px;"width="60%">' . $customer_name . '</td>
												<td rowspan="2" valign="top" style="font-size:8px;" width="20%">' . $doc . ':' . $nro_doc . '</td>
											</tr>
											<tr>
												<td align="left" style="font-size:8px;">' . $l_address . '</td>
												<td  style="font-size:8px;">' . $customer_address . '</td>
											</tr>
										</table>
									</td>
								</tr>		
							</table>
							<br>';
      //*****************************************TRJ088 - KENY PONTE -************************************************************** */						
      //***************TRJ043 - ALEXANDER ROCA - 30/04/2019**************
      // <tr>
      //     <td align="left" width="20%"  style="font-size:10px"> ' . $l_address . ': </td>
      //     <td align="left" width="80%"  style="font-size:10px"> ' . $customer_address . '</td>
      // </tr>
    }
    $sub = $this->tec->formatMoney($inv['subtotal']);
    $desc = $this->tec->formatMoney($inv['order_discount']); //(-$inv['rounding']) +
    $afc = $this->tec->formatMoney($inv['affected']);
    $exo = $this->tec->formatMoney($inv['non_affected']);
    $tax_ICBPER = $this->tec->formatMoney($inv['tax_ICBPER']); //***************TRJ068 - ALEXANDER ROCA - 13/08/2019********************
    $exoReal = $this->tec->formatMoney($inv['exonerated']); //****************TRJ008 - ALEXANDER ROCA  - 11/04/2019**********
    $igv = $this->tec->formatMoney($inv['total_tax']);
    $grat = $this->tec->formatMoney(0);
    $tot1 = $this->tec->formatMoney($inv['amount']);
    $round = $this->tec->formatMoney($inv['rounding']);
    $tot2 = $this->tec->formatMoney($inv['grand_total']);
    $totLetras = strtoupper(numtoletras($inv['grand_total']) . " " . $currency);

    $this->load->library('Pdf');

    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($tipo_doc . " - " . $numComp);
    $pdf->SetHeaderMargin(30);
    $pdf->SetTopMargin(20);
    $pdf->setFooterMargin(20);
    $pdf->SetAutoPageBreak(true);
    $pdf->SetAuthor('Author');
    $pdf->SetDisplayMode('real', 'default');

    $pdf->AddPage();

    $ivPorc = $this->Settings->default_tax_rate;
    $nombreCorto = strtoupper($this->Settings->site_name);

    $razon_social = $this->session->userdata('razon_social');
    $ruc = $this->session->userdata('ruc');
    $direccion = $this->session->userdata('direccion');
    $region = $this->session->userdata('region');
    $pais = $this->session->userdata('pais');
    $region_pais = strtoupper($region . " - " . $pais);
    $imagen = $this->session->userdata('logo');
    $pos_logo = $this->session->userdata('pos_logo');
    //****************TRJ030 - RENATO GAMONAL*******************
    $imagen2 = $this->session->userdata('logo_pdf');
    $type_imagen_pdf = $this->session->userdata('type_imagen_pdf');
    //****************TRJ030 - RENATO GAMONAL*******************

    $width = 334;
    $height = 102;

    if ($pos_logo == 2) {
      $width = 334;
      $height = 102;
    } else if ($pos_logo == 1) {
      $width = 84;
      $height = 102;
    }

    $_ruc = $l_ruc . ". " . $ruc;

    //-----------------------------------QR-------------------------------------------//
    $serieNumero = explode('-', $numComp);
    $serie = $serieNumero[0];
    $numero = $serieNumero[1];
    $date = $arrD1[0];
    $hash = $inv['digest_value'];

    if ($inv['document_type'] == 2) {
      $cusDoc = "06";
      $docType = "01";
      $numDoc = $customer_det->cf2;
      $qr = $ruc . "|" . $docType . "|" . $serie . "|" . $numero . "|" . $igv . "|" . $tot1 . "|" . $date . "|" . $cusDoc . "|" . $numDoc . "|" . $hash;
    } else {
      $cusDoc = "01";
      $docType = "03";
      $numDoc = $customer_det->cf1;
      $qr = $ruc . "|" . $docType . "|" . $serie . "|" . $numero . "|" . $igv . "|" . $tot1 . "|" . $date . "|" . $cusDoc . "|" . $numDoc . "|" . $hash;
    }
    //****************TRJ011 - ALEXANDER ROCA - 19/03/2019 *******************
    $ex1 = new QRCodeGenerator();
    $qr_img = '<img src="' . $ex1->generate($serieNumero[0] . $serieNumero[1], $qr) . '" width="80" height="80">';
    //****************TRJ011 - ALEXANDER ROCA - 19/03/2019 *******************
    //------------------------------------------------------------------------------//
    //****************TRJ030 - RENATO GAMONAL*******************
    if ($type_imagen_pdf == 1) {
      $cabecera = '<img class="aligncenter" src="' . base_url('uploads/' . $imagen) . '" width="' . $width . '" height="' . $height . '">';
      $cabecera2 = '<div><br>' . $razon_social . '<br>' . $direccion . '<br>' . $region_pais . '<br>' . $_ruc . '</div>';
    } else if ($type_imagen_pdf == 2) {
      $width2 = 370;
      $height2 = 150;
      $cabecera = '<img class="aligncenter" src="' . base_url('uploads/' . $imagen2) . '" width="' . $width2 . '" height="' . $height2 . '">';
      $cabecera2 = "";
    }
    //****************TRJ030 - RENATO GAMONAL*******************  
    //****************TRJ009 - ALEXANDER ROCA - 19/03/2019 *******************
    //***************TRJ008 - ALEXANDER ROCA - 11/04/2019********************
    //**********************************TRJ088 - KENY PONTE -****************************************** */
    $u = $this->site->getURLconsulta();
    $url = $u->footer;
    //$url=strip_tags($foot,"<br>");
    if ($tax_ICBPER > 0) {
      $rowspan = 9;
      $bol_plasticas = '<tr>
  <td colspan="1"  align="left" style="font-size:7px;border: 1px solid #000000">' . $op_ICBPER . '</td>
  <td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">' . $tax_ICBPER . '</td>
</tr> ';
    } else if ($tax_ICBPER <= 0) {
      $rowspan = 8;
      $bol_plasticas = '';
    }

    $tbl1 = <<<EOD
	<table  width="100%" cellspacing="0" cellpadding="2" >
		<tr>
			<td width="70%" align="center" style="font-size:10px">
			$cabecera
			</td>
			<td width="30%" valign="middle"><br><br><br>
				<table border="0.5" width="100%" cellspacing="0" cellpadding="8" >
					<tr>
						<td align="center"  style="font-size:10px"><h2 style="font-size:8px">$_ruc</h2></td>
					</tr>
					<tr>
						<td align="center" bgcolor="#E4E4E4" style="font-size:10px"><h2 style="font-size:8px">$tipo_doc</h2></td>
					</tr>
					<tr>
						<td align="center" style="font-size:10px"><h2 style="font-size:8px">$numComp</h2></td>
					</tr>
				</table><br>
			</td>
		</tr>
	</table>
	<br>
	<table border="1" width="100%" cellspacing="0" cellpadding="" >
		<tr>
			<td bgcolor="#1B3752" align="center" width="20%" style="font-size:10px;color: #fefeff"><strong style="font-size:7px;color: #fefeff">FECHA DE EMISION</strong></td>
			<td bgcolor="#1B3752" align="center" width="20%" style="font-size:10px;color: #fefeff"><strong style="font-size:7px;color: #fefeff">HORA DE EMISION</strong></td>
			<td bgcolor="#1B3752" align="center" width="20%" style="font-size:10px;color: #fefeff"><strong style="font-size:7px;color: #fefeff">FECHA DE VENCIMIENTO</strong></td>
			<td bgcolor="#1B3752" align="center" width="20%" style="font-size:10px;color: #fefeff"><strong style="font-size:7px;color: #fefeff">FECHA DE INICIO DE PERIODO</strong></td>
			<td bgcolor="#1B3752" align="center" width="20%" style="font-size:10px;color: #fefeff"><strong style="font-size:7px;color: #fefeff">FECHA DE FIN DE PERIODO</strong></td>
		</tr>

		<tr>
			<td align="center" style="font-size:8px">$fecha_emision</td>
			<td align="center" style="font-size:8px">$hora_emision</td>
			<td align="center" style="font-size:8px"></td>
			<td align="center" style="font-size:8px">$fecha_inicio</td>
			<td align="center" style="font-size:8px">$fecha_fin</td>
		</tr>

	</table><br>

	$impRuc
	
	<br>
	
	<table width="100%" cellspacing="0" >
	  <tr height="30">
			<th bgcolor="#1B3752" align="center" width="8%" style="font-size:7px;color: #fefeff;border: 1px solid #000000">CANTIDAD</th>
      <th bgcolor="#1B3752" align="center" width="11%" style="font-size:7px;color: #fefeff;border: 1px solid #000000">CODIGO</th>
      <th bgcolor="#1B3752" align="center" width="11.5%" style="font-size:7px;color: #fefeff;border: 1px solid #000000">UNIDAD MEDIDA</th>
			<th bgcolor="#1B3752" align="center" width="51%" style="font-size:7px;color: #fefeff;border: 1px solid #000000">DESCRIPCION</th>
			<th bgcolor="#1B3752" align="center" width="9.5%" style="font-size:7px;color: #fefeff;border: 1px solid #000000">PRECIO UNITARIO</th>
			<th bgcolor="#1B3752" align="center" width="9%" style="font-size:7px;color: #fefeff;border: 1px solid #000000">IMPORTE</th>
    </tr>
    <tr>
    $row_items_html
    </tr>
		<tr>
			<td colspan="4" rowspan="$rowspan" style="font-size:9px;"><br>SON:<br> $totLetras</td>
			<td colspan="1" align="left" style="font-size:7px;border: 1px solid #000000">Sub Total</td>
			<td colspan="1" align="right"  style="font-size:8px;border: 1px solid #000000">$sub</td>
		</tr>
		<tr>
			<td colspan="1" align="left"  style="font-size:7px;border: 1px solid #000000">op.gravada</td>
			<td colspan="1" align="right"  style="font-size:8px;border: 1px solid #000000">$afc</td>
		</tr>
		<tr>
			<td colspan="1" align="left"  style="font-size:7px;border: 1px solid #000000">$op_exo</td>
			<td colspan="1" align="right"  style="font-size:8px;border: 1px solid #000000">$exo</td>
		</tr>
		<tr>
			<td colspan="1" align="left" style="font-size:7px;border: 1px solid #000000">$op_exoReal</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$exoReal</td>
		</tr>
		<tr>
			<td colspan="1"  align="left" style="font-size:7px;border: 1px solid #000000">op.gratuita</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$grat</td>
		</tr>
		<tr>
			<td colspan="1"  align="left" style="font-size:7px;border: 1px solid #000000">I.G.V-$ivPorc %</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$igv</td>
    </tr>
   $bol_plasticas
		<tr>
			<td colspan="1"  align="left" style="font-size:7px;border: 1px solid #000000">importe total</td>
			<td colspan="1" align="right" style="font-size:8px;border: 1px solid #000000">$tot2</td>
		</tr>
	</table>    
	<br><br>	
	<table  width="100%">
		<tr style="font-size:10px">
	  	<td align="left" width="20%">$qr_img</td>                     
      <td  width="62%" style="font-size:7px;vertical-align: bottom">$emision $url</td>
		</tr>
	</table>
	<br>
EOD;
    /*******************************TRJ088 - KENY PONTE -//************************************************ */
    //***************TRJ008 - ALEXANDER ROCA - 11/04/2019********************
    //****************TRJ009 - ALEXANDER ROCA - 19/03/2019 *******************
    $pdf->writeHTML($tbl1, true, false, false, false, '');

    if (!$file = $this->sales_model->getFileBySaleID($sale_id)) {

      if ($inv['document_type'] == 1) {
        $docName = 'boletas';
      } else {
        $docName = 'facturas';
      }

      $nombPDF = randomstring(20);

      //GRABA EN TABLA HISTORIAL
      $rutaTabla = array(
        'sale_id' => $sale_id,
        'file_name' => $docName . '/' . $nombPDF . '.pdf',
      );

      $this->db->insert('sales_files', $rutaTabla);

      //GUARDA EL PDF FISICO
      $pdf->Output(FCPATH . 'uploads/pdf/' . $docName . '/' . $nombPDF . '.pdf', 'F');

      return true;
    } else {

      $this->db->update('sales_files', ['file_name' => $file->file_name], ['sale_id' => $sale_id]);

      //GUARDA EL PDF FISICO
      $pdf->Output(FCPATH . 'uploads/pdf/' . $file->file_name, 'F');

      return true;
    }

    return false;
  }

  /*******************************TRJ088 - KENY PONTE 03/09/2019******************* */

  function resend_xml($id = null)
  {

    $data_inv = (array)$this->pos_model->getSaleByID($id);

    if ($data_inv['invoice_id'] != null) {

      if ($data_inv['document_type'] != 3) {

        //Generar XML
        $sale_items = (array)$this->sales_model->getSaleItemsByID($id);
        $customer_det = (array)$this->pos_model->getCustomerByID($data_inv['customer_id']);
        require("funciones.php");
        if ($respuesta = $this->generar_xml($data_inv['invoice_id'], $data_inv, $sale_items, $customer_det)) {

          $res = array(
            'flg_response' => $respuesta['flg_response'],
            'error_code' => $respuesta['error_code'],
            'response_descrip' => $respuesta['response_descrip'],
            'digest_value' => $respuesta['digest_value']
          );

          if ($this->pos_model->updateSaleCab($id, $res)) {
            $this->session->set_flashdata('message', lang("invoice_resend"));
            redirect('sales');
          }
        }
      } else {
        $this->session->set_flashdata('error', lang("no_ticket"));
        redirect('sales');
      }
    } else {
      $this->session->set_flashdata('error', lang("not_saled"));
      redirect('sales');
    }

    $this->session->set_flashdata('error', lang("something_wrong"));
    redirect('sales');
  }

  //   function delete($id = null)
  //   {
  //     if (DEMO) {
  //       $this->session->set_flashdata('error', lang('disabled_in_demo'));
  //       redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
  //     }

  //     if ($this->input->get('id')) {
  //       $id = $this->input->get('id');
  //     }

  //     if (!$this->Admin) {
  //       $this->session->set_flashdata('error', lang("access_denied"));
  //       redirect('sales');
  //     }

  //     //REGISTRA EN TABLA MOVIMIENTOS
  //     $sale = $this->sales_model->getSaleByID($id);
  //     $sale_items = $this->sales_model->getSaleItemsByID($id);

  //     foreach ($sale_items as $sale_item) {

  //       if ($sale_item->product_id != null) {

  //         $rowMot = $this->site->getMotiveByAlias('IAV');
  //         $idMotivo = 0;
  //         if ($rowMot) {
  //           $idMotivo = $rowMot->id;
  //         }
  //         $dataM = array(
  //           'origin_id' => $sale->id,
  //           'warehouse_id' => $this->Settings->default_warehouse,
  //           'product_id' => $sale_item->product_id,
  //           'cant' => $sale_item->quantity,
  //           'tipo' => 'I',
  //           'idMotivo' => $idMotivo,
  //           'ref' => $sale->invoice_id,
  //           'uCrea' => $this->session->userdata('user_id'),
  //           'fCrea' => date("Y-m-d H:i:s"),
  //           'estado' => 1
  //         );
  //         $this->mov_model->addMovement($dataM);
  //       }
  //     }

  //     if ($this->sales_model->deleteInvoice($id)) {
  //       $this->session->set_flashdata('message', lang("invoice_deleted"));
  //       redirect('sales');
  //     }
  //   }

  function anular($id = null)
  {
    if (DEMO) {
      $this->session->set_flashdata('error', lang('disabled_in_demo'));
      redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
    }

    if ($this->input->get('id')) {
      $id = $this->input->get('id');
    }

    if (!$this->Admin) {
      $this->session->set_flashdata('error', lang("access_denied"));
      redirect('sales');
    }

    //REGISTRA EN TABLA MOVIMIENTOS
    $sale = $this->sales_model->getSaleByID($id);
    $sale_items = $this->sales_model->getSaleItemsByID($id);

    if ($sale->invoice_id != null) { //$sale->status != "DEBE"

      $warehouse_id = $sale->warehouse_id;


      foreach ($sale_items as $sale_item) {
        //***********************TRJ035 - ALEXANDER ROCA - 15/04/2019 ************
        if ($sale_item['product_id'] != null) {

          $dataM = array(
            'origin_id' => $sale->id,
            'local_id' => $this->session->userdata('local'),
            'warehouse_id' => $warehouse_id, //$this->Settings->default_warehouse,
            'product_id' => $sale_item['product_id'],
            'cant' => $sale_item['quantity'],
            'tipo' => 'I',
            'idMotivo' => 3, //Ingreso por anulación de venta
            'ref' => $sale->invoice_id,
            'uCrea' => $this->session->userdata('user_id'),
            'fCrea' => date("Y-m-d H:i:s"),
            'estado' => 1
          );

          $this->mov_model->addMovement($dataM);

          //ACTUALIZAR STOCK A ALMACEN POR DEFECTO
          $q = $this->db->get_where('tec_warehouse_stock', array('warehouse_id' => $warehouse_id, 'product_id' => $sale_item['product_id']), 1); //$this->Settings->default_warehouse

          if ($q->num_rows() > 0) {
            //return
            $fila1 = $q->row();
            $data1 = array(
              'stock' => $fila1->stock + $sale_item['quantity']
            );
            $this->db->update('tec_warehouse_stock', $data1, array('warehouse_id' => $warehouse_id, 'product_id' => $sale_item['product_id'])); //$this->Settings->default_warehouse
          } else {
            $data1 = array(
              'warehouse_id' => $warehouse_id, //$this->Settings->default_warehouse
              'product_id' => $sale_item['product_id'],
              'stock' => $fila1->stock + $sale_item['quantity']
            );
            $this->db->insert('tec_warehouse_stock', $data1);
          }
          /////////FIN DE ACTUALIZAR STOCK A ALMACEN POR DEFECTO
        }
      }
      //***********************TRJ035 - ALEXANDER ROCA - 15/04/2019 ************
    }
    $dataU = '';
    $tipoDocumento = $sale->document_type==2?'La factura':'la boleta';
    $dataU->flg_response = 1;
    $dataU->error_code = 0;
    $dataU->response_descrip= 'SYS: La anulacion de '.$tipoDocumento.' '.$sale->invoice_id.', se encuentra pendiente de envio';
    $dataU->estado = 0;
    $dataU->updated_by = $this->session->userdata('user_id');
    $dataU->updated_at = date("Y-m-d H:i:s");


    if ($this->pos_model->updateSaleCab($id, $dataU)) {
      $this->session->set_flashdata('message', lang("invoice_disabled"));
      redirect('sales');
    }
  }

  function delete_holded($id = null)
  {

    if ($this->input->get('id')) {
      $id = $this->input->get('id');
    }

    if (!$this->Admin) {
      $this->session->set_flashdata('error', lang("access_denied"));
      redirect('sales/opened');
    }

    if ($this->sales_model->deleteOpenedSale($id)) {
      $this->session->set_flashdata('message', lang("opened_bill_deleted"));
      redirect('sales/opened');
    }
  }

  /* -------------------------------------------------------------------------------- */

  function payments($id = null)
  {
    $this->data['sale'] = $this->sales_model->getSaleByID($id);
    $this->data['payments'] = $this->sales_model->getSalePayments($id);
    $this->load->view($this->theme . 'sales/payments', $this->data);
  }

  function payment_note($id = null)
  {
    $payment = $this->sales_model->getPaymentByID($id);
    $inv = $this->sales_model->getSaleByID($payment->sale_id);
    $this->data['customer'] = $this->site->getCompanyByID($inv->customer_id);
    $this->data['inv'] = $inv;
    $this->data['payment'] = $payment;
    $this->data['page_title'] = $this->lang->line("payment_note");

    $this->load->view($this->theme . 'sales/payment_note', $this->data);
  }

  function add_payment($id = null, $cid = null)
  {

    // $this->load->library('Pdf');

    $this->load->helper('security');
    if ($this->input->get('id')) {
      $id = $this->input->get('id');
    }

    $this->form_validation->set_rules('amount-paid', lang("amount"), 'required');
    $this->form_validation->set_rules('paid_by', lang("paid_by"), 'required');
    $this->form_validation->set_rules('userfile', lang("attachment"), 'xss_clean');

    if ($this->input->post('invoice') == null) { //$this->input->post('status')=='DEBE' &&
      $this->form_validation->set_rules('document_type', lang("document_type"), 'required');
    }

    if ($this->form_validation->run() == true) {

      if ($this->Admin) {
        $date = $this->input->post('date');
      } else {
        $date = date('Y-m-d H:i:s');
      }

      if ($this->input->post('invoice') == null) { //$this->input->post('status')=='DEBE' &&
        //VALIDACIONES
        // $sales = $this->sales_model->getSaleByID($this->input->post('sale_id'));
        $customer_det = (array)$this->pos_model->getCustomerByID($cid);

        $paso = 1;
        $doc_type = $this->input->post('document_type');
        $err_nopaso = "";





        if ($paso == 0) {
          echo json_encode(array('status' => 'failed', 'msg' => $err_nopaso));
          die();
          /*$this->data['error'] = $err_nopaso;
                    $this->session->set_flashdata('error', $err_nopaso);
                    redirect($_SERVER["HTTP_REFERER"]);*/
        } else {

          $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
          // echo json_encode(array('status' => 'failed', 'msg' => validation_errors())); die();
        }

        // $amount = $this->tec->formatDecimal($paid > $grand_total ? ($paid - $this->input->post('balance_amount')) : $paid);
        // $payment['pos_paid'] = $this->tec->formatDecimal($this->input->post('amount'));
        // $payment['pos_balance'] = $this->tec->formatDecimal($this->input->post('balance_amount'));

      }

      $payment = array(
        'date' => $date,
        'sale_id' => $id,
        'customer_id' => $cid,
        'reference' => $this->input->post('reference'),
        'amount' => $this->input->post('amount-paid'),
        'currency' => $this->Settings->currency_prefix,
        'paid_by' => $this->input->post('paid_by'),
        'cheque_no' => $this->input->post('cheque_no'),
        'gc_no' => $this->input->post('gift_card_no'),
        'cc_no' => $this->input->post('pcc_no'),
        'cc_holder' => $this->input->post('pcc_holder'),
        'cc_month' => $this->input->post('pcc_month'),
        'cc_year' => $this->input->post('pcc_year'),
        'cc_type' => $this->input->post('pcc_type'),
        'note' => $this->input->post('note'),
        'created_by' => $this->session->userdata('user_id'),
      );

      if ($_FILES['userfile']['size'] > 0) {
        $this->load->library('upload');
        $config['upload_path'] = 'files/';
        $config['allowed_types'] = $this->digital_file_types;
        $config['max_size'] = 2048;
        $config['overwrite'] = false;
        $config['encrypt_name'] = true;
        $this->upload->initialize($config);
        if (!$this->upload->do_upload()) {
          $error = $this->upload->display_errors();
          $this->session->set_flashdata('error', $error);
          //redirect($_SERVER["HTTP_REFERER"]);
          echo json_encode(array('status' => 'success', 'msg' => "Ok", 'redirect' => 1));
          exit();
        }
        $photo = $this->upload->file_name;
        $payment['attachment'] = $photo;
      }

      // $this->sma->print_arrays($payment);

    } elseif ($this->input->post('add_payment')) {
      $this->session->set_flashdata('error', validation_errors());
      $this->tec->dd();
    }

    //Pago en Caja
    if ($this->form_validation->run() == true) {

      if ($this->input->post('invoice') == null) { //$this->input->post('status')=='DEBE' &&

        // $start = microtime(true);
        $document_type = (int)$this->input->post('document_type');
        $note = $this->tec->clear_tags($this->input->post('spos_note'));

        //Asignar Nro Comprobante
        if ($document_type == 2) {
          $new_number = (int)$this->Settings->invoice_number + 1;
          $format = $this->Settings->invoice_format;
        } else if ($document_type == 1) {
          $new_number = (int)$this->Settings->bill_number + 1;
          $format = $this->Settings->bill_format;
        } else if ($document_type == 3) {
          $new_number = (int)$this->Settings->nventa_number + 1; 
          $format = $this->Settings->nventa_format; 
        }

        $parte1 = explode('{', $format);
        $parte2 = explode('}', $parte1[1]);
        $parentesis = $parte2[0];

        $buscar = strpos($parentesis, '+');

        if ($buscar) {
          $numero = explode('+', $parentesis);
          $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
        } else {
          $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
        }


        $serieNumero = $parte1[0] . $new_format;


        if ($this->pos_model->getInvoiceId($serieNumero)) {
          echo json_encode(array('status' => 'failed', 'msg' => lang("the_invoice") . $serieNumero . lang("not_unique")));
          exit();
        }

        //Actualiza Nro Comprobante (Settings)
        //$this->pos_model->update_invoice_Number($document_type);
        if ($this->pos_model->update_invoice_Number($document_type)) {

          if ($document_type != 3) {

            //Generar XML
            $data_inv = (array)$this->pos_model->getSaleByID($id);
            $data_inv['document_type'] = $document_type;
            $sale_items = (array)$this->sales_model->getSaleItemsByID($id);

            // $customer_det = (array)$this->pos_model->getCustomerByID($data_inv['customer_id']);
            require("funciones.php");
            if ($respuesta = $this->generar_xml($serieNumero, $data_inv, $sale_items, $customer_det)) {
              $flg_response = $respuesta['flg_response'];
              $error_code = $respuesta['error_code'];
              $response_descrip = $respuesta['response_descrip'];
              $digest_value = $respuesta['digest_value'];
              // $this->pos_model->send_bill($id);
            }
          }
        }

        //Grabar Comprobante
        $datasales = array(
          'document_type' => $document_type,
          'note' => $note,
          'invoice_id' => $serieNumero,
          'flg_response' => $flg_response,
          'error_code' => $error_code,
          'response_descrip' => $response_descrip,
          'digest_value' => $digest_value,
          //'cmp' => $this->input->post('cmp'),
          //'doctor' => $this->input->post('doctor')
        );
      }
    }

    if ($this->form_validation->run() == true && $this->sales_model->addPayment($payment)) {

      $msg = lang("payment_added");
      $this->session->set_flashdata('message', $msg);

      if ($this->input->post('status') == 'DEBE') {

        if ($this->input->post('invoice') == null) {

          if ($this->pos_model->updateSaleCab($id, $datasales)) {

            //REGISTRA EN TABLA MOVIMIENTOS
            foreach ($sale_items as $sale_item) {

              // $sale_item = (array)$sale_item;
              //***********************TRJ017 - ALEXANDER ROCA - 26/03/2019 ************
              if ($sale_item['product_id'] != null) { //$sale_item['product_id']
                //***********************TRJ017 - ALEXANDER ROCA - 26/03/2019 ************
                $dataM = array(
                  'origin_id' => $id,
                  'local_id' => $this->session->userdata('local'),
                  'warehouse_id' => $this->Settings->default_warehouse,
                  'product_id' => $sale_item['product_id'], //$sale_item->product_id, 
                  'cant' => $sale_item['quantity'], //$sale_item->quantity, //$sale_item['quantity'],
                  'tipo' => 'S',
                  'idMotivo' => 5, //Salida por venta
                  'ref' => $serieNumero,
                  'uCrea' => $this->session->userdata('user_id'),
                  'fCrea' => date("Y-m-d H:i:s"),
                  'estado' => 1
                );


                $this->mov_model->addMovement($dataM);
                $this->pos_model->updateItemStock($sale_item);
              }
            }
            // $this->pos_model->updateStock($id);
            /************************TRJ088 - KENY PONTE - 02/09/2019********************* */
            $p = $this->site->getPDFformat();
            $pdf = $p->pdf_format;

            /************************TRJ088 - KENY PONTE - 02/09/2019********************* */
            if ($document_type == 1) {

              //PDF
              include("app/class/QRCodeGenerator.class.php"); //****************TRJ011 - ALEXANDER ROCA - 19/03/2019 *******************
              //*****************TRJ088 -KENY PONTE - 03/09/2019************* */
              if ($pdf == 1) {
                $this->generar_pdf($id, $data_inv, $sale_items, $customer_det);
              } else if ($pdf == 2) {
                $this->generar_pdf1($id, $data_inv, $sale_items, $customer_det);
              }
              //*******************TRJ088 - KENY PONTE 03/09/2019*************** */
            } else if ($document_type == 2) {

              //Enviar Comprobante
              $this->enviar_comprobante($serieNumero, $id, null, "pago", $customer_det, $datasales); //***********TRJ016 - ALEXANDER ROCA - 29/03/2019************

              //PDF
              include("app/class/QRCodeGenerator.class.php"); //****************TRJ011 - ALEXANDER ROCA - 19/03/2019 *******************
              /***********************************TRJ088 - KENY PONTE - 03/09/2019****************** */
              if ($pdf == 1) {
                $this->generar_pdf($id, $data_inv, $sale_items, $customer_det);
              } else if ($pdf == 2) {
                $this->generar_pdf1($id, $data_inv, $sale_items, $customer_det);
              }
              /*******************************TRJ088 - KENY PONTE - 03/09/2019********************************** */
            }

            // $time_elapsed= microtime(true) - $start;
            // $this->session->set_flashdata('message', $time_elapsed);
            // echo json_encode(array('status' => 'success', 'msg' =>  "Ok",'redirect' =>  2,'idd' =>  $id ));
            // exit();

            //Redireccion
            echo json_encode(array('status' => 'success', 'msg' => "Ok", 'redirect' => 2, 'idd' => $id));
            exit();
          } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $sale = $this->sales_model->getSaleByID($id);
            $this->data['inv'] = $sale;

            $this->load->view($this->theme . 'sales/add_payment', $this->data);
          }
        } else {
          //Redireccion
          echo json_encode(array('status' => 'success', 'msg' => "Ok", 'redirect' => 1));
          // echo json_encode(array('status' => 'success', 'msg' =>  "Ok",'redirect' =>  2,'idd' =>  $id ));
          exit();
        }
      } else if ($this->input->post('status') == 'Pagado') {
        echo json_encode(array('status' => 'success', 'msg' => "Ok", 'redirect' => 1));
        exit();
      } else if ($this->input->post('status') == 'Parcial') {
        echo json_encode(array('status' => 'success', 'msg' => "Ok", 'redirect' => 1));
        exit();
      }
    } else {

      $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
      $sale = $this->sales_model->getSaleByID($id);
      $this->data['inv'] = $sale;

      $this->load->view($this->theme . 'sales/add_payment', $this->data);
    }
  }

  function generar_xml($serieNumero, $data, $items, $customer_det)
  {
    $invoiceTypeCode = "";
    $document = "";
    $documentID = "";
    if ($data['document_type'] == 2) {

      $invoiceTypeCode = "01";
      $documentID = $customer_det['cf2'];
      $document = "6";
    } else if ($data['document_type'] == 1) {

      $invoiceTypeCode = "03";
      // $document = "1";
      $documentID = $customer_det['cf1'];
      //**************************TRJ073 - KENY PONTE - 13/09/2019********************* */
      $doc_type = $this->sales_model->getDocument($documentID);
      $document = (string)$doc_type->document_type_id;
      //**************************TRJ073 - KENY PONTE - 13/09/2019********************* */

      // Si el cliente es una empresa
      if ($customer_det['cf1'] == null && $customer_det['cf2'] != null) {
        $document = "6";
        $documentID = $customer_det['cf2'];
      }

      if ($documentID == "" | $documentID == null) {
        $documentID = "-";
      }
    }

    if ($this->session->userdata('beta') == 0) {
      $urlDoc = "post/xml";
    } else {
      $urlDoc = "beta/post/xml";
    }

    $Date = explode(' ', $data['date'], 2);

    $supplierID = $this->session->userdata('ruc');

    $passFirma = $this->session->userdata('pass_firma');
    // $usuSol = $this->session->userdata('user_sol');
    // $passSol = $this->session->userdata('pass_sol');
    //******************************TRJ033 - ALEXANDER ROCA - 08/04/2019**********************
    $currency_prefix = (string)$data['currency']; //$this->Settings->currency_prefix;
    //******************************TRJ033 - ALEXANDER ROCA - 08/04/2019**********************
    $supplierName = $this->session->userdata('razon_social');
    $signatureID = $serieNumero;
    $URI = "#" . $signatureID;
    $supplierDocumentID = "6";
    //$localID = "0001";
    //******************************TRJ027 - ALEXANDER ROCA - 03/04/2019**********************
    //Obtener el Local
    $local_id = $this->session->userdata('local');
    $local = $this->site->getLocalByID($local_id);

    //Codigo de local
    $localID = $local->cod_sunat; //"0001";

    //******************************TRJ027 - ALEXANDER ROCA - 03/04/2019**********************
    $header = array(
      'TIPO_OPERACION' => "0101",
      'TOTAL_GRATUITAS' =>(string)$data['gratuito'],
      'TOTAL_IGV_GRATUITAS' =>(string)$data['tax_gratuito'],
      'TOTAL_EXPORTACION' => "0",
      //'POR_IGV' => "18.00",
      'TOTAL_ISC' => "0",
      'TOTAL_OTR_IMP' => "0",
      'TOTAL_LETRAS' => "",
      'NRO_GUIA_REMISION' => "",
      'COD_GUIA_REMISION' => "",
      'NRO_OTR_COMPROBANTE' => "",
      'COD_PAIS_CLIENTE' => "PE",
      'COD_UBIGEO_CLIENTE' => "",
      'DEPARTAMENTO_CLIENTE' => "",
      'PROVINCIA_CLIENTE' => "",
      'DISTRITO_CLIENTE' => "",
      'CIUDAD_CLIENTE' => "",
      'CODIGO_UBIGEO_EMPRESA' => "",
      'DIRECCION_EMPRESA' => "",
      'DEPARTAMENTO_EMPRESA' => "",
      'PROVINCIA_EMPRESA' => "",
      'DISTRITO_EMPRESA' => "",
      'CODIGO_PAIS_EMPRESA' => "",
      'CONTACTO_EMPRESA' => "",
      //******************************************************************
      "NRO_DOCUMENTO_EMPRESA" => $supplierID,
      "COD_TIPO_DOCUMENTO" => $invoiceTypeCode,
      "NRO_COMPROBANTE" => $serieNumero,
      "passFirma" => $passFirma,
      "FECHA_DOCUMENTO" => $Date[0],
      "issueTime" => $Date[1],
      "FECHA_VTO" => $Date[0],
      "note" => strtolower(numtoletras($data['amount'])),
      "COD_MONEDA" => $currency_prefix,
      "lineCountNumeric" => (string)$data['total_items'],
      "signatureID" => $signatureID,
      "RAZON_SOCIAL_EMPRESA" => replace_invalid_caracters($supplierName),
      "URI" => $URI,
      "TIPO_DOCUMENTO_EMPRESA" => $supplierDocumentID,
      "CODIGO_LOCAL" => $localID,
      "TIPO_DOCUMENTO_CLIENTE" => $document,
      "NRO_DOCUMENTO_CLIENTE" => $documentID,
      "RAZON_SOCIAL_CLIENTE" => $data['customer_name'],
      "DIRECCION_CLIENTE" => $customer_det['direccion'],
      "TOTAL_BRUTO" => (string)(float)($data['affected'] + $data['order_discount']), //(-$data['rounding']) +
      "TOTAL_IGV" => (string)$data['product_tax'],
      "TOTAL_GRAVADAS" => (string)$data['affected'], //$data['total'],
      "taxSubtotal" => (string)$data['total_tax'],
      "TOTAL" => (string)$data['amount'],
      "allowanceTotalAmount" => (string)$data['order_discount'], //(double)((-$data['rounding']) +
      "TOTAL_INAFECTA" => (string)$data['non_affected'],
      "TOTAL_EXONERADAS" => (string)$data['exonerated'], 
      "TOTAL_ICBPER" => (string)$data['tax_ICBPER'], //************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
      "mult_ICBPER" => (string)$data['mult_ICBPER'], //************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
      "FORMA_PAGO" => (string)$data['payment_method_code_sunat']
    );

    //*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
    if ($this->session->userdata('retencion') == 1) { 
      if(isset($data['retainer_total']) && $data['retainer_total'] > 0) {
        $header['RETAINER_TOTAL'] = number_format(($data['retainer_total']),2);
        $header['RETAINER_PERCENTAGE'] = number_format(($data['retainer_percentage'] / 100), 2);
      }
    }
    //*************************************END TRJ143 - DANIEL PADILLA- 23/12/2022 **************************


    if (isset($data['payment_method_cuotas'])) {
      $header['FORMA_PAGO_CUOTAS'] = $data['payment_method_cuotas'];
    }
    //******************************* TRJ057 - ALEXANDER ROCA - 20/06/2019 ******************
    $porcentaje_desc = round((((100 / $header['TOTAL_BRUTO']) * $data['order_discount']) / 100), 4);

    $discountGlobal = array(

      "TOTAL_DESCUENTO" => (string)$data['order_discount'],
      "PORCENTAJE_DESCUENTO" => (string)$porcentaje_desc
    );
    //******************************* TRJ057 - ALEXANDER ROCA - 20/06/2019 ******************

    $cant = 0;
    foreach ($items as $item) {
      //$item = (array)$item;

      // if ($item['product_id'] != NULL) {
      $product_details = (array)$this->site->getProductByID($item['product_id']);
      //     $name = $product_details['name'];
      //     $code = $product_details['code'];
      // }else{
      //     $name = $item['name'];
      //     $code = $item['code'];
      // }
      //*************************************** TRJ021 - ALEXANDER ROCA - 27/03/2019 ***************************
      $cant = $cant + 1;
      $sum_price = $item['affect_price'] + $item['non_affected_price'] + $item['exonerated_price'];

      $url = $this->config->item('api_general').'catalogos_sunat/tipo_afectacion/' . $item['tax_method'];
      $curl = curl_init();
      curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          'Content-Type: application/json'
        ),
      ));
      $response = curl_exec($curl);
      $err = curl_error($curl);
      curl_close($curl);
      $response = json_decode($response, false);
      //imprimir el resultado del servicio en los logs
      if ($response->tipo_afectacion  == 1) {
        // $amount_applies_tax=$item['unit_price'];
        // $importe_det=round((round(($amount_applies_tax*$item['quantity']),2)/1.18),2);
        $importe_det = $item['price_affected_item'];
      } else {
        if ($response->tipo_afectacion == 3) {
          // $amount_applies_tax=$item['exonerated_price'];
          // $importe_det=$amount_applies_tax * $item['quantity'];
          $importe_det = $item['price_exonerated_item'];
        } else if ($response->tipo_afectacion == 2) { 
          //  importe_det=$amount_applies_tax * $item['quantity'];
          $importe_det = $item['price_no_affected_item'];
        }else if ($response->tipo_afectacion == 4) {
          $importe_det = $item['price_gratuito_item'];
        }else if ($response->tipo_afectacion == 5) {
          $importe_det = $item['price_gratuito_item'];
        }
      }
      $item_tax = (string)$item['item_tax'];
      if ($item['igv'] == 0 || $response->tipo_afectacion != 1) {

        if ($response->tipo_afectacion == 3) {
          $CODIGO_IMPUESTO = "9997"; //codigoImp
          $TIPO_IMPUESTO = "EXO"; //tipoImp
          $TIPO_CODIGO_IMPUESTO = "VAT"; //typeCode
          $CODIGO_CATEGORIA_IMPUESTO = "E"; //taxCategoryCode
          $CODIGO_EXTENSION_IMPUESTO = (string)$response->codigo_sunat; //taxExemptionReasonCode
          $tipoPrecioVenta = "01";

        } else if($response->tipo_afectacion == 2) {

          $CODIGO_IMPUESTO = "9998"; //codigoImp
          $TIPO_IMPUESTO = "INA"; //tipoImp
          $TIPO_CODIGO_IMPUESTO = "FRE"; //typeCode
          $CODIGO_CATEGORIA_IMPUESTO = "O"; //taxCategoryCode
          $CODIGO_EXTENSION_IMPUESTO = (string)$response->codigo_sunat; //taxExemptionReasonCode
          $tipoPrecioVenta = "01";


        }else if($response->tipo_afectacion == 4){
          $CODIGO_IMPUESTO = "9996"; //codigoImp
          $TIPO_IMPUESTO = "GRA"; //tipoImp
          $TIPO_CODIGO_IMPUESTO = "FRE"; //typeCode
          $CODIGO_CATEGORIA_IMPUESTO = "O"; //taxCategoryCode
          $CODIGO_EXTENSION_IMPUESTO = (string)$response->codigo_sunat; //taxExemptionReasonCode
          $tipoPrecioVenta = "02";
          $item_tax = (string)$item['item_tax_gratuito'];
        }else if($response->tipo_afectacion == 5){
          $CODIGO_IMPUESTO = "9996"; //codigoImp
          $TIPO_IMPUESTO = "GRA"; //tipoImp
          $TIPO_CODIGO_IMPUESTO = "FRE"; //typeCode
          $CODIGO_CATEGORIA_IMPUESTO = "O"; //taxCategoryCode
          $CODIGO_EXTENSION_IMPUESTO = (string)$response->codigo_sunat; //taxExemptionReasonCode
          $tipoPrecioVenta = "02";

        }
      } else {
        $CODIGO_IMPUESTO = "1000"; //codigoImp
        $TIPO_IMPUESTO = "IGV"; //tipoImp
        $TIPO_CODIGO_IMPUESTO = "VAT"; //typeCode
        $CODIGO_CATEGORIA_IMPUESTO = "S"; //taxCategoryCode
        $CODIGO_EXTENSION_IMPUESTO = (string)$response->codigo_sunat; //taxExemptionReasonCode
        $tipoPrecioVenta = "01";
      }

      $itemArray[$cant] = array(

        "txtUNIDAD_MEDIDA_DET" => "NIU",
        //"txtCOD_TIPO_OPERACION" => "10",
        'txtCODIGO_PROD_SUNAT' => '',
        'CODIGO_IMPUESTO' => $CODIGO_IMPUESTO,
        'TIPO_IMPUESTO' => $TIPO_IMPUESTO,
        'TIPO_CODIGO_IMPUESTO' => $TIPO_CODIGO_IMPUESTO,
        'CODIGO_CATEGORIA_IMPUESTO' => $CODIGO_CATEGORIA_IMPUESTO,
        'CODIGO_EXTENSION_IMPUESTO' => $CODIGO_EXTENSION_IMPUESTO,

        "txtCANTIDAD_DET" => $item['quantity'],
        "txtIMPORTE_DET" => (string)($this->tec->formatDecimal($importe_det)), //$item['affect_price'] * $item['quantity'])),//(int)$item['quantity']),
        "txtPRECIO_DET" => (string)$item['unit_price'],
        "txtPRECIO_TIPO_CODIGO" => $tipoPrecioVenta,
        "txtIGV" => $item_tax,
        //"itemTaxSubtotalTaxableAmount" => (string)($this->tec->formatDecimal($amount_applies_tax * $item['quantity'])),//$item['affect_price'] * $item['quantity'])),//(int)$item['quantity']),
        //"itemTaxSubtotalTaxAmount" => (string)$item['item_tax'],
        "txtPRECIO_SIN_IGV_DET" => (string)$sum_price, //$item['affect_price'],
        "IGV_ITEM" => (string)(float)$item['igv'],
        "txtDESCRIPCION_DET" => (string)$item['name'], //(string)$product_details['name'], //$item['name'],//$name,
        "txtCODIGO_DET" => (string)$product_details['code'], //$item['code']//$code
        //"exonerated" => (string)$item['exonerated_price'],
        //"tax_method" => (string)$item['tax_method'],
        "ICBPER_DET" => (string)$item['tax_ICBPER'], //************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
        //"quantity_ICBPER" => (string)$item['quantity_ICBPER'],//************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
      );
    }
    //*************************************** TRJ021 - ALEXANDER ROCA - 27/03/2019 *******************************
    $emisor = array(
      "CLAVE_FIRMA" => $this->session->userdata('pass_firma'),
      "USUARIO_SOL" => $this->session->userdata('user_sol'),
      "CLAVE_SOL" => $this->session->userdata('pass_sol'),
      "BETA" => $this->session->userdata('beta'),
    );

    //datos a enviar
    $postData["header"] = $header;
    $postData["item"] = $itemArray;
    $postData["discountGlobal"] = $discountGlobal; //******************************* TRJ057 - ALEXANDER ROCA - 20/06/2019 ******************
    $postData["emisor"] = $emisor;



    // Create the context for the request
    $context = stream_context_create(array(
      'http' => array(
        'method' => 'POST',
        'header' => "Authorization: application/json\r\n" .
          "Content-Type: application/json\r\n",
        'content' => json_encode($postData)
      )
    ));    
    /****************/
    if (file_exists("datos.txt")) {
      $archivo = fopen("datos.txt", "a");
      fwrite($archivo, PHP_EOL . json_encode($postData) . PHP_EOL);
      fclose($archivo);
    } else {
      $archivo = fopen("datos.txt", "w");
      fwrite($archivo, PHP_EOL . json_encode($postData) . PHP_EOL . PHP_EOL);
      fclose($archivo);
    }
    /******************/

    // Send the request
    //$url = $this->config->item('aws_url');
    $url  = "";
    if ($data['document_type'] == 2) {
      $url = $this->config->item('aws_url') . "factura.php";
    }

    if ($data['document_type'] == 1) {
      $url = $this->config->item('aws_url') . "boleta.php";
    }
    //$response = file_get_contents($url . $urlDoc, false, $context);

    $response = file_get_contents($url, false, $context);

    /****************/
    if (file_exists("datos.txt")) {
      $archivo = fopen("datos.txt", "a");
      fwrite($archivo, PHP_EOL . json_encode($postData) . PHP_EOL . $url);
      fclose($archivo);
    } else {
      $archivo = fopen("datos.txt", "w");
      fwrite($archivo, PHP_EOL . json_encode($postData) . PHP_EOL . $url);
      fclose($archivo);
    }
    /******************/
    if ($response) {
      $res = json_decode($response, true);

      if ($res["cod_sunat"] == "0") {
        $sale_data["digest_value"] = $res["hash_cpe"];
        $sale_data["response_descrip"] = $res["msj_sunat"];
        $sale_data["flg_response"] =  "1";
      } else {
        $sale_data["digest_value"] =  "";
        $sale_data["response_descrip"] = $res["mensaje"];
        $sale_data["flg_response"] =  "0";
      }

      $sale_data["error_code"] =  $res["cod_sunat"];
      //$sale_data = array(
      //'flg_response' => $res[0],
      //'error_code' => $res[1],
      //'response_descrip' => $res[2],
      //'digest_value' => $res[4]
      //);

      return $sale_data;
    } else {
      $sale_data = array(
        'flg_response' => "0",
        'error_code' => "0",
        'response_descrip' => "Error al conectarse con WS-XML",
        'digest_value' => ""
      );

      return $sale_data;
    }

    return false;
  }

  function enviar_comprobante($serieNumero, $sale_id, $data = null, $identificador, $customer_det, $respuesta)
  {
    /*
    if ($this->session->userdata('beta') == 0) {
      $urlDoc = "post/envio";
    } else {
      $urlDoc = "beta/post/envio";
    }


    $supplierID = $this->session->userdata('ruc');
    $invoiceTypeCode = "01";

    $file_name = $supplierID . "-" . $invoiceTypeCode . "-" . $serieNumero;

    $usuSol = $this->session->userdata('user_sol');
    $passSol = $this->session->userdata('pass_sol');

    $postData = array(
      'ruc' => $supplierID,
      'typeCode' => $invoiceTypeCode,
      'serieNumero' => $serieNumero,
      'usuSol' => $usuSol,
      'passSol' => $passSol
    );

    // Create the context for the request
    $context = stream_context_create(array(
      'http' => array(
        'method' => 'POST',
        'header' => "Authorization: application/json\r\n" .
          "Content-Type: application/json\r\n",
        'content' => json_encode($postData)
      )
    ));

    // Send the request
    $url = $this->config->item('aws_url');

    $response = file_get_contents($url . $urlDoc, false, $context);
	*/
    //-------------Envio Sunat---------------//
    //if ($response) {
    //$res = json_decode($response, true);
    $tipo = "RF";

    //$datos = explode('-', $serieNumero, 2);
    //$serie = $datos[0];
    //$sNumero = $datos[1];

    if ($respuesta["flg_response"] == 0) {
      $status = 3;
    } else {
      if ($respuesta["flg_response"] == 1) {
        $status = 4;
      } else {
        $status = 1;
      }
    }

    $send_date = date("Y-m-d");
    $supplierID = $this->session->userdata('ruc');
    $invoiceTypeCode = "01";
    $file_name = $supplierID . "-" . $invoiceTypeCode . "-" . $serieNumero;
    $reg_invoice = array(
      'issue_date' => $send_date,
      //'number' => $sNumero,
      'file_name' => $file_name,
      'response_descrip' => $respuesta["response_descrip"], //$res[3] . ": " . $res[2],
      'reference_date' => $send_date,
      'processed_date' => $send_date,
      'type' => $tipo,
      'flg_response' => $respuesta["flg_response"], //$res[0],
      'error_code' => $respuesta["error_code"], //$res[1],
      'status' => $status,
      'uCrea' => $this->session->userdata('user_id'),
      'fCrea' => date('Y-m-d H:i:s'),
      'estado' => 1,
    );


    //***********TRJ016 - ALEXANDER ROCA - 29/03/2019************
    if ($status != 4) {

      $DniRuc = $customer_det["cf2"];
      $nameCliente = $customer_det["name"];

      if ($identificador == "addSale") {
        $SerieYnumero = $data["invoice_id"];
        $fecha = $data["date"];
        $montoTotal = $data["grand_total"];
        $tipoMoneda = $data["currency"];
      } else {
        $datosVenta = (array)$this->pos_model->sale($sale_id);
        $SerieYnumero = $datosVenta["invoice_id"];
        $fecha = $datosVenta["date"];
        $montoTotal = $datosVenta["grand_total"];
        $tipoMoneda = $datosVenta["currency"];
      }

      $receipt = "<html>Estimado Cliente: <br><br>Mediante la presente se informa que el siguiente comprobante no fue informado correctamente a SUNAT.<br><br>Tipo de documento &#09;&#09;&#09; : Factura Electronica<br>Serie y numero &#09;&#09;&#09;&#09; : " . $SerieYnumero . "<br>Nro RUC/DNI/CE del cliente &#09;&#09; : " . $DniRuc . "<br>Razon social cliente &#09;&#09;&#09; : " . $nameCliente . "<br>Fecha de emision &#09;&#09;&#09; : " . $fecha . "<br>Importe Total &#09;&#09;&#09;&#09; : " . $montoTotal . " " . $tipoMoneda . "<br>Motivo &#09;&#09;&#09;&#09;&#09; : (" . $res[1] . ") No hubo respuesta del servicio de SUNAT<br><br><br>Sistema TPV<br><br><br>Nota:<br>*En este correo electronico hemos eliminado las tildes para evitar errores en su visualizacion.<br>*Este mensaje es automatico, por favor no responder.<br></html>";
      $subject = "Alerta SistemaTPV - " . $this->Settings->site_name . ": Incidencia comprobante " . $SerieYnumero;
      $toUser = (array)$this->pos_model->user_mail(); //************TRJ050 RENATO GAMONAL //
      $toCopia = "soporte@actecperu.com";
      $nombreEnvia = "Sistema TPV";

      if ($this->tec->send_email($toUser["mail_incidents"], $subject, $receipt, null, $nombreEnvia, null, null, $toCopia, null, null, null)) { //************TRJ050 RENATO GAMONAL //
        //echo json_encode(array('msg' => lang("email_success")));
      } else {
        //echo json_encode(array('msg' => lang("email_failed")));
      }
    }
    //***********TRJ016 - ALEXANDER ROCA - 29/03/2019************

    $this->pos_model->addSendInvoice($reg_invoice, $sale_id);

    return true;
    /*}else{


      //cuando no hay respuesta de java
    
      $status = 1;
       $send_date = date("Y-m-d");

      $reg_invoice = array(
        'issue_date' => $send_date,
        //'number' => $sNumero,
        'file_name' => $file_name,
        'response_descrip' => $res[3] . ": " . $res[2],
        'reference_date' => $send_date,
        'processed_date' => $send_date,
        'type' => $tipo,
        'flg_response' => $res[0],
        'error_code' => $res[1],
        'status' => $status,
        'uCrea' => $this->session->userdata('user_id'),
        'fCrea' => date('Y-m-d H:i:s'),
        'estado' => 1,
      );


        $datosVenta=(array)$this->pos_model->sale ($sale_id);
        $SerieYnumero= $datosVenta["invoice_id"];
        $fecha=$datosVenta["date"];
        $montoTotal=$datosVenta["grand_total"];
        $tipoMoneda=$datosVenta["currency"];
        
		$this->pos_model->addSendInvoice($reg_invoice, $sale_id);



    }*/
  }



  function edit_payment($id = null, $sid = null)
  {

    if (!$this->Admin) {
      $this->session->set_flashdata('error', lang("access_denied"));
      redirect($_SERVER["HTTP_REFERER"]);
    }
    $this->load->helper('security');
    if ($this->input->get('id')) {
      $id = $this->input->get('id');
    }

    $this->form_validation->set_rules('amount-paid', lang("amount"), 'required');
    $this->form_validation->set_rules('paid_by', lang("paid_by"), 'required');
    $this->form_validation->set_rules('userfile', lang("attachment"), 'xss_clean');
    if ($this->form_validation->run() == true) {
      $payment = array(
        'sale_id' => $sid,
        'reference' => $this->input->post('reference'),
        'amount' => $this->input->post('amount-paid'),
        'paid_by' => $this->input->post('paid_by'),
        'cheque_no' => $this->input->post('cheque_no'),
        'gc_no' => $this->input->post('gift_card_no'),
        'cc_no' => $this->input->post('pcc_no'),
        'cc_holder' => $this->input->post('pcc_holder'),
        'cc_month' => $this->input->post('pcc_month'),
        'cc_year' => $this->input->post('pcc_year'),
        'cc_type' => $this->input->post('pcc_type'),
        'note' => $this->input->post('note'),
        'updated_by' => $this->session->userdata('user_id'),
        'updated_at' => date('Y-m-d H:i:s'),
      );

      if ($this->Admin) {
        $payment['date'] = $this->input->post('date');
      }

      if ($_FILES['userfile']['size'] > 0) {
        $this->load->library('upload');
        $config['upload_path'] = 'files/';
        $config['allowed_types'] = $this->digital_file_types;
        $config['max_size'] = 2048;
        $config['overwrite'] = false;
        $config['encrypt_name'] = true;
        $this->upload->initialize($config);
        if (!$this->upload->do_upload()) {
          $error = $this->upload->display_errors();
          $this->session->set_flashdata('error', $error);
          redirect($_SERVER["HTTP_REFERER"]);
        }
        $photo = $this->upload->file_name;
        $payment['attachment'] = $photo;
      }

      //$this->sma->print_arrays($payment);

    } elseif ($this->input->post('edit_payment')) {
      $this->session->set_flashdata('error', validation_errors());
      $this->tec->dd();
    }


    if ($this->form_validation->run() == true && $this->sales_model->updatePayment($id, $payment)) {
      $this->session->set_flashdata('message', lang("payment_updated"));
      redirect("sales");
    } else {

      $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
      $payment = $this->sales_model->getPaymentByID($id);
      if ($payment->paid_by != 'cash') {
        $this->session->set_flashdata('error', lang('only_cash_can_be_edited'));
        $this->tec->dd();
      }
      $this->data['payment'] = $payment;
      $this->load->view($this->theme . 'sales/edit_payment', $this->data);
    }
  }

  function delete_payment($id = null)
  {

    if ($this->input->get('id')) {
      $id = $this->input->get('id');
    }

    if (!$this->Admin) {
      $this->session->set_flashdata('error', lang("access_denied"));
      redirect($_SERVER["HTTP_REFERER"]);
    }

    if ($this->sales_model->deletePayment($id)) {
      $this->session->set_flashdata('message', lang("payment_deleted"));
      redirect('sales');
    }
  }

  function add()
  {
    

    $this->form_validation->set_rules('date', lang('date'), 'required');

    if ($this->form_validation->run() == true) {

      $total = 0;
      $affected = 0;
      $bruto_affecto_igv = 0;
      $tax = 0;
      $exonerated = 0;
      $exoneradoReal = 0; 
      $gratuito = 0;
      $tax_gratuito_total = 0;
      $unit_price = "price";
      $discount = $this->input->post('gdiscount');
      $total_pay = $this->input->post('total_pay');
      $document_type = (int)$this->input->post('document_type');

      if ($this->session->userdata('retencion') == 1) { 
        //*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
        $retainer_percentage = $this->input->post('retainer_percentage');
        $retainer_percentage_format = number_format(($retainer_percentage / 100), 5) ;
        $retainer_total = $total_pay * $retainer_percentage_format;
        //*************************************END TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
      }else{
        $retainer_percentage = 0;
        $retainer_percentage_format = 0;
        $retainer_total = 0;
      }
      $i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
      $settings_tax = $this->Settings->default_tax_rate;
      $count = 0;
      $countt = 0;

      //VENDEDOR 
      $traders_id = isset($_POST['traders_id']) ? $_POST['traders_id'] : NULL;
      if ($traders_id == 0) $traders_id = NULL;

      $ICBPER = (array)$this->pos_model->user_mail();


      if ($ICBPER["tax_icbper"] == 0) {
        $mult_ICBPER = 0;
      } else {
        $mult_ICBPER = (array)$this->pos_model->tax_ICBPER_amount($ICBPER["tax_icbper"]);
      }

      $total_ICBPER = 0;
      for ($r = 0; $r < $i; $r++) {
        $item_id = $_POST['product_id'][$r];
        $item_qty = $_POST['quantity'][$r];
        $item_price = $_POST['price'][$r];
        $item_affect_price = 0;
        $item_non_affected_price = 0;
        $item_exonerated_price = 0;
        $item_gratuito_price = 0;

        $item_affect_price = $_POST['affect_price'][$r];
        $item_non_affected_price = $_POST['non_affected_price'][$r];
        $item_exonerated_price = $_POST['exonerated_price'][$r];
        $item_gratuito_price = $_POST['gratuito_price'][$r];


        $tax_method = $_POST['tax_method'][$r];
        $tipo_afectacion = $_POST['tipo_afectacion'][$r];
        $real_unit_price = $_POST['real_unit_price'][$r];
        $currency_cost = $_POST['currency_cost'][$r];
        $cost = $_POST['cost'][$r];
        $name = $_POST['name'][$r];
        $code = $_POST['code'][$r];
        if ($ICBPER["tax_icbper"] > 0) {
          $tax_ICBPER = $_POST['value_ICBPER'][$r];

          if ($tax_ICBPER == 1) {

            if ($mult_ICBPER['amount'] > 0) {
              $quantity_ICBPER = (int)(round($item_qty));
            } else {
              
              $quantity_ICBPER = 0;
            }
            
            if ($quantity_ICBPER > 0) {
              $unit_price_ICBPER = $mult_ICBPER['amount'];
              $valor_item_ICBPER = $mult_ICBPER['amount'] * round($item_qty);
            } else {
              $unit_price_ICBPER = 0;
              $valor_item_ICBPER = 0;
            }
          } else {
            $unit_price_ICBPER = 0;
            $valor_item_ICBPER = 0;
            $quantity_ICBPER = 0;
          }
        } else {
          $unit_price_ICBPER = 0;
          $valor_item_ICBPER = 0;
          $quantity_ICBPER = 0;
        }

        $total_ICBPER = $total_ICBPER + $valor_item_ICBPER;

        if ($item_id && $item_qty && $unit_price) {

          $pr_item_tax = 0;
          $item_afec = 0;
          $item_tax = 0;
          $tax_gratuito = 0;
          $item_tax_gratuito = 0;
          $item_exon = 0;
          $item_exoReal = 0; 
          $item_gratuito = 0;
          $p_igv = "";
          $bool_exonerado = false;
          $bool_exoReal = false; 
          $bool_afecto = false;
            
          if (isset($settings_tax) && $settings_tax != 0) {

            if ($document_type != 3) {
              $item_afec = $item_affect_price / (1 + ($settings_tax / 100));
              $item_tax = $item_affect_price - $item_afec;
              $item_exoReal = $item_exonerated_price;
              $item_exon = $item_non_affected_price;
              $item_gratuito = $item_gratuito_price;
              if ($tipo_afectacion == 0 || $tipo_afectacion == 1) { // AFECTO
                $p_igv = $settings_tax;
                $bool_afecto = true;
              } else if ($tipo_afectacion == 2 || $tipo_afectacion == 3 || $tipo_afectacion == 5) { // 2=INAFECTO 3= exonerado 4=Gratuito
                $p_igv = 0;
              }else if ($tipo_afectacion == 4){
                $item_gratuito = $item_gratuito_price;
                $tax_gratuito = $item_gratuito * ($settings_tax / 100);
                $p_igv = $settings_tax;
              }
            } else { // NOTA DE VENTA
              $tax_method = 11;
              $item_afec = $item_affect_price; 
              $item_exoReal = $item_exonerated_price;
              $item_exon = $item_non_affected_price;
              $item_gratuito = $item_gratuito_price;
              $item_tax = 0;
              $p_igv = 0;
              $bool_afecto = true;
            }

            $pr_item_tax = $item_tax * $item_qty;
            $item_tax_gratuito = $tax_gratuito * $item_qty;
          }

          $subtotal = (($item_affect_price + $item_exoReal + $item_exon+ $item_gratuito_price) * $item_qty) + $valor_item_ICBPER; //$item_price * $item_qty;
          $igv_desc = 0;
          $gvd_desc = 0;
          $porcentaje = 0;
          $prr_discount = 0;
          if ($discount > 0) {
            if ($document_type != 3) {

              $porcentaje = $subtotal / $total_pay;
              $prr_discount = $discount * $porcentaje;
              if ($bool_afecto) {

                $gvd_desc = $prr_discount / (1 + ($settings_tax / 100));
                $igv_desc = $prr_discount - $gvd_desc;
              }
            } else {
              $gvd_desc = $discount;
              $prr_discount = 0;
              $igv_desc = 0;
            }
          } else {
            $gvd_desc = 0;
            $prr_discount = 0;
            $igv_desc = 0;
          }

          if ($code == "") {
            $item_id = null;
          }

          $unit_price_item = (float)$item_affect_price + (float)$item_non_affected_price + (float)$item_exonerated_price + (float)$item_gratuito_price;

          $unit_price_item = $unit_price_item + $unit_price_ICBPER;

          $products[] = array(
            'product_id' => $item_id,
            'code' => $code,
            'name' => $name,
            'quantity' => $item_qty,
            'unit_price' => $unit_price_item,
            'affect_price' => round($item_affect_price - $item_tax, 10), 
            'non_affected_price' => round($item_non_affected_price, 10), 
            'exonerated_price' => round($item_exonerated_price, 10), 
            'gratuito_price' => round($item_gratuito_price, 10),
            'price_affected_item' => $this->tec->formatDecimal($item_afec * $item_qty), 
            'price_no_affected_item' => $this->tec->formatDecimal($item_exon * $item_qty),
            'price_exonerated_item' => $this->tec->formatDecimal($item_exoReal * $item_qty),
            'price_gratuito_item' => $this->tec->formatDecimal($item_gratuito * $item_qty), 
            'discount' => 0,
            'item_discount' => 0.00,
            'prr_discount' => $this->tec->formatDecimal($prr_discount),
            'tax' => $this->tec->formatDecimal($item_tax),
            'item_tax' => $this->tec->formatDecimal($pr_item_tax),
            'tax_gratuito' => $this->tec->formatDecimal($tax_gratuito),
            'item_tax_gratuito' => $this->tec->formatDecimal($item_tax_gratuito),
            'igv' => $p_igv,
            'tax_ICBPER' => $valor_item_ICBPER,
            'quantity_ICBPER' => $quantity_ICBPER,
            'subtotal' => $subtotal,
            'real_unit_price' => $this->tec->formatDecimal($real_unit_price),
            'currency_cost' => $currency_cost,
            'cost' => $this->tec->formatDecimal($cost),
            'tax_method' => (int)$tax_method
          );

          $total += (((float)$item_affect_price + (float)$item_non_affected_price + (float)$item_exonerated_price) * $item_qty);

          $affected += ($item_afec * $item_qty);
          $bruto_affecto_igv +=  (($item_afec+$item_tax) * $item_qty);

          $tax += $pr_item_tax; 
          if ($item_exon > 0) {
            $exonerated += ($item_exon * $item_qty);
          } else {
            $exonerated += ($item_exon * $item_qty);
          }

          if ($item_exoReal > 0) {
            $exoneradoReal += ($item_exoReal * $item_qty);
          } else {
            $exoneradoReal += ($item_exoReal * $item_qty);
          }

          $gratuito += $item_gratuito*$item_qty;
          $tax_gratuito_total += $item_tax_gratuito;

          $count = $count + 1;
          $countt += $item_qty;
        }
      }

      if (!isset($products) || empty($products)) {
        $this->form_validation->set_rules('product', lang("order_items"), 'required');
      } else {
        krsort($products);
      }

      if ($this->form_validation->run() == true) {
        $sub_total = $affected + $exonerated + $tax + $exoneradoReal + $total_ICBPER;
        $grand_subtotal = $total + $total_ICBPER - $discount; //$total - $discount;
        $affected = $affected;
        if($discount>0){
          $tax = ($affected - $discount) * ($settings_tax / 100);
          $affected = $affected - $discount;
          $grand_subtotal = $affected + $tax;
        }

        $customer_det = (array)$this->pos_model->getCustomerByID($this->input->post('customer'));

        $data = array(
          'date' => $this->input->post('date') . " " . date('H:i:s'), //fecha de amision
          'local_id' => $this->session->userdata('local'), // identificacion del local
          'expiration_date' => $this->input->post('expiration_date') ? $this->input->post('expiration_date') : null, // fecha de experacion
          'customer_id' => $this->input->post('customer'), // identificacion del cliente
          'customer_name' => $customer_det['name'], // Nombre del cliente
          'document_type' => $document_type, // tipo de documento 1=factura 2=boleta 3 = nota de venta
          'currency' => $this->input->post('currency_code'), // codigo de moneda
          'payment_method_id' => $this->input->post('payment_method_id'), // identificacion del metodo de pago 1= contado 2= credito
          'payment_method_code_sunat' => $this->input->post('payment_method_code_sunat'), //forma de pago
          'exchange' => $this->Exchange->sell, //tipo de cambio
          'affected' => $this->tec->formatDecimal($affected), //monto afecto a igv
          'non_affected' => $this->tec->formatDecimal($exonerated), // monto inafecto
          'exonerated' => $this->tec->formatDecimal($exoneradoReal), //monto exonerado 
          'gratuito' => $this->tec->formatDecimal($gratuito), //monto exonerado 
          'tax_gratuito' => $this->tec->formatDecimal($tax_gratuito_total), //monto exonerado 
          'total' => $this->tec->formatDecimal($affected + $exonerated + $exoneradoReal), 
          'product_discount' => 0,
          'order_discount_id' => $discount,
          'order_discount' => $discount,
          'total_discount' => $discount,
          'product_tax' => $this->tec->formatDecimal($tax), 
          'order_tax_id' => 0,
          'order_tax' => 0,
          'total_tax' => $this->tec->formatDecimal($tax), 
          'tax_ICBPER' => $total_ICBPER,
          'mult_ICBPER' => $unit_price_ICBPER,
          'subtotal' => $this->tec->formatDecimal($total + $total_ICBPER),
          'amount' => $this->tec->formatDecimal($grand_subtotal),
          'grand_total' => $this->tec->formatDecimal($grand_subtotal),
          'total_items' => $count,
          'total_quantity' => $countt,
          'rounding' => 0,
          'paid' => 0,
          'status' => "DEBE",
          'created_by' => $this->session->userdata('user_id'),
          'note' => $this->input->post('note', true),
          'canal_id' => 2,
          'estado' => 1,
          'trader_id' => $traders_id,
          //*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
          'retainer_total' => $retainer_total,
          'retainer_percentage' => $retainer_percentage
          //*************************************END TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
        );
        

        $pm_credit_dates = $this->input->post('pm_credit_date');
        if (!is_null($pm_credit_dates) && count($pm_credit_dates) > 0 && $pm_credit_dates['0'] != "") {
          $pm_credit_dates = $this->input->post('pm_credit_date');
          $pm_credit_totalcuotas = $this->input->post('pm_credit_totalcuota');
          $cuotas = [];
          foreach ($pm_credit_dates as $key => $pm_credit_date) {
            $number_cuota = $key + 1;
            
            $cuotas[$number_cuota]['payment_date'] = date('d-m-Y',strtotime($pm_credit_date));
            $cuotas[$number_cuota]['amount'] = $pm_credit_totalcuotas[$key];
          }
          $dataQuotas['cuotas'] = $cuotas;
        }else{
          $cuotas[1]['payment_date'] = date('d-m-Y',strtotime($this->input->post('date')));
          $cuotas[1]['amount'] = $data['amount'];
        }

        if ($_FILES['userfile']['size'] > 0) {

          $this->load->library('upload');
          $config['upload_path'] = 'uploads/';
          $config['allowed_types'] = $this->allowed_types;
          $config['max_size'] = '2000';
          $config['overwrite'] = false;
          $config['encrypt_name'] = true;
          $this->upload->initialize($config);

          if (!$this->upload->do_upload()) {
            $error = $this->upload->display_errors();
            $this->upload->set_flashdata('error', $error);
            redirect("sales/add");
          }

          $data['attachment'] = $this->upload->file_name;
        }
        $format = "";
        $new_number = "";
        if ($data['document_type'] == 2) {
          $new_number = (int)$this->Settings->invoice_number + 1;
          $format = $this->Settings->invoice_format;
        } else if ($data['document_type'] == 1) {
          $new_number = (int)$this->Settings->bill_number + 1;
          $format = $this->Settings->bill_format;
        } else if ($data['document_type'] == 3) {
          $new_number = (int)$this->Settings->nventa_number + 1; 
          $format = $this->Settings->nventa_format; 
        }

        $parte1 = explode('{', $format);
        $parte2 = explode('}', $parte1[1]);
        $parentesis = $parte2[0];
        $buscar = strpos($parentesis, '+');

        if ($buscar) {
          $numero = explode('+', $parentesis);
          $new_format = str_pad((string)$new_number, strlen($numero[0]), "0", STR_PAD_LEFT);
        } else {
          $new_format = str_pad((string)$new_number, strlen($parentesis), "0", STR_PAD_LEFT);
        }

        $serieNumero = $parte1[0] . $new_format;

        if ($this->pos_model->getInvoiceId($serieNumero)) {
          $this->session->set_flashdata('error', lang("the_invoice") . $serieNumero . lang("not_unique"));
          redirect("sales/add");
        }

        $data['invoice_id'] = $serieNumero;

        if ($this->form_validation->run() == true) {

          //Actualiza Nro Comprobante (Settings)
          $this->pos_model->update_invoice_Number($data['document_type']);

          if ($data['document_type'] != 3) {

            //Generar XML
            require("funciones.php");
          }
        }
      }
    }
    $localData = $this->pos_model->getIDwarehouse($this->session->userdata('local'));

    $data['warehouse_id'] = $localData->default_warehouse;

    if ($data['warehouse_id'] == null || !$data['warehouse_id']) {
      $localData = $this->pos_model->getIDwarehouseDefault();
      $data['warehouse_id'] = $localData->default_warehouse;
    }
    
    if (($this->form_validation->run() == true) && ($sale = $this->sales_model->addSale($data, $products))) {
      $dataQuotas = array(
        "business_information"=>array(
          "ruc_number"=>$this->session->userdata('ruc')
        )
      );
      $dataQuotas['sale_id'] = $sale;
      $dataQuotas['currency'] = $data['currency'];
      $dataQuotas['created_by'] = $data['created_by'];
      $dataQuotas['cuotas'] = $cuotas;

      $url = $this->config->item('api_ventas');
			$url =$url. "quotas";
			$headers = array(
				'Content-Type:application/json',
				'Accept: application/json'
			);
			$curl  =curl_init($url);
			curl_setopt($curl, CURLOPT_POST,true);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($dataQuotas));
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			$response = curl_exec($curl);
			$res = json_decode($response,true);
      if 
      ($this->form_validation->run()  && isset($res)) {
        if ($res['result'] == "failed") {
          $this->session->set_flashdata('error', $res['message']);
          redirect("sales/add");
        }
        if ($res['result'] == 'ok') {
          $this->session->set_flashdata('message', $res['message']);
          if ($data['document_type'] == 2) {
            if(['payment_method_code_sunat'] != "Contado"){
                $cuotas = [];
                foreach ($res['data'] as $key=>$cuotaItem) {
                  $number_cuota = $cuotaItem->quota;
                  $cuotas[$key]['due_date'] = $cuotaItem['payment_date'];
                  $cuotas[$key]['total_cuota'] = $cuotaItem['amount'];
                  $cuotas[$key]['name_cuota'] = $cuotaItem['sunat_code'];
                }
                $data['payment_method_cuotas'] = $cuotas;
              } 
            }
        }
  
      }
      if ($data['payment_method_code_sunat'] == "Contado") {
        
          $pago = [];
          $pago['date'] = $data['date'];
          $pago['sale_id'] = $sale;
          $pago['customer_id'] = $data['customer_id'];
          $pago['paid_by'] = 'cash';
          $pago['amount'] = $data['amount'];
          $pago['currency'] = $data['currency'];
          $pago['created_by'] = $data['created_by'];
          $pago['due_date'] = date("Y-m-d");
          $pago['note_cuota'] = "contado";
          $pago['status'] = "1";
          // POR DEFECTO EL CAMPO "status" es 0, así que no lo agregamos
          $payment_cuota = $this->sales_model->addPayment($pago);
          
          //actualiza el pago de cuota
          $updateQuota = array(
            "business_information"=>array(
              "ruc_number"=>$this->session->userdata('ruc')
            )
          );
          $updateQuota['quota'] = array(
              "amount_paid"=>$data['amount'],
              "updated_by"=> $this->session->userdata('user_id')
          );
          $url = $this->config->item('api_ventas');
          $id_cuota = $res['data'][0]['id'];
          $url =$url. "quotas/".$id_cuota;
          $curl = curl_init();
          curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_POSTFIELDS =>json_encode($updateQuota),
            CURLOPT_HTTPHEADER => array(
              'Content-Type: application/json'
            ),
          ));
          $response = curl_exec($curl);
          $res = json_decode($response,true);
        
      }
      if ($data['document_type'] != 3) {
        if ($respuesta = $this->generar_xml($serieNumero, $data, $products, $customer_det)) {
          $this->sales_model->update_sale_re_XML($sale,$respuesta);
        }
      }

      $this->session->set_userdata('remove_spo', 1);
      $this->session->set_flashdata('message', lang('sale_added'));

      //REGISTRAR EN MOVIMIENTOS
      foreach ($products as $item) {

        if ($item['product_id'] != null) {

          $item_id = $item['product_id'];
          $item_quantity = $item['quantity'];
          $dataMove = array(
            'origin_id' => $sale, 
            'local_id' => $this->session->userdata('local'),
            'warehouse_id' => $this->Settings->default_warehouse,
            'product_id' => $item_id,
            'cant' => $item_quantity,
            'tipo' => 'S',
            'idMotivo' => 5, //Salida por venta
            'ref' => $data['invoice_id'], //$sale2->invoice_id,
            'uCrea' => $this->session->userdata('user_id'),
            'fCrea' => date("Y-m-d H:i:s"),
            'estado' => 1
          );

          $this->mov_model->addMovement($dataMove);

        }
      }
      $p = $this->site->getPDFformat();
      $pdf = $p->pdf_format;
      if ($document_type == 1) {

        //PDF
        include("app/class/QRCodeGenerator.class.php"); 
        if ($pdf == 1) {
          $this->generar_pdf($sale, $data, $products, $customer_det);
        } else if ($pdf == 2) {
          $this->generar_pdf1($sale, $data, $products, $customer_det);
        }
      } else if ($document_type == 2) {

        //Enviar Comprobante
        //send_envoice add
        $this->enviar_comprobante($serieNumero, $sale, null, "pago", $customer_det, $respuesta); //***********TRJ016 - ALEXANDER ROCA - 29/03/2019************

        //PDF
        include("app/class/QRCodeGenerator.class.php"); 
        if ($pdf == 1) {
          $this->generar_pdf($sale, $data, $products, $customer_det);
        } else if ($pdf == 2) {
          $this->generar_pdf1($sale, $data, $products, $customer_det);
        }
      }
      redirect("sales");
    } else {
      $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
      
      
      $get_customers = $this->get_customers();
			$this->data['customers'] = $get_customers;
      // $this->data['customers'] = $this->site->getAllCustomers();
      
      $this->data['document_type'] = $this->site->getAllDocumentType();

      $get_customers_type = $this->get_customers_type();
			$this->data['list_customer_type'] = $get_customers_type;
      // $this->data['customer_type'] = $this->site->getAllCustomerType();

      $this->data['warehouses'] = $this->site->getAllWarehouses();
      $advSale = (array)$this->site->getAdvanced_sale();
      $this->data['advance_sale'] = $advSale['advanced_sale'];

      $seting_bags = $this->pos_model->consult_plastic_bags();


      if ($seting_bags->tax_icbper == 0) {
        $this->data['plastic_bags'] = 0;
      } else {
        $consul_bags = $this->pos_model->consult_plastic_bags_type($seting_bags->tax_icbper);
        $this->data['plastic_bags'] = $consul_bags->amount;
      }

      //Busco documentos para crear el select
      $context = stream_context_create(array(
        'http' => array(
          'method' => 'GET',
          'header' => "Authorization: application/json\r\n" . "Content-Type: application/json\r\n",
          'content' => ''
        )
      ));
      $url = $this->config->item('api_general');
      $urlSerie = 'doc';
      $response = file_get_contents($url . $urlSerie, false, $context);
      $documents = json_decode($response, true);
      if ($msn['result'] == "failed") {
        if (is_array($msn['message'])) {
          $m = $msn['message'];
          $msj_error = "";
          foreach ($m as $item => $valor) {
            foreach ($valor as $cont) {
              $msj_error .= $cont . '\n';
            }
          }
        } else {
          $msj_error = $msn['message'];
        }
        $this->data['error'] = $msj_error; 
      } elseif ($msn['result'] == "ok") {
        $this->data['message'] = $msn['message'];
      } else {
      }

      //Consultas api general
      $urlapi_general = $this->config->item('api_general');
      $urlpaymenttypes = "paymenttypes";
      $response = file_get_contents($urlapi_general . $urlpaymenttypes, false, $context);
      $paymenttypes = json_decode($response, true);
      if ($paymenttypes['result'] == 'ok') {
        $paymenttypes = $paymenttypes['data']['list'];
      } else {
        $paymenttypes = [];
      }
      //Obtener listado de vendedores
      $traders = [];
      $get_traders = $this->get_traders();
      $response = json_decode($get_traders, true);
      if ($response['result'] == 'ok') {
        $traders = $response['data']['list'];
      }

      $this->data['documents'] = $documents['data']['list'];
      $this->data['payment_methods'] = $paymenttypes;
      $this->data['traders'] = $traders;
      $this->data['page_title'] = lang('add_sale');
      $bc = array(array('link' => site_url('sales'), 'page' => lang('sales')), array('link' => '#', 'page' => lang('add_sale')));
      $meta = array('page_title' => lang('add_sale'), 'bc' => $bc);
      $this->page_construct('sales/add', $this->data, $meta);
    }
  }

  function get_traders()
  {
    $urlapi_venta = $this->config->item('api_ventas');
    $url_traders = $urlapi_venta . "traders";
    //$ruc = $this->session->userdata('ruc');
    $headers = array(
      'Content-Type:application/json',
      'Accept: application/json'
    );
    $payload = array(
      'business_information' => array(
        'ruc_number' => $this->session->userdata('ruc')
      ),
    );
    $url = sprintf("%s?%s", $url_traders, http_build_query($payload));
    $process = curl_init($url); //your API url
    curl_setopt($process, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($process, CURLOPT_RETURNTRANSFER, TRUE);
    $return = curl_exec($process);
    curl_close($process);
    return $return;
  }

  function suggestions($id = null)
  {
    $affect_priceJs = null;
    $non_affected_priceJs = null;
    $exonerated_priceJs = null;

    if ($id) {
      $row = $this->site->getProductByID($id);
      $row->qty = 1;
      //***********TRJ068 - ALEXADER ROCA - 02/08/2019************
      $pr = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'tax_ICBPER' => 0, 'affect_priceJs' => $affect_priceJs, 'non_affected_priceJs' => $non_affected_priceJs, 'exonerated_priceJs' => $exonerated_priceJs);
      //***********TRJ068 - ALEXADER ROCA - 02/08/2019************
      echo json_encode($pr);
      die();
    }
    $term = $this->input->get('term', true);
    //***********TRJ0003 - ALEXADER ROCA - 13/03/2019************
    $palabraExtraida = explode(" ", $term);
    $validacion = "(";

    for ($i = 0; $i < count($palabraExtraida); $i++) {
      if ($i == count($palabraExtraida) - 1) {
        $validacion = $validacion . " name LIKE '%" . $palabraExtraida[$i] . "%'";
      } else {
        $validacion = $validacion . " name LIKE '%" . $palabraExtraida[$i] . "%' and";
      }
    }

    $validacion = $validacion . ")";

    $rows = $this->sales_model->getProductNames($term, $validacion);
    //***********TRJ0003 - ALEXADER ROCA - 13/03/2019************
    if ($rows) {
      foreach ($rows as $row) {

        //********************************TRJ064 - ALEXANDER ROCA - 03/07/2019**********************
        $this->session->set_userdata('listaVenta', $this->session->userdata('listaVenta') + 1);
        $row->productID = $row->id;
        $row->id = $this->session->userdata('listaVenta');
        //********************************TRJ064 - ALEXANDER ROCA - 03/07/2019**********************
        //***********TRJ068 - ALEXADER ROCA - 02/08/2019************ 
        $row->qty = 1;
        $pr[] = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'tax_ICBPER' => 0, 'affect_priceJs' => $affect_priceJs, 'non_affected_priceJs' => $non_affected_priceJs, 'exonerated_priceJs' => $exonerated_priceJs);
        //***********TRJ068 - ALEXADER ROCA - 02/08/2019************
      }
      echo json_encode($pr);
    } else {
      $row = array(
        'id' => substr(str_replace(".", "", microtime(true)), 0, 10),
        'qty' => 1,
        'name' => $term,
        'code' => "",
        'currency' => "",
        'price' => "0.00",
        'cost' => "0.00",
        'tax_method' => 0
      );

      // $pr[] = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row["id"], 'label' => $row["name"] . " (" . $row["code"] . ")", 'row' => $row);
      //***********TRJ068 - ALEXADER ROCA - 02/08/2019************
      $pr[] = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row["id"], 'label' => $row["name"], 'row' => $row, 'tax_ICBPER' => 0, 'affect_priceJs' => $affect_priceJs, 'non_affected_priceJs' => $non_affected_priceJs, 'exonerated_priceJs' => $exonerated_priceJs);
      echo json_encode($pr);
      //***********TRJ068 - ALEXADER ROCA - 02/08/2019************
      // echo json_encode(array(array('id' => 0, 'label' => lang('no_match_found'), 'value' => $term)));
    }
  }



  /* --------------------------------------------------------------------------------------------- */

  /* ------------------GENERA EL PDF Y GUARDA EN LA TABLA DE HISTORIAL "tec_sales_files"------------------------------- */
  function generar_pdf($sale_id, $inv, $items, $customer_det)
  {

    //Idioma ---------------
    $region = $this->session->userdata('region');
    $l_ruc = lang("ccf2");
    $l_dni = lang("ccf1");
    $l_address = lang("scf2");
    $arrMes = lang("months");
    $l_qty = lang("qty");
    $l_description = lang("description");
    $l_importe = lang("importe");
    $l_currency = lang("currency_name");
    $op_exo = lang("op_exonerated");
    $op_exoReal = lang("op_exo"); //***************TRJ008 - ALEXANDER ROCA - 11/04/2019********************
    $op_free = lang("op_free"); 
    $op_ICBPER = lang('product_tax_ICBPER') . ' (' . lang('tax_ICBPER') . ')'; //***************TRJ068 - ALEXANDER ROCA - 13/08/2019********************
    $l_forma_pago = lang("forma_pago");
    //obtenemos la informacion de las cuotas
    $urlapi_venta = $this->config->item('api_ventas');
    $url = $urlapi_venta . "quotas";
    //$ruc = $this->session->userdata('ruc');
    $headers = array(
      'Content-Type:application/json',
      'Accept: application/json'
    );
    $dataQuotas = array(
      'business_information' => array(
        'ruc_number' => $this->session->userdata('ruc')
      ),
    );
    $dataQuotas['sale_id'] = $sale_id;

    $url = sprintf("%s?%s", $url, http_build_query($dataQuotas));
    $process = curl_init($url); //your API url
    curl_setopt($process, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($process, CURLOPT_RETURNTRANSFER, TRUE);
    $response = curl_exec($process);
    curl_close($process);
    $res = json_decode($response,true);
  
    $credito_cuotas = $res['data'];
    //----------------------

    $tipo_doc = "";
    $impRuc = "";
    if ($inv['document_type'] == 1) {
      $tipo_doc = lang('bill_title');
    } else {
      $tipo_doc = lang('invoice_title');
    }

    $numComp = $inv['invoice_id'];

    $symbol = "";
    $currency = "";
    if ($inv['currency'] == 'PEN') {
      $symbol = "S/ ";
      $currency = strtoupper(lang("currency_pen"));
    } else if ($inv['currency'] == 'USD') {
      $symbol = "$ ";
      $currency = lang("currency_USD");
    }

    $arrD1 = explode(" ", $inv['date']);
    $arrD2 = explode("-", $arrD1[0]);
    $ano = $arrD2[0];
    $dia = $arrD2[2];
    $mes = $arrMes[(int)$arrD2[1] - 1];

    $row_items_html = "";
    foreach ($items as $item) {

      $item = (array)$item;

      $quantity = $this->tec->formatNumber($item['quantity']);
      $uprice = $this->tec->formatMoney($item['unit_price']);
      $subt = $this->tec->formatMoney($item['subtotal']);
      //***********************************TRJ024 - ALEXANDER ROCA - 01/04/2019**********************
      $nombreProducto = str_replace("<", "&lt;", $item['name']);
      $nombreProducto = str_replace(">", "&gt;", $nombreProducto);

      $row_items_html .= '<tr>
                    <td align="center" style="font-size:10px">' . $quantity . '</td>
                    <td align="left" style="font-size:10px">' . $nombreProducto . '</td>
                    <td align="right" style="font-size:10px">' . $uprice . '</td>
                    <td align="right" style="font-size:10px">' . $subt . '</td>
                </tr>';
    } //***********************************TRJ024 - ALEXANDER ROCA - 01/04/2019**********************

    $row_items_html .= '
            <tr>
                <td align="center">&nbsp;</td>
                <td align="left"></td>
                <td align="right"></td>
                <td align="right"></td>
            </tr>
        ';

    $customer_name = $customer_det['name'];
    $customer_address = $customer_det['direccion'];

    if ($inv['document_type'] == 2) {
      // $impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" >
      //             <tr>
      //                 <td align="left"  style="font-size:10px">' . $region . ', <u> '.$dia.' </u> de <u> '.$mes.' </u> del <u> '.$ano.' </u> </td>
      //             </tr>
      //             <tr>
      //                 <td align="left"  style="font-size:10px">' . $l_ruc . ': '.$customer_det['cf2'].'</td>
      //             </tr>

      //         </table>';

      $impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" align="left" >
                            <tr>
                                <td align="left" width="20%"  style="font-size:10px"> Señor(es): </td>
                                <td align="left" width="80%"  style="font-size:10px"> ' . $customer_name . '</td>
                            </tr>
                            <tr>
                                <td align="left" width="20%"  style="font-size:10px"> ' . $l_ruc . ': </td>
                                <td align="left" width="80%"  style="font-size:10px"> ' . $customer_det['cf2'] . '</td>
                            </tr>
                            <tr>
                                <td align="left" width="20%"  style="font-size:10px"> ' . $l_address . ': </td>
                                <td align="left" width="80%"  style="font-size:10px"> ' . $customer_address . '</td>
                            </tr>

                        </table>';
    } else {

      // $impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" >
      //             <tr>
      //                 <td align="left"  style="font-size:10px">' . $region . ', <u> '.$dia.' </u> de <u> '.$mes.' </u> del <u> '.$ano.' </u><br></td>
      //             </tr>
      //         </table>';

      $doc = $l_dni;
      $nro_doc = $customer_det['cf1'];

      if ($customer_det['cf1'] == null && $customer_det['cf2'] != null) {
        $doc = $l_ruc;
        $nro_doc = $customer_det['cf2'];
      }
      //***************TRJ043 - ALEXANDER ROCA - 30/04/2019**************
      $impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" align="left">
                        <tr>
                            <td align="left" width="20%"  style="font-size:10px"> Señor(es): </td>
                            <td align="left" width="80%"  style="font-size:10px"> ' . $customer_name . '</td>
                        </tr>

                        <tr>
								<td align="left" width="20%"  style="font-size:10px"> ' . $doc . ': </td>
								<td align="left" width="80%"  style="font-size:10px"> ' . $nro_doc . '</td>
                        </tr>
						<tr>
                                <td align="left" width="20%"  style="font-size:10px"> ' . $l_address . ': </td>
                                <td align="left" width="80%"  style="font-size:10px"> ' . $customer_address . '</td>
                        </tr>
                    </table>';
      //***************TRJ043 - ALEXANDER ROCA - 30/04/2019**************
      // <tr>
      //     <td align="left" width="20%"  style="font-size:10px"> ' . $l_address . ': </td>
      //     <td align="left" width="80%"  style="font-size:10px"> ' . $customer_address . '</td>
      // </tr>
    }

    $sub = $this->tec->formatMoney($inv['subtotal']);
    $desc = $this->tec->formatMoney($inv['order_discount']); //(-$inv['rounding']) +
    $afc = $this->tec->formatMoney($inv['affected']);
    $exo = $this->tec->formatMoney($inv['non_affected']);
    $free = $this->tec->formatMoney($inv['gratuito']);
    $tax_ICBPER = $this->tec->formatMoney($inv['tax_ICBPER']); //***************TRJ068 - ALEXANDER ROCA - 13/08/2019********************
    $exoReal = $this->tec->formatMoney($inv['exonerated']); //****************TRJ008 - ALEXANDER ROCA  - 11/04/2019**********
    $igv = $this->tec->formatMoney($inv['total_tax']);
    $tot1 = $this->tec->formatMoney($inv['amount']);
    $round = $this->tec->formatMoney($inv['rounding']);
    $tot2 = $this->tec->formatMoney($inv['grand_total']);
    $totLetras = strtoupper(numtoletras($inv['grand_total']) . " " . $currency);

    $this->load->library('Pdf');

    $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetTitle($tipo_doc . " - " . $numComp);
    $pdf->SetHeaderMargin(30);
    $pdf->SetTopMargin(20);
    $pdf->setFooterMargin(20);
    $pdf->SetAutoPageBreak(true);
    $pdf->SetAuthor('Author');
    $pdf->SetDisplayMode('real', 'default');

    $pdf->AddPage();

    $ivPorc = $this->Settings->default_tax_rate;
    $nombreCorto = strtoupper($this->Settings->site_name);

    $razon_social = $this->session->userdata('razon_social');
    $ruc = $this->session->userdata('ruc');
    $direccion = $this->session->userdata('direccion');
    $region = $this->session->userdata('region');
    $pais = $this->session->userdata('pais');
    $region_pais = strtoupper($region . " - " . $pais);
    $imagen = $this->session->userdata('logo');
    $pos_logo = $this->session->userdata('pos_logo');
    //****************TRJ030 - RENATO GAMONAL*******************
    $imagen2 = $this->session->userdata('logo_pdf');
    $type_imagen_pdf = $this->session->userdata('type_imagen_pdf');

    $forma_pago = strtoupper($inv['payment_method_code_sunat']);
    $informacion = $inv['note'];

    if (!empty($informacion)) {
      $tableInfo = '<br><br>
        <table border="1" width="100%">
          <tr>
              <td bgcolor="#E4E4E4" align="center"  width="100%" style="font-size:10px"><strong>Información</strong></td>
          </tr>
          <tr>
              <td tyle="font-size:10px">' . $informacion . '</td>
          </tr>
        </table>';
    } else {
      $tableInfo = "";
    }
    //****************TRJ030 - RENATO GAMONAL*******************

    $width = 334;
    $height = 102;

    if ($pos_logo == 2) {
      $width = 334;
      $height = 102;
    } else if ($pos_logo == 1) {
      $width = 84;
      $height = 102;
    }

    $_ruc = $l_ruc . ". " . $ruc;

    //-----------------------------------QR-------------------------------------------//
    $serieNumero = explode('-', $numComp);
    $serie = $serieNumero[0];
    $numero = $serieNumero[1];
    $date = $arrD1[0];
    $hash = $inv['digest_value'];

    if ($inv['document_type'] == 2) {
      $cusDoc = "06";
      $docType = "01";
      $numDoc = $customer_det['cf2'];
      $qr = $ruc . "|" . $docType . "|" . $serie . "|" . $numero . "|" . $igv . "|" . $tot1 . "|" . $date . "|" . $cusDoc . "|" . $numDoc . "|" . $hash;
    } else {
      $cusDoc = "01";
      $docType = "03";
      $numDoc = $customer_det['cf1'];
      $qr = $ruc . "|" . $docType . "|" . $serie . "|" . $numero . "|" . $igv . "|" . $tot1 . "|" . $date . "|" . $cusDoc . "|" . $numDoc . "|" . $hash;
    }
    //****************TRJ011 - ALEXANDER ROCA - 19/03/2019 *******************
    $ex1 = new QRCodeGenerator();
    $qr_img = '<img src="' . $ex1->generate($serieNumero[0] . $serieNumero[1], $qr) . '" width="120" height="120">';
    //****************TRJ011 - ALEXANDER ROCA - 19/03/2019 *******************
    //------------------------------------------------------------------------------//
    //****************TRJ030 - RENATO GAMONAL*******************
    if ($type_imagen_pdf == 1) {
      $cabecera = '<img class="aligncenter" src="' . base_url('uploads/' . $imagen) . '" width="' . $width . '" height="' . $height . '">';
      $cabecera2 = '<div><br>' . $razon_social . '<br>' . $direccion . '<br>' . $region_pais . '<br>' . $_ruc . ' </div>';
    } else if ($type_imagen_pdf == 2) {
      $width2 = 370;
      $height2 = 150;
      $cabecera = '<img class="aligncenter" src="' . base_url('uploads/' . $imagen2) . '" width="' . $width2 . '" height="' . $height2 . '">';
      $cabecera2 = "";
    }
    //$credito_cuotas = $this->sales_model->getSalePayments($sale_id);
    $cantidad_cuotas = count($credito_cuotas);

    if ($forma_pago == "CREDITO") {
      if (!empty($cantidad_cuotas)) {
        $cantidad_cuotas = '&nbsp;&nbsp;&nbsp;<span align="right">Cuotas:' . $cantidad_cuotas . '</span>';
      } else {
        $cantidad_cuotas = "";
      }
    } else {
      $cantidad_cuotas = "";
    }

    if ($inv['document_type'] == 2) {
      $e_forma_pago = '<tr><td ><span align="left"  style="font-size:10px">' . $l_forma_pago . ': ' . $forma_pago . '</span>' . $cantidad_cuotas . '</td></tr>';
    } else {
      $e_forma_pago = '';
    }

    //Creando tabla con informacion de las cuotas
    if ($forma_pago == "CREDITO") {

      $table_cuotas = '<table border="1" width="100%">
    <tr>
    <td align="center" bgcolor="#E4E4E4" style="font-size:10px"><strong>Información de cuotas</strong></td>
    </tr>
    <tr>
    <td>
    <table frame = "box" rules = "none" width="100%">
    
    <tr>
      <td  align="center" style="font-size:10px "><strong>N° Cuota</strong></td>
      <td  align="center" style="font-size:10px"><strong>Fec. Ven.</strong></td>
      <td  align="center" style="font-size:10px"><strong>Monto</strong></td>    
      <td  align="center" style="font-size:10px"><strong>N° Cuota</strong></td>
      <td  align="center" style="font-size:10px"><strong>Fec. Ven.</strong></td>
      <td  align="center" style="font-size:10px"><strong>Monto</strong></td>      
      <td  align="center" style="font-size:10px"><strong>N° Cuota</strong></td>
      <td  align="center" style="font-size:10px"><strong>Fec. Ven.</strong></td>
      <td  align="center" style="font-size:10px"><strong>Monto</strong></td>       
    </tr><tr>';
      $i = 1;
      $ncuotas = 1;
      foreach ($credito_cuotas as $credito_cuota) {
        $table_cuotas .= '<td  style="font-size:10px"> Cuota  ' . $credito_cuota['quota'] . '</td>';
        $table_cuotas .= '<td  style="font-size:10px"> ' . date("d/m/Y", strtotime($credito_cuota['payment_date'])) . '</td>';
        $table_cuotas .= '<td  style="font-size:10px"> ' . $credito_cuota['amount'] . '</td>';
        if ($i == 3) {
          $i = 0;
          $table_cuotas .= '</tr><tr>';
        }
        $i++;
      }
      $table_cuotas .= '</tr></table></td></tr></table>';
    } else {
      $table_cuotas = "";
    }
    //*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
    $table_retainer = "";

    if(isset($inv['retainer_total']) && $inv['retainer_total'] > 0) {
      $table_retainer = '<br><br>
        <table border="0" width="100%" cellspacing="0" cellpadding="2" >
            <tr>
                <td align="left" style="font-size:10px">Porcentaje de retención: '.$inv['retainer_percentage'].'%</td>
            </tr>
            <tr>
                <td align="left" style="font-size:10px">Monto de retención: '.$symbol. $this->tec->formatMoney($inv['retainer_total']).'</td>
            </tr>
        </table>';
    }
    if($this->session->userdata('gratuito')){
      $trGratuito='<tr>
              <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>'.$op_free.'</strong></td>
              <td align="right" width="40%" style="font-size:10px">'.$free.'</td>
          </tr>';
    }else{
      $trGratuito = "";
    }
    //*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************

    //****************TRJ030 - RENATO GAMONAL*******************  
    //****************TRJ009 - ALEXANDER ROCA - 19/03/2019 *******************
    //****************TRJ008 - ALEXANDER ROCA  - 11/04/2019**********
    //***************TRJ068 - ALEXANDER ROCA - 13/08/2019********************
    $tbl = <<<EOD
            <table border="0" width="100%" cellspacing="0" cellpadding="2" >
                <tr>
                    <td width="65%" align="center" style="font-size:10px">
                        $cabecera
						$cabecera2
                    </td>
                    <td width="35%" valign="middle"><br><br><br><br>
                        <table border="1" width="100%" cellspacing="0" cellpadding="2" >
                            <tr>
                                <td align="center"  style="font-size:10px"><h2>$_ruc</h2></td>
                            </tr>
                            <tr>
                                <td align="center" bgcolor="#E4E4E4" style="font-size:10px"><h2>$tipo_doc</h2></td>
                            </tr>
                            <tr>
                                <td align="center" style="font-size:10px"><h2>$numComp</h2></td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <tr>
                    <td width="65%" align="left">

                        $impRuc

                    </td>

                    <td width="35%">

                        <table border="1" width="100%" cellspacing="0" cellpadding="2" >
                            <tr>
                                <td align="left" style="font-size:10px"> <u>$region</u> ,  <u>     $dia     </u>   de   <u>   $mes   </u>   del   <u>     $ano     </u> </td>
                            </tr>
                            <tr>
                                <td align="left"  style="font-size:10px"> $l_currency: $currency</td>
                            </tr>
                            $e_forma_pago
                        </table>

                    </td>
                </tr>
            </table>
            <br><br>
          $table_cuotas
                <br><br>

                <table border="1" width="100%" cellspacing="0" cellpadding="2" >
                    <tr>
                        <td bgcolor="#E4E4E4" align="center" width="10%" style="font-size:10px"><strong>$l_qty</strong></td>
                        <td bgcolor="#E4E4E4" align="center" width="60%" style="font-size:10px"><strong>$l_description</strong></td>
                        <td bgcolor="#E4E4E4" align="center" width="15%" style="font-size:10px"><strong>Precio Unitario</strong></td>
                        <td bgcolor="#E4E4E4" align="center" width="15%" style="font-size:10px"><strong>$l_importe</strong></td>
                    </tr>
                    $row_items_html
                </table>
                <table border="0" width="100%" cellspacing="0" cellpadding="2" >
                    <tr>
                        <td align="left" style="font-size:10px">SON: $totLetras</td>
                    </tr>
                </table>
                $table_retainer
                <table border="0" width="100%" cellspacing="0" cellpadding="2" >
                    <tr>
                        <td  width="70%" align="center">
                            <table border="0" cellspacing="0" cellpadding="2" >
                                <tr>
                                    <td align="center">$qr_img</td>
                                    <br>
                                </tr>
                                <tr>
                                    <td align="center" style="font-size:10px"><i>CANCELADO</i></td>
                                </tr>
								<BR>
                                <tr>
                                    <td align="center" style="font-size:10px"><u>$region</u> ,  __________<!--$dia--> de __________<!--$mes--> del __________<!--$ano--> </td>
                                </tr>
                            </table>
                        </td>

                        <td align="center" width="30%">

                        <br><br>

                        <table border="1" width="100%" cellspacing="0" cellpadding="2" >
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Sub Total</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$sub</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Descuento</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$desc</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Total</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$tot1</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Op. Gravadas</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$afc</td>
                            </tr>
							<tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>$op_exoReal</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$exoReal</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>$op_exo</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$exo</td>
                            </tr>
                            $trGratuito                   
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>IGV - $ivPorc %</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$igv</td>
                            </tr>
							<tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>$op_ICBPER</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$tax_ICBPER</td>
                            </tr>
                            <tr>
									<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Redondeo</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$round</td>
                            </tr>
                            <tr>
                                <td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Total Venta</strong></td>
                                <td align="right" width="40%" style="font-size:10px">$tot2</td>
                            </tr>
                        </table>

                        </td>
                    </tr>
                </table>
                $tableInfo
                <br>
EOD;
    //***************TRJ068 - ALEXANDER ROCA - 13/08/2019********************
    //****************TRJ008 - ALEXANDER ROCA  - 11/04/2019**********
    //****************TRJ009 - ALEXANDER ROCA - 19/03/2019 *******************
    $pdf->writeHTML($tbl, true, false, false, false, '');

    if (!$file = $this->sales_model->getFileBySaleID($sale_id)) {

      if ($inv['document_type'] == 1) {
        $docName = 'boletas';
      } else {
        $docName = 'facturas';
      }

      $nombPDF = randomstring(20);

      //GRABA EN TABLA HISTORIAL
      $rutaTabla = array(
        'sale_id' => $sale_id,
        'file_name' => $docName . '/' . $nombPDF . '.pdf',
      );

      $this->db->insert('sales_files', $rutaTabla);

      //GUARDA EL PDF FISICO
      $pdf->Output(FCPATH . 'uploads/pdf/' . $docName . '/' . $nombPDF . '.pdf', 'F');

      return true;
    } else {

      $this->db->update('sales_files', ['file_name' => $file->file_name], ['sale_id' => $sale_id]);

      //GUARDA EL PDF FISICO
      $pdf->Output(FCPATH . 'uploads/pdf/' . $file->file_name, 'F');

      return true;
    }

    return false;
  }

  //***************TRJ029 - ALEXANDER ROCA - 05/04/2019*************************
  function reenvioSunatXml($id = null)
  {


    try {

      //**********TRJ041 - ALEXANDER ROCA - 29/04/2019**************
      $capturaVenta = $this->sales_model->sale($id);


      if ($this->sales_model->getSendInvoce($id)) {

        $this->session->set_flashdata('error', "La factura " . $capturaVenta->invoice_id . " " . lang("send_ok_error"));
        redirect('sales');
      } else {

        $data = array(
          'document_type' => $capturaVenta->document_type,
          'invoice_id' => $capturaVenta->invoice_id,
          'customer_id' => $capturaVenta->customer_id,
        );

        $customer_det = (array)$this->sales_model->customers_sale($data['customer_id']);

        if ($data['document_type'] == 2) {

          $this->enviar_comprobante($data['invoice_id'], $id, null, "pago", $customer_det);
        } else {
          $this->session->set_flashdata('error', lang("type_error"));
          redirect('sales');
        }

        $this->sales_model->update_status_send_invoice($id);

        $this->session->set_flashdata('message', $capturaVenta->invoice_id . " - " . lang("invoice_forwarding"));
        redirect('sales');
      } //**********TRJ041 - ALEXANDER ROCA - 29/04/2019**************

    } catch (Exception $e) {

      $this->session->set_flashdata('error', lang("type_error") . " - error :" . $e);
      redirect('sales');
    }
  }
  //***************TRJ029 - ALEXANDER ROCA - 05/04/2019*************************

  //**********TRJ045 - ALEXANDER ROCA - 21/05/2019**************
  function reArmarXml($id = null)
  {
    $capturaVenta = (array)$this->sales_model->sale($id);

    if ($capturaVenta['document_type'] != 2 && $capturaVenta['document_type'] != 1) {

      $this->session->set_flashdata('error', $capturaVenta['invoice_id'] . " - solo se pueden recrear XML y reenviar de Facturas");
      redirect('sales');
    }

    if ($capturaVenta['flg_response'] == 1 && $capturaVenta['error_code'] == 0) {

      $this->session->set_flashdata('warning', $capturaVenta['invoice_id'] . " - " . lang("recreate_Xml_error_access"));
      redirect('sales');
    } else {

      $serieNumero = $capturaVenta['invoice_id'];
      $customer_det = (array)$this->pos_model->getCustomerByID($capturaVenta['customer_id']);

      $data = array(
        'document_type' => $capturaVenta['document_type'],
        'date' => $capturaVenta['date'],
        'currency' => $capturaVenta['currency'],
        'amount' => $capturaVenta['amount'],
        'total_items' => $capturaVenta['total_items'],
        'customer_name' => $capturaVenta['customer_name'],
        'order_discount' => $capturaVenta['order_discount'],
        'product_tax' => $capturaVenta['product_tax'],
        'affected' => $capturaVenta['affected'],
        'gratuito' => $capturaVenta['gratuito'],
        'total_tax' => $capturaVenta['total_tax'],
        'tax_gratuito' => $capturaVenta['tax_gratuito'],
        'exonerated' => $capturaVenta['exonerated'],
        'non_affected' => $capturaVenta['non_affected'],
        'tax_ICBPER' => (string)$capturaVenta['tax_ICBPER'], //************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
        'mult_ICBPER' => (string)$capturaVenta['mult_ICBPER'], //************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
        'payment_method_id' => $capturaVenta['payment_method_id'],
        'payment_method_code_sunat' => $capturaVenta['payment_method_code_sunat']
      );

      // Si el método de pago es "crédito", tiene cuotas. Sólo sucede cuando es factura
      if ($capturaVenta['payment_method_id'] == 2) {
        //obtenemos la informacion de las cuotas
        $urlapi_venta = $this->config->item('api_ventas');
        $url = $urlapi_venta . "quotas";
        //$ruc = $this->session->userdata('ruc');
        $headers = array(
          'Content-Type:application/json',
          'Accept: application/json'
        );
        $dataQuotas = array(
          'business_information' => array(
            'ruc_number' => $this->session->userdata('ruc')
          ),
        );
        $dataQuotas['sale_id'] = $id;

        $url = sprintf("%s?%s", $url, http_build_query($dataQuotas));
        $process = curl_init($url); //your API url
        curl_setopt($process, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($process, CURLOPT_RETURNTRANSFER, TRUE);
        $response = curl_exec($process);
        curl_close($process);
        $res = json_decode($response,true);
      
        if ($res['result'] == 'ok') {
          $credito_cuotas = $res['data'];
          $cuotas = [];
          foreach ($credito_cuotas as $key=>$cuotaItem) {
            $number_cuota = $cuotaItem->quota;
            //$name_cuota = "Cuota" . $cuotaItem->sunat_code;
            $cuotas[$key]['due_date'] = $cuotaItem['payment_date'];
            $cuotas[$key]['total_cuota'] = round($cuotaItem['amount'],2);
            $cuotas[$key]['name_cuota'] = $cuotaItem['sunat_code'];
          }
          $data['payment_method_cuotas'] = $cuotas;
        }
      }
      $items = $this->sales_model->getSaleItemsByID($id);

      foreach ($items as $item) {

        $products[] = array(
          'quantity' => $item['quantity'],
          'affect_price' => $item['affect_price'],
          'non_affected_price' => $item['non_affected_price'],
          'exonerated_price' => $item['exonerated_price'],
          'gratuito_price' => $item['gratuito_price'],
          'unit_price' => $item['unit_price'],
          'price_affected_item' => $item['price_affected_item'], //$this->tec->formatDecimal($item_price - $item_tax),
          'price_no_affected_item' => $item['price_no_affected_item'], //$this->tec->formatDecimal($item_price - $item_tax),
          'price_exonerated_item' => $item['price_exonerated_item'],
          'price_gratuito_item' => $item['price_gratuito_item'],
          'item_tax' => $item['item_tax'],
          'item_tax_gratuito' => $item['item_tax_gratuito'],
          'igv' => $item['igv'],
          'name' => $item['name'],
          'product_id' => $item['product_id'],
          "tax_method" => $item['tax_method'],
          "tax_ICBPER" => (string)$item['tax_ICBPER'], //************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
          "quantity_ICBPER" => (string)$item['quantity_ICBPER'], //************TRJ068 - ALEXANDER ROCA - 12/08/2019***********
        );
      }

      require("funciones.php");

      if ($respuesta = $this->generar_xml($serieNumero, $data, $products, $customer_det)) {
        $resp['flg_response'] = $respuesta['flg_response'];
        $resp['error_code'] = $respuesta['error_code'];
        $resp['response_descrip'] = $respuesta['response_descrip'];
        $resp['digest_value'] = $respuesta['digest_value'];
      }

      if ($capturaVenta['document_type'] != 1) {
        $this->enviar_comprobante($serieNumero, $id, null, "pago", $customer_det, $respuesta);
        $this->sales_model->update_status_send_invoice($id);
      }

      if ($this->sales_model->update_sale_re_XML($id, $resp)) {
        if ($capturaVenta['document_type'] != 1) {
          $this->session->set_flashdata('message', $capturaVenta['invoice_id'] . " - Se recreo el XML y reenvio a SUNAT");
        } else {
          $this->session->set_flashdata('message', $capturaVenta['invoice_id'] . " - Se recreo el XML");
        }
        redirect('sales');
      }
    }




    $this->session->set_flashdata('error', $capturaVenta['invoice_id'] . " - error al recrear XML y reenviar a SUNAT");
    redirect('sales');
  }
  //**********TRJ045 - ALEXANDER ROCA - 21/05/2019**************
  //**********TRJ074 - ALEXANDER ROCA - 23/08/2019**************
  function removeSale($id = null)
  {

    if ($this->sales_model->remove_sale($id)) {

      $capturaVenta = (array)$this->sales_model->sale($id);
      $this->session->set_flashdata('message', lang("proof") . " " . $capturaVenta['invoice_id'] . " " . lang("remove_sale_succes"));
      redirect('sales');
    } else {
      $this->session->set_flashdata('error', lang("remove_sale_error"));
      redirect('sales');
    }
  }
  //**********TRJ074 - ALEXANDER ROCA - 23/08/2019**************
  //********************TRJ111 - KENY PONTE - 08/02/2022********************/
  function downloadPDF($sale_id)
  {
    $Archivo = $this->pos_model->getFileNameBySaleId($sale_id);
    $nombreArchivo = $Archivo->file_name;
    $ruta = '/uploads/pdf/';
    $rutaArchivo = $ruta . $nombreArchivo;

    $raiz = dirname(__DIR__);
    $pos = strripos($raiz, '/app');
    $file_raiz = substr($raiz, 0, $pos);

    $filePath = $file_raiz . $rutaArchivo;

    $invoice = $this->sales_model->getInvoiceIdSale($sale_id);
    $nombreArchivoDescarga = $invoice->invoice_id . ".pdf";
    //echo $ubicacionArchivo;
    if (!empty($nombreArchivo) && file_exists($filePath)) {
      // Define headers
      header("Cache-Control: public");
      header("Content-Description: File Transfer");
      header("Content-Disposition: attachment; filename=$nombreArchivoDescarga");
      header("Content-Type: application/PDF");
      header("Content-Transfer-Encoding: binary");

      // Read the file
      readfile($filePath);
      exit;
    } else {
      $this->session->set_flashdata('error', "No se encontro el archivo PDF.");
      redirect('sales');
    }
  }
  function downloadXML($sale_id)
  {

    $inv = $this->pos_model->getSaleByID($sale_id);

    if ($inv->document_type == 2) {
      $tipo = "01";
    } else {
      $tipo = "03";
    }
    if ($this->session->userdata('beta') == 0) {
      $direccion = $this->session->userdata('ubicacion_XML') . $this->session->userdata('ruc') . '/CPE/XML/';
    } else {
      $direccion = $this->session->userdata('ubicacion_XML') . $this->session->userdata('ruc') . '/CPE/BETA/';
    }

    if (!file_exists($direccion)) {
      mkdir($direccion);
    }

    $ubicacionArchivo_XML = $direccion . $this->session->userdata('ruc') . "-" . $tipo . "-" . $inv->invoice_id . ".XML";

    $nombreArchivoDescarga = $inv->invoice_id . ".XML";

    if (!empty($nombreArchivoDescarga) && file_exists($ubicacionArchivo_XML)) {
      header("Cache-Control: public");
      header("Content-Description: File Transfer");
      header("Content-Disposition: attachment; filename=$nombreArchivoDescarga");
      header("Content-Type: application/XML");
      header("Content-Transfer-Encoding: binary");

      readfile($ubicacionArchivo_XML);
      exit;
    } else {
      $this->session->set_flashdata('error', "No se encontro el archivo XML");
      redirect('sales');
    }
  }
  //********************TRJ111 - KENY PONTE - 11/02/2022********************/
  function downloadCDR($sale_id)
  {

    $inv = $this->pos_model->getSaleByID($sale_id);

    if ($inv->document_type == 2) {
      $tipo = "01";
    } else {
      $tipo = "03";
    }
    if ($this->session->userdata('beta') == 0) {
      $direccion = $this->session->userdata('ubicacion_XML') . $this->session->userdata('ruc') . '/CDR/XML/';
    } else {
      $direccion = $this->session->userdata('ubicacion_XML') . $this->session->userdata('ruc') . '/CDR/BETA/';
    }

    if (!file_exists($direccion)) {
      mkdir($direccion);
    }

    $ubicacionArchivo_XML = $direccion . "R-" . $this->session->userdata('ruc') . "-" . $tipo . "-" . $inv->invoice_id . ".XML";

    $nombreArchivoDescarga = "CDR-" . $inv->invoice_id . ".XML";

    if (!empty($nombreArchivoDescarga) && file_exists($ubicacionArchivo_XML)) {
      header("Cache-Control: public");
      header("Content-Description: File Transfer");
      header("Content-Disposition: attachment; filename=$nombreArchivoDescarga");
      header("Content-Type: application/XML");
      header("Content-Transfer-Encoding: binary");

      readfile($ubicacionArchivo_XML);
      exit;
    } else {
      $this->session->set_flashdata('error', "No se encontro el archivo XML del CDR");
      redirect('sales');
    }
  }
  //********************TRJ111 - KENY PONTE - 11/02/2022********************/
  function getTypeSaleForId($invoice_id)
  {
    $data = $this->sales_model->getTypeSaleForId($invoice_id);
    echo json_encode($data);
  }

  function get_customers_type()
	{
		$urlapi_venta = $this->config->item('api_ventas');
		$url_customer_type = $urlapi_venta . "customer_type";
		//$ruc = $this->session->userdata('ruc');
		$headers = array(
			'Content-Type:application/json',
			'Accept: application/json'
		);
		$payload = array(
			'business_information' => array(
				'ruc_number' => $this->session->userdata('ruc')
			),
		);
		$url = sprintf("%s?%s", $url_customer_type, http_build_query($payload));
		$process = curl_init($url); //your API url
		curl_setopt($process, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($process, CURLOPT_RETURNTRANSFER, TRUE);
		$return = curl_exec($process);
		curl_close($process);

		$customer_type = json_decode($return, true);
		return $customer_type["data"]["list"];
	}

	function get_customers()
	{
		$urlapi_venta = $this->config->item('api_ventas');
		$url_customer = $urlapi_venta . "customer";
		$headers = array(
			'Content-Type:application/json',
			'Accept: application/json'
		);
		$payload = array(
			'business_information' => array(
				'ruc_number' => $this->session->userdata('ruc')
			),
      "tipo_listado"=>2
		);
		$url = sprintf("%s?%s", $url_customer, http_build_query($payload));
		$process = curl_init($url); //your API url
		curl_setopt($process, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($process, CURLOPT_RETURNTRANSFER, TRUE);
		$return = curl_exec($process);
		curl_close($process);

		$customer_list = json_decode($return, true);
		return $customer_list["data"];
	}


}
