<?php

use SebastianBergmann\Environment\Console;

(defined('BASEPATH')) or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title><?= $page_title . ' | ' . $Settings->site_name; ?></title>
    <link rel="shortcut icon" href="<?= $assets ?>img/iconoFSFT.png" />
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>plugins/font-awesome/css/font-awesome.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
        body {
            background-color: #ecf0f5;
        }

        .table th {
            text-align: center;
        }

        .table-bordered>thead>tr>th,
        .table-bordered>tbody>tr>th,
        .table-bordered>tfoot>tr>th,
        .table-bordered>thead>tr>td,
        .table-bordered>tbody>tr>td,
        .table-bordered>tfoot>tr>td {
            border: #eae9e9;
        }

        .table>tbody>tr.active>td,
        .table>tbody>tr.active>th,
        .table>tbody>tr>td.active,
        .table>tbody>tr>th.active,
        .table>tfoot>tr.active>td,
        .table>tfoot>tr.active>th,
        .table>tfoot>tr>td.active,
        .table>tfoot>tr>th.active,
        .table>thead>tr.active>td,
        .table>thead>tr.active>th,
        .table>thead>tr>td.active,
        .table>thead>tr>th.active {
            background-color: #eae9e9;
        }

        .table {
            margin-bottom: 10px;
        }
    </style>



</head>

<body>

    <section class="content">
        <div class="row">

            <div class="col-xs-12">
                
                <center><img src="<?= $assets ?>img/logo.png" alt="..." style="max-width: 26rem;;"></center>
                <div class="box" style="border-top: 2.5px solid #004785;">
                    <div class="box-header">
                        <h3 class="box-title"><?= lang('purchase_order') . ' # ' . $purchase_orders['id']; ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="col-lg-12">

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive">

                                        <table class="table table-bordered">
                                            <thead>
                                                <tr class="active">

                                                    <th colspan="4"><?= lang('applicant_dates'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td class="col-xs-2"><?= lang('name'); ?></td>
                                                    <td class="col-xs-4"><?=  $Settings->site_name?></td>
                                                    <td class="col-xs-2"><?= lang('RUC'); ?></td>
                                                    <td class="col-xs-4"><?= $Settings->ruc; ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="col-xs-2"><?= lang('phone'); ?></td>
                                                    <td class="col-xs-4"><?= $Settings->tel; ?></td>
                                                    <td class="col-xs-2"><?= lang('email'); ?></td>
                                                    <td class="col-xs-4"><?= $Settings->mail_incidents; ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="col-xs-2"><?= lang('direcc_entr'); ?></td>
                                                    <td class="col-xs-4"><?= $Settings->direccion; ?></td>
                                                </tr>
                                            </tbody>
                                        </table>

                                        <table class="table table-bordered">
                                            <thead>
                                                <tr class="active">

                                                    <th colspan="4"><?= lang('supplier_info'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td class="col-xs-2"><?= lang('supplier'); ?></td>
                                                    <td class="col-xs-4"><?= $purchase_orders['supplier_name']; ?></td>
                                                    <td class="col-xs-2"><?= lang('RUC'); ?></td>
                                                    <td class="col-xs-4"><?= $purchase_orders['supplier_ruc']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="col-xs-2"><?= lang('phone'); ?></td>
                                                    <td class="col-xs-4"><?= $purchase_orders['supplier_contact_phone']; ?></td>
                                                    <td class="col-xs-2"><?= lang('email'); ?></td>
                                                    <td class="col-xs-4"><?= $purchase_orders['supplier_contact_email']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="col-xs-2"><?= lang('direcc_sali'); ?></td>
                                                    <td class="col-xs-4"><?= $purchase_orders['supplier_address']; ?></td>

                                                </tr>
                                            </tbody>
                                        </table>
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <thead>
                                                    <tr class="active">
                                                        <th><?= lang('product'); ?></th>
                                                        <th class="col-xs-2"><?= lang('quantity'); ?></th>
                                                        <th class="col-xs-2"><?= lang('unit_cost'); ?></th>
                                                        <th class="col-xs-2"><?= lang('tax_ICBPER'); ?></th>
                                                        <th class="col-xs-2"><?= lang('subtotal'); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                    <?php

                                                    if ($purchase_orders && isset($purchase_orders['items']) && !empty($purchase_orders['items'])) {
                                                        foreach ($purchase_orders['items'] as $item) {
                                                            echo '<tr>';
                                                            echo '<td>' . $item['name'] . ' (' . $item['code'] . ')</td>';
                                                            echo '<td class="text-center">' . intval($item['quantity']) . '</td>';
                                                            echo '<td class="text-right">' . $item['unit_price'] . '</td>';
                                                            echo '<td class="text-right">' . $item['tax_ICBPER'] . '</td>';
                                                            echo '<td class="text-right">' . $item['subtotal'] . '</td>'; /* $item['quantity'] * $item['cost'] */
                                                            echo '</tr>';
                                                        }
                                                    }
                                                    ?>

                                                </tbody>
                                                <thead>
                                                    <tr class="active">
                                                        <td><?= lang('total'); ?></td>
                                                        <td class="col-xs-2"></td>
                                                        <td class="col-xs-2"></td>
                                                        <td class="col-xs-2"></td>
                                                        <td class="col-xs-2 text-right"><?= $purchase_orders['subtotal'];; ?></td>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>

                                        <div class="text-right" style="margin-bottom: 20px">
                                            <table class="table table-condensed">
                                                <tbody>
                                                    <tr>
                                                        <td style="border: none"><?= strtoupper(lang('opgrav') . ':'); ?></td>
                                                        <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['affected']; ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="border: none"><?= strtoupper(lang('opexon') . ':'); ?></td>
                                                        <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['non_affected']; ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="border: none"><?= strtoupper(lang('opexonReal') . ':'); ?></td>
                                                        <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['exonerated']; ?></td>
                                                    </tr>
                                                    <tr>
                                                    <?php if ($purchase_orders['gratuito'] > 0) : ?>
                                                        <td style="border: none"><?= strtoupper(lang('opfree') . ':'); ?></td>
                                                        <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['gratuito']; ?></td>
                                                    <?php endif; ?>    
                                                    </tr>
                                                    <tr>
                                                        <td style="border: none"><?= strtoupper(lang('product_tax') . " - " . $Settings->default_tax_rate . '%:'); ?></td>
                                                        <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['total_tax']; ?></td>
                                                    </tr>
                                                    <?php if ($purchase_orders['tax_ICBPER'] > 0) : ?>
                                                        <tr>
                                                            <td style="border: none"><?= strtoupper(lang('tax_ICBPER') . ':'); ?></td>
                                                            <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['tax_ICBPER']; ?></td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <?php if ($purchase_orders['total_discount'] > 0) : ?>
                                                        <tr>
                                                            <td style="border: none"><?= strtoupper(lang('total_discount') . ':'); ?></td>
                                                            <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['total_discount']; ?></td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <tr class="active">
                                                        <td style="border: none"><strong><?= strtoupper(lang('importe') . " " . lang('total') . ':'); ?></strong></td>
                                                        <td style="border: none; padding-right:10px" class="col-xs-2"><?= $purchase_orders['grand_total']; ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</body>

</html>