<?php

use SebastianBergmann\Environment\Console;

 (defined('BASEPATH')) or exit('No direct script access allowed'); ?>
<link rel="stylesheet" href="<?= $assets ?>dist/css/pages/sales.css">
<?php $plastic_bags = 0;  ?>

<?php $id = $purchase_orders['id'] ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12"> 
            <?php echo form_open_multipart("purchase_orders/edit/". $id); ?>
            <div class="box" style="border-top: 2.5px solid #9fc10b;">
                <div class="box-body">
                    <div class="col-lg-12">
                        <div class="alert alert-warning alert-dismissable" style="display: none" id="warning">
                            <button id="close" aria-hidden="true" class="close" type="button">×</button>
                            <center>
                                <strong style="color:red;"><i class="icon fa fa-warning"></i> <?= lang('warning'); ?></strong></br>
                                <span style="color:#484848;" id="warning_text"></span>
                            </center>
                        </div>

                        <div class="row">
    
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang('supplier', 'supplier'); ?>
                                    <?php
                                    $sp[''] = lang("select") . " " . lang("supplier");
                                    if ($suppliers != null) {
                                        foreach ($suppliers as $supplier) {
                                            $sp[$supplier->id] = $supplier->name;
                                        }
                                    }
                                    ?>
                                    <?= form_dropdown('supplier', $sp, $purchase_orders['supplier_id'], 'class="form-control select2 tip" id="supplier"  required="required" style="width:100%;"'); ?>
                                </div>
                            </div>

                        </div>
                        <div class="row">

                            <div class="col-md-2">
                                <div class="form-group">
                                    <?= lang('issue_date_2', 'issue_date_2'); ?>
                                    <?= form_input('date', set_value('date', date('Y-m-d')), 'class="form-control datetimepicker tip" id="date"  required="required"'); ?>
                                
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <?= lang('expiration_date', 'expiration_date'); ?>
                                    <?= form_input('expiration_date', set_value('expiration_date'), 'class="form-control datepicker tip" id="expiration_date"'); ?>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <?= lang('currency_name', 'currency_name'); ?>
                                    <?php
                                    $cy['PEN'] = lang('currency_pen');
                                    $cy['USD'] = lang('currency_usd');
                                    ?>
                                    <?= form_dropdown('currency_code', $cy, set_value('currency_code', $purchase_orders['currency']), 'class="form-control select2" id="currency_code"  required="required"'); ?>
                                
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="box" style="border-top: 0px solid;">
                <div class="box-body">
                    <div style="padding-left:10px; padding-right:10px" class="form-group">
                        <input type="text" placeholder="<?= lang('search_product_by_name_code'); ?>" id="add_item" class="form-control">
                    </div>

                    <?php

                    // echo json_encode($items);

                    ?>

                    <div style="padding-left:10px; padding-right:10px" class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table id="poTable" class="table table-striped table-bordered">
                                    <thead>
                                        <tr class="active">
                                            <th><?= lang('product'); ?></th>
                                            <!--**************TRJ044 - ALEXANDER ROCA - 23/05/2019******************-->
                                            <?php if ($advance_sale == 0) { ?>

                                                <!--**************TRJ038 - ALEXANDER ROCA - 17/04/2019******************-->
                                                <th class="col-xs-3">
                                                    <div style="margin-left:20px;"><?= lang('tax'); ?></div>
                                                </th>
                                                <!--**************TRJ038 - ALEXANDER ROCA - 17/04/2019******************-->
                                                <?php if ($plastic_bags > 0) { ?>

                                                    <th class="col-xs-1"><?= lang('quantity'); ?></th>
                                                    <th class="col-xs-1"><?= lang('price'); ?></th>
                                                    <th class="col-xs-1"><?= lang('tax_ICBPER'); ?></th>

                                                <?php } else { ?>

                                                    <th class="col-xs-2"><?= lang('quantity'); ?></th>
                                                    <th class="col-xs-2"><?= lang('price'); ?></th>

                                                <?php } ?>
                                                <th class="col-xs-1"><?= lang('importe'); ?></th>

                                            <?php } else { ?>

                                                <th class="col-xs-1"><?= lang('quantity'); ?></th>
                                                <th class="col-xs-1"><?= lang('affected'); ?></th>
                                                <th class="col-xs-1"><?= lang('exonerated'); ?></th>
                                                <th class="col-xs-1"><?= lang('exo'); ?></th>
                                                <?php if ($plastic_bags > 0) { ?>
                                                    <th class="col-xs-1"><?= lang('tax_ICBPER'); ?></th>
                                                <?php } ?>
                                                <th class="col-xs-1"><span class="text-right"><?= lang('importe'); ?></span></th>

                                            <?php } ?>
                                            <!--**************TRJ044 - ALEXANDER ROCA - 23/05/2019******************-->

                                            <th style="width:25px;"><i class="fa fa-trash-o"></i></th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody-items">
                                        <tr>
                                            <?php if ($advance_sale == 0) { ?>

                                                <?php if ($plastic_bags > 0) { ?>
                                                    <td colspan="7"><?= lang('add_product_by_searching_above_field'); ?></td>
                                                <?php } else { ?>
                                                    <td colspan="6"><?= lang('add_product_by_searching_above_field'); ?></td>
                                                <?php } ?>

                                            <?php } else { ?>

                                                <?php if ($plastic_bags > 0) { ?>
                                                    <td colspan="8"><?= lang('add_product_by_searching_above_field'); ?></td>
                                                <?php } else { ?>
                                                    <td colspan="7"><?= lang('add_product_by_searching_above_field'); ?></td>
                                                <?php } ?>

                                            <?php } ?>
                                        </tr>
                                    </tbody>
                                    <tfoot>
                                        <tr class="active">
                                            <th><?= lang('total_items'); ?>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                &nbsp;&nbsp;
                                                <span id="tart">0 (0.00)</span>
                                            </th>
                                            <?php if ($plastic_bags > 0) { ?>

                                                <th class="col-xs-1"></th>
                                                <th class="col-xs-1"></th>

                                            <?php } else { ?>

                                                <th class="col-xs-2"></th>
                                                <th class="col-xs-2"></th>

                                            <?php } ?>
                                            <th class="text-right"><?= lang('subtotal'); ?></th>
                                            <!--**************TRJ044 - ALEXANDER ROCA - 24/05/2019******************-->
                                            <?php if ($advance_sale == 1) { ?>
                                                <th class="col-xs-1"></th>
                                            <?php } ?>
                                            <!--**************TRJ044 - ALEXANDER ROCA - 24/05/2019******************-->
                                            <?php if ($plastic_bags > 0) { ?>
                                                <th style="width:25px;"></th>
                                            <?php } ?>
                                            <th class="col-xs-2 text-right"><span id="gtotal">0.00</span></th>
                                            <input type="hidden" id="total_pay" value="0.00" name="total_pay">
                                            <th style="width:25px;"></th>

                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="text-right" style="padding-left:10px; padding-right:10px">
                        <table class="table table-condensed">
                            <tbody>
                                <tr style="border: 1px;">
                                    <td rowspan="10">

                                    </td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><?= strtoupper(lang('discount') . ':'); ?></td>
                                    <td style="col-md-2; border: none; padding-left:8%; padding-right:25px;" colspan="2"><input class="form-control input-sm kb-pad text-right" name="gdiscount" type="text" value="0.00" id="gdiscount" onClick="this.select();"></td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><strong><?= strtoupper(lang('total') . ':'); ?></strong></td>
                                    <td style="border: none; padding-right:35px;" class="col-xs-2"><strong><span id="gtot">0.00</span></strong></td>
                                </tr>
                                <tr>
                                    <td style="border: none;"><?= strtoupper(lang('opgrav') . ':'); ?></td>
                                    <td style="border: none; padding-right:35px;" class="col-xs-2"><span id="gaffected">0.00</span></td>
                                    <!-- <input type="hidden" id="opgra" value="0.00" name="opgra"> -->
                                </tr>
                                <!--**********************TRJ008 - ALEXANDER ROCA - 11/04/2019******************-->
                                <tr>
                                    <td style="border: none;"><?= strtoupper(lang('opexonReal') . ':'); ?></td>
                                    <td style="border: none; padding-right:35px;" class="col-xs-2"><span id="gexoneratedReal">0.00</span></td>
                                    <!-- <input type="hidden" id="opexo" value="0.00" name="opexo"> -->
                                </tr>
                                <!--**********************TRJ008 - ALEXANDER ROCA - 11/04/2019******************-->
                                <tr>
                                    <td style="border: none;"><?= strtoupper(lang('opexon') . ':'); ?></td>
                                    <td style="border: none; padding-right:35px;" class="col-xs-2"><span id="gexonerated">0.00</span></td>
                                    <!-- <input type="hidden" id="opexo" value="0.00" name="opexo"> -->
                                </tr>
                                <?php if ($this->session->userdata('gratuito')) { ?>

                                    <tr>
                                        <td style="border: none;"><?= strtoupper(lang('opfree') . ':'); ?></td>
                                        <td style="border: none; padding-right:35px;" class="col-xs-2"><span id="ggratuita">0.00</span></td>
                                        <!-- <input type="hidden" id="opexo" value="0.00" name="opexo"> -->
                                    </tr>
                                <?php } ?>
                                <tr>
                                    <td style="border: none;"><?= strtoupper(lang('product_tax') . " - " . $Settings->default_tax_rate . '%:'); ?></td>
                                    <td style="border: none; padding-right:35px;" class="col-xs-2"><span id="gtax">0.00</span></td>
                                    <!-- <input type="hidden" id="imigv" value="0.00" name="imigv"> -->
                                </tr>
                                <!--***********TRJ068 - ALEXADER ROCA - 02/08/2019************-->
                                <?php if ($plastic_bags > 0) { ?>
                                    <tr>
                                        <td style="border: none;"><?= strtoupper(lang('product_tax_ICBPER') . ' (' . lang('total_bags') . '):'); ?></td>
                                        <td style="border: none; padding-right:35px;" class="col-xs-2"><span id="gtaxICBPER">0.00</span></td>
                                        <!-- <input type="hidden" id="imigv" value="0.00" name="imigv"> -->
                                    </tr>
                                <?php } ?>
                                <!--***********TRJ068 - ALEXADER ROCA - 02/08/2019************-->
                                <tr class="active">
                                    <td style="border: none"><strong><?= strtoupper(lang('importe') . " " . lang('total') . ':'); ?></strong></td>
                                    <td style="border: none; padding-right:35px;" class="col-xs-2"><strong><span id="gimptotal">0.00</span></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            

            <div class="box" style="border-top: 0px solid;">
                <div class="box-body">

                    <div class="row">
                        <div class="form-group col-md-12">
                            <?= lang("note", 'note'); ?>
                            <?= form_textarea('note', isset($purchase_orders['note']) ? $purchase_orders['note'] : '', 'class="form-control redactor" id="note"'); ?>
                        </div>
                    </div>

                    <input type="hidden" id="exchange" value="<?= $Exchange->sell ?>">
                   
                    <?= log_message('error', $purchase_orders['note']); ?>
                    
                    <div class="row">
                        <div class="form-group col-md-12">
                            <?= form_submit('finish_order', lang('finish_order'), 'class="btn btn-primary" id="finish_order" onclick="setHiddenValue(1)"'); ?>
                            <?= form_submit('finish_later', lang('finish_later'), 'class="btn btn-warning" id="finish_later" onclick="setHiddenValue(2)"'); ?>
                            <button style="border-radius: 0px;" type="button" id="reset" class="btn btn-danger" onclick="resetForm()"><?= lang('reset'); ?></button>
                        </div>
                    </div>




                    
                    <!-- Hidden input estado -->
                    <input type="hidden" id="estado" name="estado" value="">
                </div>
            </div>
            <?php echo form_close(); ?>
            <div class="clearfix"></div>
        </div>
    </div>
</section>



<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    var avdSale = <?= $advance_sale ?>; 
    $(function() {

        var today = new Date();
        var min = new Date().setDate(today.getDate() - 3);
        var min
        // var in_a_week   =new Date().setDate(today.getDate()+7);
        var min_ex = new Date().setDate(today.getDate() + 1);
        var rowCount = 1;

        $('.datepicker').datetimepicker({
            format: 'YYYY-MM-DD',
            minDate: min_ex
        });


        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD',
            maxDate: today,
            minDate: min //restingue fecha en la que se genera una factura - solicitud especial viccar
        });


        
    });
    // HH:mm
</script>
<script src="<?= $assets ?>dist/js/jquery-ui.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
<script src="<?= $assets ?>dist/js/pages/purchase_orders.js" type="text/javascript"></script>

<script type="text/javascript">
   
    var plastic_bags = '<?= $plastic_bags; ?>';
    var lang = new Array();
    lang['code_error'] = '<?= lang('code_error'); ?>';
    lang['r_u_sure'] = '<?= lang('r_u_sure'); ?>';
    lang['no_match_found'] = '<?= lang('no_match_found'); ?>';
    lang['products_not_found'] = '<?= lang('products_not_found') ?>';
    lang['sale_not_less'] = '<?= lang('sale_not_less') ?>';
    lang['verify_ruc'] = '<?= lang('verify_ruc') ?>';
    lang['verify_dniRuc'] = '<?= lang('verify_dniRuc') ?>';
    lang['verify_address'] = '<?= lang('verify_address') ?>';
    lang['aviso_tax_ICBPER'] = '<?= lang('aviso_tax_ICBPER') ?>';
</script>
<script>
    $(document).ready(function() {
        var itemspro = <?php  echo json_encode($items)  ?>;
        console.log(itemspro);
        var spoitems = {};
        store('spoitems',JSON.stringify(itemspro));

        $("#gdiscount").val(formatMoney(<?=$purchase_orders['order_discount_no_percentage_value']?> ));

        loadItems()



        console.log(get('spoitems'))

        if (get('remove_spo')) {
            if (get('spoitems')) {
                remove('spoitems');
            }
            remove('remove_spo');
        }
        <?php if ($this->session->userdata('remove_spo')) { ?>
            if (get('spoitems')) {
                remove('spoitems');
            }
        <?php $this->tec->unset_data('remove_spo');
        } ?>

        function attach(x) {
            if (x !== null) {
                return '<a href="<?= base_url(); ?>uploads/' + x + '" target="_blank" class="btn btn-primary btn-block btn-xs"><i class="fa fa-chain"></i></a>';
            }
            return '';
        }



    });
</script>


<script language="javascript">
    $(document).ready(function() {

        $('form').keypress(function(e) {
            if (e == 13) {
                return false;
            }
        });

        $(document).on('keypress', 'input', function(e) {
            if (e.which == 13) {
                return false;
            }
        });

    });
</script>
<script>
    function setHiddenValue(value) {
        document.getElementById("estado").value = value;
    }

    function resetForm() {
        document.getElementById("estado").value = "";
        
    }
</script>