
class OnlyIntegers {
    constructor(inputElement) {
        this.inputElement = inputElement;
        this.init();
    }

    init() {
        this.inputElement.addEventListener('input', this.validateInput.bind(this));
    }

    validateInput(event) {
        const value = event.target.value;
        if (!/^\d*$/.test(value)) {
            event.target.value = value.replace(/\D/g, '');
        }
    }
}
class IntegersAndHyphens {
    constructor(inputElement) {
        this.inputElement = inputElement;
        this.init();
    }

    init() {
        this.inputElement.addEventListener('input', this.validateInput.bind(this));
    }

    validateInput(event) {
        const value = event.target.value;
        if (!/^[\d-]*$/.test(value)) {
            event.target.value = value.replace(/[^\d-]/g, '');
        }
    }
}

// $(document).on("input change", ".div_secundary_user input", function () {
//     var valor = $(this).val().trim(); // Obtener el valor del campo y quitar espacios en blanco al inicio y al final

//     // Seleccionar el label asociado al campo actual
//     var label = $(this).siblings("label");

//     // Seleccionar el <small> asociado al campo actual
//     var small = $(this).siblings("small");

//     // Verificar si el campo está completo
//     if (valor !== "") {
//         console.log('Campo completo');
//         $(this).css({
//             "border": "1px solid #28a745", // Verde
//             "background-color": "transparent"
//         });
//         label.css({
//             "color": "#28a745" // Verde
//         });
//         small.hide(); // Ocultar el <small>
//         $('.tabs li a').removeClass('disabled');
//         document.getElementById('beta_checkbox').disabled = false;


//     } else {
//         console.log('Campo vacío');
//         $(this).css({
//             "border": "1px solid #dc3545", // Rojo
//         });
//         label.css({
//             "color": "#dc3545" // Rojo
//         });
//         small.show(); // Mostrar el <small>
        
//         $('.tabs li a').addClass('disabled');
//         document.getElementById('beta_checkbox').disabled = true;


//     }
// });


// Aplicar la clase a todos los campos de entrada con la clase "only-integers" cuando el DOM esté cargado
document.addEventListener('DOMContentLoaded', () => {
    const integerInputs = document.querySelectorAll('.only-integers');
    integerInputs.forEach(input => new OnlyIntegers(input));

    const integerHyphenInputs = document.querySelectorAll('.integers-and-hyphens');
    integerHyphenInputs.forEach(input => new IntegersAndHyphens(input));

    const tabs = document.querySelectorAll('.tabs li');
    const tabContent = document.querySelectorAll('div[id^="tab"]');
    const submitBtn = document.getElementById('update_settings_btn');

    const betaCheckbox = document.getElementById('beta_checkbox');



    tabs.forEach(clickedTab => {
        clickedTab.querySelector('a').addEventListener('click', e => {
            if (clickedTab.querySelector('a').classList.contains('disabled')) {
                e.preventDefault();
                return;
            }

            e.preventDefault();
            const objetivo = clickedTab.querySelector('a').getAttribute('href');
            tabContent.forEach(content => {
                content.style.display = 'none';
            });
            document.querySelector(objetivo).style.display = 'block';
            tabs.forEach(tab => {
                tab.classList.remove('active');
            });
            clickedTab.classList.add('active');
        });
    });

    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.attributeName === 'disabled') {
                if (submitBtn.disabled) {
                    tabs.forEach(tab => {
                        tab.querySelector('a').classList.add('disabled');
                    });
                    betaCheckbox.disabled = true;
                    
                } else {
                    tabs.forEach(tab => {
                        tab.querySelector('a').classList.remove('disabled');
                    });
                    betaCheckbox.disabled = false;
                    
                }
            }
        });
    });

    // Configurar el observador para observar cambios en los atributos del botón de envío
    observer.observe(submitBtn, {
        attributes: true
    });

});




$(document).ready(function () {
    
    // $('#update_settings_btn').click(function (e) {

    //     var betatoggle = $('#beta_hidden').val();
    //     var beta_user_sol = $('#beta_user_sol').val();
    //     var beta_pass_sol = $('#beta_pass_sol').val();

    //     var pass_sol = $('#pass_sol').val();
    //     var user_sol = $('#user_sol').val();

    //     console.log('Beta toggle: ' + betatoggle);
    //     console.log('Beta user: ' + beta_user_sol);
    //     console.log('Beta pass: ' + beta_pass_sol);
        

    //     if ( betatoggle == 1 ) {
            
    //         console.log('Beta toggle activado');

    //         if (!beta_user_sol.trim() || !beta_pass_sol.trim()) {
    //             console.log("No se ha ingresado usuario o contraseña BETA");

                
                
    //             e.preventDefault();


    //         } else {
    //             console.log("beta_user_sol y beta_pass_sol no importan");
    //         }

    //     } else if ( betatoggle == 0 ) {


    //         if (!user_sol.trim() || !pass_sol.trim()) { 

    //             console.log('No se ha ingresado usuario o contraseña');


    //             e.preventDefault();


    //         }
            
            
    //     }       
        
    // });
    

    // const submitButton = document.querySelector('#update_settings_btn');

    // const observer = new MutationObserver(() => {
    //     if (submitButton.disabled) {
    //         console.log('El botón de submit ha sido deshabilitado.');
    
    //         // Selecciona todos los elementos li dentro de .tabs y les agrega la clase 'disabled'
    
    //     } else {
    //         console.log('El botón de submit ha sido habilitado.');
    
    //         // Selecciona todos los elementos li dentro de .tabs y les quita la clase 'disabled'
    //     }
    // });

    // document.addEventListener('DOMContentLoaded', function() {
    //     const tabs = document.querySelectorAll('.tabs li a');
    
    //     tabs.forEach(tab => {
    //         tab.addEventListener('click', function(event) {
    //             if (tab.classList.contains('disabled')) {
    //                 event.preventDefault();
    //             }
    //         });
    //     });
    
    //     // Ejemplo: Deshabilitar todas las pestañas
    //     tabs.forEach(tab => tab.classList.add('disabled'));
    // });

    // // Configurar el observer para observar cambios en los atributos
    // observer.observe(submitButton, { attributes: true });

    

    // Función para manejar el evento keydown y establecer la combinación de teclas
    function handleKeydown(event) {
        const allowedKeys = new Set([
            'F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 'F10', 'F11', 'F12',
            'Control', 'Shift', 'Alt'
        ]);

        let keyCombination = '';
        if (event.ctrlKey && event.key !== 'Control') keyCombination += 'CTRL+';
        if (event.shiftKey && event.key !== 'Shift') keyCombination += 'SHIFT+';
        if (event.altKey && event.key !== 'Alt') keyCombination += 'ALT+';

        if (event.key !== 'Control' && event.key !== 'Shift' && event.key !== 'Alt') {
            keyCombination += event.key.toUpperCase();
        }

        console.log('Tecla presionada: ' + keyCombination);

        if (!allowedKeys.has(event.key)) {
            // Prevenir el comportamiento por defecto si la tecla no está permitida
            event.preventDefault();
            return;
        }

        const specialKeys = ['Tab', 'Enter', 'Escape', 'ArrowUp', 'ArrowDown', 'ArrowLeft', 'ArrowRight'];
        if (!specialKeys.includes(event.key)) {
            // Establecer la combinación de teclas como el valor del input
            event.target.value = keyCombination;

            // Disparar el evento 'input' o 'change' para que el navegador lo reconozca
            event.target.dispatchEvent(new Event('input', { bubbles: true }));
            event.target.dispatchEvent(new Event('change', { bubbles: true }));

            // Prevenir el comportamiento por defecto
            event.preventDefault();
        }
    }

    // Seleccionar todos los inputs relevantes y añadir el evento keydown
    const inputs = document.querySelectorAll('#focus_add_item, #add_customer, #toggle_category_slider, #cancel_sale, #suspend_sale, #print_order, #print_bill, #finalize_sale, #today_sale, #open_hold_bills, #close_register');
    inputs.forEach(input => {
        input.addEventListener('keydown', handleKeydown);
    });



    

});
