<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($title ?? 'Sistema Facsisoft'); ?></title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('template/assets/css/app.min.css')); ?>">
    <!-- Template CSS -->
    <?php echo $__env->yieldPushContent('styles-library'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('template/assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('template/assets/css/components.css')); ?>">

    
    <link rel="shortcut icon" href="<?php echo e(asset('metch')); ?>/media/logos/iconoFSFT.png">

    <style>
        .main-sidebar .sidebar-brand a .header-logo {
            height: 80px;
        }
    </style>

    <?php echo $__env->yieldPushContent('styles-custom'); ?>

</head>

<body>

    

    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <div class="navbar-bg"></div>
            
            <?php echo $__env->make('layouts.shared.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            

            
            <?php echo $__env->make('layouts.shared.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            

            
            <div class="main-content">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
            

            
            <?php echo $__env->make('layouts.shared.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="<?php echo e(asset('template/assets/js/app.min.js')); ?>"></script>
    <!-- JS Libraies -->
    <!-- Page Specific JS File -->
    <?php echo $__env->yieldPushContent('scripts-library'); ?>
    <!-- Template JS File -->
    <script src="<?php echo e(asset('template/assets/js/scripts.js')); ?>"></script>

    <!-- Mix Js -->
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            validateToken();
        });

        const validateToken = () => {
            const token = sessionStorage.getItem('token');
            if (!token) {
                //Redireccionar a Login
                window.location.href = "/login";
            } else {
                setPerfil();
            }
        }

        const setPerfil = () => {
            const token = sessionStorage.getItem('token');
            const user = sessionStorage.getItem('user');
            if (token && user) {
                const objuser = JSON.parse(user);
                //console.log(objuser);
                document.getElementById("navbarUsername").innerHTML = objuser.name
            }
        }

        const logout = async () => {
            const token = sessionStorage.getItem('token');
            if (token) {
                //Obtenemos la ruta donde debe ir los datos del formulario.
                let route = `${endpointWS}/cerrar_session`;
                //Hacer Request
                const response = await requestAxios(route, "POST", {
                    "api_token": token
                });
                //console.log(response);
                /* if (response.status === 201 || response.status === 200) {
                    sessionStorage.removeItem('token');
                    sessionStorage.removeItem('user');
                } */
                sessionStorage.removeItem('token');
                sessionStorage.removeItem('user');
                window.location.href = "/login";
            } else {
                //Redireccionar a Login
                window.location.href = "/login";
            }
        }
    </script>

    <?php echo $__env->yieldPushContent('scripts-custom'); ?>

</body>

</html>
<?php /**PATH D:\xampp\htdocs\web-facsisoft-administrador\resources\views/layouts/app_admin.blade.php ENDPATH**/ ?>