<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $title ?? 'Sistema Facsisoft' }}</title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="{{ asset('template/assets/css/app.min.css') }}">
    <!-- Template CSS -->
    @stack('styles-library')

    <link rel="stylesheet" href="{{ asset('template/assets/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('template/assets/css/components.css') }}">

    {{-- <link rel='shortcut icon' type='image/x-icon' href="{{ asset('template/assets/img/favicon.ico') }}"> --}}
    <link rel="shortcut icon" href="{{ asset('metch') }}/media/logos/iconoFSFT.png">

    <style>
        .main-sidebar .sidebar-brand a .header-logo {
            height: 80px;
        }
    </style>

    @stack('styles-custom')

</head>

<body>

    {{-- @auth()
        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    @endauth --}}

    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <div class="navbar-bg"></div>
            {{-- NAVBAR --}}
            @include('layouts.shared.navbar')
            {{-- NAVBAR --}}

            {{-- SIDEBAR --}}
            @include('layouts.shared.sidebar')
            {{-- SIDEBAR --}}

            {{-- CONTENIDO --}}
            <div class="main-content">
                @yield('content')
            </div>
            {{-- CONTENIDO --}}

            {{-- FOOTER --}}
            @include('layouts.shared.footer')
            {{-- FOOTER --}}
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="{{ asset('template/assets/js/app.min.js') }}"></script>
    <!-- JS Libraies -->
    <!-- Page Specific JS File -->
    @stack('scripts-library')
    <!-- Template JS File -->
    <script src="{{ asset('template/assets/js/scripts.js') }}"></script>

    <!-- Mix Js -->
    <script src="{{ asset('js/app.js') }}"></script>

    <script>
        $(document).ready(function() {
            validateToken();
        });

        const validateToken = () => {
            const token = sessionStorage.getItem('token');
            if (!token) {
                //Redireccionar a Login
                window.location.href = "/login";
            } else {
                setPerfil();
            }
        }

        const setPerfil = () => {
            const token = sessionStorage.getItem('token');
            const user = sessionStorage.getItem('user');
            if (token && user) {
                const objuser = JSON.parse(user);
                //console.log(objuser);
                document.getElementById("navbarUsername").innerHTML = objuser.name
            }
        }

        const logout = async () => {
            const token = sessionStorage.getItem('token');
            if (token) {
                //Obtenemos la ruta donde debe ir los datos del formulario.
                let route = `${endpointWS}/cerrar_session`;
                //Hacer Request
                const response = await requestAxios(route, "POST", {
                    "api_token": token
                });
                //console.log(response);
                /* if (response.status === 201 || response.status === 200) {
                    sessionStorage.removeItem('token');
                    sessionStorage.removeItem('user');
                } */
                sessionStorage.removeItem('token');
                sessionStorage.removeItem('user');
                window.location.href = "/login";
            } else {
                //Redireccionar a Login
                window.location.href = "/login";
            }
        }
    </script>

    @stack('scripts-custom')

</body>

</html>
