export const matrix = {
	chrome: {
		    48: 0b01001111011111100111110101111101,
		    49: 0b01001111111111100111111111111111,
		    50: 0b01011111111111100111111111111111,
		    51: 0b01011111111111100111111111111111,
		    52: 0b01111111111111100111111111111111
	},
	firefox: {
		    43: 0b01000111111101100000110111011101,
		    44: 0b01000111111101100000110111011101,
		    45: 0b01000111111101100000110111011101,
		    46: 0b01010111111111100000110111011101,
		    47: 0b01010111111111100111111111011111,
		    48: 0b01010111111111100111111111011111
	},
	safari: {
		     8: 0b01000000000000000000000000000000,
		     9: 0b01001111001101100000011101011110
	},
	ie: {
		     8: 0b00000000000000000000000000000000,
		     9: 0b01000000000000000000000000000000,
		    10: 0b01000000000000000000000000000000,
		    11: 0b01000000000000000111000001100000
	},
	edge: {
		    12: 0b01011110110111100011010001011101,
		    13: 0b01011111110111100011110001011111
	},
	node: {
		'0.10': 0b01000000000101000000000001000000,
		'0.12': 0b01000001000101000000010001000100,
		     4: 0b01001111000111100111111001111111,
		     5: 0b01001111000111100111111001111111,
		     6: 0b01011111111111100111111111111111
	}
};

export const features = [
	'arrow',
	'classes',
	'collections',
	'computedProperty',
	'conciseMethodProperty',
	'constLoop',
	'constRedef',
	'defaultParameter',
	'destructuring',
	'extendNatives',
	'forOf',
	'generator',
	'letConst',
	'letLoop',
	'letLoopScope',
	'moduleExport',
	'moduleImport',
	'numericLiteral',
	'objectProto',
	'objectSuper',
	'oldOctalLiteral',
	'parameterDestructuring',
	'spreadRest',
	'stickyRegExp',
	'symbol',
	'templateString',
	'unicodeEscape',
	'unicodeIdentifier',
	'unicodeRegExp',

	// ES2016
	'exponentiation',

	// additional transforms, not from
	// https://featuretests.io
	'reservedProperties',

	'trailingFunctionCommas'
];
