<?php

namespace App\Models;

use Facade\FlareClient\Http\Response;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
//use DateTimeInterface;

class Client extends Model
{
    use HasFactory;

    protected $table = "empresas";

    public function getBusiness()
    {
        try {
            $res = DB::select('call SP_ADMIN_LISTAR_EMPRESAS()');
            return $this->SuccessResponse($res, Response::HTTP_OK);
        } catch (\Throwable $th) {
            return $this->ErrorResponse($th, Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }


    protected $casts = [
        'fec_afiliacion' => 'datetime:d/m/Y',
    ];
}
