<style>
    .modal {
  text-align: center;
}

@media screen and (min-width: 768px) { 
  .modal:before {
    display: inline-block;
    vertical-align: middle;
    content: " ";
    height: 100%;
  }
}

.modal-dialog {
  display: inline-block;
  text-align: left;
  vertical-align: middle;
}
</style>
<input type="hidden" value="<?= site_url('tickets') ?>">
<section class="content">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#ticketTable').DataTable({
                "aaSorting": [[ 0, "asc" ]], 
                "iDisplayLength": <?= $Settings->rows_per_page ?>,     
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "<?php echo site_url('tickets/get_tickets'); ?>",
                    "type": "GET"
                },
                "columns": [
                    { "data": "numero" },
                    { "data": "fec_emision" },
                    { "data": "fec_periodo_ini" },
                    { "data": "fec_periodo_fin" },
                    { "data": "fec_vencimiento" },
                    { "data": "imp_total" },
                    { "data": "fec_pago" },
                    { "data": "estado" },
                    { "data": "action" },
                ],
                "columnDefs": [{
                    "orderable": false, "targets": [8]
                }],
            });
            
        });
        
        
    </script>
    <div class="row">   
        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="ticketTable" class="table table-bordered table-hover table-striped ">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line("number"); ?></th>
                                    <th><?php echo $this->lang->line("fec_emision"); ?></th>
                                    <th><?php echo $this->lang->line("fec_periodo_ini"); ?></th>
                                    <th><?php echo $this->lang->line("fec_periodo_fin"); ?></th>
                                    <th><?php echo $this->lang->line("fec_vencimiento"); ?></th>
                                    <th><?php echo $this->lang->line("imp_total"); ?></th>
                                    <th><?php echo $this->lang->line("fec_pago"); ?></th>
                                    <th><?php echo $this->lang->line("estado"); ?></th>
                                    <th style="width:65px;"><?php echo $this->lang->line("action"); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="6" class="dataTables_empty"><?= lang('loading_data_from_server') ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div> 
</section>
<div class="modal fade"  id="modaldetalle" role="dialog">
    <div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('view_detail'); ?></h4>
        </div>
        <div class="modal-body">
            <div class="table-responsive">
            <table id="detalle" cellpadding="0" cellspacing="0" border="0"
                           class="table table-bordered table-hover table-striped">
                        <thead>
                            <tr>
                                <th style="width:15%;"><span >Ticket Detalle ID</span></th>
                                <th style="width:10%;"><span >Ticket ID</span></th>
                                <th style="width:15%;"><span >Cantidad</th>
                                <th style="width:15%;"><span >Descripcion</span></th>
                                <th style="width:15%;"><span >Importe</span></th>
                            </tr>
                        </thead>
                        <tbody>
                        <tr>
                                <td><span id="id_ticket_det"></span></td>
                                <td><span id="id_ticket"></span></td>
                                <td><span id="cantidad"></span></td>
                                <td><span id="descripcion"></span></td>
                                <td><span id="importe"></span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    $('#modaldetalle').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget); // Elemento que activó el modal
        var id_ticket = button.data('id'); // Extraer el valor del atributo data-id
        var modal = $(this);
        console.log("id",id_ticket);
        $.ajax({
            url: "<?php echo site_url('tickets/detalle'); ?>/" + id_ticket,
            type: 'GET',
            success: function(response) {
                var detalle_ticket = JSON.parse(response)[0];
                $('#id_ticket_det').text(detalle_ticket.id_ticket_det);
                $('#id_ticket').text(detalle_ticket.id_ticket);
                $('#cantidad').text(detalle_ticket.cantidad);
                $('#descripcion').text(detalle_ticket.descripcion);
                $('#importe').text(detalle_ticket.importe);
                // Mostrar el modal
                //modal.modal('show');
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
    });
});
</script>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>
