<?php

namespace App\Controllers;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use App\Models\MySQL\CodeyGenerateSale\SaleModel;
use App\Models\MySQL\CodeyGenerateSale\SaleItemsModel;
use App\Models\MySQL\CodeyGenerateCustomer\CustomerModel;
use App\Models\MySQL\CodeyGenerateBusiness\BusinessModel;
use App\DAO\MySQL\CodeBD\CustomerDAO;
use App\DAO\MySQL\CodeBD\UserDAO;
use App\DAO\MySQL\CodeBD\LocalDAO;
use App\DAO\MySQL\CodeBD\CanalDAO;
use App\DAO\MySQL\CodeBD\WarehouseDAO;
use App\DAO\MySQL\CodeBD\Pro_ventas_importarDAO;
use App\DAO\MySQL\CodeBD\SaleDAO;
use App\DAO\MySQL\CodeBD\SettingsDAO;
use App\Libraries\pdf;
use App\Libraries\QRCodeGenerator;
use DirectoryIterator;

final class SaleController
{
	public function register_Sale(Request $request, Response $response, array $args): Response
	{
		$data_recibida = $request->getParsedBody();
		date_default_timezone_set('America/Lima');
		//$url = getenv('WSurl_ventas');
		$headerSale = new SaleModel();
		$customer = new CustomerModel();
		$business = new BusinessModel();
		//Obteniendo datos para la conexion a base de datos
		$datos_empresa_general = $this->conexionBDgeneral($data_recibida['empresa']['ruc']);
		//Comprobando si existen datos para la conexion
		if ($datos_empresa_general != null) {
			//cargando el ruc al objeto empresa
			$business->setRuc($data_recibida['empresa']['ruc']);
		} else {
			//enviando un mensaje si el ruc no existe
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error datos generales: el ruc de la empresa es incorrecto";
			$resp_json = $response->withJson($mensaje);
			return $resp_json;
		}
		
		$settings_query = new SettingsDAO();
		$settings_tax = $settings_query->valid_tax($datos_empresa_general);
		foreach ($settings_tax as $tax_rate) {
				$tax_default=$tax_rate['default_tax_rate'];
		}
		
		$valid_empresa=$this->validacion_masivo_header($data_recibida['empresa'], $datos_empresa_general);
		if(isset($valid_empresa)){
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"] = $valid_empresa;
		}

		$type_invoice = $data_recibida['header']['document_type'];
		$document_iden = $data_recibida['header']['identification_customer'];

		$customer_query = new CustomerDAO();

		$datos_customer = $customer_query->valid_Customer($document_iden, trim($data_recibida['empresa']['ruc']), $datos_empresa_general);
		$captura = count($datos_customer);

		//if(substr_count($data_recibida['header']['date'], '-')==2 && substr_count($data_recibida['header']['date'], ':')==2){}else{}

		$valid_date_create=str_replace(' ','', $data_recibida['header']['date']);
		$valid_date_create=str_replace('-','', $valid_date_create);
		$valid_date_create=str_replace(':','', $valid_date_create);
		
		
		if(is_numeric($valid_date_create)){
			$dateHora = explode(' ', $data_recibida['header']['date']);
			
			if (count($dateHora) == 2) {
				
				$dateJson = explode('-', $dateHora[0]);
				
				
				if(isset($dateJson[2])){
				
					if (count($dateJson) == 3) {
						if ($dateJson[0] >= date("Y") - 1 && $dateJson[0] < 10000) {
							//se valida si el año es mayor al año anterior del año actual y si no se retorna un mensaje
						} else {
							//$mensaje["invoice"] = "0";
							$mensaje["mensaje"][] = "Error cabecera: el año de la fecha del registro no tiene el formato correcto";
							//$resp_json = $response->withJson($mensaje);
							//return $resp_json;
						}

						if ($dateJson[1] == date("m")) {
							// se valida si el mes enviado es igual al mes actual
						} else {
							//$mensaje["invoice"] = "0";
							$mensaje["mensaje"][] = "Error cabecera: el mes de la fecha del registro no tiene el formato correcto";
							//$resp_json = $response->withJson($mensaje);
							//return $resp_json;
						}

						if ($dateJson[1] == "01" || $dateJson[1] == "03" || $dateJson[1] == "05" || $dateJson[1] == "07" || $dateJson[1] == "08" || $dateJson[1] == "10" || $dateJson[1] == "12") {
							if ($dateJson[2] > 0 && $dateJson[2] < 32) {
							} else {
								//$mensaje["invoice"] = "0";
								$mensaje["mensaje"][] = "Error cabecera: el día de la fecha del registro no tiene el formato correcto";
								//$resp_json = $response->withJson($mensaje);
								//return $resp_json;
							}
						} else {
							if ($dateJson[1] == "02") {
								if ($dateJson[0] % 4 == 0) {
									if ($dateJson[2] > 0 && $dateJson[2] <= 30) {
									} else {
										//$mensaje["invoice"] = "0";
										$mensaje["mensaje"][] = "Error cabecera: el día de la fecha del registro no tiene el formato correcto";
										//$resp_json = $response->withJson($mensaje);
										//return $resp_json;
									}
								} else {
									if ($dateJson[2] > 0 && $dateJson[2] <= 29) {
									} else {
										//$mensaje["invoice"] = "0";
										$mensaje["mensaje"][] = "Error cabecera: el día de la fecha del registro no tiene el formato correcto";
										//$resp_json = $response->withJson($mensaje);
										//return $resp_json;
									}
								}
							} else {
								if ($dateJson[2] > 0 && $dateJson[2] < 31) {
								} else {
									//$mensaje["invoice"] = "0";
									$mensaje["mensaje"][] = "Error cabecera: el día de la fecha del registro no tiene el formato correcto";
									//$resp_json = $response->withJson($mensaje);
									//return $resp_json;
								}
							}
						}
					} else {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error cabecera: la fecha y hora del registro no tiene el formato correcto";
						//$resp_json = $response->withJson($mensaje);
						//return $resp_json;
					}

					
				
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error cabecera: la fecha del registro no tiene el formato correcto";
				}
				
				if(isset($dateHora[1])){
					
					$horaJson = explode(':', $dateHora[1]);
					
					if(isset($horaJson[2])){
					
						if (count($horaJson) == 3) {
							if(is_numeric($horaJson[0]) && is_numeric($horaJson[1]) && is_numeric($horaJson[2])){
								if ($horaJson[0] >= 0 && $horaJson[0] < 24) {
								} else {
									//$mensaje["invoice"] = "0";
									$mensaje["mensaje"][] = "Error cabecera: la hora del registro no tiene el formato correcto";
									//$resp_json = $response->withJson($mensaje);
									//return $resp_json;
								}

								if ($horaJson[1] >= 0 && $horaJson[1] < 60) {
								} else {
									//$mensaje["invoice"] = "0";
									$mensaje["mensaje"][] = "Error cabecera: los minutos del registro no tiene el formato correcto";
									//$resp_json = $response->withJson($mensaje);
									//return $resp_json;
								}

								if ($horaJson[2] >= 0 && $horaJson[2] < 60) {
								} else {
									//$mensaje["invoice"] = "0";
									$mensaje["mensaje"][] = "Error cabecera: los segundos del registro no tiene el formato correcto";
									//$resp_json = $response->withJson($mensaje);
									//return $resp_json;
								}
							}else{
								$mensaje["mensaje"][] = "Error cabecera: el tiempo del registro no tiene el formato correcto";
							}
						} else {
							//$mensaje["invoice"] = "0";
							$mensaje["mensaje"][] = "Error cabecera: el tiempo del registro no tiene el formato correcto";
							//$resp_json = $response->withJson($mensaje);
							//return $resp_json;
						}
					}else{
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error cabecera: el tiempo del registro no tiene el formato correcto";
					}
				}
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: la fecha y hora del registro no tiene el formato correcto";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: la fecha y hora del ingreso no tiene el formato correcto";
		}
		
		if (strlen($data_recibida['header']['expiration_date']) > 0) {
		
			$valid_expiration_create=str_replace(' ','', $data_recibida['header']['expiration_date']);
			$valid_expiration_create=str_replace('-','', $valid_expiration_create);
			$valid_expiration_create=str_replace(':','', $valid_expiration_create);
			
			if(is_numeric($valid_expiration_create)){

				if (strlen($data_recibida['header']['expiration_date']) > 0) {
					$dateHoraExpira = explode('-', $data_recibida['header']['expiration_date']);

					if (count($dateHoraExpira) == 3) {
						if(is_numeric($dateHoraExpira[0]) && is_numeric($dateHoraExpira[1]) && is_numeric($dateHoraExpira[2])){
							if ($dateHoraExpira[0] >= date("Y") - 1 && $dateHoraExpira[0] < 10000) {
							} else {
								//$mensaje["invoice"] = "0";
								$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
								//$resp_json = $response->withJson($mensaje);
								//return $resp_json;
							}

							if ($dateHoraExpira[1] == date("m")) {
							} else {
								//$mensaje["invoice"] = "0";
								$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
								//$resp_json = $response->withJson($mensaje);
								//return $resp_json;
							}

							if ($dateHoraExpira[1] == "01" || $dateHoraExpira[1] == "03" || $dateHoraExpira[1] == "05" || $dateHoraExpira[1] == "07" || $dateHoraExpira[1] == "08" || $dateHoraExpira[1] == "10" || $dateHoraExpira[1] == "12") {
								if ($dateHoraExpira[2] > 0 && $dateHoraExpira[2] < 32) {
								} else {
									//$mensaje["invoice"] = "0";
									$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
									//$resp_json = $response->withJson($mensaje);
									//return $resp_json;
								}
							} else {
								if ($dateHoraExpira[1] == "02") {
									if ($dateHoraExpira[0] % 4 == 0) {
										if ($dateHoraExpira[2] > 0 && $dateHoraExpira[2] < 30) {
										} else {
											//$mensaje["invoice"] = "0";
											$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
											//$resp_json = $response->withJson($mensaje);
											//return $resp_json;
										}
									} else {
										if ($dateHoraExpira[2] > 0 && $dateHoraExpira[2] < 29) {
										} else {
											//$mensaje["invoice"] = "0";
											$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
											//$resp_json = $response->withJson($mensaje);
											//return $resp_json;
										}
									}
								} else {
									if ($dateHoraExpira[2] > 0 && $dateHoraExpira[2] < 31) {
									} else {
										//$mensaje["invoice"] = "0";
										$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
										//$resp_json = $response->withJson($mensaje);
										//return $resp_json;
									}
								}
							}
						}else{
							$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
						}
					} else {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
						//$resp_json = $response->withJson($mensaje);
						//return $resp_json;
					}
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: la fecha de expiracion no tiene el formato correcto";
			}
		}

		if ($data_recibida['header']['currency'] == "PEN" || $data_recibida['header']['currency'] == "USD") {} else {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: tipo de moneda no valida";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}

		$sale_query = new SaleDAO();

		$Exchange = $sale_query->valid_Exchange($datos_empresa_general);

		foreach ($Exchange as $Exchang) {
			$headerSale->setExchange($Exchang['sell']);
		}
		
		$sensor_montos=0;
		
		if(is_numeric($data_recibida['header']['affected'])){
			if($data_recibida['header']['affected']>-1){
				$sensor_montos++;
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto afecto";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto afecto";
		}
		
		if(is_numeric($data_recibida['header']['non_affected'])){
			if($data_recibida['header']['non_affected']>-1){
				$sensor_montos++;
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto no afecto";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto no afecto";
		}
		
		if(is_numeric($data_recibida['header']['exonerated'])){
			if($data_recibida['header']['exonerated']>-1){
				$sensor_montos++;
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto exonerado";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto exonerado";
		}
		
		if(is_numeric($data_recibida['header']['total'])){
			if($data_recibida['header']['total']>-1){
				$sensor_montos++;
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto total";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto total";
		}
		
		if(is_numeric($data_recibida['header']['subtotal'])){
			if($data_recibida['header']['subtotal']>-1){
				$sensor_montos++;
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto subtotal";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto subtotal";
		}
		
		if(is_numeric($data_recibida['header']['product_tax'])){
			if($data_recibida['header']['product_tax']>-1){
				$sensor_montos++;
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto del impuesto de los productos";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto del impuesto de los productos";
		}
		
		if(is_numeric($data_recibida['header']['tax_ICBPER'])){
			if($data_recibida['header']['tax_ICBPER']>-1){
				$sensor_montos++;
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto del impuesto de las bolsas";
			}
		}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto del impuesto de las bolsas";
		}

		
		
		if($sensor_montos==7){
			$headerAfecto=(float) $data_recibida['header']['affected'] ;
			$headerInafecto=(float) $data_recibida['header']['non_affected'];
			$headerExonerdo=(float) $data_recibida['header']['exonerated'];
			$sumaInpuestos=round(($headerAfecto+$headerInafecto+$headerExonerdo)*100)/100;
			$headerTotal=(float) $data_recibida['header']['total'];
			$headersubtotal=$data_recibida['header']['subtotal'];
			$headerImpuestoProd=(float) $data_recibida['header']['product_tax'];
			$headerTax_ICBPER=(float) $data_recibida['header']['tax_ICBPER'];
			
			if (trim($headerTotal) == trim($sumaInpuestos)) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: no coincide el total con la sumatoria de affected, non_affected y exonerated";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}

			if (trim($headersubtotal) ==trim(($headerTotal + $headerImpuestoProd + $headerTax_ICBPER))) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: no coincide el subtotal con la sumatoria de affected, non_affected, exonerated, igv y ICBPER";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}
		
		}
		
		

		if ($data_recibida['header']['total_items'] > 0 && $data_recibida['header']['total_quantity'] > 0) {

			if ($data_recibida['header']['total_items'] <= $data_recibida['header']['total_quantity']) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: la cantidad de items y cantidad de productos no son correctas";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}
		} else {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: la cantidad de items y cantidad de productos no son correctas";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}

		if ($data_recibida['header']['subtotal'] >= $data_recibida['header']['paid'] && $data_recibida['header']['paid'] > -1) {
		} else {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: monto pagado incorrecto";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}
		
		if(strtoupper(trim($data_recibida['header']['method_paid']))=="CASH" || 
		strtoupper(trim($data_recibida['header']['method_paid']))=="CC" ||
		strtoupper(trim($data_recibida['header']['method_paid']))=="CHEQUE" ||
		strtoupper(trim($data_recibida['header']['method_paid']))=="STRIPE" ||
		strtoupper(trim($data_recibida['header']['method_paid']))==""){}else{
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][]='Error cabecera: error con el metodo de pago del comprobante';
		}

		if ($data_recibida['header']['mult_ICBPER'] <= -1) {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: los valores del impuesto a las bolsas esta incorrecto";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}
		
		$afectoItems = 0;
		$inafectoItems = 0;
		$exoneradoItems = 0;
		$taxItems = 0;
		$Tax_ICBPER = 0;
		$cantidadItems = count($data_recibida['item']);
		$cantidadProductItems = 0;

		if ($cantidadItems == $data_recibida['header']['total_items']) {
		} else {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][] = "Error cabecera: la cantidad de items indica no coincide con la que se envia";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}
		
		$sensor_montos_items_total=0;

		for ($contador = 1; $contador < count($data_recibida['item']) + 1; $contador++) {
			$sensor_montos_items=0;
			
			if (is_numeric($data_recibida['item'][$contador]['Quantity'])) {
				if ($data_recibida['item'][$contador]['Quantity'] > 0) {
					$sensor_montos_items++;
				} else {
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato de la cantidad del item";
				}
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato de la cantidad del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Unit_price'])){
				if($data_recibida['item'][$contador]['Unit_price']>0){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del precio unitario del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del precio unitario del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Affect_price'])){
				if($data_recibida['item'][$contador]['Affect_price']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto afecto del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto afecto del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Non_affected_price'])){
				if($data_recibida['item'][$contador]['Non_affected_price']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto no afecto del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto no afecto del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Exonerated_price'])){
				if($data_recibida['item'][$contador]['Exonerated_price']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto exonerado del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto exonerado del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Tax'])){
				if($data_recibida['item'][$contador]['Tax']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del igv del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del igv del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Item_tax'])){
				if($data_recibida['item'][$contador]['Item_tax']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del impuesto del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del impuesto del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Igv'])){
				if($data_recibida['item'][$contador]['Igv']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del porcentaje del igv del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del porcentaje del igv del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Tax_ICBPER'])){
				if($data_recibida['item'][$contador]['Tax_ICBPER']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del impuesto ICBPER del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del impuesto ICBPER del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Quantity_ICBPER'])){
				if($data_recibida['item'][$contador]['Quantity_ICBPER']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto unitario del impuesto ICBPER del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto unitario del impuesto ICBPER del item";
			}
			
			if(is_numeric($data_recibida['item'][$contador]['Subtotal'])){
				if($data_recibida['item'][$contador]['Subtotal']>-1){
					$sensor_montos_items++;
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del Subtotal del item";
				}
			}else{
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del monto del Subtotal del item";
			}
			
			//if ((float) $data_recibida['item'][$contador]['Affect_price'] > 0) {
			if ($data_recibida['item'][$contador]['Type_tax'] =="IGV") {
				$data_recibida['item'][$contador]['tax_method'] = "0";
			} else {
				//if ((float) $data_recibida['item'][$contador]['Non_affected_price'] > 0) {
				if ($data_recibida['item'][$contador]['Type_tax'] =="INA") {

					//if ((float) $data_recibida['item'][$contador]['Non_affected_price'] > (float) $data_recibida['item'][$contador]['Exonerated_price']) {
						$data_recibida['item'][$contador]['tax_method'] = "2";
					// } else {
					// 	$data_recibida['item'][$contador]['tax_method'] = "3";
					// }
				} else {
					if ($data_recibida['item'][$contador]['Type_tax'] =="EXO") {
						$data_recibida['item'][$contador]['tax_method'] = "3";
					} else {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error item ".$contador.": error con el tipo de impuesto indicado";
					}
				}
			}
			
			if($sensor_montos_items==11){
				$precio_unitario=(float) $data_recibida['item'][$contador]['Unit_price'] ;
				$afecto=(float) $data_recibida['item'][$contador]['Affect_price'];
				$inafecto=(float) $data_recibida['item'][$contador]['Non_affected_price'];
				$exonerado=(float) $data_recibida['item'][$contador]['Exonerated_price'];
				$impuesto=(float)$data_recibida['item'][$contador]['Tax'];
				$impuesto_bolsa=(float) $data_recibida['item'][$contador]['Tax_ICBPER'];
				$cantidad_bolsas=(float) $data_recibida['item'][$contador]['Quantity_ICBPER'];
				$igv=$data_recibida['item'][$contador]['Igv'];
				$cantidad_productos=$data_recibida['item'][$contador]['Quantity'];
				$impuesto_item=$data_recibida['item'][$contador]['Item_tax'];

				$afecto_valid_producto=($precio_unitario-$inafecto-$exonerado)/(1+($tax_default/100));
				$igv_valid_producto=$precio_unitario-$afecto_valid_producto-$inafecto-$exonerado;

				if ((round($igv_valid_producto,2))== $impuesto) {
					/*if ((round(($afecto* ($igv / 100)),2))-0.02 < $impuesto) {}else{
						$mensaje["mensaje"][] = "Error item ".$contador.": el impuesto igv aplicado al monto afecto del producto unitario es incorrecto";
					}*/
				} else {
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": el impuesto igv aplicado al monto afecto del producto unitario es incorrecto";
					//$resp_json = $response->withJson(($mensaje));
					//return $resp_json;
				}
				
				
				if(is_numeric($data_recibida['item'][$contador]['Subtotal'])){
					$afecto_subtotal=($data_recibida['item'][$contador]['Subtotal']-(($inafecto+$exonerado)*$cantidad_productos))/(1+($tax_default/100));
					$igv_subtotal=$data_recibida['item'][$contador]['Subtotal']-$afecto_subtotal-(($inafecto+$exonerado)*$cantidad_productos);

					if (round($igv_subtotal,2)== $impuesto_item) {
						/*if (round(round(($afecto * ($igv / 100)),2 )* $cantidad_productos,2)-0.02 < doubleval($impuesto_item)) {}else{
							$mensaje["mensaje"][] = "Error item ".$contador.": el impuesto igv aplicado al monto afecto del producto total es incorrecto";
						}*/
					} else {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error item ".$contador.": el impuesto igv aplicado al monto afecto del producto total es incorrecto";
						//$resp_json = $response->withJson($mensaje);
						//return $resp_json;
					}
				}else{
					$mensaje["mensaje"][] = "Error cabecera: error con el formato del monto subtotal";
				}
				
				
				if(is_numeric(trim($data_recibida['item'][$contador]['Quantity_ICBPER'])) && is_numeric(trim($data_recibida['header']['mult_ICBPER'])) && is_numeric(trim($data_recibida['item'][$contador]['Tax_ICBPER']))){
					if ($data_recibida['item'][$contador]['Quantity_ICBPER'] * $data_recibida['header']['mult_ICBPER'] == $data_recibida['item'][$contador]['Tax_ICBPER']) {
					} else {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error item ".$contador.": el impuesto a las bolsas aplicado no es el correcto";
						//$resp_json = $response->withJson($mensaje);
						//return $resp_json;
					}
				}else{
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": el impuesto a las bolsas aplicado no es el correcto";
				}
				
				if($impuesto_bolsa>-1 && $cantidad_bolsas>0){
					$impuesto_total_bolsas=$impuesto_bolsa /$cantidad_bolsas;
				}else{
					$impuesto_total_bolsas=0;
				}

				//if ($precio_unitario  == ($afecto +$inafecto  + $exonerado + $impuesto  + $impuesto_total_bolsas)) {
				if (trim($precio_unitario)  == trim($afecto +$inafecto  + $exonerado + $impuesto)) {
					//si se cumple la condicion no retorna ningun mensaje
				} else {
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": los montos afecto, inafecto, exonerado, impuesto a las bolsas e igv del item no cuadra con el precio unitario";
					//$resp_json = $response->withJson($mensaje);
					//return $resp_json;
				}

				if (trim(($data_recibida['item'][$contador]['Unit_price'] * $data_recibida['item'][$contador]['Quantity'])+$data_recibida['item'][$contador]['Tax_ICBPER']) == trim($data_recibida['item'][$contador]['Subtotal'])) {
				} else {
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][] = "Error item ".$contador.": los montos precio unitario, cantidad y subtotal del item no cuadran";
					//$resp_json = $response->withJson($mensaje);
					//return $resp_json;
				}

				//$afectoItems = $afectoItems + ($data_recibida['item'][$contador]['Affect_price'] * $data_recibida['item'][$contador]['Quantity']);
				$afecto_subtotal_item_temp=(($data_recibida['item'][$contador]['Subtotal']-
				(($data_recibida['item'][$contador]['Exonerated_price']
				+$data_recibida['item'][$contador]['Non_affected_price'])*$data_recibida['item'][$contador]['Quantity'])
				)/(1+($tax_default/100)));
				$afectoItems = $afectoItems + $afecto_subtotal_item_temp;
				$inafectoItems = $inafectoItems + ($data_recibida['item'][$contador]['Non_affected_price'] * $data_recibida['item'][$contador]['Quantity']);
				$exoneradoItems = $exoneradoItems + ($data_recibida['item'][$contador]['Exonerated_price'] * $data_recibida['item'][$contador]['Quantity']);
				//$taxItems = $taxItems + $data_recibida['item'][$contador]['Item_tax'];
				$taxItems = $taxItems + ($data_recibida['item'][$contador]['Subtotal']-
				(($data_recibida['item'][$contador]['Exonerated_price']
				+$data_recibida['item'][$contador]['Non_affected_price'])*$data_recibida['item'][$contador]['Quantity'])-$afecto_subtotal_item_temp);
				$Tax_ICBPER = $Tax_ICBPER + $data_recibida['item'][$contador]['Tax_ICBPER'];
				$cantidadProductItems = $cantidadProductItems + $data_recibida['item'][$contador]['Quantity'];
				
			}
			
			$result_product = $this->consult_product(
			$data_recibida['empresa']['ruc'], 
			$data_recibida['item'][$contador]['code'], 
			$data_recibida['item'][$contador]['name']
			);
			
			if($result_product['name']!=null){
				if($data_recibida['item'][$contador]['name']!=$result_product['name']){
					//$mensaje["invoice"] = "0";
					//$mensaje["error"]['items'][$contador]['name']='error con el nombre del producto';
					$data_recibida['item'][$contador]['name']=$result_product['name'];
				}
			}else{
				if(strlen(trim($data_recibida['item'][$contador]['code'])) > 0){
					if (strlen(trim($data_recibida['item'][$contador]['name'])) > 0) {
						if(isset($mensaje)){}else{
							$url_alma=getenv("WSurl_almacen");
							$temp_prodcuto['empresa']['ruc']=$data_recibida['empresa']['ruc'];
							$temp_prodcuto['empresa']['user']=$data_recibida['empresa']['user'];
							$temp_prodcuto['empresa']['warehouse']=$data_recibida['empresa']['warehouse'];
							
							$temp_prodcuto['producto']['tipo_producto']="standard";
							$temp_prodcuto['producto']['nombre_producto']=trim($data_recibida['item'][$contador]['name']);
							$temp_prodcuto['producto']['code']=trim($data_recibida['item'][$contador]['code']);
							$temp_prodcuto['producto']['categoria']="1";
							$temp_prodcuto['producto']['moneda']=$data_recibida['header']['currency'];
							$temp_prodcuto['producto']['precio']=
							trim($data_recibida['item'][$contador]['Affect_price'])+
							trim($data_recibida['item'][$contador]['Tax']);
							$temp_prodcuto['producto']['imagen']="no_image.png";
							$temp_prodcuto['producto']['costo']="0";
							$temp_prodcuto['producto']['metodo_impuesto']="0";
							$temp_prodcuto['producto']['codigo_barras']="code39";
							$temp_prodcuto['producto']['detalle']="";
							$temp_prodcuto['producto']['cantidad_alerta']="0";
							$temp_prodcuto['producto']['fabricante']="0";
							$temp_prodcuto['producto']['presentacion']="";
							$idProducto = $this->consumir_servicio_local($temp_prodcuto, $url_alma, "v1/registrar_producto");
							//$mensaje["error"]['items'][$contador]['code'] = $idProducto;
						}
					} else {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del nombre del item";
					}
				}else{
					if (strlen(trim($data_recibida['item'][$contador]['name'])) > 0) {} else {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del nombre del item";
						$mensaje["mensaje"][] = "Error item ".$contador.": error con el formato del codigo del item";
					}
				}
				
			}
			
			
			$sensor_montos_items_total=$sensor_montos_items_total+$sensor_montos_items;
			
		}
		
		if($sensor_montos_items_total==(11*count($data_recibida['item'])) && $sensor_montos==7){
		
			if (trim(round($afectoItems,2)) == trim($data_recibida['header']['affected'])) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: los montos afectos de la cabecera y los detalles no cuadran ";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}

			if (trim($inafectoItems) == trim($data_recibida['header']['non_affected'])) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: los montos inafectos de la cabecera y los detalles no cuadran";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}

			if ($exoneradoItems == $data_recibida['header']['exonerated']) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: los montos exonerados de la cabecera y los detalles no cuadran";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}

			if (trim(round($taxItems,2)) == trim($data_recibida['header']['product_tax'])) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: los montos de los impuestos IGV de la cabecera y los detalles no cuadran";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}

			if(is_numeric($data_recibida['header']['tax_ICBPER']) && isset($data_recibida['header']['tax_ICBPER'])){
				if (((string) ($Tax_ICBPER * 100)) == ((string) ($data_recibida['header']['tax_ICBPER'] * 100))) {
				} else {
					//$mensaje["invoice"] = "0";
					$mensaje["mensaje"][]  = "Error cabecera: los montos de los impuestos a la bolsa de la cabecera y los detalles no cuadran";
					//$resp_json = $response->withJson($mensaje);
					//return $resp_json;
				}
			}

			if ($cantidadProductItems == $data_recibida['header']['total_quantity']) {
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: la cantidad de los productos de la cabecera y los detalles no cuadran";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}
		}
		

		if ($captura > 0) {

			foreach ($datos_customer as $data) {
				$customer->setId($data['id']);
				$customer->setName($data['name']);
				$customer->setCf1($data['cf1']);
				$customer->setCf2($data['cf2']);
				$customer->setDireccion($data['direccion']);
				$customer->setDocument_type_id($data['document_type_id']);
			}
			//$headerSale->setCustomer_name($customer->getName());
			//$headerSale->setCustomer_id($customer->getId());

		} else {

			$json = file_get_contents('http://api.ateneaperu.com/api/Sunat/Ruc?sNroDocumento=' . $document_iden, false, null);
			$datosCustomerAPI  = json_decode($json);
			//$data=$datos->direccion_completa;
			if ($datosCustomerAPI->ruc != "") {

				$customer->setName($datosCustomerAPI->nombre_o_razon_social);
				$customer->setCf1("");
				$customer->setCf2($datosCustomerAPI->ruc);
				$customer->setDireccion($datosCustomerAPI->direccion_completa);
				$customer->setPhone("");
				$customer->setEmail("");
				$customer->setCustomers_type_id(1);
				$customer->setEstado(1);
				$customer->setPerson_type(2);
				$customer->setDocument_type_id($data_recibida['header']['type_document_customer']);
			} else {

				/*$jsondni = file_get_contents('http://aplicaciones007.jne.gob.pe/srop_publico/Consulta/Afiliado/GetNombresCiudadano?DNI=' . $document_iden, false, null);
				$datosDNI = explode("|", $jsondni);

				if ($datosDNI[0] != "" && $datosDNI[0] != null) {
					$customer->setName($datosDNI[2] . " " . $datosDNI[0] . " " . $datosDNI[1]);
					$customer->setCf1($document_iden);
					$customer->setCf2("");
					$customer->setDireccion("");
					$customer->setPhone("");
					$customer->setEmail("");
					$customer->setCustomers_type_id(1);
					$customer->setEstado(1);
					$customer->setPerson_type(1);
					$customer->setDocument_type_id($data_recibida['header']['type_document_customer']);

					//$resp_json = $response->withJson($customer->getName());
					//return $resp_json;
				} else {*/

					$customer->setName($data_recibida['header']['name_customer']);
					$customer->setDireccion($data_recibida['header']['address_customer']);
					$customer->setPhone("");
					$customer->setEmail("");
					$customer->setCustomers_type_id(1);
					$customer->setEstado(1);
					$customer->setDocument_type_id($data_recibida['header']['type_document_customer']);

					if ($data_recibida['header']['type_document_customer'] == 6) {

						if (strlen($document_iden) == 11) {
							$customer->setCf2($document_iden);
							$customer->setCf1("");
							$customer->setPerson_type(2);
						} else {
							$customer->setCf2("");
							$customer->setCf1("");
							//$mensaje["invoice"] = "0";
							$mensaje["mensaje"][] = "Error cabecera: el formato del ruc es incorrecto";
							//$resp_json = $response->withJson($mensaje);
							//return $resp_json;
						}
					} else {

						if ($data_recibida['header']['type_document_customer'] == 1) {
							if (strlen($document_iden) == 8) {
								$customer->setCf1($document_iden);
								$customer->setCf2("");
								$customer->setPerson_type(1);
							} else {
								$customer->setCf2("");
								$customer->setCf1("");
								//$mensaje["invoice"] = "0";
								$mensaje["mensaje"][]  = "Error cabecera: el formato del dni es incorrecto";
								//$resp_json = $response->withJson($mensaje);
								//return $resp_json;
							}
						} else {
							//if (strlen($document_iden) ==12) {
								$customer->setCf1($document_iden);
								$customer->setCf2("");
								$customer->setPerson_type(1);
								$customer->setDireccion($data_recibida['header']['address_customer']);
							/*} else {
								$customer->setCf2("");
								$customer->setCf1("");
								//$mensaje["invoice"] = "0";
								$mensaje["mensaje"][]  = "Error cabecera: el formato del pasaporte o carnet de extrajeria es incorrecto";
								//$resp_json = $response->withJson($mensaje);
								//return $resp_json;
							}*/
						}
					}
				//}
			}
		}

		if ($data_recibida['header']['type_document_customer'] != 6 && 
			$data_recibida['header']['type_document_customer'] != 1 && 
			$data_recibida['header']['type_document_customer'] != 7 && 
			$data_recibida['header']['type_document_customer'] != 4) {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][]  = "Error cabecera: El tipo de documento del cliente es incorrecto";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}
		
		if (strlen($customer->getCf2()) <= 0 && 
			$data_recibida['header']['type_document_customer'] == 6) {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][]  = "Error cabecera: El ruc del cliente no es el correcto";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}

		if (strlen($customer->getCf1()) <= 0 && 
			($data_recibida['header']['type_document_customer'] == 1 || 
			$data_recibida['header']['type_document_customer'] == 7 || 
			$data_recibida['header']['type_document_customer'] == 4)) {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][]  = "Error cabecera: El dni, pasaporte o carnet enviado no es el correcto";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}

		if (strlen($customer->getName()) == 0) {
			//$mensaje["invoice"] = "0";
			$mensaje["mensaje"][]  = "Error cabecera: El nombre no pueden estar vacio";
			//$resp_json = $response->withJson($mensaje);
			//return $resp_json;
		}

		if ($type_invoice == 2) {

			if (strlen($customer->getCf2()) > 0) {
				$headerSale->setDocument_type(2);
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: El cliente requiere tener ruc, cuando se genera una factura";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}

			if (strlen($customer->getDireccion()) == 0) {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: La direccion no pueden estar vacio";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}
		} else {
			if ($type_invoice == 1) {

				if (strlen($customer->getCf1()) > 0) {
					$headerSale->setDocument_type(1);
				} else {
					if (strlen($customer->getCf2()) < 0) {
						//$mensaje["invoice"] = "0";
						$mensaje["mensaje"][] = "Error cabecera: El cliente requiere tener dni, pasaporte, carnet de extrajeria o ruc para generar una boleta";
						//$resp_json = $response->withJson($mensaje);
						//return $resp_json;
					} else {
						$headerSale->setDocument_type(1);
					}
				}
			} else {
				//$mensaje["invoice"] = "0";
				$mensaje["mensaje"][] = "Error cabecera: tipo de comprobante no valido";
				//$resp_json = $response->withJson($mensaje);
				//return $resp_json;
			}
		}

		

		if(!isset($mensaje)){
			
			if ($captura == 0) {
				$idCustomerDni = $customer_query->insert_customer($customer, trim($data_recibida['empresa']['ruc']), $datos_empresa_general);
				$customer->setId($idCustomerDni[0]);
				/*$temp_customer["empresa"]["ruc"]=trim($data_recibida['empresa']['ruc']);
				$temp_customer["customer"]["name"]=trim($data_recibida['header']['name_customer']);
				$temp_customer["customer"]["address"]=trim($data_recibida['header']['address_customer']);
				$temp_customer["customer"]["Phone"]='';
				$temp_customer["customer"]["Email"]='';
				$temp_customer["customer"]["Customers_type"]='1';
				$temp_customer["customer"]["Document_type"]=trim($data_recibida['header']['type_document_customer']);
				$temp_customer["customer"]["document_numeric"]=trim($data_recibida['header']['identification_customer']);
				if(trim($data_recibida['header']['type_document_customer'])=='6'){
					$temp_customer["customer"]["Person_type"]='2';
				}else{
					$temp_customer["customer"]["Person_type"]='1';
				}
				$idCustomerDni = $this->consumir_servicio_local($temp_customer, $url, "registrar_cliente");
				$customer->setId($idCustomerDni["id_customer"]);*/
				
			}
			$headerSale->setCustomer_name($customer->getName());
			$headerSale->setCustomer_id($customer->getId());
			
			$headerSale->setCurrency($data_recibida['header']['currency']);
			$headerSale->setAffected($data_recibida['header']['affected']);
			$headerSale->setNon_affected($data_recibida['header']['non_affected']);
			$headerSale->setExonerated($data_recibida['header']['exonerated']);
			$headerSale->setTotal($data_recibida['header']['total']);
			$headerSale->setProduct_tax($data_recibida['header']['product_tax']);
			$headerSale->setTotal_tax($data_recibida['header']['product_tax']);
			$headerSale->setTax_ICBPER($data_recibida['header']['tax_ICBPER']);
			$headerSale->setMult_ICBPER($data_recibida['header']['mult_ICBPER']);
			$headerSale->setSubtotal($data_recibida['header']['subtotal']);
			$headerSale->setAmount($data_recibida['header']['subtotal']);
			$headerSale->setGrand_total($data_recibida['header']['subtotal']);
			$headerSale->setTotal_items($data_recibida['header']['total_items']);
			$headerSale->setTotal_quantity($data_recibida['header']['total_quantity']);
			$headerSale->setPaid($data_recibida['header']['paid']);
			
			$headerSale->setDate((string) $data_recibida['header']['date']);
			$headerSale->setLocal_id((int)($data_recibida['empresa']['local'])); //****
			$headerSale->setWarehouse_id((int)($data_recibida['empresa']['warehouse'])); //****
			$headerSale->setProduct_discount("0.00"); //***
			$headerSale->setOrder_discount_id("0.00"); //****
			$headerSale->setOrder_discount("0.00"); //*****
			$headerSale->setTotal_discount("0.00"); //*****
			$headerSale->setOrder_tax_id("0.00"); //*****
			$headerSale->setOrder_tax("0.00"); //*****

			$headerSale->setCreated_by((int)($data_recibida['empresa']['user'])); //****
			//$headerSale->setUpdated_by(0); //****
			//$headerSale->setUpdated_at("2019-08-30"); //****
			$headerSale->setNote($data_recibida['header']['note']);
			if($data_recibida['header']['paid']==$data_recibida['header']['subtotal']){
				$headerSale->setStatus("Pagado");
			}else{
				$headerSale->setStatus("DEBE");
			}
			$headerSale->setRounding("0.00"); //****
			$headerSale->setAttachment("");
			$headerSale->setExpiration_date($data_recibida['header']['expiration_date']);
			$headerSale->setCanal_id((int)($data_recibida['empresa']['canal'])); //****
			$headerSale->setCustom_field_1("");
			$headerSale->setCustom_field_2("");
			$headerSale->setCustom_field_3("");
			$headerSale->setInvoice_id("");
			$headerSale->setFlg_response(0);
			$headerSale->setError_code("");
			$headerSale->setResponse_descrip("");
			$headerSale->setDigest_value("");
			$headerSale->setEstado(1);
			$headerSale->setDocument_type($data_recibida['header']['document_type']);
			
			$invoice = $sale_query->regist_sale($headerSale, $data_recibida['item'], $data_recibida['empresa']['ruc'], $data_recibida['header']['method_paid'], $datos_empresa_general);
			$headerSale->setInvoice_id($invoice[0]);
			$headerSale->setId($invoice[1]);

			$settings_query = new SettingsDAO();
			$settings_beta = $settings_query->valid_beta($datos_empresa_general);

			foreach ($settings_beta as $beta) {
				$business->setBeta($beta['beta']);
			}
			$business->setRazon_social($datos_empresa_general['razon_social']);
			$business->setLocalID("1");
			$business->setPassFirma($datos_empresa_general['password_firma']);
			$business->setUsuSol($datos_empresa_general['usuario_secundario']);
			$business->setPassSol($datos_empresa_general['clave_secundario']);

			$respuesta_WS = $this->generar_xml($headerSale, $data_recibida['item'], $customer, $business);

			$headerSale->setFlg_response($respuesta_WS['flg_response']);
			$headerSale->setError_code($respuesta_WS['error_code']);
			$headerSale->setResponse_descrip($respuesta_WS['response_descrip']);
			$headerSale->setDigest_value($respuesta_WS['digest_value']);

			$sale_query->modificar_sale_Xml($headerSale, $datos_empresa_general);

			$pdf = $this->generar_pdf($headerSale, $data_recibida['item'], $customer, $business, $datos_empresa_general, $response); //*********************TRJ100 - KENY PONTE - 10/10/2019******************** */
			$mensaje["resultado"] = "ok";
			$mensaje["mensaje"] = $headerSale->getInvoice_id();
			//$mensaje["pdf"] = $pdf; //*********************TRJ100 - KENY PONTE - 10/10/2019******************** */

			if ($headerSale->getDocument_type() == 2) {


				$datos_send_invoice = $respuesta_WS; //$this->enviarXML_sale($business, $headerSale);

				$datos_send_invoice['date'] = date("Y") . "-" . date("m") . "-" . date("d");
				$datos_send_invoice['hora'] = date("H") . ":" . date("i") . ":" . date("s");

				$supplierID = $business->getRuc();
				$serieNumero = $headerSale->getInvoice_id();
				$invoiceTypeCode = "01";

				$file_name = $supplierID . "-" . $invoiceTypeCode . "-" . $serieNumero;
				$datos_send_invoice['file_name'] = $file_name;

				if ($datos_send_invoice["flg_response"] == 0) {
					$status = 3;
				} else {
					if ($datos_send_invoice["flg_response"] == 1) {
						$status = 4;
					} else {
						$status = 1;
					}
				}
				$datos_send_invoice['status'] = $status;
				if ($datos_send_invoice['status'] == 3) {
					$mensaje["resultado"] = "error";
					$mensaje["mensaje"] = "SN: rechazado";
				}
				if ($datos_send_invoice['status'] == 1) {
					$mensaje["resultado"] = "error";
					$mensaje["mensaje"] = "SN: error de envio";
				}

				$sale_query->regist_send_invoice($datos_send_invoice, $headerSale->getId(), $datos_empresa_general);
			}
		
		}else{
			$mensaje["resultado"] = "error";
		}
		
		$resp_json = $response->withJson($mensaje);
		return $resp_json;
		
	}

	public function generar_xml(SaleModel $data, array $items, CustomerModel $customer_det, BusinessModel $empresa): array
	{
		if ($data->getDocument_type() == 2) {
			$invoiceTypeCode = "01";
			$documentID = $customer_det->getCf2();
			$document = $customer_det->getDocument_type_id();
			// $urlDoc="boleta";//"factura";
		} else if ($data->getDocument_type() == 1) {

			$invoiceTypeCode = "03";

			$document = $customer_det->getDocument_type_id();
			$documentID = $customer_det->getCf1();

			// Si el cliente es una empresa
			if ($customer_det->getCf1() == null && $customer_det->getCf2() != null) {
				$document = $customer_det->getDocument_type_id();
				$documentID = $customer_det->getCf2();
			}

			if ($documentID == "" | $documentID == null) {
				$documentID = "-";
			}
		}


		$serieNumero = $data->getInvoice_id();
		$Date = explode(' ', $data->getDate(), 2);

		$supplierID = $empresa->getRuc();
		$passFirma = $empresa->getPassFirma();
		$supplierName = $empresa->getRazon_social();

		$currency_prefix = $data->getCurrency();
		$signatureID = $serieNumero;
		$URI = "#" . $signatureID;
		$supplierDocumentID = "6";

		//Obtener el Local
		/*$local_id = $this->session->userdata('local');
		$local = $this->site->getLocalByID($local_id);*/

		//Codigo de local
		$localID = $empresa->getLocalID(); //$local->cod_sunat; //"0001";

		require("Funciones.php");

		$header = array(
			"TIPO_OPERACION" => "0101",
			"TOTAL_GRATUITAS" => "0",
			"TOTAL_EXPORTACION" => "0",
			"TOTAL_ISC" => "0",
			"TOTAL_OTR_IMP" => "0",
			"TOTAL_LETRAS" => "",
			"NRO_GUIA_REMISION" => "",
			"COD_GUIA_REMISION" => "",
			"NRO_OTR_COMPROBANTE" => "",
			"COD_PAIS_CLIENTE" => "PE",
			"COD_UBIGEO_CLIENTE" => "",
			"DEPARTAMENTO_CLIENTE" => "",
			"PROVINCIA_CLIENTE" => "",
			"DISTRITO_CLIENTE" => "",
			"CIUDAD_CLIENTE" => "",
			"CODIGO_UBIGEO_EMPRESA" => "",
			"DIRECCION_EMPRESA" => "",
			"DEPARTAMENTO_EMPRESA" => "",
			"PROVINCIA_EMPRESA" => "",
			"DISTRITO_EMPRESA" => "",
			"CODIGO_PAIS_EMPRESA" => "",
			"CONTACTO_EMPRESA" => "",
			/***************************************************************** */
			"NRO_DOCUMENTO_EMPRESA" => $supplierID,
			"COD_TIPO_DOCUMENTO" => $invoiceTypeCode,
			"NRO_COMPROBANTE" => $serieNumero,
			"passFirma" => $passFirma,
			"FECHA_DOCUMENTO" => $Date[0],
			"issueTime" => $Date[1],
			"FECHA_VTO" => $Date[0],
			"note" => strtolower(numtoletras($data->getAmount())),
			"COD_MONEDA" => $currency_prefix,
			"lineCountNumeric" => (string) $data->getTotal_items(),
			"signatureID" => $signatureID,
			"RAZON_SOCIAL_EMPRESA" => $supplierName,
			"URI" => $URI,
			"TIPO_DOCUMENTO_EMPRESA" => $supplierDocumentID,
			"CODIGO_LOCAL" => $localID,
			"TIPO_DOCUMENTO_CLIENTE" => (string) $document,
			"NRO_DOCUMENTO_CLIENTE" => $documentID,
			"RAZON_SOCIAL_CLIENTE" => $data->getCustomer_name(),
			"DIRECCION_CLIENTE" => $customer_det->getDireccion(),
			"baseAmount" => (string) (float) ((float) $data->getAmount() + (float) $data->getOrder_discount()),
			"TOTAL_IGV" => (string) $data->getProduct_tax(),
			"TOTAL_GRAVADAS" => (string) $data->getAffected(),
			"taxSubtotal" => (string) $data->getTotal_tax(),
			"TOTAL" => (string) $data->getAmount(),
			"allowanceTotalAmount" => (string) $data->getOrder_discount(),
			"TOTAL_INAFECTA" => (string) $data->getNon_affected(),
			"TOTAL_EXONERADAS" => (string) $data->getExonerated(),
			"TOTAL_ICBPER" => (string) $data->getTax_ICBPER(),
			"mult_ICBPER" => (string) $data->getMult_ICBPER()

		);
		$porcentaje_desc = round((((100 / $header['baseAmount']) * (float) $data->getOrder_discount()) / 100), 4);

		$discountGlobal = array("discount_global" => (string) $porcentaje_desc);

		$cant = 0;
		foreach ($items as $item) {

			$cant = $cant + 1;
			$sum_price = (float) $item['Affect_price'] + (float) $item['Non_affected_price'] + (float) $item['Exonerated_price'];

			if ($item['tax_method'] == 0 || $item['tax_method'] == 1) {
				$amount_applies_tax = $item['Affect_price'];
			} else {
				if ($item['tax_method'] == 3) {
					$amount_applies_tax = $item['Exonerated_price'];
				} else {
					$amount_applies_tax = $item['Non_affected_price'];
				}
			}


			if ($item['Type_tax'] == "EXO") {

				$CODIGO_IMPUESTO = "9997"; //codigoImp
				$TIPO_IMPUESTO = "EXO"; //tipoImp
				$TIPO_CODIGO_IMPUESTO = "VAT"; //typeCode
				$CODIGO_CATEGORIA_IMPUESTO = "E"; //taxCategoryCode
				$CODIGO_EXTENSION_IMPUESTO = "20"; //taxExemptionReasonCode

			} else if ($item['Type_tax'] == "INA") {

				$CODIGO_IMPUESTO = "9998"; //codigoImp
				$TIPO_IMPUESTO = "INA"; //tipoImp
				$TIPO_CODIGO_IMPUESTO = "FRE"; //typeCode
				$CODIGO_CATEGORIA_IMPUESTO = "O"; //taxCategoryCode
				$CODIGO_EXTENSION_IMPUESTO = "30"; //taxExemptionReasonCode


			} else if ($item['Type_tax'] == "IGV") {
				$CODIGO_IMPUESTO = "1000"; //codigoImp
				$TIPO_IMPUESTO = "IGV"; //tipoImp
				$TIPO_CODIGO_IMPUESTO = "VAT"; //typeCode
				$CODIGO_CATEGORIA_IMPUESTO = "S"; //taxCategoryCode
				$CODIGO_EXTENSION_IMPUESTO = "10"; //taxExemptionReasonCode
			}
			$itemArray[$cant] = array(
				"txtUNIDAD_MEDIDA_DET" => "NIU",
				"txtCODIGO_PROD_SUNAT" => '',
				'CODIGO_IMPUESTO' => $CODIGO_IMPUESTO,
				'TIPO_IMPUESTO' => $TIPO_IMPUESTO,
				'TIPO_CODIGO_IMPUESTO' => $TIPO_CODIGO_IMPUESTO,
				'CODIGO_CATEGORIA_IMPUESTO' => $CODIGO_CATEGORIA_IMPUESTO,
				'CODIGO_EXTENSION_IMPUESTO' => $CODIGO_EXTENSION_IMPUESTO,

				"txtCANTIDAD_DET" => $item['Quantity'],
				"txtIMPORTE_DET" => (string) (formatDecimal((float) $amount_applies_tax * (float) $item['Quantity'])),
				"txtPRECIO_DET" => (string) $item['Unit_price'],
				"txtPRECIO_TIPO_CODIGO" => "01",
				"txtIGV" => (string) $item['Item_tax'],
				// "itemTaxSubtotalTaxableAmount" => (string) (formatDecimal((float) $amount_applies_tax * (float) $item['Quantity'])),
				// "itemTaxSubtotalTaxAmount" => (string) $item['Item_tax'],
				"txtPRECIO_SIN_IGV_DET" => (string) $sum_price,
				"IGV_ITEM" => (string) (float) $item['Igv'],
				"txtDESCRIPCION_DET" => (string) $item['name'],
				"txtCODIGO_DET" => (string) $item['code'],
				//"tax_method" => (string) $item['tax_method'],
				"tax_ICBPER" => (string) $item['Tax_ICBPER'],
				//"quantity_ICBPER" => (string) $item['Quantity_ICBPER'],
			);
		}

		$emisor = array(
			"CLAVE_FIRMA" => $empresa->getPassFirma(),
			"USUARIO_SOL" => $empresa->getUsuSol(),
			"CLAVE_SOL" => $empresa->getPassSol(),
			"BETA" => $empresa->getBeta(),
		);
		//datos a enviar
		$postData["header"] = $header;
		$postData["item"] = $itemArray;
		$postData["discountGlobal"] = $discountGlobal;
		$postData["emisor"] = $emisor;
		// Create the context for the request
		$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
			)
		));
		$url_raiz = getenv('WSurl_fe');
		if ($data->getDocument_type() == 2) {
			$url = 'factura.php';
		} else if ($data->getDocument_type() == 1) {
			$url = 'boleta.php';
		}
		$url_FE=$url_raiz . $url;

		// Send the request
		//$this->config->item('aws_url');
		$response = file_get_contents($url_FE, false, $context);

		if ($response) {
			$res = json_decode($response, true);

			if ($res["cod_sunat"] == "0") {
				$sale_data["digest_value"] = $res["hash_cpe"];
				$sale_data["response_descrip"] = $res["msj_sunat"];
				$sale_data["error_code"]  = $res["cod_sunat"];
				$sale_data["flg_response"] =  "1";
			} else {
				$sale_data["digest_value"] =  "";
				$sale_data["response_descrip"] = $res["mensaje"];
				$sale_data["error_code"]  = $res["cod_sunat"];
				$sale_data["flg_response"] =  "0";
			}
			// $sale_data = array(
			// 	'flg_response' => $res[0],
			// 	'error_code' => $res[1],
			// 	'response_descrip' => $res[2],
			// 	'digest_value' => $res[4]
			// );


			return $sale_data;
		} else {
			$sale_data = array(
				'flg_response' => "0",
				'error_code' => "0",
				'response_descrip' => "Error al conectarse con AWS",
				'digest_value' => ""
			);

			return $sale_data;
		}

		return false;
	}
	public function enviarXML_sale(BusinessModel $empresa, SaleModel $data): array
	{
		if ($empresa->getBeta() == 0) {
			$urlDoc = "post/envio";
		} else {
			$urlDoc = "beta/post/envio";
		}
		if ($data->getDocument_type() == 2) {
			$invoiceTypeCode = "01";
		} else if ($data->getDocument_type() == 1) {
			$invoiceTypeCode = "03";
		}
		$supplierID = $empresa->getRuc();
		$serieNumero = $data->getInvoice_id();
		$file_name = $supplierID . "-" . $invoiceTypeCode . "-" . $serieNumero;
		$usuSol = $empresa->getUsuSol();
		$passSol = $empresa->getPassSol();

		$postData = array(
			'ruc' => $supplierID,
			'typeCode' => $invoiceTypeCode,
			'serieNumero' => $serieNumero,
			'usuSol' => $usuSol,
			'passSol' => $passSol
		);

		// Create the context for the request
		$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
			)
		));

		// Send the request
		$url = getenv('WSurl_fe');
		$response = file_get_contents($url . $urlDoc, false, $context);

		//-------------Envio Sunat---------------//
		if ($response) {
			$res = json_decode($response, true);

			$tipo = "RF";

			if ($res[1] != 0) {
				$status = 3;
			} else {
				if ($res[0] == 1) {
					$status = 4;
				} else {
					$status = 1;
				}
			}

			$NC_data = array(
				'flg_response' => $res[0],
				'error_code' => $res[1],
				'response_descrip' => $res[3] . ": " . $res[2],
				'status' => $status,
				'file_name' => $file_name
			);
		} else {
			$NC_data = array(
				'flg_response' => "0",
				'error_code' => "0",
				'response_descrip' => "error al conectarse a AWS",
				'status' => "1",
				'file_name' => $file_name
			);
		}

		return $NC_data;
	}
	//*********************TRJ100 - KENY PONTE - 10/10/2019******************** */

	public function generar_pdf(SaleModel $data, array $items, CustomerModel $customer_det, BusinessModel $empresa, $datos_empresa_general, Response $response)
	{
		
		//$emp= $this->conexionBDgeneral($empresa->getRuc());
		$meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
		//$region = $this->session->userdata('region');
		$region = "Lima";


		$l_ruc = 'RUC';
		$l_dni = 'Numero de Documento';
		$l_address = 'Direccion';
		$arrMes = $meses[date('n') - 1];
		$l_qty = 'CANT.';
		$l_description = 'Descripcion';
		$l_importe = 'Importe';
		$l_currency = 'Moneda';
		$op_exo = 'Op. Inafectos';
		$op_exoReal = 'Op. Exonerado';
		$op_ICBPER = 'OP. ICBPER' . ' ' . 'Bolsa plástica';
		//----------------------
		$tipo_doc = "";
		$impRuc = "";
		if ($data->getDocument_type() == 1) {
			$tipo_doc = 'BOLETA DE VENTA ELECTRONICA';
		} else {
			$tipo_doc = 'FACTURA ELECTRONICA';
		}
		$numComp = $data->getInvoice_id();
		$symbol = "";
		$currency = "";
		if ($data->getCurrency() == 'PEN') {
			$currency = 'Soles';
		} else if ($data->getCurrency() == 'USD') {
			$currency = 'Dólares';
		}
		$arrD1 = explode(" ", $data->getDate());
		$arrD2 = explode("-", $arrD1[0]);
		$ano = $arrD2[0];
		$dia = $arrD2[2];
		$mes = $arrD2[1];
		$row_items_html = "";
		foreach ($items as $item) {

			$item = (array) $item;
			$decimals = 2;
			$dec_point = ".";
			$thousands_sep = ",";
			$quantity = number_format($item['Quantity'], $decimals, $dec_point, $thousands_sep);
			$uprice = number_format($item['Unit_price'], $decimals, $dec_point, $thousands_sep);
			$subt = number_format($item['Subtotal'], $decimals, $dec_point, $thousands_sep);
			$nombreProducto = str_replace("<", "&lt;", $item['name']);
			$nombreProducto = str_replace(">", "&gt;", $nombreProducto);

			$row_items_html .= '<tr>
					  <td align="center" style="font-size:10px">' . $quantity . '</td>
					  <td align="left" style="font-size:10px">' . $nombreProducto . '</td>
					  <td align="right" style="font-size:10px">' . $uprice . '</td>
					  <td align="right" style="font-size:10px">' . $subt . '</td>
				  </tr>';
		}

		$row_items_html .= '
			  <tr>
				  <td align="center">&nbsp;</td>
				  <td align="left"></td>
				  <td align="right"></td>
				  <td align="right"></td>
			  </tr>
		  ';
		$customer_name = $customer_det->getName();
		$customer_address = $customer_det->getDireccion();
		if ($data->getDocument_type() == 2) {
			$impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" align="left" >
				<tr>
					<td align="left" width="20%"  style="font-size:10px"> Señor(es): </td>
					<td align="left" width="80%"  style="font-size:10px"> ' . $customer_name . '</td>
				</tr>
				<tr>
					<td align="left" width="20%"  style="font-size:10px"> ' . $l_ruc . ': </td>
					<td align="left" width="80%"  style="font-size:10px"> ' . $customer_det->getCf2() . '</td>
				</tr>
				<tr>
					<td align="left" width="20%"  style="font-size:10px"> ' . $l_address . ': </td>
					<td align="left" width="80%"  style="font-size:10px"> ' . $customer_address . '</td>
				</tr>

			</table>';
		} else {
			$doc = $l_dni;
			$nro_doc = $customer_det->getCf1();

			if ($customer_det->getCf1() == null && $customer_det->getCf2() != null) {
				$doc = $l_ruc;
				$nro_doc = $customer_det->getCf2();
			}
			$impRuc = '<table border="1" width="100%" cellspacing="0" cellpadding="2" align="left">
				<tr>
					<td align="left" width="20%"  style="font-size:10px"> Señor(es): </td>
					<td align="left" width="80%"  style="font-size:10px"> ' . $customer_name . '</td>
				</tr>
				<tr>
					<td align="left" width="20%"  style="font-size:10px"> ' . $doc . ': </td>
					<td align="left" width="80%"  style="font-size:10px"> ' . $nro_doc . '</td>
				</tr>
				<tr>
					<td align="left" width="20%"  style="font-size:10px"> ' . $l_address . ': </td>
					<td align="left" width="80%"  style="font-size:10px"> ' . $customer_address . '</td>
				</tr>
			</table>';
		}
		$sub = number_format($data->getSubtotal(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$desc = number_format($data->getOrder_discount(), $decimals = 2, $dec_point = ".", $thousands_sep = ","); //(-$inv['rounding']) +
		$afc = number_format($data->getAffected(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$exo = number_format($data->getNon_affected(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$tax_ICBPER = number_format($data->getTax_ICBPER(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$exoReal = number_format($data->getExonerated(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$igv = number_format($data->getTotal_tax(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$tot1 = number_format($data->getAmount(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$round = number_format($data->getRounding(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$tot2 = number_format($data->getGrand_total(), $decimals = 2, $dec_point = ".", $thousands_sep = ",");
		$totLetras = strtolower(numtoletras($data->getGrand_total()) . " " . $currency);


		$pdf = new pdf('P', 'mm', 'A4', true, 'UTF-8', false);
		$pdf->SetTitle($tipo_doc . " - " . $numComp);
		$pdf->SetHeaderMargin(30);
		$pdf->SetTopMargin(20);
		$pdf->setFooterMargin(20);
		$pdf->SetAutoPageBreak(true);
		$pdf->SetAuthor('Author');
		$pdf->SetDisplayMode('real', 'default');

		$pdf->AddPage();

		$razon_social = $empresa->getRazon_social();
		$ruc = $empresa->getRuc();


		$_ruc = $l_ruc . ". " . $ruc;

		//-----------------------------------QR-------------------------------------------//
		$serieNumero = explode('-', $numComp);
		$serie = $serieNumero[0];
		$numero = $serieNumero[1];
		$date = $arrD1[0];
		$hash = $data->getDigest_value();

		if ($data->getDocument_type() == 2) {
			$cusDoc = "06";
			$docType = "01";
			$numDoc = $customer_det->getCf2();
			$qr = $ruc . "|" . $docType . "|" . $serie . "|" . $numero . "|" . $igv . "|" . $tot1 . "|" . $date . "|" . $cusDoc . "|" . $numDoc . "|" . $hash;
		} else {
			$cusDoc = "01";
			$docType = "03";
			$numDoc = $customer_det->getCf1();
			$qr = $ruc . "|" . $docType . "|" . $serie . "|" . $numero . "|" . $igv . "|" . $tot1 . "|" . $date . "|" . $cusDoc . "|" . $numDoc . "|" . $hash;
		}
		$ex1 = new QRCodeGenerator();
		$nombqr1 = $ex1->generate($serieNumero[0] . $serieNumero[1], $qr);
		$qr_img = '<img src="' . $nombqr1 . '" width="120" height="120">';


		$settings_query = new SettingsDAO();
		$settings_header = $settings_query->select_header($datos_empresa_general);
		foreach ($settings_header as $header) {
			$header = $header['header'];
		}

		$tbl = <<<EOD
		<table border="0" width="100%" cellspacing="0" cellpadding="2" >
			<tr>
				<td width="65%" align="center" style="font-size:10px">
				$header
				</td>
				<td width="35%" valign="middle"><br><br><br><br>
					<table border="1" width="100%" cellspacing="0" cellpadding="2" >
						<tr>
							<td align="center"  style="font-size:10px"><h2>$_ruc</h2></td>
						</tr>
						<tr>
							<td align="center" bgcolor="#E4E4E4" style="font-size:10px"><h2>$tipo_doc</h2></td>
						</tr>
						<tr>
							<td align="center" style="font-size:10px"><h2>$numComp</h2></td>
						</tr>
					</table>
				</td>
			</tr>

			<tr>
				<td width="65%" align="left">
					$impRuc
				</td>
				<td width="35%">
					<table border="1" width="100%" cellspacing="0" cellpadding="2" >
						<tr>
							<td align="left" style="font-size:10px"> <u>$region</u> ,  <u>     $dia     </u>   de   <u>   $arrMes   </u>   del   <u>     $ano     </u> </td>
						</tr>
						<tr>
							<td align="left"  style="font-size:10px"> $l_currency: $currency</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<br><br>
		<table border="1" width="100%" cellspacing="0" cellpadding="2" >
			<tr>
				<td bgcolor="#E4E4E4" align="center" width="10%" style="font-size:10px"><strong>$l_qty</strong></td>
				<td bgcolor="#E4E4E4" align="center" width="60%" style="font-size:10px"><strong>$l_description</strong></td>
				<td bgcolor="#E4E4E4" align="center" width="15%" style="font-size:10px"><strong>Precio Unitario</strong></td>
				<td bgcolor="#E4E4E4" align="center" width="15%" style="font-size:10px"><strong>$l_importe</strong></td>
			</tr>
				$row_items_html
		</table>
		<table border="0" width="100%" cellspacing="0" cellpadding="2" >
			<tr>
				<td align="left" style="font-size:10px">SON: $totLetras</td>
			</tr>
		</table>
		<table border="0" width="100%" cellspacing="0" cellpadding="2" >
			<tr>
				<td  width="70%" align="center">
					<table border="0" cellspacing="0" cellpadding="2" >
						<tr>
							<td align="center">$qr_img</td>
							<br>
						</tr>
						<tr>
							<td align="center" style="font-size:10px"><i>CANCELADO</i></td>
						</tr>
						<BR>
						<tr>
							<td align="center" style="font-size:10px"><u>$region</u> ,  __________<!--$dia--> de __________<!--$mes--> del __________<!--$ano--> </td>
						</tr>
					</table>
				</td>
				<td align="center" width="30%">
				<br><br>
					<table border="1" width="100%" cellspacing="0" cellpadding="2" >
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Sub Total</strong></td>
							<td align="right" width="40%" style="font-size:10px">$sub</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Descuento</strong></td>
							<td align="right" width="40%" style="font-size:10px">$desc</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Total</strong></td>
							<td align="right" width="40%" style="font-size:10px">$tot1</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Op. Gravadas</strong></td>
							<td align="right" width="40%" style="font-size:10px">$afc</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>$op_exoReal</strong></td>
							<td align="right" width="40%" style="font-size:10px">$exoReal</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>$op_exo</strong></td>
							<td align="right" width="40%" style="font-size:10px">$exo</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>IGV - ivPorc %</strong></td>
							<td align="right" width="40%" style="font-size:10px">$igv</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>$op_ICBPER</strong></td>
							<td align="right" width="40%" style="font-size:10px">$tax_ICBPER</td>
						</tr>
						<tr>
								<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Redondeo</strong></td>
							<td align="right" width="40%" style="font-size:10px">$round</td>
						</tr>
						<tr>
							<td bgcolor="#E4E4E4" align="left" width="60%" style="font-size:10px"><strong>Total Venta</strong></td>
							<td align="right" width="40%" style="font-size:10px">$tot2</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	<br>
EOD;
		$pdf->writeHTML($tbl, true, false, false, false, '');

		$nombPDF = randomstring(20);

		
		if ($data->getDocument_type() == 1) {
			$archivopdf="boletas/" . $nombPDF . ".pdf";
		} else if ($data->getDocument_type() == 2) {
			$archivopdf="facturas/" . $nombPDF . ".pdf";
		}
		//$carpetaFuentes=/*getenv('raiz_ubicacion').*/Extraendo_nombre('https://',$emp["subdominio"]);
		$carpetaFuentes=str_replace("https://", "", $datos_empresa_general['subdominio']);
		$carpetaFuentes=str_replace("http://", "", $carpetaFuentes);
		$carpetaFuentes=explode(".", $carpetaFuentes);
		$carpetaFuentes=$carpetaFuentes[0];
		
		$sale_query = new SaleDAO();
		$sale_query->regist_sale_file($numComp, $archivopdf,$datos_empresa_general);
		$content = $pdf->Output(getenv('ubicacion_pdfs').$carpetaFuentes.'/uploads/pdf/'.$archivopdf, 'F');
		//$content = $pdf->Output($carpetaFuentes.'/uploads/pdf/'.$archivopdf, 'F');
		unlink($nombqr1);
	}

	public function conexionBDgeneral($ruc)
	{

		$postData['ruc'] = $ruc;

		$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
			)
		));

		$url = getenv('WSurl_general');
		$urlDoc = "v1/Empresa/datos";
		$response = file_get_contents($url . $urlDoc, false, $context);
		$res = json_decode($response, true);

		$datosEmp['ruc'] = $res['ruc'];
		$datosEmp['razon_social'] = $res['razon_social'];
		$datosEmp['usuario_sol'] = $res['usuario_sol'];
		$datosEmp['usuario_secundario'] = $res['usuario_secundario'];
		$datosEmp['clave_secundario'] = $res['clave_secundario'];
		$datosEmp['password_firma'] = $res['password_firma'];
		$datosEmp['host_BD'] = $res['host_BD'];

		$datosEmp['BD_sistema'] = $res['BD_sistema'];
		$datosEmp['usuario_BD'] = $res['usuario_BD'];
		$datosEmp['password_BD'] = $res['password_BD'];
		$datosEmp['subdominio'] =$res['subdominio'];


		return $datosEmp;
	}
	
	public function masivo_register_ventas(Request $request, Response $response, array $args): Response
	{
		$data_recibida = $request->getParsedBody();
		
		$datos_empresa_general = $this->conexionBDgeneral($data_recibida['empresa']['ruc']);
		$url = getenv('WSurl_ventas');
		
		$settings_query = new SettingsDAO();
		$settings_tax = $settings_query->valid_tax($datos_empresa_general);
		foreach ($settings_tax as $tax_rate) {
				$tax_default=$tax_rate['default_tax_rate'];
		}
		
		$sensor_errores=0;
		
		$valid_header= $this->validacion_masivo_header($data_recibida['empresa'], $datos_empresa_general);
		
		for ($contador = 1; $contador < count($data_recibida['item']) + 1; $contador++) {
			$resp=$this->validacion_masivo_items($data_recibida['item'][$contador], $contador, $datos_empresa_general, $tax_default);
			if(!is_null ($resp)){
				$valid_items[]=$resp;
				$sensor_errores++;
			}
		}
		
		if(isset($valid_header)){
			$sensor_errores++;
			$respuestaFinal["mensaje"]=$valid_header;
		}
		
		if(isset($valid_items)){
			foreach($valid_items as $row_item){
				foreach($row_item as $r_item){
					$respuestaFinal["mensaje"][]=$r_item;
				}
			}
		}
		
		if($sensor_errores>0){
			$respuestaFinal["resultado"]="error";
		}else{
			
			$ventas_importar = new Pro_ventas_importarDAO();
			
			for ($contador = 1; $contador < count($data_recibida['item']) + 1; $contador++) {
				
				$id_items[$contador]=$ventas_importar->regist_ventas_importar(
				$data_recibida['item'][$contador],
				$data_recibida['empresa']['user'],
				$data_recibida['empresa']['ruc'], 
				$datos_empresa_general);
				
			}
			date_default_timezone_set('America/Lima');
			$datos_send_invoice['date'] = date("Y") . "-" . date("m") . "-" . date("d");
			$datos_send_invoice['hora'] = date("H") . ":" . date("i") . ":" . date("s");
				
			$sensor_inicio=1;
			$sensor_fin=1;
			$contadorWhile=1;
			$numero_venta=1;
			$contador_export_item=0;
			
			while($contadorWhile < count($data_recibida['item']) + 1){
				
				$afecto_itemsT=0;
				$igv_itemsT=0;
				$inafecto_itemsT=0;
				$exonerado_itemsT=0;
				$subtotal_item=0;
				
				$cant_item_total=0;
				
				$data_ventas[$numero_venta]['empresa']['ruc']=trim($data_recibida['empresa']['ruc']);
				$data_ventas[$numero_venta]['empresa']['user']=trim($data_recibida['empresa']['user']);
				$data_ventas[$numero_venta]['empresa']['local']=trim($data_recibida['empresa']['local']);
				$data_ventas[$numero_venta]['empresa']['canal']=trim($data_recibida['empresa']['canal']);
				$data_ventas[$numero_venta]['empresa']['warehouse']=trim($data_recibida['empresa']['warehouse']);
				
				$data_ventas[$numero_venta]['header']['date'] = $datos_send_invoice['date'] ." ". $datos_send_invoice['hora'];
				
				if(strlen(trim($data_recibida['item'][$contadorWhile]['expiracion']))>0){
					$formato_date_expiracion=explode("/",trim($data_recibida['item'][$contadorWhile]['expiracion']));
					$data_ventas[$numero_venta]['header']['expiration_date'] = 
					$formato_date_expiracion[2] ."-". $formato_date_expiracion[1] ."-". $formato_date_expiracion[0];
				}else{
					$data_ventas[$numero_venta]['header']['expiration_date'] = "";
				}
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['tipo_comprobante']))=="F"){
					$data_ventas[$numero_venta]['header']['document_type'] = "2";
				}
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['tipo_comprobante']))=="B"){
					$data_ventas[$numero_venta]['header']['document_type'] = "1";
				}
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['tipo_comprobante']))=="N"){
					$data_ventas[$numero_venta]['header']['document_type'] = "3";
				}
				
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['tipo_doc']))=="DNI"){
					$data_ventas[$numero_venta]['header']['type_document_customer'] = "1";
				}
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['tipo_doc']))=="CE"){
					$data_ventas[$numero_venta]['header']['type_document_customer'] = "4";
				}
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['tipo_doc']))=="PAS"){
					$data_ventas[$numero_venta]['header']['type_document_customer'] = "7";
				}
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['tipo_doc']))=="RUC"){
					$data_ventas[$numero_venta]['header']['type_document_customer'] = "6";
				}
				
				$data_ventas[$numero_venta]['header']['identification_customer'] = trim($data_recibida['item'][$contadorWhile]['num_doc']);
				$data_ventas[$numero_venta]['header']['name_customer'] = trim($data_recibida['item'][$contadorWhile]['nom_cliente']);
				$data_ventas[$numero_venta]['header']['address_customer'] = trim($data_recibida['item'][$contadorWhile]['direccion']);
				$data_ventas[$numero_venta]['header']['currency'] = strtoupper(trim($data_recibida['item'][$contadorWhile]['moneda']));
				
				$cantidadItems=trim($data_recibida['item'][$contadorWhile]['cantidad_item']);
				
				$contador_export_item=1;
				$contador = $sensor_inicio;
				while($contador < $sensor_inicio + $cantidadItems){
				//for ($contador = $sensor_inicio; $contador <= $cantidadItems; $contador++) {
					
					$data_ventas[$numero_venta]['item'][$contador_export_item]['code'] = trim($data_recibida['item'][$contador]['cod_producto']);
					$data_ventas[$numero_venta]['item'][$contador_export_item]['name'] = trim($data_recibida['item'][$contador]['nom_producto']);
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Quantity'] = trim($data_recibida['item'][$contador]['cantidad']);
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Unit_price'] = (String)(
					trim($data_recibida['item'][$contador]['afecto'])+
					trim($data_recibida['item'][$contador]['igv'])+
					trim($data_recibida['item'][$contador]['inafecto'])+
					trim($data_recibida['item'][$contador]['exonerado']));
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Affect_price'] = trim($data_recibida['item'][$contador]['afecto']);
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Non_affected_price'] = trim($data_recibida['item'][$contador]['inafecto']);
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Exonerated_price'] = trim($data_recibida['item'][$contador]['exonerado']);
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Tax'] = trim($data_recibida['item'][$contador]['igv']);
					
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Igv'] =$tax_default;
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Tax_ICBPER'] ="0";
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Quantity_ICBPER'] ="0";
					
					$afecto_items=(trim($data_recibida['item'][$contador]['afecto']))*(trim($data_recibida['item'][$contador]['cantidad']));
					$igv_items=(trim($data_recibida['item'][$contador]['igv']))*(trim($data_recibida['item'][$contador]['cantidad']));
					$inafecto_items=(trim($data_recibida['item'][$contador]['inafecto']))*(trim($data_recibida['item'][$contador]['cantidad']));
					$exonerado_items=(trim($data_recibida['item'][$contador]['exonerado']))*(trim($data_recibida['item'][$contador]['cantidad']));
					
					/*$data_ventas[$numero_venta]['item'][$contador_export_item]['Subtotal'] =(String)(
					$afecto_items + $igv_items+ $inafecto_items+$exonerado_items);*/
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Subtotal'] =trim($data_recibida['item'][$contador]['total']);
					
					$total_unit_item=$data_recibida['item'][$contador]['total'];
					$exo_unit_item=$data_recibida['item'][$contador]['exonerado'];
					$ina_unit_item=$data_recibida['item'][$contador]['inafecto'];
					$cant_unit_item=$data_recibida['item'][$contador]['cantidad'];
					
					//$afecto_itemsT=$afecto_itemsT +(trim($data_recibida['item'][$contador]['afecto']))*(trim($data_recibida['item'][$contador]['cantidad']));
					$calculo_afecto_items=(($total_unit_item-(($exo_unit_item+$ina_unit_item)*$cant_unit_item))/(1+($tax_default/100)));
					
					$afecto_itemsT=$afecto_itemsT + $calculo_afecto_items;
					
					//$igv_itemsT=$igv_itemsT +(trim($data_recibida['item'][$contador]['igv']))*(trim($data_recibida['item'][$contador]['cantidad']));
					$igv_itemsT=$igv_itemsT +($total_unit_item-
					($calculo_afecto_items+
					(($data_recibida['item'][$contador]['exonerado']+$data_recibida['item'][$contador]['inafecto'])*$cant_unit_item)));
					
					$data_ventas[$numero_venta]['item'][$contador_export_item]['Item_tax'] = (String)(round(($total_unit_item-($calculo_afecto_items+(($data_recibida['item'][$contador]['exonerado']+$data_recibida['item'][$contador]['inafecto'])*$cant_unit_item))),2));
					
					$inafecto_itemsT=$inafecto_itemsT +(trim($data_recibida['item'][$contador]['inafecto']))*(trim($data_recibida['item'][$contador]['cantidad']));
					$exonerado_itemsT=$exonerado_itemsT +(trim($data_recibida['item'][$contador]['exonerado']))*(trim($data_recibida['item'][$contador]['cantidad']));
					
					if(trim($data_recibida['item'][$contador]['afecto'])>0){
						$data_ventas[$numero_venta]['item'][$contador_export_item]['Type_tax'] ="IGV";
					}else{
						if(trim($data_recibida['item'][$contador]['inafecto'])>0){
							$data_ventas[$numero_venta]['item'][$contador_export_item]['Type_tax'] ="INA";
						}else{
							$data_ventas[$numero_venta]['item'][$contador_export_item]['Type_tax'] ="EXO";
						}
					}
					$subtotal_item=$subtotal_item+$data_recibida['item'][$contador]['total'];
					$cant_item_total=$cant_item_total+trim($data_recibida['item'][$contador]['cantidad']);
					$contador++;
					$sensor_fin=$contador;
					$contador_export_item++;
					
				//}
				}
				$sensor_inicio=$sensor_fin;
				
				$data_ventas[$numero_venta]['header']['affected'] = (String)round($afecto_itemsT,2);
				$data_ventas[$numero_venta]['header']['non_affected'] = (String)($inafecto_itemsT);
				$data_ventas[$numero_venta]['header']['exonerated'] = (String)($exonerado_itemsT);
				$data_ventas[$numero_venta]['header']['total'] = (String)round(($afecto_itemsT+$inafecto_itemsT+$exonerado_itemsT),2);
				$data_ventas[$numero_venta]['header']['product_tax'] = (String)round($igv_itemsT,2);
				$data_ventas[$numero_venta]['header']['tax_ICBPER'] = "0";
				$data_ventas[$numero_venta]['header']['mult_ICBPER'] = "0";
				$data_ventas[$numero_venta]['header']['subtotal'] = (String)($subtotal_item);
				$data_ventas[$numero_venta]['header']['total_items'] = trim($data_recibida['item'][$contadorWhile]['cantidad_item']);
				$data_ventas[$numero_venta]['header']['total_quantity'] = $cant_item_total;
				
				if(strtoupper(trim($data_recibida['item'][$contadorWhile]['estado']))=="P"){
					$data_ventas[$numero_venta]['header']['paid'] = (String)($subtotal_item);
					if(strtoupper(trim($data_recibida['item'][$contadorWhile]['metodo_pago']))=="EF"){
						$data_ventas[$numero_venta]['header']['method_paid'] = "cash";
					}
					if(strtoupper(trim($data_recibida['item'][$contadorWhile]['metodo_pago']))=="TC"){
						$data_ventas[$numero_venta]['header']['method_paid'] = "CC";
					}
					if(strtoupper(trim($data_recibida['item'][$contadorWhile]['metodo_pago']))=="TD"){
						$data_ventas[$numero_venta]['header']['method_paid'] = "Cheque";
					}
					if(strtoupper(trim($data_recibida['item'][$contadorWhile]['metodo_pago']))=="CH"){
						$data_ventas[$numero_venta]['header']['method_paid'] = "stripe";
					}
					if(strtoupper(trim($data_recibida['item'][$contadorWhile]['metodo_pago']))==""){
						$data_ventas[$numero_venta]['header']['method_paid'] = "";
					}
				}else{
					$data_ventas[$numero_venta]['header']['paid'] = "0";
					$data_ventas[$numero_venta]['header']['method_paid'] = "";
				}
				if(strlen(trim($data_recibida['item'][$contadorWhile]['nota']))>0){
					$data_ventas[$numero_venta]['header']['note'] =  trim($data_recibida['item'][$contadorWhile]['nota']);
				}else{
					$data_ventas[$numero_venta]['header']['note'] =  "";
				}
				$contadorWhile=$sensor_inicio;
				
				$numero_venta++;
			}
			
			$numero_items_venta=0;
			$contador_procesadas=0;
			$no_contador_procesadas=0;
			$solo_contador_registradas=0;
			$a_procesar=0;
			for($cant_ventas_enviar=1; $cant_ventas_enviar<=count($data_ventas); $cant_ventas_enviar++){
				$respuestaSend = $this->consumir_servicio_local($data_ventas[$cant_ventas_enviar], $url, "registrar_venta");
				$respuestaInvoice[$cant_ventas_enviar]=$respuestaSend['mensaje'];
				
				$cantidad_items_x_venta=count($data_ventas[$cant_ventas_enviar]['item']);
				
				if($data_ventas[$cant_ventas_enviar]['header']['document_type'] == "2"){$a_procesar++;}
				
				if($respuestaSend["resultado"]=="ok"){
					
					if(stristr($respuestaInvoice[$cant_ventas_enviar],'F')!=false){
						$contador_procesadas++;
					}else{
						$solo_contador_registradas++;
					}
					
					for($contador_reg_venta=$numero_items_venta; $contador_reg_venta<($numero_items_venta +$cantidad_items_x_venta); $contador_reg_venta++ ){
						$ventas_importar->update_ventas_importar(
						$id_items[$contador_reg_venta+1], 
						trim($data_recibida['empresa']['user']),
						$datos_empresa_general
						);
					}
					
				}else{
					$no_contador_procesadas++;
				}
				$numero_items_venta=$numero_items_venta + $cantidad_items_x_venta;
			}
			
		$respuestaFinal["resultado"] ="ok";
		//$respuestaFinal["mensaje"]["comprobante"] =$respuestaInvoice;
		$respuestaFinal["mensaje"][] =($solo_contador_registradas + $contador_procesadas)."/".count($data_ventas)." comprobantes registrados ";
		$respuestaFinal["mensaje"][] =$contador_procesadas."/".$a_procesar." facturas procesadas en sunat";
		//$respuestaFinal["mensaje"][] ="comprobantes no procesados: ".$no_contador_procesadas;
		}
		$resp_json = $response->withJson($respuestaFinal);
		return $resp_json;
		
	}
	
	public function validacion_masivo_items($datos_excel, $num_item, $datos_empresa_general, $igv_default){
		
		
		$sensor_valid_montos=0;
		if(strlen(trim($datos_excel['expiracion']))>0){
			$valores = explode('/', trim($datos_excel['expiracion']));
			if(count($valores) == 3){
				if($valores[1]!='' && $valores[0]!='' && $valores[2]!=''){
					if(is_numeric($valores[1]) && is_numeric($valores[0]) && is_numeric($valores[2])){
						if(checkdate($valores[1], $valores[0], $valores[2])){
							if(date("Y")==$valores[2] || $valores[2]==date("Y")+1){
								//$respuesta= 1;
							}else{
								$respuesta[]='Error registro '.$num_item.': error con fecha de expiracion';
							}
							
							if(date("m")==$valores[1] || $valores[1]==date("m")+1){
								//$respuesta= 1;
							}else{
								$respuesta[]='Error registro '.$num_item.': error con fecha de expiracion';
							}
						}else{
							$respuesta[]='Error registro '.$num_item.': error con fecha de expiracion';
						}
					}else{
						$respuesta[]='Error registro '.$num_item.': error con fecha de expiracion';
					}
				}else{
					$respuesta[]='Error registro '.$num_item.': error con fecha de expiracion';
				}
			}else{
				$respuesta[]='Error registro '.$num_item.': error con fecha de expiracion';
			}
		}
		
		
		if(strtoupper(trim($datos_excel['tipo_comprobante']))=="B" || strtoupper(trim($datos_excel['tipo_comprobante']))=="F" 
		|| strtoupper(trim($datos_excel['tipo_comprobante']))=="N"){
			if(strtoupper(trim($datos_excel['tipo_comprobante']))=="F"){
				if(strtoupper(trim($datos_excel['tipo_doc']))=="RUC"){}else{
					$respuesta[]='Error registro '.$num_item.': para generar una factura el documento del cliente debe ser ruc';
				}
			}else{}
		}else{
			$respuesta[]='Error registro '.$num_item.': error con el tipo de comprobante';
		}
		
		if(is_numeric(trim($datos_excel['cantidad_item']))){
			if(trim($datos_excel['cantidad_item'])>0){
				
				if(stristr(trim($datos_excel['cantidad_item']), ',')=== FALSE &&
				stristr(trim($datos_excel['cantidad_item']), '.')=== FALSE){}else{
					$respuesta[]='Error registro '.$num_item.': error con la cantidad de items';
				}
			}else{
				$respuesta[]='Error registro '.$num_item.': error con la cantidad de items';
			}
		}else{
			$respuesta[]='Error registro '.$num_item.': error con la cantidad de items';
		}
		
		if(strtoupper(trim($datos_excel['tipo_doc']))=="DNI" || strtoupper(trim($datos_excel['tipo_doc']))=="CE" 
		|| strtoupper(trim($datos_excel['tipo_doc']))=="PAS" || strtoupper(trim($datos_excel['tipo_doc']))=="RUC" ){
			
			if(strtoupper(trim($datos_excel['tipo_doc']))=="DNI"){
				if(is_numeric(trim($datos_excel['num_doc'])) && strlen(trim($datos_excel['num_doc']))==8 ){
					if(stristr(trim($datos_excel['num_doc']), ',')=== FALSE &&
					stristr(trim($datos_excel['num_doc']), '.')=== FALSE){}else{
						$respuesta[]='Error registro '.$num_item.': error con el formato del documento (DNI)';
					}
				}else{
					$respuesta[]='Error registro '.$num_item.': error con el formato del documento (DNI)';
				}
			}
			
			if(strtoupper(trim($datos_excel['tipo_doc']))=="RUC"){
				if(is_numeric(trim($datos_excel['num_doc'])) && strlen(trim($datos_excel['num_doc']))==11 ){
					if(stristr(trim($datos_excel['num_doc']), ',')=== FALSE &&
					stristr(trim($datos_excel['num_doc']), '.')=== FALSE){}else{
						$respuesta[]='Error registro '.$num_item.': error con el formato del documento (RUC)';
					}
				}else{
					$respuesta[]='Error registro '.$num_item.': error con el formato del documento (RUC)';
				}
			}
			
			/*if(strtoupper(trim($datos_excel['tipo_doc']))=="PAS" || strtoupper(trim($datos_excel['tipo_doc']))=="CE"){
				if(is_numeric(trim($datos_excel['num_doc'])) && strlen(trim($datos_excel['num_doc']))==12 ){
					if(stristr(trim($datos_excel['num_doc']), ',')=== FALSE &&
					stristr(trim($datos_excel['num_doc']), '.')=== FALSE){}else{
						$respuesta[]='Error registro '.$num_item.': error con el formato del documento (pasaporte o carnet de extrajeria)';
					}
				}else{
					$respuesta[]='Error registro '.$num_item.': error con el formato del documento (pasaporte o carnet de extrajeria)';
				}
			}*/
			
		}else{
			$respuesta[]='Error registro '.$num_item.': error con el tipo de documento';
		}
		
		$customer_query = new CustomerDAO();
		$datos_customer = $customer_query->valid_Customer($datos_excel['num_doc'], trim($datos_empresa_general['ruc']), $datos_empresa_general);
		$existe_customer = count($datos_customer);
		
		if($existe_customer > 0){
			
			foreach ($datos_customer as $data) {
				//$setId=$data['id'];
				$setName=$data['name'];
				$setCf1=$data['cf1'];
				$setCf2=$data['cf2'];
				$setDireccion=$data['direccion'];
				//$setDocument_type_id=$data['document_type_id'];
			}
			
			/*if($setCf1==trim($datos_excel['num_doc']) || $setCf2==trim($datos_excel['num_doc'])){}else{
				$respuesta['num_doc']='error con el numero de documento';
			}*/
			
			/*if($setName==trim($datos_excel['nom_cliente'])){}else{
				$respuesta[]='Error registro '.$num_item.': error con el nombre del cliente';
			}
			
			if($setDireccion==trim($datos_excel['direccion'])){}else{
				$respuesta[]='Error registro '.$num_item.': error con la direccion del cliente';
			}*/
			
		}else{
			if(strlen(trim($datos_excel['nom_cliente']))>0){}else{
				$respuesta[]='Error registro '.$num_item.': error con el nombre del cliente';
			}
			
			if(strlen(trim($datos_excel['direccion']))>0){}else{
				$respuesta[]='Error registro '.$num_item.': error con la direccion del cliente';
			}
		}
		
		if(strtoupper(trim($datos_excel['moneda']))=="PEN" || 
		strtoupper(trim($datos_excel['moneda']))=="USD"){}else{
			$respuesta[]='Error registro '.$num_item.': error con el tipo de moneda';
		}
		
		if(strtoupper(trim($datos_excel['estado']))=="P" || 
		strtoupper(trim($datos_excel['estado']))=="D"){}else{
			$respuesta[]='Error registro '.$num_item.': error con el estado del comprobante';
		}
		
		if(strtoupper(trim($datos_excel['metodo_pago']))=="EF" || 
		strtoupper(trim($datos_excel['metodo_pago']))=="TC" ||
		strtoupper(trim($datos_excel['metodo_pago']))=="TD" ||
		strtoupper(trim($datos_excel['metodo_pago']))=="CH" ||
		strtoupper(trim($datos_excel['metodo_pago']))==""){}else{
			$respuesta[]='Error registro '.$num_item.': error con el metodo de pago del comprobante';
		}
		
		/*if(strlen(trim($datos_excel['nota']))>0){}else{
			$respuesta[]='Error registro '.$num_item.': error con la nota';
		}*/
		
		$result_product = $this->consult_product($datos_empresa_general['ruc'], trim($datos_excel['cod_producto']), $datos_excel['nom_producto']);
		
		if($result_product['name']!=null){
			if($datos_excel['nom_producto']!=$result_product['name']){
				//$respuesta[]='Error registro '.$num_item.': error con el nombre del producto';
				$datos_excel['nom_producto']=$result_product['name'];
			}
		}else{
			/*if(strlen(trim($datos_excel['cod_producto']))>0){}else{
				$respuesta['cod_producto']='error con el codigo del producto';
			}*/
			
			if(strlen(trim($datos_excel['nom_producto']))>0){}else{
				$respuesta[]='Error registro '.$num_item.': error con el nombre del producto';
			}
		}
		
		if(is_numeric(trim($datos_excel['cantidad']))){
			if(trim($datos_excel['cantidad'])>0){
				/*if(stristr(trim($datos_excel['cantidad']), ',')=== FALSE &&
				   stristr(trim($datos_excel['cantidad']), '.')=== FALSE){*/
					   $sensor_valid_montos++;
				   /*}else{
						$respuesta[]='Error registro '.$num_item.': error con la cantidad de productos';
				}*/
			}else{
				$respuesta[]='Error registro '.$num_item.': error con la cantidad de productos';
			}
		}else{
			$respuesta[]='Error registro '.$num_item.': error con la cantidad de productos';
		}
		
		if(is_numeric(trim($datos_excel['afecto']))){
			$afecto_valid=round((($datos_excel['total']/$datos_excel['cantidad'])- $datos_excel['inafecto'] -$datos_excel['exonerado'])/(1+($igv_default/100)),2);
			if(trim($datos_excel['afecto']) == $afecto_valid){
				$sensor_valid_montos++;
			}else{
				$respuesta[]='Error registro '.$num_item.': error con el monto afecto';
			}
		}else{
			$respuesta[]='Error registro '.$num_item.': error con el monto afecto';
		}
		
		if(is_numeric(trim($datos_excel['igv']))){
			$afecto_valid=(($datos_excel['total']/$datos_excel['cantidad'])- $datos_excel['inafecto'] -$datos_excel['exonerado'])/(1+($igv_default/100));
			$igv_calcul=round((($datos_excel['total']/$datos_excel['cantidad'])-$afecto_valid- $datos_excel['inafecto'] -$datos_excel['exonerado']),2);
			
			if(is_numeric(trim($datos_excel['afecto']))){
				if(floatval(trim($datos_excel['igv']))== $igv_calcul){
					/*if(($igv_calcul-0.02)< floatval(trim($datos_excel['igv']))){*/
						$sensor_valid_montos++;
					/*}else{
						$respuesta[]='Error registro '.$num_item.': error con el monto igv';
					}*/
				}else{
					$respuesta[]='Error registro '.$num_item.': error con el monto igv';
				}
			}
		}else{
			$respuesta[]='Error registro '.$num_item.': error con el monto igv';
		}
		
		if(is_numeric(trim($datos_excel['inafecto']))){
			$sensor_valid_montos++;
		}else{
			$respuesta[]='Error registro '.$num_item.': error con el monto inafecto';
		}
		
		if(is_numeric(trim($datos_excel['exonerado']))){
			$sensor_valid_montos++;
		}else{
			$respuesta[]='Error registro '.$num_item.': error con el monto exonerado';
		}
		
		if(is_numeric(trim($datos_excel['total']))){
			if($sensor_valid_montos==5){
				
				$valid_total_items=trim(((trim($datos_excel['afecto'])+trim($datos_excel['igv'])+trim($datos_excel['inafecto'])+trim($datos_excel['exonerado']))*trim($datos_excel['cantidad'])));
				
				if(trim($datos_excel['total'])>0 && trim($datos_excel['total'])==$valid_total_items ){}else{
					$respuesta[]='Error registro '.$num_item.': error con el monto total';
				}
			}else{
				$respuesta[]='Error registro '.$num_item.': error con el monto total';
			}
		}else{
			$respuesta[]='Error registro '.$num_item.': error con el monto total';
		}
		
		
		if(isset($respuesta)){
			return $respuesta;
		}
	}
	
	public function consult_product($ruc, $code_product, $nameProduct){
		
		$postData['ruc'] = $ruc;
		$postData['codeP'] = $code_product;
		$postData['nameP'] = $nameProduct;

		$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
			)
		));

		$url = getenv('WSurl_almacen');
		$urlDoc = "v1/consultar_product";
		$response = file_get_contents($url . $urlDoc, false, $context);
		$res = json_decode($response, true);

		$datosProduct['id'] = $res['id'];
		$datosProduct['code'] = $res['code'];
		$datosProduct['name'] = $res['name'];

		return $datosProduct;
		
	}
	
	public function validacion_masivo_header($datos_excel, $datos_empresa_general){
		
		if(is_numeric($datos_excel['user'])){
			$user_query = new UserDAO();
			$datos_user = $user_query->valid_user($datos_excel['user'], $datos_empresa_general);
			$existe_user = count($datos_user);
			
			if($existe_user > 0){
				foreach ($datos_user as $data) {
					$setIdUser=$data['id'];
				}
			}
			if(isset($setIdUser)){}else{
				$respuesta[]='Error datos generales: error con los datos del usuario';
			}
		}else{
			$respuesta[]='Error datos generales: error con los datos del usuario';
		}
		
		if(is_numeric($datos_excel['local'])){
			$local_query = new LocalDAO();
			$datos_local = $local_query->valid_local($datos_excel['local'], $datos_empresa_general);
			$existe_local = count($datos_local);
			
			if($existe_local > 0){
				foreach ($datos_local as $data) {
					$setIdLocal=$data['id'];
				}
			}
			if(isset($setIdLocal)){}else{
				$respuesta[]='Error datos generales: error con los datos del local';
			}
		}else{
			$respuesta[]='Error datos generales: error con los datos del local';
		}
		
		if(is_numeric($datos_excel['canal'])){
			$canal_query = new CanalDAO();
			$datos_canal = $canal_query->valid_canal($datos_excel['canal'], $datos_empresa_general);
			$existe_canal = count($datos_canal);
			
			if($existe_canal > 0){
				foreach ($datos_canal as $data) {
					$setIdCanal=$data['id'];
				}
			}
			
			if(isset($setIdCanal)){}else{
				$respuesta[]='Error datos generales: error con los datos del canal';
			}
		}else{
			$respuesta[]='Error datos generales: error con los datos del canal';
		}
		
		if(is_numeric($datos_excel['warehouse'])){
			$Warehouse_query = new WarehouseDAO();
			$datos_Warehouse = $Warehouse_query->valid_warehouse($datos_excel['warehouse'], $datos_empresa_general);
			$existe_Warehouse = count($datos_Warehouse);
			
			if($existe_Warehouse > 0){
				foreach ($datos_Warehouse as $data) {
					$setIdWarehouse=$data['id'];
				}
			}
			
			if(isset($setIdWarehouse)){}else{
				$respuesta[]='Error datos generales: error con los datos del warehouse';
			}
		}else{
			$respuesta[]='Error datos generales: error con los datos del warehouse';
		}
		
		if(isset($respuesta)){
			return $respuesta;
		}
		
	}
	
	public function consumir_servicio_local($postData, $urlRaiz, $urlDoc){
		
		$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
			)
		));
		/*$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => $postData
			)
		));*/

		
		//$urlDoc = "registrar_venta";
		$response = file_get_contents($urlRaiz . $urlDoc, false, $context);
		$res = json_decode($response, true);

		return $res;
		
	}
	
	
}
