<?php
class Apisunat
{
    public function crear_xml_factura($cabecera, $detalle, $ruta)
    {
        $validacion = new validaciondedatos();
        $doc = new DOMDocument();
        $doc->formatOutput = FALSE;
        $doc->preserveWhiteSpace = TRUE;
        //$doc->encoding = 'ISO-8859-1';
        $doc->encoding = 'utf-8';

        if ($cabecera['DETRACTION_FLAG'] == 1) {
            
            $detraction = 

            '<cac:PaymentMeans> 
                <cbc:ID>Detracción</cbc:ID>
                    <cbc:PaymentMeansCode listName="Medio de pago" listAgencyName="PE:SUNAT" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo59">'. $cabecera["PAYMENT_METHOD"] .'</cbc:PaymentMeansCode>
                        <cac:PayeeFinancialAccount>
                    <cbc:ID>'. $cabecera["BANK_ACCOUNT_NUMBER"] .'</cbc:ID>
                </cac:PayeeFinancialAccount>
            </cac:PaymentMeans>
            <cac:PaymentTerms>
                <cbc:ID>Detracción</cbc:ID>
                    <cbc:PaymentMeansID schemeName="Codigo de detraccion" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo54">'. $cabecera["DETRACTION_TYPE"] .'</cbc:PaymentMeansID>
                    <cbc:PaymentPercent>'. $cabecera["PERCENTAGE_OF_DETRACTION"] .'</cbc:PaymentPercent>
                <cbc:Amount currencyID="PEN">'. $cabecera["TOTAL_OF_DETRACTION"] .'</cbc:Amount>
            </cac:PaymentTerms>';

            if ($cabecera['TYPE_OF_OPERATION'] == 1002) {

                $detraction_hydrobiological_resources =
                
                '<cac:AdditionalItemProperty>
                    <cbc:Name>Detracciones: Recursos Hidrobiológicos-Matrícula de la embarcación</cbc:Name>
                    <cbc:NameCode listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo55" listAgencyName="PE:SUNAT" listName="Propiedad del item">3001</cbc:NameCode>
                    <cbc:Value>'. $cabecera["MATRICULA_EMBARCACION"] .'</cbc:Value>
                </cac:AdditionalItemProperty>

                <cac:AdditionalItemProperty>
                    <cbc:Name>Detracciones: Recursos Hidrobiológicos-Nombre de la embarcación</cbc:Name>
                    <cbc:NameCode listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo55" listAgencyName="PE:SUNAT" listName="Propiedad del item">3002</cbc:NameCode>
                    <cbc:Value>'. $cabecera["NOMBRE_EMBARCACION"] .'</cbc:Value>
                </cac:AdditionalItemProperty>

                <cac:AdditionalItemProperty>
                    <cbc:Name>Detracciones: Recursos Hidrobiológicos-Tipo de especie vendida</cbc:Name>
                    <cbc:NameCode listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo55" listAgencyName="PE:SUNAT" listName="Propiedad del item">3003</cbc:NameCode>
                    <cbc:Value>'. $cabecera["DESCRIPCION_TIPO_ESPECIE_VENDIDA"] .'</cbc:Value>
                </cac:AdditionalItemProperty>

                <cac:AdditionalItemProperty>
                    <cbc:Name>Detracciones: Recursos Hidrobiológicos-Lugar de descarga</cbc:Name>
                    <cbc:NameCode listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo55" listAgencyName="PE:SUNAT" listName="Propiedad del item">3004</cbc:NameCode>
                    <cbc:Value>'. $cabecera["LUGAR_DESCARGA"] .'</cbc:Value>
                </cac:AdditionalItemProperty>

                <cac:AdditionalItemProperty>
                    <cbc:Name>Detracciones: Recursos Hidrobiológicos-Cantidad de especie vendida</cbc:Name>
                    <cbc:NameCode listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo55" listAgencyName="PE:SUNAT" listName="Propiedad del item">3006</cbc:NameCode>
                    <cbc:ValueQuantity>'. $cabecera["CANTIDAD_ESPECIE_VENDIDA"] .'</cbc:ValueQuantity>
                </cac:AdditionalItemProperty>
                
                <cac:AdditionalItemProperty>
                    <cbc:Name>Detracciones: Recursos Hidrobiológicos-Fecha de descarga</cbc:Name>
                    <cbc:NameCode listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo55" listAgencyName="PE:SUNAT" listName="Propiedad del item">3005</cbc:NameCode>
                    <cac:UsabilityPeriod>
                    <cbc:StartDate>'. $cabecera["FECHA_DESCARGA"] .'</cbc:StartDate>
                    </cac:UsabilityPeriod>
                </cac:AdditionalItemProperty>';
                
            }else {
                $detraction_hydrobiological_resources ='';
            }

            if ($cabecera['TYPE_OF_OPERATION'] == 1004) { 

                $detraction_detail_transport_services = 
                
                '<cac:Delivery>
                    <cac:Despatch>
                        <cbc:Instructions>'. $cabecera["DETALLES_VIAJE"] .'</cbc:Instructions>
                        <cac:DespatchAddress>
                            <cbc:ID schemeAgencyName="PE:INEI" schemeName="Ubigeos">'. $cabecera["UBIGEO_ORIGEN"] .'</cbc:ID>
                            <cac:AddressLine>
                                <cbc:Line>'. $cabecera["DIRECCION_ORIGEN"] .'</cbc:Line>
                            </cac:AddressLine>
                        </cac:DespatchAddress>
                    </cac:Despatch>
                </cac:Delivery>
                <cac:Delivery>
                    <cac:DeliveryTerms>
                        <cbc:ID>01</cbc:ID>
                        <cbc:Amount currencyID="PEN">'. $cabecera["VALOR_REFERENCIAL_SERVICIO_TRANSPORTE"] .'</cbc:Amount>
                    </cac:DeliveryTerms>
                </cac:Delivery>
                <cac:Delivery>
                    <cac:DeliveryTerms>
                        <cbc:ID>02</cbc:ID>
                        <cbc:Amount currencyID="PEN">'. $cabecera["VALOR_REFERENCIAL_CARGA_EFECTIVA"] .'</cbc:Amount>
                    </cac:DeliveryTerms>
                </cac:Delivery>
                <cac:Delivery>
                    <cac:DeliveryTerms>
                        <cbc:ID>03</cbc:ID>
                        <cbc:Amount currencyID="PEN">'. $cabecera["VALOR_REFERENCIAL_CARGA_UTIL"] .'</cbc:Amount>
                    </cac:DeliveryTerms>
                </cac:Delivery>
                <cac:Delivery>
                    <cac:DeliveryLocation>
                        <cac:Address>
                            <cbc:ID schemeAgencyName="PE:INEI" schemeName="Ubigeos">'. $cabecera["UBIGEO_DESTINO"] .'</cbc:ID>
                            <cac:AddressLine>
                                <cbc:Line>'. $cabecera["DIRECCION_DESTINO"] .'</cbc:Line>
                            </cac:AddressLine>
                        </cac:Address>
                    </cac:DeliveryLocation>
                </cac:Delivery>';

            }else {
                $detraction_detail_transport_services = '';
            }
            
        }

            




        if ($cabecera['TOTAL_GRAVADAS'] > 0) {
            $AFECTAS = '
            <cac:TaxSubtotal>
			    <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_GRAVADAS"] . '</cbc:TaxableAmount>
                <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_IGV"] . '</cbc:TaxAmount>
                <cac:TaxCategory>
                    <cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">S</cbc:ID>
                    <cac:TaxScheme>
                        <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">1000</cbc:ID>
                        <cbc:Name>IGV</cbc:Name>
                        <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                    </cac:TaxScheme>
                </cac:TaxCategory>
            </cac:TaxSubtotal>';
        } else {
            $AFECTAS = "";
        }


        if ($cabecera["TOTAL_INAFECTA"] > 0) {
            $INAFECTAS = '
					<cac:TaxSubtotal>
                    <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_INAFECTA"] . '</cbc:TaxableAmount>
                    <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">0.00</cbc:TaxAmount>
                    <cac:TaxCategory>
                    <cbc:ID schemeID="UN/ECE 5153" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">O</cbc:ID>
                    <cac:TaxScheme>
                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">9998</cbc:ID>
                    <cbc:Name>INA</cbc:Name>
                    <cbc:TaxTypeCode>FRE</cbc:TaxTypeCode>
                    </cac:TaxScheme>
                    </cac:TaxCategory>
                    </cac:TaxSubtotal>
                    ';
        } else {
            $INAFECTAS = '';
        }

        if ($cabecera["TOTAL_EXONERADAS"] > 0) {
            $EXONERADO = '
						<cac:TaxSubtotal>
                        <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_EXONERADAS"] . '</cbc:TaxableAmount>
                        <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">0.00</cbc:TaxAmount>
                        <cac:TaxCategory>
                        <cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">E</cbc:ID>
                        <cac:TaxScheme>
                        <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">9997</cbc:ID>
                        <cbc:Name>EXO</cbc:Name>
                        <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                        </cac:TaxScheme>
                        </cac:TaxCategory>
                        </cac:TaxSubtotal>
                        ';
        } else {
            $EXONERADO = '';
        }
        if ($cabecera["TOTAL_GRATUITAS"] > 0) {
            $GRATUITAS = '
                <cac:TaxSubtotal>
                    <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_GRATUITAS"] . '</cbc:TaxableAmount>
                    <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_IGV_GRATUITAS"] . '</cbc:TaxAmount>
                    <cac:TaxCategory>
                        <cac:TaxScheme>
                            <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">9996</cbc:ID>
                            <cbc:Name>GRA</cbc:Name>
                            <cbc:TaxTypeCode>FRE</cbc:TaxTypeCode>
                        </cac:TaxScheme>
                    </cac:TaxCategory>
                </cac:TaxSubtotal>
                        ';
        } else {
            $GRATUITAS = '';
        }


        if($cabecera["FORMA_PAGO"] == "Contado"){
            $formaPago='     
    <cac:PaymentTerms>
        <cbc:ID>FormaPago</cbc:ID>
        <cbc:PaymentMeansID>'.$cabecera["FORMA_PAGO"].'</cbc:PaymentMeansID>
    </cac:PaymentTerms>';
        }else if($cabecera["FORMA_PAGO"] == "Credito"){
            $new_total_retainer = $cabecera["TOTAL"];
            if (isset($cabecera["RETAINER_TOTAL"]) && $cabecera["RETAINER_TOTAL"] > 0) {
                $new_total_retainer = $cabecera["TOTAL"] - $cabecera["RETAINER_TOTAL"];
            }
            $formaPago='
            <cac:PaymentTerms>
                <cbc:ID>FormaPago</cbc:ID>
                <cbc:PaymentMeansID>'.$cabecera["FORMA_PAGO"].'</cbc:PaymentMeansID>
                <cbc:Amount currencyID="' . $cabecera["COD_MONEDA"] . '">'.$new_total_retainer.'</cbc:Amount>
            </cac:PaymentTerms>';
                    if(isset($cabecera["FORMA_PAGO_CUOTAS"])){
                        for($i=0;$i<count($cabecera["FORMA_PAGO_CUOTAS"]);$i++){
                            $formaPago.='
            <cac:PaymentTerms>
                <cbc:ID>FormaPago</cbc:ID>
                <cbc:PaymentMeansID>'.$cabecera["FORMA_PAGO_CUOTAS"][$i]['name_cuota'].'</cbc:PaymentMeansID>
                <cbc:Amount currencyID="' . $cabecera["COD_MONEDA"] . '">'.$cabecera["FORMA_PAGO_CUOTAS"][$i]['total_cuota'].'</cbc:Amount>
                <cbc:PaymentDueDate>'.$cabecera["FORMA_PAGO_CUOTAS"][$i]['due_date'].'</cbc:PaymentDueDate>
            </cac:PaymentTerms>';
                }
            }
        }else{
            $formaPago='
                <cac:PaymentTerms>
                    <cbc:ID>FormaPago</cbc:ID>
                    <cbc:PaymentMeansID>Contado</cbc:PaymentMeansID>
                </cac:PaymentTerms>';
        }
        //*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
        $retainer = "";
        if (isset($cabecera["RETAINER_TOTAL"]) && $cabecera["RETAINER_TOTAL"] > 0) {
            $retainer = '<cac:AllowanceCharge>
                <cbc:ChargeIndicator>false</cbc:ChargeIndicator>
                <cbc:AllowanceChargeReasonCode>62</cbc:AllowanceChargeReasonCode>
                <cbc:MultiplierFactorNumeric>'.$cabecera["RETAINER_PERCENTAGE"].'</cbc:MultiplierFactorNumeric>
                <cbc:Amount currencyID="' . $cabecera["COD_MONEDA"] . '">'.$cabecera["RETAINER_TOTAL"].'</cbc:Amount>
                <cbc:BaseAmount currencyID="' . $cabecera["COD_MONEDA"] . '">'.$cabecera["TOTAL"].'</cbc:BaseAmount>
            </cac:AllowanceCharge>';
        }
        //*************************************END TRJ143 - DANIEL PADILLA- 23/12/2022 **************************


        $xmlCPE = '<?xml version="1.0" encoding="utf-8"?>
<Invoice xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2">
	<ext:UBLExtensions>
		<ext:UBLExtension>
			<ext:ExtensionContent>
			</ext:ExtensionContent>
		</ext:UBLExtension>
	</ext:UBLExtensions>
	<cbc:UBLVersionID>2.1</cbc:UBLVersionID>
	<cbc:CustomizationID schemeAgencyName="PE:SUNAT">2.0</cbc:CustomizationID>
	<cbc:ProfileID schemeName="Tipo de Operacion" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo51">' . $cabecera["TIPO_OPERACION"] . '</cbc:ProfileID>
	<cbc:ID>' . $cabecera["NRO_COMPROBANTE"] . '</cbc:ID>
	<cbc:IssueDate>' . $cabecera["FECHA_DOCUMENTO"] . '</cbc:IssueDate>
	<cbc:IssueTime>00:00:00</cbc:IssueTime>
	<cbc:DueDate>' . $cabecera["FECHA_VTO"] . '</cbc:DueDate>
	<cbc:InvoiceTypeCode listAgencyName="PE:SUNAT" listName="Tipo de Documento" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo01" listID="0101" name="Tipo de Operacion" listSchemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo51">' . $cabecera["COD_TIPO_DOCUMENTO"] . '</cbc:InvoiceTypeCode>';
        if ($cabecera["TOTAL_LETRAS"] <> "") {
            $xmlCPE = $xmlCPE .
                '<cbc:Note languageLocaleID="1000">' . $cabecera["TOTAL_LETRAS"] . '</cbc:Note>';
        }
        $xmlCPE = $xmlCPE .
            '<cbc:DocumentCurrencyCode listID="ISO 4217 Alpha" listName="Currency" listAgencyName="United Nations Economic Commission for Europe">' . $cabecera["COD_MONEDA"] . '</cbc:DocumentCurrencyCode>
            <cbc:LineCountNumeric>' . count($detalle) . '</cbc:LineCountNumeric>';
        if ($cabecera["NRO_OTR_COMPROBANTE"] <> "") {
            $xmlCPE = $xmlCPE .
                '<cac:OrderReference>
                    <cbc:ID>' . $cabecera["NRO_OTR_COMPROBANTE"] . '</cbc:ID>
            </cac:OrderReference>';
        }
        if ($cabecera["NRO_GUIA_REMISION"] <> "") {
            $xmlCPE = $xmlCPE .
                '<cac:DespatchDocumentReference>
		<cbc:ID>' . $cabecera["NRO_GUIA_REMISION"] . '</cbc:ID>
		<cbc:IssueDate>' . $cabecera["FECHA_GUIA_REMISION"] . '</cbc:IssueDate>
		<cbc:DocumentTypeCode listAgencyName="PE:SUNAT" listName="Tipo de Documento" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo01">' . $cabecera["COD_GUIA_REMISION"] . '</cbc:DocumentTypeCode>
            </cac:DespatchDocumentReference>';
        }
        $xmlCPE = $xmlCPE .
            '<cac:Signature>
		<cbc:ID>' . $cabecera["NRO_COMPROBANTE"] . '</cbc:ID>
		<cac:SignatoryParty>
			<cac:PartyIdentification>
				<cbc:ID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
			</cac:PartyIdentification>
			<cac:PartyName>
				<cbc:Name>' . $cabecera["RAZON_SOCIAL_EMPRESA"] . '</cbc:Name>
			</cac:PartyName>
		</cac:SignatoryParty>
		<cac:DigitalSignatureAttachment>
			<cac:ExternalReference>
				<cbc:URI>#' . $cabecera["NRO_COMPROBANTE"] . '</cbc:URI>
			</cac:ExternalReference>
		</cac:DigitalSignatureAttachment>
	</cac:Signature>
	<cac:AccountingSupplierParty>
		<cac:Party>
			<cac:PartyIdentification>
				<cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '" schemeName="Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
			</cac:PartyIdentification>
			<cac:PartyName>
				<cbc:Name><![CDATA[' . $cabecera["NOMBRE_COMERCIAL_EMPRESA"] . ']]></cbc:Name>
			</cac:PartyName>
			<cac:PartyTaxScheme>
				<cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_EMPRESA"] . ']]></cbc:RegistrationName>
				<cbc:CompanyID schemeID="' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:CompanyID>
				<cac:TaxScheme>
					<cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
				</cac:TaxScheme>
			</cac:PartyTaxScheme>
			<cac:PartyLegalEntity>
				<cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_EMPRESA"] . ']]></cbc:RegistrationName>
				<cac:RegistrationAddress>
					<cbc:ID schemeName="Ubigeos" schemeAgencyName="PE:INEI" />
					<cbc:AddressTypeCode listAgencyName="PE:SUNAT" listName="Establecimientos anexos">' . $cabecera["CODIGO_LOCAL"] . '</cbc:AddressTypeCode>
					<cbc:CityName><![CDATA[' . $cabecera["DEPARTAMENTO_EMPRESA"] . ']]></cbc:CityName>
					<cbc:CountrySubentity><![CDATA[' . $cabecera["PROVINCIA_EMPRESA"] . ']]></cbc:CountrySubentity>
					<cbc:District><![CDATA[' . $cabecera["DISTRITO_EMPRESA"] . ']]></cbc:District>
					<cac:AddressLine>
						<cbc:Line><![CDATA[' . $cabecera["DIRECCION_EMPRESA"] . ']]></cbc:Line>
					</cac:AddressLine>
					<cac:Country>
						<cbc:IdentificationCode listID="ISO 3166-1" listAgencyName="United Nations Economic Commission for Europe" listName="Country">' . $cabecera["CODIGO_PAIS_EMPRESA"] . '</cbc:IdentificationCode>
					</cac:Country>
				</cac:RegistrationAddress>
			</cac:PartyLegalEntity>
			<cac:Contact>
				<cbc:Name><![CDATA[' . $cabecera["CONTACTO_EMPRESA"] . ']]></cbc:Name>
			</cac:Contact>
		</cac:Party>
	</cac:AccountingSupplierParty>
	<cac:AccountingCustomerParty>
		<cac:Party>
			<cac:PartyIdentification>
				<cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_CLIENTE"] . '" schemeName="Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_CLIENTE"] . '</cbc:ID>
			</cac:PartyIdentification>
			<cac:PartyName>
				<cbc:Name><![CDATA[' . $cabecera["RAZON_SOCIAL_CLIENTE"] . ']]></cbc:Name>
			</cac:PartyName>
			<cac:PartyTaxScheme>
				<cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_CLIENTE"] . ']]></cbc:RegistrationName>
				<cbc:CompanyID schemeID="' . $cabecera["TIPO_DOCUMENTO_CLIENTE"] . '" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_CLIENTE"] . '</cbc:CompanyID>
				<cac:TaxScheme>
					<cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_CLIENTE"] . '" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_CLIENTE"] . '</cbc:ID>
				</cac:TaxScheme>
			</cac:PartyTaxScheme>
			<cac:PartyLegalEntity>
				<cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_CLIENTE"] . ']]></cbc:RegistrationName>
				<cac:RegistrationAddress>
					<cbc:ID schemeName="Ubigeos" schemeAgencyName="PE:INEI">' . $cabecera["COD_UBIGEO_CLIENTE"] . '</cbc:ID>
					<cbc:CityName><![CDATA[' . $cabecera["DEPARTAMENTO_CLIENTE"] . ']]></cbc:CityName>
					<cbc:CountrySubentity><![CDATA[' . $cabecera["PROVINCIA_CLIENTE"] . ']]></cbc:CountrySubentity>
					<cbc:District><![CDATA[' . $cabecera["DISTRITO_CLIENTE"] . ']]></cbc:District>
					<cac:AddressLine>
						<cbc:Line><![CDATA[' . $cabecera["DIRECCION_CLIENTE"] . ']]></cbc:Line>
					</cac:AddressLine>                                        
					<cac:Country>
						<cbc:IdentificationCode listID="ISO 3166-1" listAgencyName="United Nations Economic Commission for Europe" listName="Country">' . $cabecera["COD_PAIS_CLIENTE"] . '</cbc:IdentificationCode>
					</cac:Country>
				</cac:RegistrationAddress>
			</cac:PartyLegalEntity>
		</cac:Party>
	</cac:AccountingCustomerParty>'

    .$detraction //Etiquetas para Medio de pago, Numero de banco de la nacion, Tipo de detraccion, Porcentaje de detraccion y Total de la detraccion. 

    .$formaPago
    //*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
    . $retainer .
    //*************************************END TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
    '<cac:AllowanceCharge>
		<cbc:ChargeIndicator>false</cbc:ChargeIndicator>
		<cbc:AllowanceChargeReasonCode listName="Cargo/descuento" listAgencyName="PE:SUNAT" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo53">02</cbc:AllowanceChargeReasonCode>
		<cbc:MultiplierFactorNumeric>'.$cabecera["PORC_DESCUENTO_GLOBAL"].'</cbc:MultiplierFactorNumeric>
		<cbc:Amount currencyID="' . $cabecera["COD_MONEDA"] . '">'.$cabecera["DESCUENTO_GLOBAL"].'</cbc:Amount>
		<cbc:BaseAmount currencyID="' . $cabecera["COD_MONEDA"] . '">'.$cabecera["TOTAL_BRUTO"].'</cbc:BaseAmount>
	</cac:AllowanceCharge>
	<cac:TaxTotal>
		<cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">';
        if ($cabecera["TOTAL_ICBPER"] > 0) {
            $xmlCPE .= ($cabecera["TOTAL_IGV"] + $cabecera["TOTAL_ICBPER"]);
        } else {
            $xmlCPE .= $cabecera["TOTAL_IGV"];
        }
        $xmlCPE .= '</cbc:TaxAmount>';
        $xmlCPE = $xmlCPE .$AFECTAS . $EXONERADO . $INAFECTAS.$GRATUITAS;

        if ($cabecera["TOTAL_OTR_IMP"] > 0) {
            $xmlCPE = $xmlCPE .
                '<cac:TaxSubtotal>
                <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_OTR_IMP"] . '</cbc:TaxableAmount>
                <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_OTR_IMP"] . '</cbc:TaxAmount>
                <cac:TaxCategory>
                    <cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">S</cbc:ID>
                    <cac:TaxScheme>
                        <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">9999</cbc:ID>
                        <cbc:Name>OTR</cbc:Name>
                        <cbc:TaxTypeCode>OTH</cbc:TaxTypeCode>
                    </cac:TaxScheme>
                </cac:TaxCategory>
            </cac:TaxSubtotal>';
        }

        if (isset($cabecera["TOTAL_ICBPER"])) {
            if ($cabecera["TOTAL_ICBPER"] > 0) {
                $xmlCPE = $xmlCPE . '
                <cac:TaxSubtotal>
                    <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_ICBPER"] . '</cbc:TaxAmount>
                    <cac:TaxCategory>
                        <cac:TaxScheme>
                            <cbc:ID schemeAgencyName="PE:SUNAT" schemeName="Codigo de tributos" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">7152</cbc:ID>
                            <cbc:Name>ICBPER</cbc:Name>
                            <cbc:TaxTypeCode>OTH</cbc:TaxTypeCode>	
                        </cac:TaxScheme>
                    </cac:TaxCategory>
                </cac:TaxSubtotal>';
            }
        }

        //TOTAL=GRAVADA+IGV+EXONERADA
        //NO ENTRA GRATUITA(INAFECTA) NI DESCUENTO
        //SUB_TOTAL=PRECIO(SIN IGV) * CANTIDAD
        $xmlCPE = $xmlCPE .
            '</cac:TaxTotal>
	<cac:LegalMonetaryTotal>
		<cbc:LineExtensionAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["SUB_TOTAL"] . '</cbc:LineExtensionAmount>
		<cbc:TaxInclusiveAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL"] . '</cbc:TaxInclusiveAmount>
		<cbc:AllowanceTotalAmount currencyID="' . $cabecera["COD_MONEDA"] . '">0.00</cbc:AllowanceTotalAmount>
		<cbc:ChargeTotalAmount currencyID="' . $cabecera["COD_MONEDA"] . '">0.00</cbc:ChargeTotalAmount>
		<cbc:PayableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL"] . '</cbc:PayableAmount>
	</cac:LegalMonetaryTotal>';
        for ($i = 0; $i < count($detalle); $i++) {
            $xmlCPE = $xmlCPE . '<cac:InvoiceLine>
		<cbc:ID>' . $detalle[$i]["txtITEM"] . '</cbc:ID>
		<cbc:InvoicedQuantity unitCode="' . $detalle[$i]["txtUNIDAD_MEDIDA_DET"] . '" unitCodeListID="UN/ECE rec 20" unitCodeListAgencyName="United Nations Economic Commission for Europe">' . $detalle[$i]["txtCANTIDAD_DET"] . '</cbc:InvoicedQuantity>
		<cbc:LineExtensionAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIMPORTE_DET"] . '</cbc:LineExtensionAmount>
		<cac:PricingReference>
			<cac:AlternativeConditionPrice>
				<cbc:PriceAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtPRECIO_DET"] . '</cbc:PriceAmount>
				<cbc:PriceTypeCode listName="Tipo de Precio" listAgencyName="PE:SUNAT" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo16">' . $detalle[$i]["txtPRECIO_TIPO_CODIGO"] . '</cbc:PriceTypeCode>
			</cac:AlternativeConditionPrice>
		</cac:PricingReference>'.

        $detraction_detail_transport_services
        
        .'
		<cac:TaxTotal>';
        if($detalle[$i]["CODIGO_IMPUESTO"] == '9996'){
            if($detalle[$i]["ICBPER_DET"] > 0){
                $xmlCPE = $xmlCPE . '
                <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["ICBPER_DET"] . '</cbc:TaxAmount>';
            }else{
                $xmlCPE = $xmlCPE . '
                <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">0</cbc:TaxAmount>';
            }

        }else{
            $total_igv_with_icbper = $detalle[$i]["txtIGV"] + $detalle[$i]["ICBPER_DET"];
            $xmlCPE = $xmlCPE . '
            <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $total_igv_with_icbper . '</cbc:TaxAmount>';

        }
        $xmlCPE = $xmlCPE . '
			<cac:TaxSubtotal>
				<cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIMPORTE_DET"] . '</cbc:TaxableAmount>
				<cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIGV"] . '</cbc:TaxAmount>
				<cac:TaxCategory>
					<cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">' . $detalle[$i]["CODIGO_CATEGORIA_IMPUESTO"] . '</cbc:ID>
					<cbc:Percent>' . $detalle[$i]["IGV_ITEM"] . '</cbc:Percent>
					<cbc:TaxExemptionReasonCode listAgencyName="PE:SUNAT" listName="Afectacion del IGV" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo07">' . $detalle[$i]["CODIGO_EXTENSION_IMPUESTO"] . '</cbc:TaxExemptionReasonCode>
					<cac:TaxScheme>
						<cbc:ID schemeID="UN/ECE 5153" schemeName="Codigo de tributos" schemeAgencyName="PE:SUNAT">' . $detalle[$i]["CODIGO_IMPUESTO"] . '</cbc:ID>
						<cbc:Name>' . $detalle[$i]["TIPO_IMPUESTO"] . '</cbc:Name>
						<cbc:TaxTypeCode>' . $detalle[$i]["TIPO_CODIGO_IMPUESTO"] . '</cbc:TaxTypeCode>
					</cac:TaxScheme>
				</cac:TaxCategory>
			</cac:TaxSubtotal>
		
        ';

            if (isset($detalle[$i]["ICBPER_DET"]) && $detalle[$i]["ICBPER_DET"] > 0) {
                $xmlCPE = $xmlCPE . '
                <cac:TaxSubtotal>
                    <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["ICBPER_DET"] . '</cbc:TaxAmount>
                    <cbc:BaseUnitMeasure unitCode="NIU">' . intval($detalle[$i]["txtCANTIDAD_DET"]) . '</cbc:BaseUnitMeasure>
                    <cac:TaxCategory>
                        <cbc:PerUnitAmount currencyID="PEN">0.10</cbc:PerUnitAmount>
                        <cac:TaxScheme>
                            <cbc:ID schemeAgencyName="PE:SUNAT" schemeName="Codigo de tributos" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">7152</cbc:ID>
                            <cbc:Name>ICBPER</cbc:Name>
                            <cbc:TaxTypeCode>OTH</cbc:TaxTypeCode>	
                        </cac:TaxScheme>
                    </cac:TaxCategory>
                </cac:TaxSubtotal>
                ';
            }

            $xmlCPE = $xmlCPE . '
            </cac:TaxTotal>
		<cac:Item>
			<cbc:Description><![CDATA[' . $validacion->replace_invalid_caracters((isset($detalle[$i]["txtDESCRIPCION_DET"])) ? $detalle[$i]["txtDESCRIPCION_DET"] : "") . ']]></cbc:Description>
			<cac:SellersItemIdentification>
				<cbc:ID><![CDATA[' . $validacion->replace_invalid_caracters((isset($detalle[$i]["txtCODIGO_DET"])) ? $detalle[$i]["txtCODIGO_DET"] : "") . ']]></cbc:ID>
			</cac:SellersItemIdentification>

			' ./*<cac:CommodityClassification>
				<cbc:ItemClassificationCode listID="UNSPSC" listAgencyName="GS1 US" listName="Item Classification">'.$detalle[$i]['txtCODIGO_PROD_SUNAT'].'</cbc:ItemClassificationCode>
			</cac:CommodityClassification>*/ '

            '. $detraction_hydrobiological_resources . '
		</cac:Item>
		<cac:Price>
			<cbc:PriceAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtPRECIO_SIN_IGV_DET"] . '</cbc:PriceAmount>
		</cac:Price>
	</cac:InvoiceLine>';
        }

        $xmlCPE = $xmlCPE . '</Invoice>';

        $direccion = $cabecera['NRO_DOCUMENTO_EMPRESA'] . '-' . $cabecera['COD_TIPO_DOCUMENTO'] . '-' . $cabecera['NRO_COMPROBANTE'];
        $validarRuta = str_replace($direccion, '', $ruta);

        //print_r($validarRuta);

        if (!file_exists($validarRuta)) {
            mkdir($validarRuta, 0777, true);
        }

        $doc->loadXML($xmlCPE);
        $doc->save($ruta . '.XML');
        $resp['respuesta'] = 'ok';
        $resp['url_xml'] = $ruta . '.XML';
        return $resp;
    }



















    public function crear_xml_nota_credito($cabecera, $detalle, $ruta)
    {
        $validacion = new validaciondedatos();
        $doc = new DOMDocument();
        $doc->formatOutput = FALSE;
        $doc->preserveWhiteSpace = TRUE;
        //$doc->encoding = 'ISO-8859-1';
        $doc->encoding = 'utf-8';

        if ($cabecera["TOTAL_INAFECTA"] > 0) {
            $INAFECTAS = '
					<cac:TaxSubtotal>
                    <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_INAFECTA"] . '</cbc:TaxableAmount>
                    <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">0.00</cbc:TaxAmount>
                    <cac:TaxCategory>
                    <cbc:ID schemeID="UN/ECE 5153" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">O</cbc:ID>
                    <cac:TaxScheme>
                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">9998</cbc:ID>
                    <cbc:Name>INA</cbc:Name>
                    <cbc:TaxTypeCode>FRE</cbc:TaxTypeCode>
                    </cac:TaxScheme>
                    </cac:TaxCategory>
                    </cac:TaxSubtotal>
                    ';
        } else {
            $INAFECTAS = '';
        }

        if ($cabecera["TOTAL_EXONERADAS"] > 0) {
            $EXONERADO = '
						<cac:TaxSubtotal>
                        <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_EXONERADAS"] . '</cbc:TaxableAmount>
                        <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">0.00</cbc:TaxAmount>
                        <cac:TaxCategory>
                        <cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">E</cbc:ID>
                        <cac:TaxScheme>
                        <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">9997</cbc:ID>
                        <cbc:Name>EXO</cbc:Name>
                        <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                        </cac:TaxScheme>
                        </cac:TaxCategory>
                        </cac:TaxSubtotal>
                        ';
        } else {
            $EXONERADO = '';
        }

        $xmlCPE = '<?xml version="1.0" encoding="UTF-8"?>
<CreditNote xmlns="urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <ext:UBLExtensions>
        <ext:UBLExtension>
            <ext:ExtensionContent>
            </ext:ExtensionContent>
        </ext:UBLExtension>
    </ext:UBLExtensions>
    <cbc:UBLVersionID>2.1</cbc:UBLVersionID>
    <cbc:CustomizationID>2.0</cbc:CustomizationID>
    <cbc:ID>' . $cabecera["NRO_COMPROBANTE"] . '</cbc:ID>
    <cbc:IssueDate>' . $cabecera["FECHA_DOCUMENTO"] . '</cbc:IssueDate>
    <cbc:IssueTime>00:00:00</cbc:IssueTime>
    <cbc:DocumentCurrencyCode>' . $cabecera["COD_MONEDA"] . '</cbc:DocumentCurrencyCode>
    <cac:DiscrepancyResponse>
        <cbc:ReferenceID>' . $cabecera["NRO_DOCUMENTO_MODIFICA"] . '</cbc:ReferenceID>
        <cbc:ResponseCode>' . $cabecera["COD_TIPO_MOTIVO"] . '</cbc:ResponseCode>
        <cbc:Description><![CDATA[' . $cabecera["DESCRIPCION_MOTIVO"] . ']]></cbc:Description>
    </cac:DiscrepancyResponse>
    <cac:BillingReference>
        <cac:InvoiceDocumentReference>
            <cbc:ID>' . $cabecera["NRO_DOCUMENTO_MODIFICA"] . '</cbc:ID>
            <cbc:DocumentTypeCode>' . $cabecera["TIPO_COMPROBANTE_MODIFICA"] . '</cbc:DocumentTypeCode>
        </cac:InvoiceDocumentReference>
    </cac:BillingReference>
    <cac:Signature>
        <cbc:ID>IDSignST</cbc:ID>
        <cac:SignatoryParty>
            <cac:PartyIdentification>
                <cbc:ID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyName>
                <cbc:Name><![CDATA[' . $cabecera["RAZON_SOCIAL_EMPRESA"] . ']]></cbc:Name>
            </cac:PartyName>
        </cac:SignatoryParty>
        <cac:DigitalSignatureAttachment>
            <cac:ExternalReference>
                <cbc:URI>#SignatureSP</cbc:URI>
            </cac:ExternalReference>
        </cac:DigitalSignatureAttachment>
    </cac:Signature>
    <cac:AccountingSupplierParty>
        <cac:Party>
            <cac:PartyIdentification>
                <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '" schemeName="Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyName>
                <cbc:Name><![CDATA[' . $cabecera["NOMBRE_COMERCIAL_EMPRESA"] . ']]></cbc:Name>
            </cac:PartyName>
            <cac:PartyLegalEntity>
<cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_EMPRESA"] . ']]></cbc:RegistrationName>
                <cac:RegistrationAddress>
                    <cbc:AddressTypeCode>0000</cbc:AddressTypeCode>
                </cac:RegistrationAddress>
            </cac:PartyLegalEntity>
        </cac:Party>
    </cac:AccountingSupplierParty>
    <cac:AccountingCustomerParty>
        <cac:Party>
            <cac:PartyIdentification>
                <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_CLIENTE"] . '" schemeName="Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_CLIENTE"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyLegalEntity>
<cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_CLIENTE"] . ']]></cbc:RegistrationName>
            </cac:PartyLegalEntity>
        </cac:Party>
    </cac:AccountingCustomerParty>
    <cac:TaxTotal>
        <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_IGV"] . '</cbc:TaxAmount>
        <cac:TaxSubtotal>
<cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_GRAVADAS"] . '</cbc:TaxableAmount>
<cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_IGV"] . '</cbc:TaxAmount>
            <cac:TaxCategory>
                <cac:TaxScheme>
                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">1000</cbc:ID>
                    <cbc:Name>IGV</cbc:Name>
                    <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                </cac:TaxScheme>
            </cac:TaxCategory>
        </cac:TaxSubtotal>
		' . $EXONERADO . $INAFECTAS . '
    </cac:TaxTotal>
    <cac:LegalMonetaryTotal>
        <cbc:PayableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL"] . '</cbc:PayableAmount>
    </cac:LegalMonetaryTotal>';
        //$xmlCPE = $xmlCPE . $EXONERADO . $INAFECTAS ;


        for ($i = 0; $i < count($detalle); $i++) {

            $xmlCPE = $xmlCPE . '<cac:CreditNoteLine>
        <cbc:ID>' . $detalle[$i]["txtITEM"] . '</cbc:ID>
<cbc:CreditedQuantity unitCode="' . $detalle[$i]["txtUNIDAD_MEDIDA_DET"] . '">' . $detalle[$i]["txtCANTIDAD_DET"] . '</cbc:CreditedQuantity>
<cbc:LineExtensionAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIMPORTE_DET"] . '</cbc:LineExtensionAmount>
        <cac:PricingReference>
            <cac:AlternativeConditionPrice>
<cbc:PriceAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtPRECIO_DET"] . '</cbc:PriceAmount>
                <cbc:PriceTypeCode>' . $detalle[$i]["txtPRECIO_TIPO_CODIGO"] . '</cbc:PriceTypeCode>
            </cac:AlternativeConditionPrice>
        </cac:PricingReference>
        <cac:TaxTotal>
<cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIGV"] . '</cbc:TaxAmount>
            <cac:TaxSubtotal>
<cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIMPORTE_DET"] . '</cbc:TaxableAmount>
<cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIGV"] . '</cbc:TaxAmount>
                <cac:TaxCategory>
				<cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">' . $detalle[$i]["CODIGO_CATEGORIA_IMPUESTO"] . '</cbc:ID>
                    <cbc:Percent>' . $detalle[$i]["POR_IGV"] . '</cbc:Percent>
<cbc:TaxExemptionReasonCode>' . $detalle[$i]["CODIGO_EXTENSION_IMPUESTO"] . '</cbc:TaxExemptionReasonCode>
                    <cac:TaxScheme>
                        <cbc:ID schemeID="UN/ECE 5153" schemeName="Codigo de tributos" schemeAgencyName="PE:SUNAT">' . $detalle[$i]["CODIGO_IMPUESTO"] . '</cbc:ID>
                        <cbc:Name>' . $detalle[$i]["TIPO_IMPUESTO"] . '</cbc:Name>
                        <cbc:TaxTypeCode>' . $detalle[$i]["TIPO_CODIGO_IMPUESTO"] . '</cbc:TaxTypeCode>
                    </cac:TaxScheme>
                </cac:TaxCategory>
            </cac:TaxSubtotal>
        </cac:TaxTotal>
        <cac:Item>
<cbc:Description><![CDATA[' . $validacion->replace_invalid_caracters((isset($detalle[$i]["txtDESCRIPCION_DET"])) ? $detalle[$i]["txtDESCRIPCION_DET"] : "") . ']]></cbc:Description>
            <cac:SellersItemIdentification>
                <cbc:ID><![CDATA[' . $validacion->replace_invalid_caracters((isset($detalle[$i]["txtCODIGO_DET"])) ? $detalle[$i]["txtCODIGO_DET"] : "") . ']]></cbc:ID>
            </cac:SellersItemIdentification>
            '/*.'<cac:CommodityClassification>
				<cbc:ItemClassificationCode listID="UNSPSC" listAgencyName="GS1 US" listName="Item Classification">'.$detalle[$i]['txtCODIGO_PROD_SUNAT'].'</cbc:ItemClassificationCode>
			</cac:CommodityClassification>'*/ . '
        </cac:Item>
        <cac:Price>
<cbc:PriceAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtPRECIO_SIN_IGV_DET"] . '</cbc:PriceAmount>
        </cac:Price>
    </cac:CreditNoteLine>';
        }

        $xmlCPE = $xmlCPE . '</CreditNote>';
        $doc->loadXML($xmlCPE);
        $doc->save($ruta . '.XML');

        $resp['respuesta'] = 'ok';
        $resp['url_xml'] = $ruta . '.XML';
        return $resp;
    }

    public function crear_xml_nota_debito($cabecera, $detalle, $ruta)
    {
        $validacion = new validaciondedatos();
        $doc = new DOMDocument();
        $doc->formatOutput = FALSE;
        $doc->preserveWhiteSpace = TRUE;
        //$doc->encoding = 'ISO-8859-1';
        $doc->encoding = 'utf-8';

        $xmlCPE = '<?xml version="1.0" encoding="UTF-8"?>
<DebitNote xmlns="urn:oasis:names:specification:ubl:schema:xsd:DebitNote-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <ext:UBLExtensions>
        <ext:UBLExtension>
            <ext:ExtensionContent>
            </ext:ExtensionContent>
        </ext:UBLExtension>
    </ext:UBLExtensions>
    <cbc:UBLVersionID>2.1</cbc:UBLVersionID>
    <cbc:CustomizationID>2.0</cbc:CustomizationID>
    <cbc:ID>' . $cabecera["NRO_COMPROBANTE"] . '</cbc:ID>
    <cbc:IssueDate>' . $cabecera["FECHA_DOCUMENTO"] . '</cbc:IssueDate>
    <cbc:IssueTime>00:00:00</cbc:IssueTime>
    <cbc:DocumentCurrencyCode>' . $cabecera["COD_MONEDA"] . '</cbc:DocumentCurrencyCode>
    <cac:DiscrepancyResponse>
        <cbc:ReferenceID>' . $cabecera["NRO_DOCUMENTO_MODIFICA"] . '</cbc:ReferenceID>
        <cbc:ResponseCode>' . $cabecera["COD_TIPO_MOTIVO"] . '</cbc:ResponseCode>
        <cbc:Description><![CDATA[' . $cabecera["DESCRIPCION_MOTIVO"] . ']]></cbc:Description>
    </cac:DiscrepancyResponse>
    <cac:BillingReference>
        <cac:InvoiceDocumentReference>
            <cbc:ID>' . $cabecera["NRO_DOCUMENTO_MODIFICA"] . '</cbc:ID>
            <cbc:DocumentTypeCode>' . $cabecera["TIPO_COMPROBANTE_MODIFICA"] . '</cbc:DocumentTypeCode>
        </cac:InvoiceDocumentReference>
    </cac:BillingReference>
    <cac:Signature>
        <cbc:ID>IDSignST</cbc:ID>
        <cac:SignatoryParty>
            <cac:PartyIdentification>
                <cbc:ID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyName>
                <cbc:Name><![CDATA[' . $cabecera["RAZON_SOCIAL_EMPRESA"] . ']]></cbc:Name>
            </cac:PartyName>
        </cac:SignatoryParty>
        <cac:DigitalSignatureAttachment>
            <cac:ExternalReference>
                <cbc:URI>#SignatureSP</cbc:URI>
            </cac:ExternalReference>
        </cac:DigitalSignatureAttachment>
    </cac:Signature>
    <cac:AccountingSupplierParty>
        <cac:Party>
            <cac:PartyIdentification>
                <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyName>
                <cbc:Name><![CDATA[' . $cabecera["NOMBRE_COMERCIAL_EMPRESA"] . ']]></cbc:Name>
            </cac:PartyName>
            <cac:PartyLegalEntity>
                <cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_EMPRESA"] . ']]></cbc:RegistrationName>
                <cac:RegistrationAddress>
                    <cbc:AddressTypeCode>0001</cbc:AddressTypeCode>
                </cac:RegistrationAddress>
            </cac:PartyLegalEntity>
        </cac:Party>
    </cac:AccountingSupplierParty>
    <cac:AccountingCustomerParty>
        <cac:Party>
            <cac:PartyIdentification>
                <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_CLIENTE"] . '" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_CLIENTE"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyLegalEntity>
<cbc:RegistrationName><![CDATA[' . $cabecera["RAZON_SOCIAL_CLIENTE"] . ']]></cbc:RegistrationName>
            </cac:PartyLegalEntity>
        </cac:Party>
    </cac:AccountingCustomerParty>
    <cac:TaxTotal>
        <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_IGV"] . '</cbc:TaxAmount>
        <cac:TaxSubtotal>
<cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_GRAVADAS"] . '</cbc:TaxableAmount>
            <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL_IGV"] . '</cbc:TaxAmount>
            <cac:TaxCategory>
                <cac:TaxScheme>
                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">1000</cbc:ID>
                    <cbc:Name>IGV</cbc:Name>
                    <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                </cac:TaxScheme>
            </cac:TaxCategory>
        </cac:TaxSubtotal>
    </cac:TaxTotal>
    <cac:RequestedMonetaryTotal>
<cbc:PayableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $cabecera["TOTAL"] . '</cbc:PayableAmount>
    </cac:RequestedMonetaryTotal>';

        for ($i = 0; $i < count($detalle); $i++) {
            $xmlCPE = $xmlCPE . '
    <cac:DebitNoteLine>
        <cbc:ID>' . $detalle[$i]["txtITEM"] . '</cbc:ID>
<cbc:DebitedQuantity unitCode="' . $detalle[$i]["txtUNIDAD_MEDIDA_DET"] . '">' . $detalle[$i]["txtCANTIDAD_DET"] . '</cbc:DebitedQuantity>
<cbc:LineExtensionAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIMPORTE_DET"] . '</cbc:LineExtensionAmount>
        <cac:PricingReference>
            <cac:AlternativeConditionPrice>
<cbc:PriceAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtPRECIO_DET"] . '</cbc:PriceAmount>
<cbc:PriceTypeCode>' . $detalle[$i]["txtPRECIO_TIPO_CODIGO"] . '</cbc:PriceTypeCode>
            </cac:AlternativeConditionPrice>
        </cac:PricingReference>
        <cac:TaxTotal>		
<cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIGV"] . '</cbc:TaxAmount>
            <cac:TaxSubtotal>
                <cbc:TaxableAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIMPORTE_DET"] . '</cbc:TaxableAmount>
                <cbc:TaxAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtIGV"] . '</cbc:TaxAmount>
                <cac:TaxCategory>
                    <cbc:Percent>' . $cabecera["POR_IGV"] . '</cbc:Percent>
<cbc:TaxExemptionReasonCode>' . $detalle[$i]["txtCOD_TIPO_OPERACION"] . '</cbc:TaxExemptionReasonCode>
                    <cac:TaxScheme>
                        <cbc:ID>1000</cbc:ID>
                        <cbc:Name>IGV</cbc:Name>
                        <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                    </cac:TaxScheme>
                </cac:TaxCategory>
            </cac:TaxSubtotal>
        </cac:TaxTotal>
		
<cac:Item>
<cbc:Description><![CDATA[' . $validacion->replace_invalid_caracters((isset($detalle[$i]["txtDESCRIPCION_DET"])) ? $detalle[$i]["txtDESCRIPCION_DET"] : "") . ']]></cbc:Description>
            <cac:SellersItemIdentification>
                <cbc:ID><![CDATA[' . $validacion->replace_invalid_caracters((isset($detalle[$i]["txtCODIGO_DET"])) ? $detalle[$i]["txtCODIGO_DET"] : "") . ']]></cbc:ID>
            </cac:SellersItemIdentification>
            <cac:CommodityClassification>
				<cbc:ItemClassificationCode listID="UNSPSC" listAgencyName="GS1 US" listName="Item Classification">' . $detalle[$i]['txtCODIGO_PROD_SUNAT'] . '</cbc:ItemClassificationCode>
			</cac:CommodityClassification>
        </cac:Item>
<cac:Price>
<cbc:PriceAmount currencyID="' . $cabecera["COD_MONEDA"] . '">' . $detalle[$i]["txtPRECIO_DET"] . '</cbc:PriceAmount>
</cac:Price>
    </cac:DebitNoteLine>';
        }

        $xmlCPE = $xmlCPE . '</DebitNote>';

        $doc->loadXML($xmlCPE);
        $doc->save($ruta . '.XML');

        $resp['respuesta'] = 'ok';
        $resp['url_xml'] = $ruta . '.XML';
        return $resp;
    }

    public function crear_xml_resumen_documentos($cabecera, $detalle, $ruta)
    {
        $validacion = new validaciondedatos();
        $doc = new DOMDocument();
        $doc->formatOutput = FALSE;
        $doc->preserveWhiteSpace = TRUE;
        $doc->encoding = 'ISO-8859-1';
        $xmlCPE = '<?xml version="1.0" encoding="iso-8859-1" standalone="no"?>
        <SummaryDocuments 
        xmlns="urn:sunat:names:specification:ubl:peru:schema:xsd:SummaryDocuments-1" 
        xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" 
        xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" 
        xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
        xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" 
        xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1"
        xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" 
        xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2">
        <ext:UBLExtensions>
            <ext:UBLExtension>
                            <ext:ExtensionContent>
                </ext:ExtensionContent>
            </ext:UBLExtension>
        </ext:UBLExtensions>
        <cbc:UBLVersionID>2.0</cbc:UBLVersionID>
        <cbc:CustomizationID>1.1</cbc:CustomizationID>
        <cbc:ID>' . $cabecera["CODIGO"] . '-' . $cabecera["SERIE"] . '-' . $cabecera["SECUENCIA"] . '</cbc:ID>
        <cbc:ReferenceDate>' . $cabecera["FECHA_REFERENCIA"] . '</cbc:ReferenceDate>
        <cbc:IssueDate>' . $cabecera["FECHA_DOCUMENTO"] . '</cbc:IssueDate>
        <cac:Signature>
            <cbc:ID>' . $cabecera["CODIGO"] . '-' . $cabecera["SERIE"] . '-' . $cabecera["SECUENCIA"] . '</cbc:ID>
            <cac:SignatoryParty>
                <cac:PartyIdentification>
                    <cbc:ID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
                </cac:PartyIdentification>
                <cac:PartyName>
                    <cbc:Name>' . $cabecera["RAZON_SOCIAL_EMPRESA"] . '</cbc:Name>
                </cac:PartyName>
            </cac:SignatoryParty>
            <cac:DigitalSignatureAttachment>
                <cac:ExternalReference>
                    <cbc:URI>' . $cabecera["CODIGO"] . '-' . $cabecera["SERIE"] . '-' . $cabecera["SECUENCIA"] . '</cbc:URI>
                </cac:ExternalReference>
            </cac:DigitalSignatureAttachment>
        </cac:Signature>
        <cac:AccountingSupplierParty>
            <cbc:CustomerAssignedAccountID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:CustomerAssignedAccountID>
            <cbc:AdditionalAccountID>' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '</cbc:AdditionalAccountID>
            <cac:Party>
                <cac:PartyLegalEntity>
                    <cbc:RegistrationName>' . $cabecera["RAZON_SOCIAL_EMPRESA"] . '</cbc:RegistrationName>
                </cac:PartyLegalEntity>
            </cac:Party>
        </cac:AccountingSupplierParty>';
        for ($i = 0; $i < count($detalle); $i++) {
            $xmlCPE = $xmlCPE . '<sac:SummaryDocumentsLine>
            <cbc:LineID>' . $detalle[$i]["ITEM"] . '</cbc:LineID>
            <cbc:DocumentTypeCode>' . $detalle[$i]["TIPO_COMPROBANTE"] . '</cbc:DocumentTypeCode>
            <cbc:ID>' . $detalle[$i]["NRO_COMPROBANTE"] . '</cbc:ID>
            <cac:AccountingCustomerParty>
                <cbc:CustomerAssignedAccountID>' . $detalle[$i]["NRO_DOCUMENTO"] . '</cbc:CustomerAssignedAccountID>
                <cbc:AdditionalAccountID>' . $detalle[$i]["TIPO_DOCUMENTO"] . '</cbc:AdditionalAccountID>
            </cac:AccountingCustomerParty>';
            if ($detalle[$i]["TIPO_COMPROBANTE"] == "07" || $detalle[$i]["TIPO_COMPROBANTE"] == "08") {
                $xmlCPE = $xmlCPE . '<cac:BillingReference>
                <cac:InvoiceDocumentReference>
                    <cbc:ID>' . $detalle[$i]["NRO_COMPROBANTE_REF"] . '</cbc:ID>
                    <cbc:DocumentTypeCode>' . $detalle[$i]["TIPO_COMPROBANTE_REF"] . '</cbc:DocumentTypeCode>
                </cac:InvoiceDocumentReference>
            </cac:BillingReference>';
            }
            $xmlCPE = $xmlCPE . '<cac:Status>
                <cbc:ConditionCode>' . $detalle[$i]["STATUS"] . '</cbc:ConditionCode>
            </cac:Status>                
            <sac:TotalAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["TOTAL"] . '</sac:TotalAmount>
            
                    <sac:BillingPayment>
                <cbc:PaidAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["GRAVADA"] . '</cbc:PaidAmount>
                <cbc:InstructionID>01</cbc:InstructionID>
            </sac:BillingPayment>';

            if (intval($detalle[$i]["EXONERADO"]) > 0) {
                $xmlCPE = $xmlCPE . '<sac:BillingPayment>
                <cbc:PaidAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["EXONERADO"] . '</cbc:PaidAmount>
                <cbc:InstructionID>02</cbc:InstructionID>
            </sac:BillingPayment>';
            }

            if (intval($detalle[$i]["INAFECTO"]) > 0) {
                $xmlCPE = $xmlCPE . '<sac:BillingPayment>
                <cbc:PaidAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["INAFECTO"] . '</cbc:PaidAmount>
                <cbc:InstructionID>03</cbc:InstructionID>
            </sac:BillingPayment>';
            }

            if (intval($detalle[$i]["EXPORTACION"]) > 0) {
                $xmlCPE = $xmlCPE . '<sac:BillingPayment>
                <cbc:PaidAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["EXPORTACION"] . '</cbc:PaidAmount>
                <cbc:InstructionID>04</cbc:InstructionID>
            </sac:BillingPayment>';
            }

            if (intval($detalle[$i]["GRATUITAS"]) > 0) {
                $xmlCPE = $xmlCPE . '<sac:BillingPayment>
                <cbc:PaidAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["GRATUITAS"] . '</cbc:PaidAmount>
                <cbc:InstructionID>05</cbc:InstructionID>
            </sac:BillingPayment>';
            }



            if (intval($detalle[$i]["MONTO_CARGO_X_ASIG"]) > 0) {
                $xmlCPE = $xmlCPE . '<cac:AllowanceCharge>';
                if ($detalle[$i]["CARGO_X_ASIGNACION"] == 1) {
                    $xmlCPE = $xmlCPE . '<cbc:ChargeIndicator>true</cbc:ChargeIndicator>';
                } else {
                    $xmlCPE = $xmlCPE . '<cbc:ChargeIndicator>false</cbc:ChargeIndicator>';
                }
                $xmlCPE = $xmlCPE . '<cbc:Amount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["MONTO_CARGO_X_ASIG"] . '</cbc:Amount>
                        </cac:AllowanceCharge>';
            }
            if (intval($detalle[$i]["ISC"]) > 0) {
                $xmlCPE = $xmlCPE . '<cac:TaxTotal>
                <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["ISC"] . '</cbc:TaxAmount>
                <cac:TaxSubtotal>
                    <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["ISC"] . '</cbc:TaxAmount>
                    <cac:TaxCategory>
                        <cac:TaxScheme>
                            <cbc:ID>2000</cbc:ID>
                            <cbc:Name>ISC</cbc:Name>
                            <cbc:TaxTypeCode>EXC</cbc:TaxTypeCode>
                        </cac:TaxScheme>
                    </cac:TaxCategory>
                </cac:TaxSubtotal>
            </cac:TaxTotal>';
            }
            $xmlCPE = $xmlCPE . '<cac:TaxTotal>
                <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["IGV"] . '</cbc:TaxAmount>
                <cac:TaxSubtotal>
                    <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["IGV"] . '</cbc:TaxAmount>
                    <cac:TaxCategory>
                        <cac:TaxScheme>
                            <cbc:ID>1000</cbc:ID>
                            <cbc:Name>IGV</cbc:Name>
                            <cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>
                        </cac:TaxScheme>
                    </cac:TaxCategory>
                </cac:TaxSubtotal>
            </cac:TaxTotal>';

            if (isset($detalle[$i]["ICBPER"])) {
                if (floatval($detalle[$i]["ICBPER"]) > 0) {
                    $xmlCPE = $xmlCPE . '
                    <cac:TaxTotal>
                        <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["ICBPER"] . '</cbc:TaxAmount>
                        <cac:TaxSubtotal>
                            <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["ICBPER"] . '</cbc:TaxAmount>
                            <cac:TaxCategory>
                                <cac:TaxScheme>
                                    <cbc:ID schemeAgencyName="PE:SUNAT" schemeName="Codigo de tributos" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo05">7152</cbc:ID>
                                    <cbc:Name>ICBPER</cbc:Name>
                                    <cbc:TaxTypeCode>OTH</cbc:TaxTypeCode>	
                                </cac:TaxScheme>
                            </cac:TaxCategory>
                        </cac:TaxSubtotal>
                    </cac:TaxTotal>';
                }
            }

            if (intval($detalle[$i]["OTROS"]) > 0) {
                $xmlCPE = $xmlCPE . '<cac:TaxTotal>
                <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["OTROS"] . '</cbc:TaxAmount>
                <cac:TaxSubtotal>
                    <cbc:TaxAmount currencyID="' . $detalle[$i]["COD_MONEDA"] . '">' . $detalle[$i]["OTROS"] . '</cbc:TaxAmount>
                    <cac:TaxCategory>
                        <cac:TaxScheme>
                            <cbc:ID>9999</cbc:ID>
                            <cbc:Name>OTROS</cbc:Name>
                            <cbc:TaxTypeCode>OTH</cbc:TaxTypeCode>
                        </cac:TaxScheme>
                    </cac:TaxCategory>
                </cac:TaxSubtotal>
            </cac:TaxTotal>';
            }
            $xmlCPE = $xmlCPE . '</sac:SummaryDocumentsLine>';
        }
        $xmlCPE = $xmlCPE . '</SummaryDocuments>';

        $doc->loadXML($xmlCPE);
        $doc->save($ruta . '.XML');
        $resp['respuesta'] = 'ok';
        $resp['url_xml'] = $ruta . '.XML';
        return $resp;
    }

    public function enviar_documento($ruc, $usuario_sol, $pass_sol, $ruta_archivo, $ruta_archivo_cdr, $archivo, $ruta_ws)
    {
        //=================ZIPEAR ================
        $zip = new ZipArchive();
        $filenameXMLCPE = $ruta_archivo . '.ZIP';

        if ($zip->open($filenameXMLCPE, ZIPARCHIVE::CREATE) === true) {
            $zip->addFile($ruta_archivo . '.XML', $archivo . '.XML'); //ORIGEN, DESTINO
            $zip->close();
        }

        //===================ENVIO FACTURACION=====================
        $soapUrl = $ruta_ws;
        // xml post structure
        $xml_post_string = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
        xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" 
        xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
        <soapenv:Header>
            <wsse:Security>
                <wsse:UsernameToken>
                    <wsse:Username>' . $ruc . $usuario_sol . '</wsse:Username>
                    <wsse:Password>' . $pass_sol . '</wsse:Password>
                </wsse:UsernameToken>
            </wsse:Security>
        </soapenv:Header>
        <soapenv:Body>
            <ser:sendBill>
                <fileName>' . $archivo . '.ZIP</fileName>
                <contentFile>' . base64_encode(file_get_contents($ruta_archivo . '.ZIP')) . '</contentFile>
            </ser:sendBill>
        </soapenv:Body>
        </soapenv:Envelope>';

        $headers = array(
            "Content-type: text/xml;charset=\"utf-8\"",
            "Accept: text/xml",
            "Cache-Control: no-cache",
            "Pragma: no-cache",
            "SOAPAction: ",
            "Content-length: " . strlen($xml_post_string),
        );

        $url = $soapUrl;

        // PHP cURL  for https connection with auth
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // converting
        $response = curl_exec($ch);
        error_log($response);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpcode == 200) {
            $doc = new DOMDocument();
            $doc->loadXML($response);

            //===================VERIFICAMOS SI HA ENVIADO CORRECTAMENTE EL COMPROBANTE=====================

            if (isset($doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue)) {
                $xmlCDR = $doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue;
                file_put_contents($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP', base64_decode($xmlCDR));

                //extraemos archivo zip a xml
                $zip = new ZipArchive;
                if ($zip->open($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP') === TRUE) {
                    $zip->extractTo($ruta_archivo_cdr, 'R-' . $archivo . '.XML');
                    $zip->close();
                }

                //eliminamos los archivos Zipeados
                unlink($ruta_archivo . '.ZIP');
                unlink($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP');

                //=============hash CDR=================
                $doc_cdr = new DOMDocument();
                if (file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.XML')) {
                    $doc_cdr->load($ruta_archivo_cdr . 'R-' . $archivo . '.XML');
                    $resp['respuesta'] = 'ok';
                    $resp['cod_sunat'] = $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = 'SUNAT: '.$doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else if(file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.xml')){
                    $doc_cdr->load($ruta_archivo_cdr.'R-'.$archivo.'.XML');
                    $resp['respuesta']='ok';
                    $resp['cod_sunat']= 'SUNAT: '.$doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = $doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else{
                    $resp['respuesta'] = 'error';
                    $resp['cod_sunat'] = "0100";
                    $resp['mensaje'] = "SYS: El sistema no puede responder su solicitud. Intente nuevamente o comuníquese con su Administrador";
                    $resp['hash_cdr'] = "";
                }
            } else {
                $resp['respuesta'] = 'error';
                $resp['cod_sunat'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue;
                $resp['mensaje'] = $doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                $resp['hash_cdr'] = "";
            }
        }else if ($httpcode == 500) {
            $doc = new DOMDocument();
            $doc->loadXML($response);

            //===================VERIFICAMOS SI HA ENVIADO CORRECTAMENTE EL COMPROBANTE=====================


            if (isset($doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue)) {
                $xmlCDR = $doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue;
                file_put_contents($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP', base64_decode($xmlCDR));

                //extraemos archivo zip a xml
                $zip = new ZipArchive;
                if ($zip->open($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP') === TRUE) {
                    $zip->extractTo($ruta_archivo_cdr, 'R-' . $archivo . '.XML');
                    $zip->close();
                }

                //eliminamos los archivos Zipeados
                unlink($ruta_archivo . '.ZIP');
                unlink($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP');

                //=============hash CDR=================
                $doc_cdr = new DOMDocument();
                if (file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.XML')) {
                    $doc_cdr->load($ruta_archivo_cdr . 'R-' . $archivo . '.XML');
                    $resp['respuesta'] = 'ok';
                    $resp['cod_sunat'] = $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = 'SUNAT: '.$doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else if(file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.xml')){
                    $doc_cdr->load($ruta_archivo_cdr.'R-'.$archivo.'.XML');
                    $resp['respuesta']='ok';
                    $resp['cod_sunat']= $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = 'SUNAT: '. $doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else{
                    $resp['respuesta'] = 'error';
                    $resp['cod_sunat'] = "0100";
                    $resp['mensaje'] = "SYS: El sistema no puede responder su solicitud. Intente nuevamente o comuníquese con su Administrador";
                    $resp['hash_cdr'] = "";
                }
            } else {
                $resp['respuesta'] = 'error';
                $resp['cod_sunat'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue;
                $resp['mensaje'] = $doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                $resp['hash_cdr'] = "";
            }
        } else {
            //echo "no responde web";
            $resp['respuesta'] = 'error';
            $resp['cod_sunat'] = "0100";
            $resp['mensaje'] = "El sistema no puede responder su solicitud. Intente nuevamente o comuníquese con su Administrador". $response. $httpcode. 'OWO';
            $resp['hash_cdr'] = "";
        }
        return $resp;
    }



    //require_once('decode_64.php');
    public function enviar_documento_prueba($ruc, $usuario_sol, $pass_sol, $ruta_archivo, $ruta_archivo_cdr, $archivo, $ruta_ws)
    {
        try {
            //=================ZIPEAR ================
            $zip = new ZipArchive();
            $filenameXMLCPE = $ruta_archivo . '.ZIP';

            if ($zip->open($filenameXMLCPE, ZIPARCHIVE::CREATE) === true) {
                $zip->addFile($ruta_archivo . '.XML', $archivo . '.XML'); //ORIGEN, DESTINO
                $zip->close();
            }

            //===================ENVIO FACTURACION=====================
            $soapUrl = $ruta_ws; //"https://e-beta.sunat.gob.pe:443/ol-ti-itcpfegem-beta/billService"; // asmx URL of WSDL
            $soapUser = "";  //  username
            $soapPassword = ""; // password
            // xml post structure
            $xml_post_string = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
    xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" 
    xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
    <soapenv:Header>
        <wsse:Security>
            <wsse:UsernameToken>
                <wsse:Username>' . $ruc . $usuario_sol . '</wsse:Username>
                <wsse:Password>' . $pass_sol . '</wsse:Password>
            </wsse:UsernameToken>
        </wsse:Security>
    </soapenv:Header>
    <soapenv:Body>
        <ser:sendBill>
            <fileName>' . $archivo . '.ZIP</fileName>
            <contentFile>' . base64_encode(file_get_contents($ruta_archivo . '.ZIP')) . '</contentFile>
        </ser:sendBill>
    </soapenv:Body>
    </soapenv:Envelope>';

            $headers = array(
                "Content-type: text/xml;charset=\"utf-8\"",
                "Accept: text/xml",
                "Cache-Control: no-cache",
                "Pragma: no-cache",
                "SOAPAction: ",
                "Content-length: " . strlen($xml_post_string),
            ); //SOAPAction: your op URL

            $url = $soapUrl;

            //echo $xml_post_string;

            // PHP cURL  for https connection with auth
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            //curl_setopt($ch, CURLOPT_USERPWD, $soapUser.":".$soapPassword); // username and password - declared at the top of the doc
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            // converting
            $response = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            //echo $httpcode;
            //echo $response;
            //if ($httpcode == 200) {//======LA PAGINA SI RESPONDE
            //echo $httpcode.'----'.$response;
            //convertimos de base 64 a archivo fisico
            $doc = new DOMDocument();
            $doc->loadXML($response);



            //===================VERIFICAMOS SI HA ENVIADO CORRECTAMENTE EL COMPROBANTE=====================
            if (isset($doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue)) {
                $xmlCDR = $doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue;
                file_put_contents($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP', base64_decode($xmlCDR));

                //extraemos archivo zip a xml
                $zip = new ZipArchive;
                if ($zip->open($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP') === TRUE) {
                    $zip->extractTo($ruta_archivo_cdr, 'R-' . $archivo . '.XML');
                    $zip->close();
                }

                //eliminamos los archivos Zipeados
                unlink($ruta_archivo . '.ZIP');
                unlink($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP');

                //=============hash CDR=================
                $doc_cdr = new DOMDocument();
                $doc_cdr->load(dirname(__FILE__) . '/' . $ruta_archivo_cdr . 'R-' . $archivo . '.XML');

                $mensaje['cod_sunat'] = $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                $mensaje['msj_sunat'] = $doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                $mensaje['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
            } else {
                //$mensaje['cod_sunat'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue;
                //$mensaje['msj_sunat'] = $doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                //$mensaje['hash_cdr'] = "";

                $mensaje['cod_sunat'] = $doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                $mensaje['msj_sunat'] = $doc->getElementsByTagName('message')->item(0)->nodeValue;
                $mensaje['hash_cdr'] = "";
            }
        } catch (Exception $e) {
            $mensaje['cod_sunat'] = "0000";
            $mensaje['msj_sunat'] = "SYS: SUNAT ESTA FUERA SERVICIO: " . $e->getMessage();
            $mensaje['hash_cdr'] = "";
        }
        //print_r($mensaje); 
        return $mensaje;
        //$xmlCDR = $doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue;
    }
    public function enviar_guia_remision($ruc, $usuario_sol, $pass_sol, $ruta_archivo, $ruta_archivo_cdr, $archivo, $ruta_ws, $client_id, $client_secret,$tipodeproceso)
    {
        try {
            //=================ZIPEAR ================
            $zip = new ZipArchive();
            $filenameXMLCPE = $ruta_archivo . '.ZIP';

            if ($zip->open($filenameXMLCPE, ZIPARCHIVE::CREATE) === true) {
                $zip->addFile($ruta_archivo . '.XML', $archivo . '.XML'); //ORIGEN, DESTINO
                $zip->close();
            }
            $base64_arcGreZip = base64_encode(file_get_contents($ruta_archivo . '.ZIP'));
            $sha256_hashZip = hash_file('sha256', $ruta_archivo . '.ZIP');
            //===================ENVIO FACTURACION=====================
            $soapUrl = $ruta_ws; //"https://e-beta.sunat.gob.pe:443/ol-ti-itcpfegem-beta/billService"; // asmx URL of WSDL
            // xml post structure
            $url = $soapUrl;

            //echo $xml_post_string;

            // PHP cURL  for https connection with auth
            $curl = curl_init();
            // generar token digital
            $tokenSunat = $this->generarTokenSunat($ruc,$usuario_sol,$pass_sol,$client_id, $client_secret, $tipodeproceso);
            if($tokenSunat['estado'] == 200){
                $token = $tokenSunat['token'];
                if($tipodeproceso == '1'){
                    $url = 'https://gre-test.nubefact.com/v1/contribuyente/gem/comprobantes/'.$archivo;
                }
                if($tipodeproceso== '0'){
                    $url = 'https://api-cpe.sunat.gob.pe/v1/contribuyente/gem/comprobantes/'.$archivo;
                }
                /************************************************//****************************************************/
                curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{
                        "archivo": {
                            "nomArchivo": "'.$archivo.'.zip",
                            "arcGreZip": "'.$base64_arcGreZip.'",
                            "hashZip": "'.$sha256_hashZip.'"
                        }
                    }',
                CURLOPT_HTTPHEADER => array('Authorization:Bearer ' . $token)

                    ));

                $response = curl_exec($curl);
                curl_close($curl);
                $res = json_decode($response, false);                /****************************************************/
                $ticket = $res->numTicket;
                $respuesta = $this->ConsultarEstadoGuiaRemision($ticket, $token, $ruta_archivo_cdr, $archivo,$tipodeproceso);
                unlink($ruta_archivo . '.ZIP');

            }else{
                $respuesta = array(
                    "codigo_sunat"=> $tokenSunat['estado'],
                    "msj_sunat" => $tokenSunat['msg']
                );
            }
           	       
    return $respuesta;
    }catch(Exception $e){
        
    }
}
    function generarTokenSunat($ruc, $usuarioSol, $passUsuarioSol, $client_id, $client_secret, $tipoProceso){
        if($tipoProceso == '1'){
            $url = 'https://gre-test.nubefact.com/v1/clientessol/'.$client_id.'/oauth2/token/';

        }
        if($tipoProceso == '0'){
            $url = 'https://api-seguridad.sunat.gob.pe/v1/clientessol/'.$client_id.'/oauth2/token/';
        }
        $params = array(
            'grant_type' => 'password',
            'scope' => 'https://api-cpe.sunat.gob.pe',
            'client_id' => $client_id,
            'client_secret' => $client_secret,
            'username' => $ruc.$usuarioSol,
            'password' => $passUsuarioSol
        );
        $params = http_build_query($params);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        error_log($response);
        curl_close($ch);
        $res = json_decode($response, false);
        error_log(json_encode($res));
        if(isset($res->cod)){
            $respuesta = array(
                "estado" => $res->cod,
                "msg" =>$res->msg
            );
        }else{
            $respuesta = array(
                "estado" => 200,
                "token" =>$res->access_token
            );
        }
        return $respuesta;
    }
    function ConsultarEstadoGuiaRemision($ticket, $token, $ruta_archivo_cdr, $archivo, $tipoProceso){

        // URL de la API y token de autenticación
        if($tipoProceso == '1'){
            $url = 'https://gre-test.nubefact.com/v1/contribuyente/gem/comprobantes/envios/'.$ticket;

        }
        else if($tipoProceso == '0'){
            $url = 'https://api-cpe.sunat.gob.pe/v1/contribuyente/gem/comprobantes/envios/'.$ticket;
        }

        // Iniciar la sesión de cURL
        $ch = curl_init();

        // Establecer las opciones de cURL
        curl_setopt($ch, CURLOPT_URL, $url); // URL de la API
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Devolver la respuesta como una cadena
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer ' . $token // Token de autenticación
        ));
        // Ejecutar la solicitud y recibir la respuesta
        $response = curl_exec($ch);
        // Verificar si hubo algún error durante la solicitud
        if(curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
        }
        // Cerrar la sesión de cURL
        curl_close($ch);
        $res = json_decode($response, false);
        if($res->codRespuesta == 99){
            $mensaje['cod_sunat'] = $res->error->numError;
            $mensaje['msj_sunat'] = $res->error->desError;
            $mensaje['hash_cdr'] = "";
        }else{
            file_put_contents($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP', base64_decode($res->arcCdr));
            $zip = new ZipArchive;
            if ($zip->open($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP') === TRUE) {
                $zip->extractTo($ruta_archivo_cdr, 'R-' . $archivo . '.xml');
                $zip->close();
            }
            
            unlink($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP');
            if(file_exists(dirname(__FILE__) . '/' .$ruta_archivo_cdr. 'R-' . $archivo . '.xml')){
                    //=============hash CDR=================
                $doc_cdr = new DOMDocument();
                $doc_cdr->load(dirname(__FILE__) . '/' . $ruta_archivo_cdr . 'R-' . $archivo . '.XML');

                $mensaje['cod_sunat'] = $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                $mensaje['msj_sunat'] = 'SUNAT: '.$doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                $mensaje['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
            }else{
                $mensaje['cod_sunat'] = 0;
                $mensaje['msj_sunat'] = "Sin CDR";
                $mensaje['hash_cdr'] = "";
            }
            
        
        }
        // Procesar la respuesta de la API
        return $mensaje;

    }
    public function crear_xml_guia_remision($cabecera, $detalle, $ruta)
    {

        if ($cabecera["NUMERO_PAQUETES"] == "0") {
            $numero_paq = '';
        } else {
            $numero_paq = '<cbc:TotalTransportHandlingUnitQuantity>' . $cabecera["NUMERO_PAQUETES"] . '</cbc:TotalTransportHandlingUnitQuantity>';
        }
        if($cabecera['CODTIPO_TRANSPORTISTA'] == '01'){//Trasporte publico
            $conductor = '<cac:CarrierParty>
            <cac:PartyIdentification>
                <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_TRANSPORTE"] . '">'.$cabecera["NRO_DOCUMENTO_TRANSPORTE"].'</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyLegalEntity>
                <cbc:RegistrationName>'.$cabecera["RAZON_SOCIAL_TRANSPORTE"].'</cbc:RegistrationName>
            </cac:PartyLegalEntity>
        </cac:CarrierParty>';
        }
        if($cabecera['CODTIPO_TRANSPORTISTA'] == '02'){//Trasporte privado
            $conductor ='<cac:TransportMeans>
        </cac:TransportMeans>
        <cac:DriverPerson>
            <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_TRANSPORTE"] . '">'.$cabecera["NRO_DOCUMENTO_TRANSPORTE"].'</cbc:ID>
            <cbc:FirstName>'.$cabecera["NOMBRE_TRANSPORTISTA"].'</cbc:FirstName>
            <cbc:FamilyName>'.$cabecera["APELLIDOS_TRANSPORTISTA"].'</cbc:FamilyName>
            <cbc:JobTitle>Principal</cbc:JobTitle>
            <cac:IdentityDocumentReference>
                <cbc:ID>'.$cabecera["LICENCIA_TRANSPORTE"].'</cbc:ID>
            </cac:IdentityDocumentReference>
        </cac:DriverPerson>';
        }
        if ($cabecera["PESO"] == "0") {
            $peso = '';
        } else {
            $peso = '<cbc:GrossWeightMeasure unitCode="' . $cabecera['unidad_medida'] . '">' . $cabecera["PESO"] . '</cbc:GrossWeightMeasure>';
        }

        /*if($cabecera["PLACA"]!="0"){
			$placa='<cac:TransportMeans>
				<cac:RoadTransport>
					<cbc:LicensePlateID>' . $cabecera["PLACA"] . '</cbc:LicensePlateID>
				</cac:RoadTransport>
			</cac:TransportMeans>';
		}else{
			$placa='';
		}*/

        if ($cabecera["NOTA"] == "-") {
            $nota = '';
        } else {
            $nota = '<cbc:Note>' . $cabecera["NOTA"] . '</cbc:Note>';
        }

        $validacion = new validaciondedatos();
        $doc = new DOMDocument();
        $doc->formatOutput = FALSE;
        $doc->preserveWhiteSpace = TRUE;
        $doc->encoding = 'ISO-8859-1';
        $xmlCPE = '<?xml version="1.0" encoding="iso-8859-1"?>
    <DespatchAdvice xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1" xmlns="urn:oasis:names:specification:ubl:schema:xsd:DespatchAdvice-2">
    <ext:UBLExtensions>
        <ext:UBLExtension>
            <ext:ExtensionContent>
            </ext:ExtensionContent>
        </ext:UBLExtension>
    </ext:UBLExtensions>
    <cbc:UBLVersionID>2.1</cbc:UBLVersionID>
    <cbc:CustomizationID>2.0</cbc:CustomizationID>
    <cbc:ID>' . $cabecera["SERIE_SECUENCIA"] . '</cbc:ID>
    <cbc:IssueDate>' . $cabecera["FECHA_DOCUMENTO"] . '</cbc:IssueDate>
    <cbc:IssueTime>' . $cabecera["HORA_DOCUMENTO"] . '</cbc:IssueTime>
    <cbc:DespatchAdviceTypeCode>' . $cabecera["CODIGO"] . '</cbc:DespatchAdviceTypeCode>
    ' . $nota . '
    <cac:Signature>
        <cbc:ID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
        <cac:SignatoryParty>
            <cac:PartyIdentification>
                <cbc:ID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyName>
                <cbc:Name>' . $validacion->replace_invalid_caracters($cabecera["RAZON_SOCIAL_EMPRESA"]) . '</cbc:Name>
            </cac:PartyName>
        </cac:SignatoryParty>
        <cac:DigitalSignatureAttachment>
            <cac:ExternalReference>
                <cbc:URI>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:URI>
            </cac:ExternalReference>
        </cac:DigitalSignatureAttachment>
    </cac:Signature>
    <cac:DespatchSupplierParty>
        <cbc:CustomerAssignedAccountID schemeID="' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '">' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:CustomerAssignedAccountID>
        <cac:Party>
            <cac:PartyIdentification>
                <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '" schemeName="Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyLegalEntity>
                <cbc:RegistrationName>' . $validacion->replace_invalid_caracters($cabecera["RAZON_SOCIAL_EMPRESA"]) . '</cbc:RegistrationName>
            </cac:PartyLegalEntity>
        </cac:Party>
    </cac:DespatchSupplierParty>
    <cac:DeliveryCustomerParty>
        <cac:Party>
            <cac:PartyIdentification>
                <cbc:ID schemeID="' . $cabecera["TIPO_DOCUMENTO_CLIENTE"] . '" schemeName="Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">' . $cabecera["NRO_DOCUMENTO_CLIENTE"] . '</cbc:ID>
            </cac:PartyIdentification>
            <cac:PartyLegalEntity>
                <cbc:RegistrationName>' . $cabecera["RAZON_SOCIAL_CLIENTE"] . '</cbc:RegistrationName>
            </cac:PartyLegalEntity>
        </cac:Party>
    </cac:DeliveryCustomerParty>
    <cac:Shipment>
        <cbc:ID>1</cbc:ID>
        <cbc:HandlingCode>' . $cabecera["CODMOTIVO_TRASLADO"] . '</cbc:HandlingCode>
        ' . $peso . '
        ' . $numero_paq . '

        <cac:ShipmentStage>
            <cbc:TransportModeCode>' . $cabecera["CODTIPO_TRANSPORTISTA"] . '</cbc:TransportModeCode>
            <cac:TransitPeriod>
                <cbc:StartDate>' . $cabecera["FECHA_INICIO_TRASLADO"] . '</cbc:StartDate>
            </cac:TransitPeriod>
            ' /*. $placa*/ . '
            ' . $conductor . '
        </cac:ShipmentStage>
        <cac:Delivery>
            <cac:DeliveryAddress>
                <cbc:ID schemeAgencyName="PE:INEI" schemeName="Ubigeos">' . $cabecera["UBIGEO_DESTINO"] . '</cbc:ID>
                <cac:AddressLine>
                    <cbc:Line>' . $cabecera["DIR_DESTINO"] . '</cbc:Line>
                </cac:AddressLine>
            </cac:DeliveryAddress>
            <cac:Despatch>
                <cac:DespatchAddress>
                    <cbc:ID schemeAgencyName="PE:INEI" schemeName="Ubigeos">' . $cabecera["UBIGEO_PARTIDA"] . '</cbc:ID>
                    <cac:AddressLine>
                        <cbc:Line>' . $cabecera["DIR_PARTIDA"] . '</cbc:Line>
                    </cac:AddressLine>
                </cac:DespatchAddress>
            </cac:Despatch>
        </cac:Delivery>';
        if($cabecera['CODTIPO_TRANSPORTISTA'] == 2){
            $xmlCPE = $xmlCPE . '<cac:TransportHandlingUnit>
            <cac:TransportEquipment>
                <cbc:ID>A1W809</cbc:ID>
            </cac:TransportEquipment>
        </cac:TransportHandlingUnit>';
        }
        $xmlCPE = $xmlCPE . '</cac:Shipment>';

        for ($i = 0; $i < count($detalle); $i++) {
            $xmlCPE = $xmlCPE . '
            <cac:DespatchLine>
            <cbc:ID>' . $detalle[$i]["ITEM"] . '</cbc:ID>
    <cbc:DeliveredQuantity unitCode="' . $detalle[$i]["CODE_UNIDAD_MEDIDA"] . '">' . $detalle[$i]["PESO"] . '</cbc:DeliveredQuantity>
    <cac:OrderLineReference>
    <cbc:LineID>' . $detalle[$i]["NUMERO_ORDEN"] . '</cbc:LineID>
    </cac:OrderLineReference>
    
    <cac:Item>
                <cbc:Description>' . $validacion->replace_invalid_caracters($detalle[$i]["DESCRIPCION"]) . '</cbc:Description>
                <cac:SellersItemIdentification>
                    <cbc:ID>' . $detalle[$i]["CODIGO_PRODUCTO"] . '</cbc:ID>
                </cac:SellersItemIdentification>
            </cac:Item>
        </cac:DespatchLine>';
        }
        $xmlCPE = $xmlCPE . '</DespatchAdvice>';

        /*
    echo $xmlCPE;
    exit();
    */

        $doc->loadXML($xmlCPE);
        $doc->save($ruta . '.XML');
        $resp['respuesta'] = 'ok';
        $resp['url_xml'] = $ruta . '.XML';
        return $resp;
    }


    public function crear_xml_baja_sunat($cabecera, $detalle, $ruta)
    {
        $validacion = new validaciondedatos();
        $doc = new DOMDocument();
        $doc->formatOutput = FALSE;
        $doc->preserveWhiteSpace = TRUE;
        $doc->encoding = 'ISO-8859-1';
        $xmlCPE = '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?><VoidedDocuments xmlns="urn:sunat:names:specification:ubl:peru:schema:xsd:VoidedDocuments-1" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <ext:UBLExtensions>
    <ext:UBLExtension>
    <ext:ExtensionContent>
    </ext:ExtensionContent>
    </ext:UBLExtension>
    </ext:UBLExtensions>
    <cbc:UBLVersionID>2.0</cbc:UBLVersionID>
    <cbc:CustomizationID>1.0</cbc:CustomizationID>
    <cbc:ID>' . $cabecera["CODIGO"] . '-' . $cabecera["SERIE"] . '-' . $cabecera["SECUENCIA"] . '</cbc:ID>
    <cbc:ReferenceDate>' . $cabecera["FECHA_REFERENCIA"] . '</cbc:ReferenceDate>
    <cbc:IssueDate>' . $cabecera["FECHA_BAJA"] . '</cbc:IssueDate>
    <cac:Signature>
    <cbc:ID>IDSignKG</cbc:ID>
    <cac:SignatoryParty>
    <cac:PartyIdentification>
    <cbc:ID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:ID>
    </cac:PartyIdentification>
    <cac:PartyName>
    <cbc:Name>' . $validacion->replace_invalid_caracters($cabecera["RAZON_SOCIAL_EMPRESA"]) . '</cbc:Name>
    </cac:PartyName>
    </cac:SignatoryParty>
    <cac:DigitalSignatureAttachment>
    <cac:ExternalReference>
    <cbc:URI>#' . $cabecera["SERIE"] . '-' . $cabecera["SECUENCIA"] . '</cbc:URI>
    </cac:ExternalReference>
    </cac:DigitalSignatureAttachment>
    </cac:Signature>
    <cac:AccountingSupplierParty>
    <cbc:CustomerAssignedAccountID>' . $cabecera["NRO_DOCUMENTO_EMPRESA"] . '</cbc:CustomerAssignedAccountID>
    <cbc:AdditionalAccountID>' . $cabecera["TIPO_DOCUMENTO_EMPRESA"] . '</cbc:AdditionalAccountID>
    <cac:Party>
    <cac:PartyLegalEntity>
    <cbc:RegistrationName><![CDATA[' . $validacion->replace_invalid_caracters($cabecera["RAZON_SOCIAL_EMPRESA"]) . ']]></cbc:RegistrationName>
    </cac:PartyLegalEntity>
    </cac:Party>
    </cac:AccountingSupplierParty>';

        for ($i = 0; $i < count($detalle); $i++) {
            $xmlCPE = $xmlCPE . '<sac:VoidedDocumentsLine>
    <cbc:LineID>' . $detalle[$i]["ITEM"] . '</cbc:LineID>
    <cbc:DocumentTypeCode>' . $detalle[$i]["TIPO_COMPROBANTE"] . '</cbc:DocumentTypeCode>
    <sac:DocumentSerialID>' . $detalle[$i]["SERIE"] . '</sac:DocumentSerialID>
    <sac:DocumentNumberID>' . $detalle[$i]["NUMERO"] . '</sac:DocumentNumberID>
    <sac:VoidReasonDescription><![CDATA[' . $validacion->replace_invalid_caracters($detalle[$i]["MOTIVO"]) . ']]></sac:VoidReasonDescription>
    </sac:VoidedDocumentsLine>';
        }
        $xmlCPE = $xmlCPE . '</VoidedDocuments>';

        $doc->loadXML($xmlCPE);
        $doc->save($ruta . '.XML');
        $resp['respuesta'] = 'ok';
        $resp['url_xml'] = $ruta . '.XML';
        return $resp;
    }

    public function enviar_documento_para_baja($ruc, $usuario_sol, $pass_sol, $ruta_archivo, $ruta_archivo_cdr, $archivo, $ruta_ws)
    {
        try {
            //=================ZIPEAR ================
            $zip = new ZipArchive();
            $filenameXMLCPE = $ruta_archivo . '.ZIP';

            if ($zip->open($filenameXMLCPE, ZIPARCHIVE::CREATE) === true) {
                $zip->addFile($ruta_archivo . '.XML', $archivo . '.XML'); //ORIGEN, DESTINO
                $zip->close();
            }

            //===================ENVIO FACTURACION=====================
            $soapUrl = $ruta_ws;
            $soapUser = "";
            $soapPassword = "";
            // xml post structure
            $xml_post_string = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
            xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" 
            xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
            <soapenv:Header>
                <wsse:Security>
                    <wsse:UsernameToken>
                        <wsse:Username>' . $ruc . $usuario_sol . '</wsse:Username>
                        <wsse:Password>' . $pass_sol . '</wsse:Password>
                    </wsse:UsernameToken>
                </wsse:Security>
            </soapenv:Header>
            <soapenv:Body>
                <ser:sendSummary>
                    <fileName>' . $archivo . '.ZIP</fileName>
                    <contentFile>' . base64_encode(file_get_contents($ruta_archivo . '.ZIP')) . '</contentFile>
                </ser:sendSummary>
            </soapenv:Body>
            </soapenv:Envelope>';

            $headers = array(
                "Content-type: text/xml;charset=\"utf-8\"",
                "Accept: text/xml",
                "Cache-Control: no-cache",
                "Pragma: no-cache",
                "SOAPAction: ",
                "Content-length: " . strlen($xml_post_string),
            ); //SOAPAction: your op URL

            $url = $soapUrl;

            // PHP cURL  for https connection with auth
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            //curl_setopt($ch, CURLOPT_USERPWD, $soapUser.":".$soapPassword); // username and password - declared at the top of the doc
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            // converting
            $response = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            //convertimos de base 64 a archivo fisico
            $doc = new DOMDocument();
            $doc->loadXML($response);

            //===================VERIFICAMOS SI HA ENVIADO CORRECTAMENTE EL COMPROBANTE=====================
            if (isset($doc->getElementsByTagName('ticket')->item(0)->nodeValue)) {
                $ticket = $doc->getElementsByTagName('ticket')->item(0)->nodeValue;

                unlink($ruta_archivo . '.ZIP');
                $mensaje['respuesta'] = 'ok';
                $mensaje['cod_ticket'] = $ticket;
                $mensaje['extra'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue . ' - ' . $doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
            } else {
                $mensaje['respuesta'] = 'error';
                $mensaje['cod_sunat'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue;
                $mensaje['mensaje'] = 'SUNAT: '.$doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                $mensaje['hash_cdr'] = "";
                $mensaje['cod_ticket'] = '0';
            }
        } catch (Exception $e) {
            $mensaje['respuesta'] = 'error';
            $mensaje['cod_sunat'] = "0000";
            $mensaje['mensaje'] = "SYS: SUNAT ESTA FUERA SERVICIO: " . $e->getMessage();
            $mensaje['hash_cdr'] = "";
            $mensaje['cod_ticket'] = '0';
        }
        return $mensaje;
    }

    public function enviar_resumen_boletas($ruc, $usuario_sol, $pass_sol, $ruta_archivo, $ruta_archivo_cdr, $archivo, $ruta_ws)
    {
        //=================ZIPEAR ================
        $zip = new ZipArchive();
        $filenameXMLCPE = $ruta_archivo . '.ZIP';

        if ($zip->open($filenameXMLCPE, ZIPARCHIVE::CREATE) === true) {
            $zip->addFile($ruta_archivo . '.XML', $archivo . '.XML'); //ORIGEN, DESTINO
            $zip->close();
        }

        //===================ENVIO FACTURACION=====================
        $soapUrl = $ruta_ws;
        $soapUser = "";
        $soapPassword = "";
        // xml post structure
        $xml_post_string = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
        xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" 
        xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
        <soapenv:Header>
            <wsse:Security>
                <wsse:UsernameToken>
                    <wsse:Username>' . $ruc . $usuario_sol . '</wsse:Username>
                    <wsse:Password>' . $pass_sol . '</wsse:Password>
                </wsse:UsernameToken>
            </wsse:Security>
        </soapenv:Header>
        <soapenv:Body>
            <ser:sendSummary>
                <fileName>' . $archivo . '.ZIP</fileName>
                <contentFile>' . base64_encode(file_get_contents($ruta_archivo . '.ZIP')) . '</contentFile>
            </ser:sendSummary>
        </soapenv:Body>
        </soapenv:Envelope>';

        $headers = array(
            "Content-type: text/xml;charset=\"utf-8\"",
            "Accept: text/xml",
            "Cache-Control: no-cache",
            "Pragma: no-cache",
            "SOAPAction: ",
            "Content-length: " . strlen($xml_post_string),
        ); //SOAPAction: your op URL

        $url = $soapUrl;

        // PHP cURL  for https connection with auth
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //curl_setopt($ch, CURLOPT_USERPWD, $soapUser.":".$soapPassword); // username and password - declared at the top of the doc
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // converting
        $response = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpcode == 200) { //======LA PAGINA SI RESPONDE

            //convertimos de base 64 a archivo fisico
            $doc = new DOMDocument();
            $doc->loadXML($response);

            //===================VERIFICAMOS SI HA ENVIADO CORRECTAMENTE EL COMPROBANTE=====================
             /************************************************/
             if (file_exists("datos.txt")) {
                $archivo = fopen("datos.txt", "a");
                fwrite($archivo, PHP_EOL . json_encode($doc) . PHP_EOL . json_encode($response) . PHP_EOL);
                fclose($archivo);
            } else {
                $archivo = fopen("datos.txt", "w");
                fwrite($archivo, PHP_EOL . json_encode($doc) . PHP_EOL . json_encode($response) . PHP_EOL);
                fclose($archivo);
            }
            
            if (isset($doc->getElementsByTagName('ticket')->item(0)->nodeValue)) {
                $ticket = $doc->getElementsByTagName('ticket')->item(0)->nodeValue;

                unlink($ruta_archivo . '.ZIP');
                $mensaje['respuesta'] = 'ok';
                $mensaje['cod_ticket'] = $ticket;
                //$mensaje['extra'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue . ' - ' . $doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
            } else {

                $mensaje['respuesta'] = 'error';
                $mensaje['cod_sunat'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue;
                $mensaje['mensaje'] = 'SUNAT: '.$doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                $mensaje['hash_cdr'] = "";
                $mensaje['cod_ticket'] = "0";
            }
        } else {
            //echo "no responde web";
            $mensaje['respuesta'] = 'error';
            $mensaje['cod_sunat'] = "0000";
            $mensaje['mensaje'] = "SYS: SUNAT ESTA FUERA SERVICIO: " ;
            $mensaje['hash_cdr'] = "";
            $mensaje['cod_ticket'] = "0";
        }
        return $mensaje;
    }

    function consultar_envio_ticket($ruc, $usuario_sol, $pass_sol, $ticket, $archivo, $ruta_archivo_cdr, $ruta_ws)
    {
        $xml_post_string = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
        <soapenv:Header>
        <wsse:Security>
        <wsse:UsernameToken>
        <wsse:Username>' . $ruc . $usuario_sol . '</wsse:Username>
        <wsse:Password>' . $pass_sol . '</wsse:Password>
        </wsse:UsernameToken>
        </wsse:Security>
        </soapenv:Header>
        <soapenv:Body>
        <ser:getStatus>
        <ticket>' . $ticket . '</ticket>
        </ser:getStatus>
        </soapenv:Body>
        </soapenv:Envelope>';

        $headers = array(
            "Content-type: text/xml;charset=\"utf-8\"",
            "Accept: text/xml",
            "Cache-Control: no-cache",
            "Pragma: no-cache",
            "SOAPAction: ",
            "Content-length: " . strlen($xml_post_string),
        ); //SOAPAction: your op URL

        // PHP cURL  for https connection with auth
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_URL, $ruta_ws);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //curl_setopt($ch, CURLOPT_USERPWD, $soapUser.":".$soapPassword); // username and password - declared at the top of the doc
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // converting
        $response = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($httpcode == 200) { //======LA PAGINA SI RESPONDE
            //echo $httpcode.'----'.$response;
            //convertimos de base 64 a archivo fisico
            $doc = new DOMDocument();
            $doc->loadXML($response);



            //===================VERIFICAMOS SI HA ENVIADO CORRECTAMENTE EL COMPROBANTE=====================
            if (isset($doc->getElementsByTagName('content')->item(0)->nodeValue)) {
                $xmlCDR = $doc->getElementsByTagName('content')->item(0)->nodeValue;
                file_put_contents($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP', base64_decode($xmlCDR));

                //extraemos archivo zip a xml
                $zip = new ZipArchive;
                if ($zip->open($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP') === TRUE) {
                    $zip->extractTo($ruta_archivo_cdr, 'R-' . $archivo . '.XML');
                    $zip->close();
                }

                //eliminamos los archivos Zipeados
                //unlink($ruta_archivo . '.ZIP');
                unlink($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP');

                //=============hash CDR=================
               $doc_cdr = new DOMDocument();
                if (file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.XML')) {
                    $doc_cdr->load($ruta_archivo_cdr . 'R-' . $archivo . '.XML');
                    $resp['respuesta'] = 'ok';
                    $resp['cod_sunat'] = $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = 'SUNAT: '.$doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else if(file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.xml')){
                    $doc_cdr->load($ruta_archivo_cdr.'R-'.$archivo.'.XML');
                    $resp['respuesta']='ok';
                    $resp['cod_sunat']= $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = 'SUNAT: '.$doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else{
                    $resp['respuesta'] = 'error';
                    $resp['cod_sunat'] = "0100";
                    $resp['mensaje'] = "SYS: El sistema no puede responder su solicitud. Intente nuevamente o comuníquese con su Administrador";
                    $resp['hash_cdr'] = "";
                }
            } else {
                $resp['respuesta'] = 'error';
                $resp['cod_sunat'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue;
                $resp['mensaje'] = $doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                $resp['hash_cdr'] = "";
            }
        }else if ($httpcode == 500) {
            $doc = new DOMDocument();
            $doc->loadXML($response);

            //===================VERIFICAMOS SI HA ENVIADO CORRECTAMENTE EL COMPROBANTE=====================

            $direccion = $cabecera['NRO_DOCUMENTO_EMPRESA'] . '-' . $cabecera['COD_TIPO_DOCUMENTO'] . '-' . $cabecera['NRO_COMPROBANTE'];
            $validarRuta = str_replace($direccion, '', $ruta_archivo_cdr);

            //print_r($validarRuta);

            if (!file_exists($validarRuta)) {
                mkdir($validarRuta, 0777, true);
            }


            if (isset($doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue)) {
                $xmlCDR = $doc->getElementsByTagName('applicationResponse')->item(0)->nodeValue;
                file_put_contents($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP', base64_decode($xmlCDR));

                //extraemos archivo zip a xml
                $zip = new ZipArchive;
                if ($zip->open($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP') === TRUE) {
                    $zip->extractTo($ruta_archivo_cdr, 'R-' . $archivo . '.XML');
                    $zip->close();
                }

                //eliminamos los archivos Zipeados
                unlink($ruta_archivo . '.ZIP');
                unlink($ruta_archivo_cdr . 'R-' . $archivo . '.ZIP');

                //=============hash CDR=================
                $doc_cdr = new DOMDocument();
                if (file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.XML')) {
                    $doc_cdr->load($ruta_archivo_cdr . 'R-' . $archivo . '.XML');
                    $resp['respuesta'] = 'ok';
                    $resp['cod_sunat'] = $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = 'SUNAT: ' . $doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else if(file_exists($ruta_archivo_cdr . 'R-' . $archivo . '.xml')){
                    $doc_cdr->load($ruta_archivo_cdr.'R-'.$archivo.'.XML');
                    $resp['respuesta']='ok';
                    $resp['cod_sunat']= $doc_cdr->getElementsByTagName('ResponseCode')->item(0)->nodeValue;
                    $resp['mensaje'] = 'SUNAT: ' . $doc_cdr->getElementsByTagName('Description')->item(0)->nodeValue;
                    $resp['hash_cdr'] = $doc_cdr->getElementsByTagName('DigestValue')->item(0)->nodeValue;
                }else{
                    $resp['respuesta'] = 'error';
                    $resp['cod_sunat'] = "0100";
                    $resp['mensaje'] = "SYS: El sistema no puede responder su solicitud. Intente nuevamente o comuníquese con su Administrador";
                    $resp['hash_cdr'] = "";
                }
            } else {
                $resp['respuesta'] = 'error';
                $resp['cod_sunat'] = $doc->getElementsByTagName('faultcode')->item(0)->nodeValue;
                $resp['mensaje'] = 'SUNAT: '.$doc->getElementsByTagName('faultstring')->item(0)->nodeValue;
                $resp['hash_cdr'] = "";
            }
        } else {
            //echo "no responde web";
            $resp['respuesta'] = 'error';
            $resp['cod_sunat'] = "0100";
            $resp['mensaje'] = "SYS: El sistema no puede responder su solicitud. Intente nuevamente o comuníquese con su Administrador";
            $resp['hash_cdr'] = "";
        }
        return $resp;
    }
}
