<?php
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
	include "../controllers/validaciondedatos.php";
	include "../controllers/procesarcomprobante.php";

	error_reporting(E_ALL ^ E_NOTICE);
	// para aceptar la conexión desde cualquier origen
	header("Access-Control-Allow-Origin: *");

	// Permite los métodos GET, POST, PUT, DELETE
	header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
	//exit();
	//obtenemos la data de la solicitud
	$bodyRequest = file_get_contents("php://input");

	// Decodificamos y lo guardamos en un array
	$data = json_decode($bodyRequest, true);

	$array_emisor = get_array_emisor($data);
	$array_detalle = get_array_detalle($data);
	$array_cabecera = get_array_cabecera($data, $array_emisor);
	$tipodeproceso = (isset($data["header"]['tipo_proceso'])) ? $data["header"]['tipo_proceso'] : "1"; //(el número 3 es para prueba, el número 1 es para producción)

	//rutas y nombres de archivos_xml_sunat
	/*$url_base = '../archivos_xml_sunat/';
    $content_folder_xml = 'cpe_xml/';
	$content_firmas = 'certificados/';*/
	$url_base = '../archivos_xml_sunat/FE/';
	
	$nombre_archivo = $array_emisor['ruc'] . '-' . $data["header"]['cod_tipo_documento'] . '-' . $data["header"]['NRO_COMPROBANTE'];

	if ($tipodeproceso == '0') {
        //$ruta = $url_base . $content_folder_xml . 'produccion/' . $array_emisor['ruc'] . "/" . $nombre_archivo;
        //$ruta_cdr = $url_base . $content_folder_xml . 'produccion/' . $array_emisor['ruc'] . "/";
        //$ruta_firma = $url_base . $content_firmas . 'produccion/' . $array_emisor['ruc'] . '.pfx';
		$ruta = $url_base . $array_emisor['ruc'] . "/CPE/XML/"  . $nombre_archivo;
        $ruta_cdr = $url_base . $array_emisor['ruc'] . "/CDR/XML/";
        $ruta_firma = $url_base . $array_emisor['ruc'] . "/CPE/FIRMAXML/FIRMAXML.pfx";
		$pass_firma = $data['header']['CLAVE_FIRMA'];
        $ruta_ws = 'https://e-factura.sunat.gob.pe/ol-ti-itcpfegem/billService';
	}
	
    if ($tipodeproceso == '1') {
		//$ruta = $url_base . $content_folder_xml . 'beta/' . $array_emisor['ruc'] . "/" . $nombre_archivo;
        //$ruta_cdr = $url_base . $content_folder_xml . 'beta/' . $array_emisor['ruc'] . "/";
        //$ruta_firma = $url_base . $content_firmas.'beta/firmabeta.pfx';
		$ruta = $url_base . $array_emisor['ruc'] . "/CPE/BETA/"  . $nombre_archivo;
        $ruta_cdr = $url_base . $array_emisor['ruc'] . "/CDR/BETA/";
        $ruta_firma = "../archivos_xml_sunat/certificados/beta/firmabeta.pfx";
        $pass_firma = '123456';
        $ruta_ws = 'https://e-beta.sunat.gob.pe:443/ol-ti-itcpfegem-beta/billService';
	}

	$rutas = array();
    $rutas['nombre_archivo'] = $nombre_archivo;
    $rutas['ruta_xml'] = $ruta;
    $rutas['ruta_cdr'] = $ruta_cdr;
    $rutas['ruta_firma'] = $ruta_firma;
    $rutas['pass_firma'] = $pass_firma;
	$rutas['ruta_ws'] = $ruta_ws;
	
	$procesarcomprobante = new Procesarcomprobante();
	$resp = $procesarcomprobante->procesar_nota_de_credito($array_cabecera, $array_detalle, $rutas);
	$resp['ruta_xml'] = 'archivos_xml_sunat/cpe_xml/beta/20100066603/'.$nombre_archivo.'.XML';
	$resp['ruta_cdr'] = 'archivos_xml_sunat/cpe_xml/beta/20100066603/R-'.$nombre_archivo.'.XML';
	$resp['ruta_pdf'] = 'controllers/prueba.php?tipo=factura&id=0';
	$resp['ruta_xml'] = "";
	$resp['url_xml'] = "";
	$resp['ruta_cdr'] = "";
	echo json_encode($resp);
	exit();
	
	function get_array_cabecera($data, $emisor) {
		$cabecera = array(
			'TOTAL_INAFECTA' => $data['header']['TOTAL_INAFECTA'],
	        'TOTAL_EXONERADAS' => $data['header']['TOTAL_EXONERADAS'],
			'TOTAL_GRAVADAS' => $data["header"]['total_gravadas'],
	        //'POR_IGV' => $data["header"]['porcentaje_igv'], //Porcentaje del impuesto
	        'TOTAL_IGV' => $data["header"]['total_igv'],
	        'TOTAL' => $data["header"]['total'],
	        //==============================================
	        'TIPO_COMPROBANTE_MODIFICA' => $data["header"]['tipo_comprobante_modifica'],
	        'NRO_DOCUMENTO_MODIFICA' => $data["header"]['nro_documento_modifica'],
	        'COD_TIPO_MOTIVO' => $data["header"]['cod_tipo_motivo'],
	        'DESCRIPCION_MOTIVO' => $data["header"]['descripcion_motivo'],
	        //===============================================
	        'NRO_COMPROBANTE' => $data["header"]['NRO_COMPROBANTE'],//$data['serie_comprobante'].'-'.$data['numero_comprobante'],
			'FECHA_DOCUMENTO' => $data["header"]['fecha_comprobante'],
			'COD_TIPO_DOCUMENTO' => $data["header"]['cod_tipo_documento'],
	        'COD_MONEDA' => $data["header"]['cod_moneda'],
	        //==================================================
	        'NRO_DOCUMENTO_CLIENTE' => $data["header"]['cliente_numerodocumento'],
			'RAZON_SOCIAL_CLIENTE' => $data["header"]['cliente_nombre'],
			'TIPO_DOCUMENTO_CLIENTE' => $data["header"]['cliente_tipodocumento'],
	        //===============================================
			'NRO_DOCUMENTO_EMPRESA' => $emisor['ruc'],
			'TIPO_DOCUMENTO_EMPRESA' => $emisor['tipo_doc'], //RUC
			'NOMBRE_COMERCIAL_EMPRESA' => $emisor['nom_comercial'],
			'CODIGO_UBIGEO_EMPRESA' => $emisor['codigo_ubigeo'],
	        'DIRECCION_EMPRESA' => $emisor['direccion'],
	        'DEPARTAMENTO_EMPRESA' => $emisor['direccion_departamento'],
	        'PROVINCIA_EMPRESA' => $emisor['direccion_provincia'],
	        'DISTRITO_EMPRESA' => $emisor['direccion_distrito'],
			'CODIGO_PAIS_EMPRESA' => $emisor['direccion_codigopais'],
			'RAZON_SOCIAL_EMPRESA' => $emisor['razon_social'],
			'CONTACTO_EMPRESA' => "",
	        //===================CLAVES SOL EMISOR====================//
	        'EMISOR_RUC' => $emisor['ruc'],
	        'EMISOR_USUARIO_SOL' => $emisor['usuariosol'],
			'EMISOR_PASS_SOL' => $emisor['clavesol']
		);
		
		return $cabecera;
	}

	function get_array_detalle($data) {
		
		$posicion=1;
		
		for($colum=0; $colum<count($data["item"]); $colum++){
			$detalle_documento[$colum]["txtITEM"] = $posicion;
			
			$detalle_documento[$colum]['txtUNIDAD_MEDIDA_DET'] = $data["item"][$posicion]['txtUNIDAD_MEDIDA_DET'];
			$detalle_documento[$colum]['txtCANTIDAD_DET'] = $data["item"][$posicion]['txtCANTIDAD_DET'];
			$detalle_documento[$colum]['txtPRECIO_DET'] = $data["item"][$posicion]['txtPRECIO_DET'];
			$detalle_documento[$colum]['txtPRECIO_TIPO_CODIGO'] = $data["item"][$posicion]['txtPRECIO_TIPO_CODIGO'];
			$detalle_documento[$colum]['txtIGV'] = $data["item"][$posicion]['txtIGV'];
			$detalle_documento[$colum]['txtIMPORTE_DET'] = $data["item"][$posicion]['txtIMPORTE_DET'];
			$detalle_documento[$colum]['txtCOD_TIPO_OPERACION'] = $data["item"][$posicion]['txtCOD_TIPO_OPERACION'];
			$detalle_documento[$colum]['txtCODIGO_DET'] = $data["item"][$posicion]['txtCODIGO_DET'];
			$detalle_documento[$colum]['txtDESCRIPCION_DET'] = $data["item"][$posicion]['txtDESCRIPCION_DET'];
			$detalle_documento[$colum]['txtPRECIO_SIN_IGV_DET'] = $data["item"][$posicion]['txtPRECIO_SIN_IGV_DET'];
			$detalle_documento[$colum]['txtCODIGO_PROD_SUNAT'] = $data["item"][$posicion]['txtCODIGO_PROD_SUNAT'];
			
			$detalle_documento[$colum]["CODIGO_IMPUESTO"] = $data["item"][$posicion]['CODIGO_IMPUESTO'] ;
			$detalle_documento[$colum]["TIPO_IMPUESTO"] = $data["item"][$posicion]['TIPO_IMPUESTO'] ;
			$detalle_documento[$colum]["TIPO_CODIGO_IMPUESTO"] = $data["item"][$posicion]['TIPO_CODIGO_IMPUESTO'] ;
			$detalle_documento[$colum]["CODIGO_CATEGORIA_IMPUESTO"] = $data["item"][$posicion]['CODIGO_CATEGORIA_IMPUESTO'] ;
			$detalle_documento[$colum]["CODIGO_EXTENSION_IMPUESTO"] = $data["item"][$posicion]['CODIGO_EXTENSION_IMPUESTO'] ;
			
			$detalle_documento[$colum]['POR_IGV'] = $data["item"][$posicion]['porcentaje_igv'];
			
			$posicion++;
		}
		
		//$detalle_documento = $data['detalle'];
		return $detalle_documento;
	}

	function get_array_emisor($data) {
		$data_emisor = $data['emisor'];

		//si estamos ofreciendo un servicio de facturación electrónica, aquí podemos recibir el ruc, y el resto de datos podemos extraerlos desde nuestra base de datos.
		//en este caso, asumimos que todos los datos llegan desde la petición.

		$emisor['ruc'] 						= $data["header"]['ruc'];
		$emisor['tipo_doc'] 				= $data["header"]['tipo_doc'];
		$emisor['nom_comercial'] 			= $data["header"]['razon_social'];
		$emisor['razon_social'] 			= $data["header"]['razon_social'];
		$emisor['codigo_ubigeo'] 			= $data["header"]['codigo_ubigeo'];
		$emisor['direccion'] 				= $data["header"]['direccion'];
		$emisor['direccion_departamento'] 	= $data["header"]['direccion_departamento'];
		$emisor['direccion_provincia'] 		= $data["header"]['direccion_provincia'];
		$emisor['direccion_distrito'] 		= $data["header"]['direccion_distrito'];
		$emisor['direccion_codigopais'] 	= $data["header"]['direccion_codigopais'];
		$emisor['usuariosol'] 				= $data["header"]['usuariosol'];
		$emisor['clavesol'] 				= $data["header"]['clavesol'];

		//Todos los campos anteriores son obligatorios
		//Aquí se pueden generar todas las validaciones que se necesiten.
		//por ejemplo: si ruc está vacio, retornar un error

		return $emisor;
	}
?>