<?php
// RUTA para enviar documentos: Tu puedes definir tu propia ruta, en nustro caso la tenemos en la siguiente dirección
$ruta = "https://sistemadefacturacionelectronicasunat.com/sis_facturacion/api_facturacion/baja_sunat.php";

//se recomienda leer: http://cpe.sunat.gob.pe/sites/default/files/inline-images/Guia%2BXML%2BFactura%2Bversion%202-1%2B1%2B0%20%282%29.pdf

$data = array(
	
	//Cabecera del documento
	"codigo"						=> "RA",
	"serie"							=> date('Ymd'),
    "secuencia"             		=> (string)generar_numero_aleatorio(2),
    "fecha_referencia"             	=> date('Y-m-d'),
	"fecha_baja"            		=> date('Y-m-d'),

	//data de la empresa emisora o contribuyente que entrega el documento electrónico.
    "emisor" => array(
		"ruc"						=> "20100066603",
		"tipo_doc" 					=> "6",
		"nom_comercial" 			=> "Tu Empresa SRL",
		"razon_social" 				=> "Tu Empresa SRL",
		"codigo_ubigeo" 			=> "070104",
		"direccion"					=> "Jr. Puno 4654",
		"direccion_departamento" 	=> "LIMA",
		"direccion_provincia" 		=> "LIMA",
		"direccion_distrito" 		=> "LIMA",
		"direccion_codigopais" 		=> "PE",
		"usuariosol"				=> "MODDATOS",
		"clavesol"					=> "moddatos"
	),

	//items
    "detalle" => array( 
                    array(
                        "ITEM"          	=> "1",
                        "TIPO_COMPROBANTE"  => "01",
                        "SERIE"           	=> "F001",
                        "NUMERO"            => "456896",
                        "MOTIVO"          	=> "Error en Factura"
                    )
	)
);

//Invocamos el servicio
$token = ''; //en caso quieras utilizar algún token generado desde tu sistema

//codificamos la data
$data_json = json_encode($data);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $ruta);
curl_setopt(
	$ch, CURLOPT_HTTPHEADER, array(
	'Authorization: Token token="'.$token.'"',
	'Content-Type: application/json',
	)
);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,$data_json);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$respuesta  = curl_exec($ch);
curl_close($ch);

$response = json_decode($respuesta, true);

echo "=========== DATA RETORNO =============== ";
echo "<br /><br />respuesta	: ".$response['respuesta'];
echo "<br /><br />url_xml	: ".$response['url_xml'];
echo "<br /><br />hash_cpe	: ".$response['hash_cpe'];
echo "<br /><br />hash_cdr	: ".$response['hash_cdr'];
echo "<br /><br />msj_sunat	: ".$response['msj_sunat'];
echo "<br /><br />ruta_cdr	: http://sistemadefacturacionelectronicasunat.com/sis_facturacion/".$response['ruta_cdr'];
echo "<br /><br />ruta_pdf	: ".$response['ruta_pdf'];




function generar_numero_aleatorio($longitud) {
	$key = '';
	$pattern = '1234567890';
	$max = strlen($pattern)-1;
	for($i=0;$i < $longitud;$i++) $key .= $pattern{mt_rand(0,$max)};
	return $key;
}
?>