<?php

namespace App\Providers;

use App\Repositories\CustomerRepository;
use Illuminate\Support\ServiceProvider;
use App\Repositories\Interfaces\ICustomerRepository;
use App\Repositories\Interfaces\IQuotaRepository;
use App\Repositories\Interfaces\ISalesChannelRepository;
use App\Repositories\Interfaces\ITraderRepository;
use App\Repositories\Interfaces\ICustomerTypeRepository;
use App\Repositories\QuotaRepository;
use App\Repositories\SalesChannelRepository;
use App\Repositories\TraderRepository;
use App\Repositories\CustomerTypeRepository;
use App\Repositories\Interfaces\IReportRepository;
use App\Repositories\ReportRepository;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(ICustomerRepository::class, CustomerRepository::class);
        $this->app->bind(ITraderRepository::class, TraderRepository::class);
        $this->app->bind(ISalesChannelRepository::class, SalesChannelRepository::class);
        $this->app->bind(IQuotaRepository::class, QuotaRepository::class);
        $this->app->bind(ICustomerTypeRepository::class, CustomerTypeRepository::class);
        $this->app->bind(IReportRepository::class, ReportRepository::class);
    }
}


