<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});


$router->group(['prefix' => 'api/v1/'], function ($app) {
    $app->group(['prefix' => 'customer_type'], function () use ($app) {
        $app->get('/', 'CustomerTypeController@index');
        $app->get('/{id}', 'CustomerTypeController@show');
        $app->post('/', 'CustomerTypeController@store');
        $app->put('/{id}', 'CustomerTypeController@update');
        $app->delete('/{id}', 'CustomerTypeController@destroy');
    });

    $app->group(['prefix' => 'customer'], function () use ($app) {
        $app->get('/', 'CustomerController@index');
        $app->get('/{id}', 'CustomerController@show');
        $app->post('/', 'CustomerController@store');
        $app->put('/{id}', 'CustomerController@update');
        $app->delete('/{id}', 'CustomerController@destroy');
    });

    $app->group(['prefix' => 'traders'], function () use ($app) {
        $app->get('/', 'TraderController@index');
        $app->get('/{id}', 'TraderController@show');
        $app->post('/', 'TraderController@store');
        $app->put('/{id}', 'TraderController@update');
        $app->delete('/{id}', 'TraderController@destroy');
    });

    $app->group(['prefix' => 'sales_channels'], function () use ($app) {
        $app->get('/', 'SalesChannelController@index');
        $app->get('/{id}', 'SalesChannelController@show');
        $app->post('/', 'SalesChannelController@store');
        $app->put('/{id}', 'SalesChannelController@update');
        $app->delete('/{id}', 'SalesChannelController@destroy');
    });

    $app->group(['prefix' => 'quotas'], function () use ($app) {
        $app->get('/', 'QuotaController@index');
        $app->get('/{id}', 'QuotaController@show');
        $app->post('/', 'QuotaController@store');
        $app->put('/{id}', 'QuotaController@update');
        $app->delete('/{id}', 'QuotaController@destroy');
        $app->delete('/destroyquotabysale/{saleId}', 'QuotaController@destroyQuotaBySale');
    });

    $app->group(['prefix' => 'reports'], function() use($app){
        $app->get('/sales_report','ReportController@salesReport');
        $app->get('/sales','ReportController@getListAllSAles');
        $app->get('/sire','ReportController@reportSire');
    });

    $app->group(['prefix' => 'purchase_order'], function () use ($app) {
        $app->get('/', 'PurchaseOrderController@index');
        $app->get('/{id}', 'PurchaseOrderController@show');
        $app->post('/', 'PurchaseOrderController@store');
        $app->put('/{id}', 'PurchaseOrderController@update');
        $app->delete('/{id}', 'PurchaseOrderController@destroy');
    });
});
