<?php
namespace App\Repositories\Interfaces;

use App\Models\Trader;
use App\DTOs\Trader\TraderCreateDto;
use App\DTOs\Trader\TraderUpdateDto;

interface ITraderRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Trader;
    public function store(TraderCreateDto $store): Trader;
    public function update(TraderUpdateDto $store): void;
    public function destroy(int $id): void;
}
