<?php
namespace App\Repositories;

use Exception;
use App\Models\Quota;
use App\DTOs\Quota\QuotaCreateDto;
use App\DTOs\Quota\QuotaUpdateDto;
use App\Repositories\Interfaces\IQuotaRepository;
use Illuminate\Support\Facades\Log;

class QuotaRepository implements IQuotaRepository
{
    public function paginate(array $request)
    {
        $business_information = $request['business_information'];
        $ruc = $business_information['ruc_number'];
        if(isset($request['sale_id'])){
            $sale_id = $request['sale_id'];
        }else{
            $sale_id = "";
        }

        if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];
            $sale_id = $request['sale_id'];
            $query = Quota::where('status', '=', 1)->where('ruc', '=', $ruc);
            if($sale_id != "" && $sale_id != null){
                    $query->where('sale_id','=',$sale_id);
            }


            if (isset($request['search'])) {
                $search = $request['search'];

                return $query->orderBy($orderBy, $orderDir)
                    //->where('warehouse', 'like', '%'.$search.'%')
                    ->skip($start)
                    ->take($length)
                    ->get();
            } else {
                return $query->orderBy($orderBy, $orderDir)
                    ->skip($start)
                    ->take($length)
                    ->get();
            }
        } else {
            $query = Quota::where('status', '=', 1)->where('ruc', '=', $ruc);
            if($sale_id != "" && $sale_id != null){
                    $query->where('sale_id','=',$sale_id);
            }

            return $query->get();
        }
    }

    public function find(int $id): ?Quota
    {
        return Quota::find($id);
    }
    public function findBySale(int $idsales)
    {
        $query = Quota::where('sale_id','=',$idsales);
         return $query->get();
    }

    public function store(QuotaCreateDto $store): Quota
    {
        $entry = new Quota();
        $entry->ruc             =       $store->ruc;
        $entry->sale_id         =       $store->sale_id;
        $entry->quota           =       $store->quota;
        $entry->sunat_code      =       $store->sunat_code;
        $entry->description     =       $store->description;
        $entry->amount          =       $store->amount;
        $entry->amount_paid     =       $store->amount_paid;
        $entry->status_quota    =       $store->status_quota;
        $entry->payment_date    =       $store->payment_date;
        $entry->currency        =       $store->currency;
        $entry->created_by      =       $store->created_by;
        $entry->updated_by      =       $store->updated_by;
        $entry->created_at      =       $store->created_at;
        $entry->updated_at      =       $store->updated_at;
        $entry->status          =       $store->status;
        /*$entry->code = $store->code;*/
        $entry->save();

        return $entry;
    }

    public function update(QuotaUpdateDto $store): void
    {
        $entry = Quota::find($store->id);
        log::alert(json_encode($store));
        Quota::where('id', $store->id)->update([
            'status_quota' => $store->status_quota,
            'amount_paid' => $store->amount_paid,
            'updated_by' => $store->updated_by
        ]);

    }

    public function destroy(int $id): void
    {
        Quota::where('id', $id)->update([
            'status' => 0
        ]);
    }

    public function destroyQuotaBySale(int $saleId, string $ruc):void
    {
        Quota::where('sale_id', $saleId)->where('ruc', $ruc)->update([
            'status' => 0
        ]);
    }
}
