<?php

namespace App\Repositories\Interfaces;

use App\DTOs\SalesChannel\SalesChannelCreateDto;
use App\DTOs\SalesChannel\SalesChannelUpdateDto;
use App\Models\SalesChannel;


interface ISalesChannelRepository
{
    public function paginate(array $request);
    public function find(int $id): ?SalesChannel;
    public function store(SalesChannelCreateDto $store): SalesChannel;
    public function update(SalesChannelUpdateDto $store): void;
    public function destroy(int $id): void;
}
