<?php
namespace App\Repositories;

use Exception;
use App\Models\PaymentMethod;
use App\Models\Setting;
use App\Repositories\Interfaces\ISettingRepository;
use App\DTOs\Setting\SettingUpdateDto;

class SettingRepository implements ISettingRepository 
{
    public function listSetting()
    {
        $response = Setting::select("*")->first();
        return $response;
    }

    public function find(int $id): ?Setting
    {
        return Setting::find($id);
    }

    public function settingEdit(SettingUpdateDto $store): void
    {
        $entry = Setting::find($store->id);

        $entry-> logo = $store->logo;
        $entry-> site_name = $store->site_name;
        $entry-> tel = $store->tel;
        $entry-> dateformat = $store->dateformat;
        $entry-> timeformat = $store->timeformat;
        $entry-> default_email = $store->default_email;
        $entry-> language = $store->language;
        $entry-> version = $store->version;
        $entry-> theme = $store->theme;
        $entry-> timezone = $store->timezone;
        $entry-> protocol = $store->protocol;
        $entry-> smtp_host = $store->smtp_host;
        $entry-> smtp_user = $store->smtp_user;
        $entry-> smtp_pass = $store->smtp_pass;
        $entry-> smtp_port = $store->smtp_port;
        $entry-> smtp_crypto = $store->smtp_crypto;
        $entry-> mmode = $store->mmode;
        $entry-> captcha = $store->captcha;
        $entry-> mailpath = $store->mailpath;
        $entry-> currency_prefix = $store->currency_prefix;
        $entry-> default_customer = $store->default_customer;
        $entry-> default_tax_rate = $store->default_tax_rate;
        $entry-> rows_per_page = $store->rows_per_page;
        $entry-> total_rows = $store->total_rows;
        $entry-> header = $store->header;
        $entry-> footer = $store->footer;
        $entry-> bsty = $store->bsty;
        $entry-> display_kb = $store->display_kb;
        $entry-> default_category = $store->default_category;
        $entry-> default_discount = $store->default_discount;
        $entry-> item_addition = $store->item_addition;
        $entry-> barcode_symbology = $store->barcode_symbology;
        $entry-> pro_limit = $store->pro_limit;
        $entry-> decimals = $store->decimals;
        $entry-> thousands_sep = $store->thousands_sep;
        $entry-> decimals_sep = $store->decimals_sep;
        $entry-> focus_add_item = $store->focus_add_item;
        $entry-> add_customer = $store->add_customer;
        $entry-> toggle_category_slider = $store->toggle_category_slider;
        $entry-> cancel_sale = $store->cancel_sale;
        $entry-> suspend_sale = $store->suspend_sale;
        $entry-> print_order = $store->print_order;
        $entry-> print_bill = $store->print_bill;
        $entry-> finalize_sale = $store->finalize_sale;
        $entry-> today_sale = $store->today_sale;
        $entry-> open_hold_bills = $store->open_hold_bills;
        $entry-> close_register = $store->close_register;
        $entry-> java_applet = $store->java_applet;
        $entry-> receipt_printer = $store->receipt_printer;
        $entry-> pos_printers = $store->pos_printers;
        $entry-> cash_drawer_codes = $store->cash_drawer_codes;
        $entry-> char_per_line = $store->char_per_line;
        $entry-> rounding = $store->rounding;
        $entry-> pin_code = $store->pin_code;
        $entry-> stripe = $store->stripe;
        $entry-> stripe_secret_key = $store->stripe_secret_key;
        $entry-> stripe_publishable_key = $store->stripe_publishable_key;
        $entry-> purchase_code = $store->purchase_code;
        $entry-> envato_username = $store->envato_username;
        $entry-> default_warehouse = $store->default_warehouse;
        $entry-> invoice_format = $store->invoice_format;
        $entry-> bill_format = $store->bill_format;
        $entry-> invoice_number = $store->invoice_number;
        $entry-> bill_number = $store->bill_number;
        $entry-> nventa_format = $store->nventa_format;
        $entry-> nventa_number = $store->nventa_number;
        $entry-> note_credit_invoice_format = $store->note_credit_invoice_format;
        $entry-> note_credit_invoice_number = $store->note_credit_invoice_number;
        $entry-> note_credit_bill_format = $store->note_credit_bill_format;
        $entry-> note_credit_bill_number = $store->note_credit_bill_number;
        $entry-> referral_guide_format = $store->referral_guide_format;
        $entry-> referral_guide_number = $store->referral_guide_number;
        // $entry-> quotation_format = $store->quotation_format;
        // $entry-> quotation_number = $store->quotation_number;
        $entry-> beta = $store->beta;
        $entry-> habilita_btn_pago = $store->habilita_btn_pago;
        $entry-> habilita_btn_caja = $store->habilita_btn_caja;
        $entry-> logo_auth = $store->logo_auth;
        $entry-> pos_logo = $store->pos_logo;
        $entry-> logo_pdf = $store->logo_pdf;
        $entry-> type_imagen_pdf = $store->type_imagen_pdf;
        $entry-> advanced_sale = $store->advanced_sale;
        $entry-> tax_icbper = $store->tax_icbper;
        $entry-> mail_incidents = $store->mail_incidents;
        $entry-> pdf_format = $store->pdf_format;
        $entry-> type_Print = $store->type_Print;
        $entry-> summaries_limit = $store->summaries_limit;
        $entry-> ubicacion_XML = $store->ubicacion_XML;
        $entry-> direccion = $store->direccion;
        $entry-> region = $store->region;
        $entry-> pais = $store->pais;
        // $entry-> razon_social = $store->razon_social;
        // $entry-> ruc = $store->ruc;
        $entry-> pass_firma = $store->pass_firma;
        $entry-> user_sol = $store->user_sol;
        $entry-> pass_sol = $store->pass_sol;
        $entry-> beta_pass_firma = $store->beta_pass_firma;
        $entry-> beta_user_sol = $store->beta_user_sol;
        $entry-> beta_pass_sol = $store->beta_pass_sol;
        $entry-> negocio = $store->negocio;
        $entry-> client_id = $store->client_id;
        $entry-> client_pass = $store->client_pass;
        $entry-> beta_client_id = $store->beta_client_id;
        $entry-> beta_client_pass = $store->beta_client_pass;
        $entry-> retencion = $store->retencion;
        $entry-> gratuito = $store->gratuito;
        $entry-> detraction = $store->detraction;
        $entry-> account_bank_number = $store->account_bank_number;

        $entry->save();
    }
}
