<?php
namespace App\Repositories;

use Exception;
use App\Models\DetractionType;
use App\Repositories\Interfaces\IDetractionTypeRepository;

class DetractionTypeRepository implements IDetractionTypeRepository
{
    public function get(array $request)
    {
        return DetractionType::select('id', 'code', 'descripcion', 'detraction_percent')
            ->where('status', 1)
            ->get();
    }

    public function find(int $id): ?DetractionType
    {
        return DetractionType::select('id', 'code', 'descripcion', 'detraction_percent')
        ->where('id', $id)
        ->where('status', 1)
        ->first();
    }

}
