<?php 

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Repositories\Interfaces\IOperationTypeRepository;
use Illuminate\Http\Request;

class OperationTypeController extends Controller
{
    private $operationTypeRepository;

    public function __construct(IOperationTypeRepository $operationTypeRepository)
    {
        $this->operationTypeRepository = $operationTypeRepository;
    }

    public function index()
    {
        // Obtener la lista de tipos de operación
        $operationTypes = $this->operationTypeRepository->get([]);

        // Construir la respuesta
        $response = [
            "result" => "ok",
            "data" => [
                "total" => count($operationTypes),
                "list" => $operationTypes
            ],
            "message" => ""
        ];

        // Devolver la respuesta como JSON
        return response()->json($response);
    }

    public function show($id)
    {
        // Obtener el tipo de operación por su ID
        $operationType = $this->operationTypeRepository->find($id);

        if (!$operationType) {
            // Si no se encuentra el tipo de operación, devolver una respuesta con un mensaje de error
            $response = [
                "result" => "error",
                "data" => null,
                "message" => "Tipo de operación no encontrado"
            ];

            return response()->json($response, 404);
        }

        // Construir la respuesta
        $response = [
            "result" => "ok",
            "data" => $operationType,
            "message" => ""
        ];

        // Devolver la respuesta como JSON
        return response()->json($response);
    }
}