<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Repositories\Interfaces\ISettingRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\DTOs\Setting\SettingUpdateDto;
use Exception;

use Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver;
use Illuminate\Validation\Rule;

class SettingController extends Controller
{
    private $settingRepository="";
    private $errorConnection = "";
    public function __construct(Request $request, ISettingRepository $iSettingRepository)
    {
        if (isset($request['business_information'])) {
            $business_information = $request['business_information'];
            $ruc = $business_information['ruc_number'];
            $this->settingRepository = $iSettingRepository;
            $existe_conexion = $this->setDBClient($ruc);
            if($existe_conexion['error']){
                $this->errorConnection=$existe_conexion['message'];
                return $this->messageError("Se espera un número de RUC válido.", 201);
            }
        } else {
            $this->errorConnection='Error en la conexión. Se espera número de RUC';
        }

    }
    public function settingList(Request $request)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201);
        }
        $response=$this->settingRepository->listSetting();
        return Response()->json($response);
    }

    public function settingEdit(int $id, Request $request)
    {
        try{
            if ($this->errorConnection != '') {
                return $this->messageError($this->errorConnection, 500);
            }
            $result = $this->settingRepository->find($id);

            if($result){
                $business_information = $request['business_information'];
                $business_ruc = $business_information['ruc_number'];

                $valoresEspeciales = [
                    'F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 'F10', 'F11', 'F12',
                    'CTRL', 'ALT', 'SHIFT'
                ];

                function convertOnToOne($value) {
                    return $value === 'on' ? '1' : $value;
                }
            
                // Aplicar la función a los campos antes de la validación
                $request->merge([
                    'retencion' => convertOnToOne($request->input('retencion')),
                    'gratuito' => convertOnToOne($request->input('gratuito')),
                    'detraction' => convertOnToOne($request->input('detraction')),
                ]);


                $this->validate($request, [
                    'site_name' => 'required|max:255',
                    //'logo' => 
                    'tel' => 'required|digits_between:6,20|numeric',
                    'language' => 'required|in:spanish,english',
                    'currency_prefix' => 'required|in:PEN,USD|min:3|max:3',/*moneda*/
                    'default_discount' => 'required|numeric',/*descuento*/
                    'default_tax_rate' => 'required|between:1,99|numeric',/*IGV*/
                    'pin_code' => 'required|numeric',/*codigo PIN*/
                    'display_kb' => 'required|in:0,1',/*mostrar teclado*/
                    'item_addition' => 'required|in:0,1',/*adicion de articulo*/
                    'default_category' => 'required',/*categoria predeterminada*/
                    'default_customer' => 'required|exists:mysql_client.tec_customers,id',/*cliente estandar*/
                    'default_warehouse' => 'required',/*almacen por defecto*/
                    'rows_per_page' => 'required|in:10,25,50,100',/*filas por pagina*/
                    'rounding' => 'required|in:0,1,2,3,5',/*redondeo*/
                    'bsty' => 'required|in:1,2,3',/*mostrar productos por*/
                    'pro_limit' => 'required|numeric',/*limite de productos mostrados*/
                    'default_email' => 'required|email',/*email de respuesta*/
                    // 'advanced_sale' => 'required|in:0,1',/*venta avanzada*/ 
                    'tax_icbper' => 'required',/*bolsa plastica*/
                    'type_Print' => 'required|in:0,1',/*tipo de impresion*/

                    'account_bank_number' => 'numeric',
                    
                    'pdf_format' => 'required|in:1,2',/*pdf por defecto*/
                    'invoice_format' => 'required|regex:/^[F]\d{3}-\{\d{1,9}\}$/',/*formato de factura*/
                    'bill_format' => 'required|regex:/^B[A-Z0-9][0-9]{2}-\{\d{1,9}\}$/',/*formato de boleta*/
                    'nventa_format' => 'required|regex:/^[A-Z]{2}\d{3}-\{\d{1,9}\}$/',/*formato de nota de venta*/
                    /*formato de fecha*/
                    'dateformat' => 'required|in:d/m/Y,Y/m/d,d-m-Y,Y-m-d',
                    'timeformat' => 'required|in:H:i:s,h:i:s A',/*formato de horario*/
                    'mail_incidents' => 'required|email',/*email de incidencias*/
                    'protocol' => 'required|in:mail,sendmail,smtp',/*protocolo de email*/
                    'smtp_host' => [
                        'required',
                        function ($attribute, $value, $fail) {
                            // Verifica si el host existe utilizando la función gethostbyname
                            $ip = gethostbyname($value);
                            if ($ip === $value) {
                                $fail("El host ingresado en el campo SMTP Host es incorrecto.");
                            }
                        },
                    ],
                    'smtp_user' => 'required|email',/*smtp usuario*/
                    'smtp_pass' => 'required|max:255',/*smtp contraseña*/
                    'smtp_port' => 'required|numeric|digits_between:1,5',/*smtp puerta*/
                    'smtp_crypto' => 'required|in:tls,ssl',
                    'focus_add_item' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Agregar/Buscar Producto contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'add_customer' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Agregar Cliente contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'cancel_sale' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Cancelar Venta contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'toggle_category_slider' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Cambiar Categoría Slider contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'suspend_sale' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Suspender Venta contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'print_order' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Ver Artículos contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'print_bill' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Ver Factura contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'finalize_sale' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Finalizar Venta contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'today_sale' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Venta del Dia contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'open_hold_bills' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Cuentas Abiertas contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'close_register' => [
                        'required',
                        function ($attribute, $value, $fail) use ($valoresEspeciales) {
                            $combinaciones = explode('+', $value);

                            foreach ($combinaciones as $combinacion) {
                                if (!in_array($combinacion, $valoresEspeciales)) {
                                    $fail("El campo Cerrar Caja contiene una combinación no válida: $combinacion o está en minúsculas");
                                }
                            }
                        }
                    ],
                    'direccion' => 'required|max:255',
                    'region' => 'required|max:255',
                    'pais' => 'required|max:255',
                    'header' => 'required',/*encabezado de la cuenta img*/
                    'footer' => 'required',/*pie de pagina*/
                    // 'ruc' => 'required|in:10123456781',
                    // 'razon_social' => 'required|in:DEMO',
                    'beta' => 'required|in:0,1',/*modo BETA*/
                    'beta_user_sol' => 'required_if:beta,1|min:8|max:8', /*usuario beta*/
                    'beta_pass_sol' => 'required_if:beta,1',/*contraseña beta*/
                    'beta_pass_firma' => 'required_if:beta,1',
                    'user_sol' => 'required_if:beta,0|min:8|max:8',
                    'pass_sol' => 'required_if:beta,0',
                    'client_id',
                    'client_pass',
                    'pass_firma' => 'required_if:beta,0',
                    'note_credit_invoice_format' => 'required|regex:/^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/',
                    'note_credit_bill_format' => 'required|regex:/^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/',
                    'referral_guide_format' => 'required|regex:/^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/',
                    //'quotation_format' => 'required|regex:/^[A-Z][A-Z0-9][0-9]{2}-\{\d{1,9}\}$/',
                    'type_imagen_pdf' => 'in:1,2',
                    // 'negocio' => 'required|in:0,1',
                    // 'habilita_btn_pago' => 'required|in:0,1',
                    // 'habilita_btn_caja' => 'required|in:0,1',
                    // 'pos_logo' => 'required|in:1,2', 
                    //'mailpath' => 'email',
                    // 'traders' => 'required|in:0,1',
                    'retencion' => 'required|in:0,1',
                    'gratuito' => 'required|in:0,1',
                    'detraction' => 'required|in:0,1',
                ],[
                    'max' => [
                        'string' => 'El campo :attribute no debe exceder :max caracteres.',
                    ],
                    'site_name.required' => 'El campo Nombre es obligatorio.',
                    'site_name.max' => 'El campo Nombre solo acepta :max caracteres.',

                    'tel.required' => 'El campo Telefono es obligatorio.',
                    'tel.digits_between' => 'El campo Telefono debe tener entre :min y :max dígitos.',
                    'tel.numeric' => 'El campo Telefono debe ser numerico.',

                    'language.required' => 'El campo Idioma es obligatorio.',
                    'language.in' => 'El Idioma seleccionado no esta disponible.',

                    'currency_prefix.required' => 'El campo Moneda es obligatorio.',
                    'currency_prefix.in' => 'El tipo de moneda seleccionado no esta disponible.',
                    'currency_prefix.min' => 'El campo Moneda solo acepta tres caracteres.',
                    'currency_prefix.max' => 'El campo Moneda solo acepta tres caracteres.',

                    'default_discount.required' => 'El campo Descuento Estandar es obligatorio.',
                    'default_discount.numeric' => 'El campo Descuento debe ser numerico.',

                    'default_tax_rate.required' => 'El campo IGV es obligatorio.',
                    'default_tax_rate.numeric' => 'El campo IGV debe ser numerico.',
                    'default_tax_rate.between' => 'El campo IGV debe estar entre :min y :max.',

                    'pin_code.required' => 'El campo Codigo PIN es obligatorio.',
                    'pin_code.numeric' => 'El campo Codigo Pin debe ser numerico.',

                    'display_kb.required' => 'El campo Mostrar Teclado es obligatorio.',
                    'display_kb.in' => 'El campo Mostrar Teclado debe ser 0 o 1.',

                    'item_addition.required' => 'El campo Adicion de Articulo es obligatorio.',
                    'item_addition.in' => 'El campo Adicion de Articulo debe ser 0 o 1.',

                    'default_category.required' => 'El campo Categoria Predeterminada es obligatorio.',

                    'default_customer.required' => 'El campo Categoria Predeterminada es obligatorio.',
                    'default_customer.exists' => 'El Cliente no existe.',

                    'default_warehouse.required' => 'El campo Almacen por Defecto es obligatorio.',

                    'rows_per_page.required' => 'El campo Filas por Pagina es obligatorio.',
                    'rows_per_page.in' => 'El campo Filas por Pagina debe ser 10, 25, 50 o 100.',

                    'rounding.required' => 'El campo Redondeo es obligatorio.',
                    'rounding.in' => 'El campo Redondeo debe ser 0, 1, 2, 3 o 5.',

                    'bsty.required' => 'El campo Mostrar Producto es obligatorio.',
                    'bsty.in' => 'El campo Mostrar Producto debe ser 1,2 o 3.',

                    'pro_limit.required' => 'El campo Limite de Productos Mostrados es obligatorio.',
                    'pro_limit.numeric' => 'El campo Limite de Productos Mostrados debe ser numerico.',

                    'default_email.required' => 'El campo Email de Respuesta es obligatorio.',
                    'default_email.email' => 'El campo Email de Respuesta no es valido.',
                    
                    'mailpath.email' => 'El campo Direccion de Correo no es valido.',

                    'advanced_sale.required' => 'El campo Venta Avanzada es obligatorio.',
                    'advanced_sale.in' => 'El campo Venta Avanzada debe ser 0 o 1.',

                    'tax_icbper.required' => 'El campo Bolsa Plastica es obligatorio.',

                    'type_Print.required' => 'El campo Tipo de Impresion es obligatorio.',
                    'type_Print.in' => 'El campo Tipo de Impresion debe ser 0 o 1.',

                    'pdf_format.required' => 'El campo PDF por Defecto es obligatorio.',
                    'pdf_format.in' => 'El campo PDF por Defecto debe ser 1 o 2.',

                    'invoice_format.required' => 'El campo Formato de Factura es obligatorio.',
                    'invoice_format.regex' => 'El campo Formato de Factura no cumple con el formato requerido. (Ejemplo: F002-{0000000})',

                    'bill_format.required' => 'El campo Formato de Boleta es obligatorio.',
                    'bill_format.regex' => 'El campo Formato de Boleta no cumple con el formato requerido. (Ejemplo: B003-{0000000})',

                    'nventa_format.required' => 'El campo Formato de Nota de Venta es obligatorio.',
                    'nventa_format.regex' => 'El campo Formato de Nota de Venta no cumple con el formato requerido. (Ejemplo: NV001-{0000})',

                    'dateformat.required' => 'El campo Formato de Fecha es obligatorio.',
                    'dateformat.in' => 'El campo Formato de Fecha no cumple con el formato requerido.',

                    'timeformat.required' => 'El campo Formato de Hora es obligatorio.',
                    'timeformat.date_format' => 'El campo Formato de Hora no cumple con el formato requerido. (Ejemplo: H:i:s)',

                    'mail_incidents.required' => 'El campo Email de Incidencias es obligatorio.',
                    'mail_incidents.email' => 'El campo Email de Incidencias no es valido.',

                    'protocol.required' => 'El campo Protocolo de Email es obligatorio.',
                    'protocol.in' => 'El campo Protocolo de Email debe ser mail, sendmail o smtp.',

                    'smtp_host.required' => 'El campo SMTP Host es obligatorio.',

                    'smtp_user.required' => 'El campo SMTP Usuario es obligatorio.',
                    'smtp_user.email' => 'El campo SMTP Usuario no es valido.',

                    'smtp_pass.required' => 'El campo SMTP Contraseña es obligatorio.',
                    'smtp_pass.max' => 'El campo SMTP Contraseña tiene como maximo 255 caracteres.',

                    'smtp_port.required' => 'El campo SMTP Puerta es obligatorio.',
                    'smtp_port.numeric' => 'El campo SMTP Puerta es numérico.',
                    'smtp_port.digits_between' => 'El campo SMTP Puerta debe tener entre 1 y 5 digitos.',

                    'smtp_crypto.required' => 'El campo SMTP Encriptación es obligatorio.',
                    'smtp_crypto.in' => 'El campo SMTP Encriptación debe ser tls o ssl.',

                    'focus_add_item.required' => 'El campo Agregar/Buscar Producto es obligatorio.',

                    'add_customer.required' => 'El campo Agregar Cliente es obligatorio.',
                    
                    'cancel_sale.required' => 'El campo Cancelar Venta es obligatorio.',

                    'toggle_category_slider.required' => 'El campo Cambiar Categoría Slider es obligatorio.',

                    'suspend_sale.required' => 'El campo Suspender Venta es obligatorio.',

                    'print_order.required' => 'El campo Ver Artículos es obligatorio.',

                    'print_bill.required' => 'El campo Ver Factura es obligatorio.',

                    'finalize_sale.required' => 'El campo Finalizar Venta es obligatorio.',

                    'today_sale.required' => 'El campo Venta del Día es obligatorio.',

                    'open_hold_bills.required' => 'El campo Cuentas Abiertas es obligatorio.',

                    'open_hold_bills.required' => 'El campo Cerrar Caja es obligatorio.',

                    'direccion.required' => 'El campo Dirección es obligatorio.',
                    'direccion.max' => 'El campo Dirección solo acepta :max caracteres.',

                    'region.required' => 'El campo Región es obligatorio.',
                    'region.max' => 'El campo Región solo acepta :max caracteres.',

                    'pais.required' => 'El campo País es obligatorio.',
                    'pais.max' => 'El campo País solo acepta :max caracteres.',

                    'header.required' => 'El campo Encabezado de la Cuenta es obligatorio.',

                    'footer.required' => 'El campo Pie de Página es obligatorio.',

                    'ruc.required' => 'El campo RUC es obligatorio.',
                    'ruc.in' => 'El campo RUC no es editable.',

                    'beta.required' => 'El botón en modo BETA necesita su valor 1.',
                    'beta.in' => 'El botón en modo BETA es 0 o 1.',

                    'beta_user_sol.required_if' => 'El campo Usuario-Beta es requerido',
                    'beta_user_sol.min' => 'El campo Usuario-Beta debe tener 8 dígitos',
                    'beta_user_sol.max' => 'El campo Usuario-Beta debe tener 8 dígitos',

                    'beta_pass_sol.required_if' => 'El campo Contraseña-Beta es requerido',

                    'beta_client_id.required_if' => 'El campo Client ID-Beta es requerido',

                    'beta_client_pass.required_if' => 'El campo Client secret-Beta es requerido',

                    'beta_pass_firma.required_if' => 'El campo Contraseña de archivo .pfx-Beta es requerido',

                    'user_sol.required_if' => 'El campo Usuario es requerido',
                    'user_sol.min' => 'El campo Usuario debe tener 8 dígitos',
                    'user_sol.max' => 'El campo Usuario debe tener 8 dígitos',

                    'pass_sol.required_if' => 'El campo Contraseña Usuario es requerido',

                    'client_id.required_if' => 'El campo Client ID es requerido',

                    'client_pass.required_if' => 'El campo Client secret es requerido',

                    'pass_firma.required_if' => 'El campo Contraseña de Archivo .pfx es requerido',

                    'retencion.required' => 'El campo Retencion es requerido',
                    'retencion.in' => 'El campo Retencion solo puede ser 0 o 1',

                    'gratuito.required' => 'El campo Gratuito es requerido',
                    'gratuito.in' => 'El campo Gratuito solo puede ser 0 o 1',

                    'detraction.required' => 'El campo Detraccion es requerido',
                    'detraction.in' => 'El campo Detraccion solo puede ser 0 o 1',

                    'account_bank_number.numeric' => 'El numero de cuenta solo puede ser numerico.',

                    'note_credit_invoice_format.required' => 'El Formato de Factura de Nota de Crédito es requerido',                    
                    'note_credit_invoice_format.regex' => 'El Formato de Factura de Nota de Crédito no cumple con el formato requerido. (Ejemplo: B003-{0000000})',
                    
                    'note_credit_bill_format.required' => 'El Formato de Boleta de Nota de Crédito es requerido',                    
                    'note_credit_bill_format.regex' => 'El Formato de Boleta de Nota de Crédito no cumple con el formato requerido. (Ejemplo: B003-{0000000})', 
                    
                    'referral_guide_format.required' => 'El Formato de Guia de Referencia es requerido',                    
                    'referral_guide_format.regex' => 'El Formato de Guia de Referencia no cumple con el formato requerido. (Ejemplo: B003-{0000000})', 

                    // 'quotation_format.required' => 'El Formato de la Cotizacion es requerido',                    
                    // 'quotation_format.regex' => 'El Formato de la Cotizacion no cumple con el formato requerido. (Ejemplo: B003-{0000000})', 

                    'type_imagen_pdf.in' => 'El campo Tipo de Imagen PDF debe ser 1 o 2',

                    // 'negocio.required' => 'El campo Negocio es requerido',
                    // 'negocio.in' => 'El campo Negocio debe ser 0 o 1',

                    // 'habilita_btn_pago.required' => 'El campo Habilitar Pago es requerido',
                    // 'habilita_btn_pago.in' => 'El campo Habilitar Pago debe ser 0 o 1',

                    // 'habilita_btn_caja.required' => 'El campo Habilitar Caja es requerido',
                    // 'habilita_btn_caja.in' => 'El campo Habilitar Caja debe ser 0 o 1',

                    // 'pos_logo.required' => 'El campo Posicion de Logo es requerido',
                    // 'pos_logo.in' => 'El campo Posicion de Logo puede ser 0 o 1',
                    
                    'retencion.required' => 'El campo Retencion es requerido',
                    'retencion.in' => 'El campo Retencion puede ser 0 o 1',
                    
                    'gratuito.required' => 'El campo Gratuito es requerido',
                    'gratuito.in' => 'El campo Gratuito puede ser 0 o 1',
                    // 'negocio.required' => 'El campo Negocio es requerido',
                    // 'negocio.in' => 'El campo Negocio debe ser 0 o 1',

                    // 'habilita_btn_pago.required' => 'El campo Habilitar Pago es requerido',
                    // 'habilita_btn_pago.in' => 'El campo Habilitar Pago debe ser 0 o 1',

                    // 'habilita_btn_caja.required' => 'El campo Habilitar Caja es requerido',
                    // 'habilita_btn_caja.in' => 'El campo Habilitar Caja debe ser 0 o 1',

                    // 'pos_logo.required' => 'El campo Posicion de Logo es requerido',
                    // 'pos_logo.in' => 'El campo Posicion de Logo puede ser 0 o 1',

                    // 'traders.required' => 'El campo Vendedor es requerido',
                    // 'traders.in' => 'El campo Vendedor puede ser 0 o 1',
                    
                ]);
                $entry = new SettingUpdateDto();
                //\Log::error($result);
                $entry-> id=$id;
                (isset($request['logo']) && !empty($request['logo'])) ? $entry-> logo = $request['logo'] : $entry-> logo = $result->logo;                
                $entry-> site_name = $request['site_name'];
                $entry-> tel = $request['tel'];
                $entry-> dateformat = $request['dateformat'];
                $entry-> timeformat = $request['timeformat'];
                $entry-> default_email = $request['default_email'];
                $entry-> language = $request['language'];
                /**/$entry-> version = $result->version;
                /**/$entry-> theme = $result->theme;
                /**/$entry-> timezone = $result->timezone;
                $entry-> protocol = $request['protocol'];
                $entry-> smtp_host = $request['smtp_host'];
                $entry-> smtp_user = $request['smtp_user'];
                $entry-> smtp_pass = $request['smtp_pass'];
                $entry-> smtp_port = $request['smtp_port'];
                $entry-> smtp_crypto = $request['smtp_crypto'];
                /**/$entry-> mmode = $result->mmode;
                /**/$entry-> captcha = $result->captcha;
                /*(isset($request['mailpath']) && !empty($request['mailpath'])) ? $entry-> mailpath = $request['mailpath'] :*/$entry-> mailpath = $result->mailpath;
                $entry-> currency_prefix = $request['currency_prefix'];
                $entry-> default_customer = $request['default_customer'];
                $entry-> default_tax_rate = $request['default_tax_rate'];
                $entry-> rows_per_page = $request['rows_per_page'];
                /**/$entry-> total_rows = $result->total_rows;
                $entry-> header = $request['header'];
                $entry-> footer = $request['footer'];
                $entry-> bsty = $request['bsty'];
                $entry-> display_kb = $request['display_kb'];
                $entry-> default_category = $request['default_category'];
                $entry-> default_discount = $request['default_discount'];
                $entry-> item_addition = $request['item_addition'];
                /**/$entry-> barcode_symbology = $result->barcode_symbology;
                $entry-> pro_limit = $request['pro_limit'];
                /**/$entry-> decimals = $result->decimals;
                /**/$entry-> thousands_sep = $result->thousands_sep;
                /**/$entry-> decimals_sep = $result->decimals_sep;
                $entry-> focus_add_item = $request['focus_add_item'];
                $entry-> add_customer = $request['add_customer'];
                $entry-> cancel_sale = $request['cancel_sale'];
                $entry-> toggle_category_slider = $request['toggle_category_slider'];
                $entry-> suspend_sale = $request['suspend_sale'];
                $entry-> print_order = $request['print_order'];
                $entry-> print_bill = $request['print_bill'];
                $entry-> finalize_sale = $request['finalize_sale'];
                $entry-> today_sale = $request['today_sale'];
                $entry-> open_hold_bills = $request['open_hold_bills'];
                $entry-> close_register = $request['close_register'];
                /**/$entry-> java_applet = $result->java_applet;
                /**/$entry-> receipt_printer = $result->receipt_printer;
                /**/$entry-> pos_printers = $result->pos_printers;
                /**/$entry-> cash_drawer_codes = $result->cash_drawer_codes;
                /**/$entry-> char_per_line = $result->char_per_line;
                $entry-> rounding = $request['rounding'];
                $entry-> pin_code = $request['pin_code'];
                /**/$entry-> stripe = $result->stripe;
                /**/$entry-> stripe_secret_key = $result->stripe_secret_key;
                /**/$entry-> stripe_publishable_key = $result->stripe_publishable_key;
                /**/$entry-> purchase_code = $result->purchase_code;
                /**/$entry-> envato_username = $result->envato_username;
                $entry-> default_warehouse = $request['default_warehouse'];
                $entry-> invoice_format = $request['invoice_format'];
                $entry-> bill_format = $request['bill_format'];
                /**/$entry-> invoice_number = $result->invoice_number;
                /**/$entry-> bill_number = $result->bill_number;
                $entry-> nventa_format = $request['nventa_format'];
                /**/$entry-> nventa_number = $result->nventa_number;
                $entry-> note_credit_invoice_format = $request['note_credit_invoice_format'];
                /**/$entry-> note_credit_invoice_number = $result->note_credit_invoice_number;
                $entry-> note_credit_bill_format = $request['note_credit_bill_format'];
                /**/$entry-> note_credit_bill_number = $result->note_credit_bill_number;
                $entry-> referral_guide_format = $request['referral_guide_format'];
                /**/$entry-> referral_guide_number = $result->referral_guide_number;
                // $entry-> quotation_format = $request['quotation_format'];
                // /**/$entry-> quotation_number = $result->quotation_number;
                $entry-> beta = $request['beta'];
                $entry-> habilita_btn_pago = $result->habilita_btn_pago;
                $entry-> habilita_btn_caja = $result->habilita_btn_caja;
                (isset($request['logo_auth']) && !empty($request['logo_auth'])) ? $entry-> logo_auth = $request['logo_auth'] : $entry-> logo_auth = $result->logo_auth;
                $entry-> pos_logo = $request['pos_logo'];
                (isset($request['logo_pdf']) && !empty($request['logo_pdf'])) ? $entry-> logo_pdf = $request['logo_pdf'] : $entry-> logo_pdf = $result->logo_pdf;
                (isset($reques['type_imagen_pdf'])) ? $entry-> type_imagen_pdf = $request['type_imagen_pdf'] : $entry-> type_imagen_pdf = $result->type_imagen_pdf;
                $entry-> advanced_sale = $result->advanced_sale;
                $entry-> tax_icbper = $request['tax_icbper'];
                $entry-> mail_incidents = $request['mail_incidents'];
                $entry-> pdf_format = $request['pdf_format'];
                $entry-> type_Print = $request['type_Print'];
                /**/$entry-> summaries_limit = $result->summaries_limit;
                /**/$entry-> ubicacion_XML = $result->ubicacion_XML;
                $entry-> direccion = $request['direccion'];
                $entry-> region = $request['region'];
                $entry-> pais = $request['pais'];
                $entry-> razon_social = $request['razon_social'];
                $entry-> ruc = $request['ruc'];
                $entry-> negocio = $result->negocio;
                $entry-> retencion = $request['retencion'];
                $entry-> gratuito = $request['gratuito'];
                $entry-> detraction= $request['detraction'];
                $entry-> account_bank_number= $request['account_bank_number'];


                if ($request['beta'] == 1) {
                    $entry -> beta_user_sol = $request['beta_user_sol'];
                    $entry -> beta_pass_sol = $request['beta_pass_sol'];
                    $entry -> beta_client_id = $request['beta_client_id'];
                    $entry -> beta_client_pass = $request['beta_client_pass'];
                    $entry -> beta_pass_firma = $request['beta_pass_firma'];

                    $entry -> user_sol = $result -> user_sol;
                    $entry -> pass_sol = $result -> pass_sol;
                    $entry -> client_id = $result -> client_id;
                    $entry -> client_pass = $result -> client_pass;
                    $entry -> pass_firma = $result -> pass_firma;
                } else {
                    $entry -> user_sol = $request['user_sol'];
                    $entry -> pass_sol = $request['pass_sol'];
                    $entry -> client_id = $request['client_id'];
                    $entry -> client_pass = $request['client_pass'];
                    $entry -> pass_firma = $request['pass_firma'];

                    $entry -> beta_user_sol = $result->beta_user_sol;
                    $entry -> beta_pass_sol = $result->beta_pass_sol;
                    $entry -> beta_client_id = $result->beta_client_id;
                    $entry -> beta_client_pass = $result->beta_client_pass;
                    $entry -> beta_pass_firma = $result->beta_pass_firma;
                }

                //ACTUALIZAMOS INFO
                $this->settingRepository->settingEdit($entry);
                //
                $result = $this->settingRepository->find($id);
                return $this->successResponse($result, "El Cliente fue actualizado correctamente", 200);
                    } else{
                return $this->errorResponse("Cliente ingresado no existe", 404);
            }
        }


        catch(\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 422);
        }
    }
}
