<?php 

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Repositories\Interfaces\IDetractionTypeRepository;
use Illuminate\Http\Request;

class DetractionTypeController extends Controller
{
    private $detractionTypeRepository;

    public function __construct(IDetractionTypeRepository $detractionTypeRepository)
    {
        $this->detractionTypeRepository = $detractionTypeRepository;
    }

    public function index()
    {
        // Obtener la lista de tipos de detracción
        $detractionTypes = $this->detractionTypeRepository->get([]);

        // Construir la respuesta
        $response = [
            "result" => "ok",
            "data" => [
                "total" => count($detractionTypes),
                "list" => $detractionTypes
            ],
            "message" => ""
        ];

        // Devolver la respuesta como JSON
        return response()->json($response);
    }

    public function show($id)
    {
        // Obtener el tipo de detracción por su ID
        $detractionType = $this->detractionTypeRepository->find($id);

        if (!$detractionType) {
            // Si no se encuentra el tipo de detracción, devolver una respuesta con un mensaje de error
            $response = [
                "result" => "error",
                "data" => null,
                "message" => "Tipo de detracción no encontrado"
            ];

            return response()->json($response, 404);
        }

        // Construir la respuesta
        $response = [
            "result" => "ok",
            "data" => $detractionType,
            "message" => ""
        ];

        // Devolver la respuesta como JSON
        return response()->json($response);
    }
}