<?php
namespace App\Repositories\Interfaces;

use App\Models\PaymentMethod;
use App\DTOs\PaymentMethods\PaymentMethodCreateDto;
use App\DTOs\PaymentMethods\PaymentMethodUpdateDto;

interface IPaymentMethodRepository
{
    public function paginate(array $request);
    public function find(int $id): ?PaymentMethod;
    public function store(PaymentMethodCreateDto $store): PaymentMethod;
    public function update(PaymentMethodUpdateDto $store): void;
    public function destroy(int $id): void;
}
