<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use App\Repositories\Interfaces\ISettingRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SettingController extends Controller
{
    private $settingRepository="";
    private $errorConnection = "";
    public function __construct(Request $request, ISettingRepository $iSettingRepository)
    {
        if (isset($request['business_information'])) {
            $business_information = $request['business_information'];
            $ruc = $business_information['ruc_number'];
            $this->settingRepository = $iSettingRepository;
            $existe_conexion = $this->setDBClient($ruc);
            if($existe_conexion['error']){
                $this->errorConnection=$existe_conexion['message'];
                return $this->messageError("Se espera un número de RUC válido.", 201); 
            }
        } else {
            $this->errorConnection='Error en la conexión. Se espera número de RUC';
        }
    }
    public function settingList(Request $request)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }
        $response=$this->settingRepository->listSetting();
        return Response()->json($response);
    }

    //
}
