<?php
/**
 * Created by PhpStorm.
 * User: juan
 * Date: 12/1/2021
 * Time: 03:11
 */

namespace App\Http\Controllers;

use Carbon\Carbon;
use GuzzleHttp\Client as HttpClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ExchangeTypeController extends Controller
{
    public function index(){
        return "ello";
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $fecha = (isset($request->fecha ) && !empty($request->fecha))?$request->fecha:"";
        $fecha_inicio = (isset($request->fecha_inicio ) && !empty($request->fecha_inicio))?$request->fecha_inicio:"";
        $fecha_fin = (isset($request->fecha_fin ) && !empty($request->fecha_fin))?$request->fecha_fin:"";

        $tipoCambioEndpoint = config("constantes.api_exchangetype");
        $token = config("constantes.api_rucdni_token");

        if($fecha != ""){
            $dataFecha = DB::table('exchange_type')->where("date","$fecha")->first();
            if($dataFecha != NULL){
                return $this->successResponse($dataFecha, "", 200);
            }
            $tipoConsulta = "/date";
            $data = array(
                'token' => $token,
                'fecha' => $fecha
            );
        }
        else if($fecha_inicio != "" && $fecha_fin != ""){
            $tipoConsulta = "";
            $data = array(
                'fecha_inicio' => $fecha_inicio,
                'fecha_fin' => $fecha_fin,
                'token' => $token
            );
        }else{
            $dataFecha = DB::table('exchange_type')->where("date",Carbon::now()->format('Y-m-d'))->first();
            if($dataFecha != NULL){
                return $this->successResponse($dataFecha, "", 200);
            }
            $data = array(
                'token' => $token
            );
            $tipoConsulta = "/latest";
        }
        $client = new HttpClient();
        $res = $client->request('POST', $tipoCambioEndpoint.$tipoConsulta, [
            'headers' => [
                'Accept' => 'application/json',
            ],
            'json' => $data,
            'verify' => false
        ]);
        
        $resp_arr = json_decode($res->getBody(), true);
       
        if(isset($resp_arr['success']) ){
            if(isset($resp_arr['data'])){
                foreach ($resp_arr['data'] as $value) {
                    $dataFecha = DB::table('exchange_type')->where("date",$value['fecha'])->first();
                    if($dataFecha == NULL){
                        DB::table('exchange_type')->insert(
                            [
                                'country' => 'PE', 
                                'currency_origin' => 'PEN',
                                'currency_change' => $value['moneda'],
                                'date' => $value['fecha'],
                                'buy' => $value['precio_compra'],
                                'sell' => $value['precio_venta'],
                                'user_created' => 1,
                                'date_created' => Carbon::now(),
                                'status' => 1
                            ]
                        );
                    }
                    
                }
                $dataFechaArray = DB::table('exchange_type')->whereBetween("date",[$fecha_inicio,$fecha_fin])->get();

                return $this->successResponse($dataFechaArray, "", 200);
            }else{
                if($fecha == ""){
                    if(Carbon::now()->format('Y-m-d') == $resp_arr['fecha']){
                        $id = DB::table('exchange_type')->insertGetId(
                            [
                                'country' => 'PE', 
                                'currency_origin' => 'PEN',
                                'currency_change' => $resp_arr['moneda'],
                                'date' => $resp_arr['fecha'],
                                'buy' => $resp_arr['precio_compra'],
                                'sell' => $resp_arr['precio_venta'],
                                'user_created' => 1,
                                'date_created' => Carbon::now(),
                                'status' => 1
                            ]
                        );
                        $dataFecha = DB::table('exchange_type')->where("id",$id)->first();
                        return $this->successResponse($dataFecha, "", 200);
                    }else{
                        $dataFecha = DB::table('exchange_type')->where("date",$resp_arr['fecha'])->first();
                        if($dataFecha){
                            return $this->successResponse($dataFecha, "", 200);
                        }else{
                            $id = DB::table('exchange_type')->insertGetId(
                                [
                                    'country' => 'PE', 
                                    'currency_origin' => 'PEN',
                                    'currency_change' => $resp_arr['moneda'],
                                    'date' => $resp_arr['fecha'],
                                    'buy' => $resp_arr['precio_compra'],
                                    'sell' => $resp_arr['precio_venta'],
                                    'user_created' => 1,
                                    'date_created' => Carbon::now(),
                                    'status' => 1
                                ]
                            );
                            $dataFecha = DB::table('exchange_type')->where("id",$id)->first();
                            return $this->successResponse($dataFecha, "", 200);
                        }
                    }

                }else{
                    $id = DB::table('exchange_type')->insertGetId(
                        [
                            'country' => 'PE', 
                            'currency_origin' => 'PEN',
                            'currency_change' => $resp_arr['moneda'],
                            'date' => $resp_arr['fecha'],
                            'buy' => $resp_arr['precio_compra'],
                            'sell' => $resp_arr['precio_venta'],
                            'user_created' => 1,
                            'date_created' => Carbon::now(),
                            'status' => 1
                            ]
                    );
                    $dataFecha = DB::table('exchange_type')->where("id",$id)->first();
                            return $this->successResponse($dataFecha, "", 200);
                }
                
                return $this->successResponse($resp_arr, "", 200);
            }
            
        } else {
            return $this->messageError("No existe tipo de cambio de la fecha.", 201);
        }
            //dd($resp_arr);
            
     }
}