<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSeriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tec_series', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('document_type_id');
            $table->string('serie',4);
            $table->string('correlative',8);
            $table->string('description',200)->nullable();
            $table->boolean('flg_started')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('series');
    }
}
