DELIMITER $$

DROP PROCEDURE IF EXISTS `SP_ADMIN_EDITAR_EMPRESA`$$

CREATE  PROCEDURE SP_ADMIN_EDITAR_EMPRESA(
    /*********ID DE LA EMPRESA A MODIFICAR***********/  
    IN            `pint_id_empresa`                   INT(11),  
    /********************daTOS DE LA PERSONA ,ODIFICADOS*************************/
    IN            `pint_id_tip_doc`                   INT(11), 
    IN            `pvar_num_documento`                VARCHAR(8), 
    IN            `pcha_tip_persona`                  CHAR(1), 
    IN            `pvar_nombres`                      VARCHAR(50), 
    IN            `pvar_ape_paterno`                  VARCHAR(20), 
    IN            `pvar_ape_materno`                  VARCHAR(20), 
    IN            `pvar_ruc`                          VARCHAR(11),
    /*******************DATOS DE LA PERSONA CONTACTO****************************/ 
    IN            `pvar_id_tip_doc_contacto`          VARCHAR(50), 
    IN            `pvar_num_documento_contacto`       VARCHAR(50), 
    IN            `pvar_nombre_contacto`              VARCHAR(50), 
    IN            `pvar_ape_paterno_contacto`         VARCHAR(50), 
    IN            `pvar_ape_materno_contacto`         VARCHAR(50), 
    IN            `pvar_email1_contacto`              VARCHAR(50),
    IN            `pvar_email2_contacto`              VARCHAR(50), 
    IN            `pvar_movil1_contacto`              VARCHAR(15),
  IN            `pvar_movil2_contacto`                VARCHAR(15),
  IN            `pvar_movil3_contacto`                VARCHAR(15), 
    /******************DATOS DE LA EMPRESA**************************************/
    IN            `pvar_direccion`                    VARCHAR(255), 
    IN            `pint_ubigeo`                       INT, 
    IN            `pint_estado`                       INT,  
    /******************USUARIO DE MODIFICACION DE REGISTROS**********************/
    IN            `pvar_user_updated`                 VARCHAR(20)
)
BEGIN
   
    DECLARE        int_count_ruc                      INTEGER                   DEFAULT        0;
    DECLARE        int_count_SubDominio               INTEGER                   DEFAULT        0;
     /*************VARIABLES PARA GUARDAR ID DE LOS ULTIMOS DATOS REGISTRADO EN LAS TABLAS*******/
    DECLARE        int_id_empresa                     INTEGER                   DEFAULT        0;
    DECLARE        int_id_persona                     INTEGER                   DEFAULT        0;
    DECLARE        int_id_pers_contacto               INTEGER                   DEFAULT        0;
    DECLARE        int_id_contacto                    INTEGER                   DEFAULT        0;
    /*********************************************************************************************/
    DECLARE        var_mensaje                        VARCHAR(255)              DEFAULT        "" ;
    -- DECLARE        var_userdb                         VARCHAR(255)              DEFAULT        "" ;
    -- DECLARE        var_passDB                         VARCHAR(255)              DEFAULT        "" ;
    -- DECLARE        var_db                             VARCHAR(255)              DEFAULT        "" ;
    -- DECLARE        var_aleatorio                      VARCHAR(255)              DEFAULT        "" ;
    DECLARE        dat_fecha_actual                   DATETIME                  DEFAULT       (SELECT now());
     
    START TRANSACTION;
    IF((SELECT count(*) FROM empresas where id_empresa=pint_id_empresa and status=1)>0) THEN
    /***************OBTENEMOS EL ID DE LA PERSONA PARA EDITAR***************************/
      set int_id_persona=(select id_persona 
                            from empresas 
                              where id_empresa=pint_id_empresa);
      /**************OBTENEMOS EL ID DE LA PERSONA PERTENECIENTE A CONTACTO**************/
      set int_id_pers_contacto=(select id_persona 
                                    from contactos 
                                      where id_empresa=pint_id_empresa);
      /*************OBTENIENDO EL ID DEL CONTACTO*************************************/
      set int_id_contacto=(select int_id_contacto 
                                       from contactos 
                                          where id_empresa=pint_id_empresa);
      /***********************ACTUALIZAMOS DATOS DE LA PERSONA RELACIOANDA CON LA EMPRESA************************/
      update personas 
            set
              id_tip_doc = pint_id_tip_doc ,          num_documento = pvar_num_documento ,       tip_persona = pcha_tip_persona , 
              nombres    = pvar_nombres ,             ape_paterno   = pvar_ape_paterno ,         ape_materno = pvar_ape_materno , 
              ruc        = pvar_ruc ,                 updated_user  = pvar_user_updated ,        updated_at = dat_fecha_actual 
            where
             id_persona   = int_id_persona ;
      /************ACTUALIZAMOS LOS DATOS DE LA EMPRESA*****************/
      update empresas 
            set
              direccion    = pvar_direccion ,         ubigeo     = pint_ubigeo ,            estado = pint_estado ,          
              updated_user = pvar_user_updated ,      updated_at = dat_fecha_actual 
                
            where
              id_empresa = pint_id_empresa ;
      /*********************aCTUALIZAMOS DATOS DE LA PERSONA CONTACTO********************************************/
       
      update personas 
            set
            id_tip_doc    = pint_id_tip_doc ,               num_documento = pvar_num_documento_contacto ,       nombres = pvar_nombre_contacto, 
            ape_paterno   = pvar_ape_paterno_contacto ,     ape_materno   = pvar_ape_materno_contacto ,         /*ruc = pvar_ruc_contacto ,*/ 
            updated_user  = pvar_user_updated ,             updated_at    = dat_fecha_actual
            
            where
            id_persona = int_id_pers_contacto ;
                   
       /*************ACTUALIZAMOS EL CONTACTO DE LA EMPRESA*********************************/       
      update contactos 
            set 
            email1      = pvar_email1_contacto ,           email2 = pvar_email2_contacto ,        movil1 = pvar_movil1_contacto , 
            movil2      = pvar_movil2_contacto ,           movil3 = pvar_movil3_contacto ,        updated_user = pvar_user_updated ,  
            updated_at  = dat_fecha_actual 
            
            where
            id_contactos = int_id_contacto ;    
      SET var_mensaje= 'Empresa actualizada con exito';
      COMMIT;
    ELSE
     SET var_mensaje='No se encontro la empresa que se desea eliminar';  
     ROLLBACK;
   END IF;
   SELECT var_mensaje as mensaje;   
END$$

DELIMITER ;