DELIMITER $$

DROP PROCEDURE IF EXISTS `SP_ADMIN_AGREGAR_EMPRESAS`$$

CREATE  PROCEDURE SP_ADMIN_AGREGAR_EMPRESAS(
 /****************DATOS´PARA LA TABLA PERSONA*********/
         IN       `pint_id_tip_doc`             INT(11),
         IN       `pvar_num_documento`          VARCHAR(15),
         IN       `pcha_tip_persona`            CHAR(1),
         IN       `pvar_nombres`                VARCHAR(50),
         IN       `pvar_ape_paterno`            VARCHAR(20),
         IN       `pvar_ape_materno`            VARCHAR(20),
         IN       `pvar_ruc`                    VARCHAR(11),   
     /****************************************************/
     /******DATOS PARA TABLA CONTACTO*********************/
         IN       `pvar_id_tip_doc_contacto`    VARCHAR(50),
         IN       `pvar_num_documento_contacto` VARCHAR(50),
         IN       `pvar_nombre_contacto`        VARCHAR(50),
         IN       `pvar_ape_paterno_contacto`   VARCHAR(50),
         IN       `pvar_ape_materno_contacto`   VARCHAR(50),
         IN       `pvar_email1_contacto`         VARCHAR(50),
         IN       `pvar_email2_contacto`         VARCHAR(50),
         IN       `pvar_movil1_contacto`         VARCHAR(15),
         IN       `pvar_movil2_contacto`         VARCHAR(15),
         IN       `pvar_movil3_contacto`         VARCHAR(15),
     /****************************************************/
     /***********DATOS PARA TABLA EMPRESAS****************/
         IN       `pvar_direccion`              VARCHAR(255),
         IN       `pint_ubigeo`                 INTEGER,
         IN       `pvar_subdominio`             VARCHAR(255),
         IN       `pvar_host_db`                VARCHAR(50),
         IN       `pvar_db_sistema`             VARCHAR(50),
         IN       `pvar_user_db`                VARCHAR(50),
         IN       `pvar_password_db`            VARCHAR(50),
         
        -- IN       `pint_ubigeo`                 INTEGER,  
    /******************************************************/
         IN       `pvar_user_created`           VARCHAR(20)/*DATOS DEL REGISTRO*/
)
BEGIN
     DECLARE       int_count_documento      INTEGER              DEFAULT        0;
     DECLARE       int_count_ruc            INTEGER              DEFAULT        0;
     DECLARE       int_count_SubDominio     INTEGER              DEFAULT        0;
     /***VARIABLES PARA GUARDAR ID DE LOS ULTIMOS DATOS REGISTRADO EN LAS TABLAS***/
     DECLARE       int_id_empresa           INTEGER              DEFAULT        0;
     DECLARE       int_id_persona           INTEGER              DEFAULT        0;
     DECLARE       int_id_pers_contacto     INTEGER              DEFAULT        0;
     DECLARE       int_id_contacto          INTEGER              DEFAULT        0;
     DECLARE       int_id_vendedor          INTEGER              DEFAULT        0;
    /******************************************************************************/
     DECLARE       var_mensaje              VARCHAR(255)         DEFAULT        "" ;
     DECLARE       dat_fecha_actual         DATETIME             DEFAULT       (SELECT now());
     
     START TRANSACTION;
     /*****VERIFICAR SI EL RUC Y EL SUBDOMINIO YA EXISTEN******/
        IF(pcha_tip_persona=1)THEN
            IF(pvar_num_documento!= '')THEN
                SET int_count_documento=(SELECT count(*) 
                                            FROM personas
                                                WHERE   num_documento = pvar_num_documento);
            END IF;
            IF(pvar_ruc!= '')THEN
                SET int_count_ruc=(SELECT count(*) 
                                            FROM personas
                                                WHERE  ruc = pvar_ruc);
            END IF;
        ELSE    
            IF(pcha_tip_persona = 2) THEN
                SET int_count_documento=(SELECT count(*) 
                                            FROM personas
                                                WHERE  num_documento = pvar_num_documento);
            END IF;
        END IF;
     
        SET int_count_SubDominio=(SELECT count(*) 
                                    FROM empresas 
                                        WHERE  sub_dominio = pvar_subdominio);
     /*********si el NUMERO DE DOCUMENTO y el subdominio no existen  se crea la nueva empresa***********/
        IF(pcha_tip_persona=1 and int_count_ruc>0)THEN
            set var_mensaje =concat('El ruc ',pvar_ruc, ' Ya existe');
        ELSEIF (pcha_tip_persona=2 and int_count_documento>0) THEN
                set var_mensaje =concat('El ruc ',pvar_num_documento, ' Ya existe');
        ELSE  
            IF(int_count_documento > 0 AND int_count_SubDominio > 0 ) THEN
                set var_mensaje =concat('El numero de documento ',pvar_num_documento,' o el subdominio ',pvar_subdominio,' ya existe ');
            ELSE
                IF (int_count_documento = 0) THEN  
                    IF(int_count_SubDominio = 0)THEN
         /********insertamos en tabla persona*****************/
                        INSERT INTO personas (id_tip_doc,             num_documento,              tip_persona,
                                              nombres,                ape_paterno,                ape_materno,
                                              ruc,                    created_user,               created_at,        
                                              status
                                             )
                                      VALUES(pint_id_tip_doc,         pvar_num_documento,         pcha_tip_persona, 
                                              pvar_nombres,           pvar_ape_paterno,           pvar_ape_materno, 
                                             pvar_ruc,                pvar_user_created,          dat_fecha_actual,   
                                             1
                                            );
                        SET int_id_persona = (SELECT @@identity );
                        
                /**********************INSERTAR EN TABLA EMPRESA***********************/
                        INSERT INTO empresas(id_persona,              direccion,                  ubigeo,
                                             sub_dominio,             db_host,                    db_name,                    
                                             db_usuario,              db_contrasena,              fec_afiliacion,            
                                             flg_reconexion,          estado,                     created_user,
                                             created_at, status
                                            )
                                     VALUES(int_id_persona,           pvar_direccion,             pint_ubigeo,
                                            pvar_subdominio,          pvar_host_db,               pvar_db_sistema,
                                            pvar_user_db,             pvar_password_db,           dat_fecha_actual,
                                            int_id_vendedor,          1,                          pvar_user_created,
                                            dat_fecha_actual,         1
                                          );
                        SET int_id_empresa=(SELECT @@identity);
                /*********************REGISTRO DE PERSONA PARA CONTACTO*********************/
                        INSERT into personas(id_tip_doc,                       num_documento,                       tip_persona,
                                             nombres,                          ape_paterno,                         ape_materno,
                                             ruc,                              created_user,                        created_at,        
                                             status
                                             )
                                      VALUES(pvar_id_tip_doc_contacto,         pvar_num_documento_contacto,         1, 
                                             pvar_nombre_contacto,             pvar_ape_paterno_contacto,           pvar_ape_materno_contacto, 
                                             pvar_ruc,                         pvar_user_created,                   dat_fecha_actual,   
                                             1
                                            );
                        SET int_id_pers_contacto=(SELECT @@identity);
                /********************REGISTRAR EL CONTACTO RELACIONADO CON LA EMPRESA***********************/
                        INSERT INTO contactos(id_persona,              id_empresa,                 email1, 
                                               email2,                   movil1,                    movil2,
                                              movil3,                  created_user,               created_at,  
                                             status
                                            )
                                    VALUES ( int_id_pers_contacto,    int_id_empresa,              pvar_email1_contacto, 
                                             pvar_email2_contacto,    pvar_movil1_contacto,        pvar_movil2_contacto,
                                             pvar_movil3_contacto,    pvar_user_created,           dat_fecha_actual, 
                                            1
                                           );
                        SET int_id_contacto=(SELECT @@identity );
                        IF(int_id_persona=0 OR int_id_empresa=0 OR int_id_contacto=0 OR int_id_pers_contacto=0 )THEN
                          ROLLBACK;
                          SET var_mensaje='Ocurrio un problema al intentar registrar empresa';
                        ELSE
                            COMMIT;
                            SET var_mensaje='Empresa registrado satisfactoriamente';
                        END IF;
                    ELSE
                       set var_mensaje =concat('El subdominio ',pvar_subdominio,' ya existe'); 
                    END IF;
                ELSE
                    set var_mensaje =concat('El numero de documento ',pvar_num_documento, ' Ya existe');   
                END IF;         
            END IF;
        END IF;    
   SELECT var_mensaje;
END$$

DELIMITER ;