<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
	
	public function User_create(Request $request){
		
		$input = $request->all();
		$input['password'] = Hash::make($request->password);
		user::create($input);
		
		return response()->json([
			'res'=> true,
			'message'=> 'Registro ingresado correctamente'
		]);
		
	}
	
	public function login(Request $request){
		$user = User::whereEmail($request->email)->first();
		
		if(!is_null($user) && Hash::check($request->password, $user->password)){
			
			$user->api_token = Str::random(150);
			$user->save();
			
			return response()->json([
				'res'=> true,
				'token'=> $user->api_token,
				'message'=> 'Bienvenido al sistema'
			]);
			
		}else{
			
			return response()->json([
				'res'=> false,
				'message'=> 'cuenta o password incorrectos'
			]);
			
		}
		
	}
	
	public function logout(){
		
		$user = auth::user();
		$user->api_token = null;
		$user->save();
		
		return response()->json([
				'res'=> true,
				'message'=> 'se cerro session'
		]);
		
	}
	
	
}

