<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->group(['prefix' => 'api/v1/'], function ($app) {
   
    $app->group(['prefix' => 'ruc'], function() use ($app){
        $app->get('/', [
            'as' => 'ruc.show',
            'uses' => 'RucController@show'
        ]);
    });

    $app->group(['prefix' => 'dni'], function() use ($app){
        $app->get('/', [
            'as' => 'dni.show',
            'uses' => 'DniController@show'
        ]);
    });

    $app->group(['prefix' => 'serie'], function () use($app){
        $app->get('/', 'SerieController@index');
        $app->get('/{id}', 'SerieController@show');
        $app->post('/', 'SerieController@store');
        $app->put('/{id}','SerieController@update');
        $app->delete('/{id}','SerieController@destroy');
    });
    
    $app->group(['prefix' => 'doc'], function () use($app){
        $app->get('/', 'DocumentController@index');
        $app->get('/{id}/series', 'SerieController@getSeriesDocument');
        $app->get('/{id}', 'DocumentController@show');
    });

    $app->group(['prefix' => 'payment_methods'], function () use ($app) {
        $app->get('/', 'PaymentMethodController@index');
        $app->get('/{id}', 'PaymentMethodController@show');
        $app->post('/', 'PaymentMethodController@store');
        $app->put('/{id}', 'PaymentMethodController@update');
        $app->delete('/{id}', 'PaymentMethodController@destroy');
    });
    
    $app->group(['prefix' => 'paymenttypes'], function () use($app){
        $app->get('/', 'PaymentTypeController@index');
        $app->get('/{id}', 'PaymentTypeController@show');
        $app->post('/', 'PaymentTypeController@store');
        $app->put('/{id}','PaymentTypeController@update');
        $app->delete('/{id}','PaymentTypeController@destroy');
    });

    $app->group(['middleware' => 'auth'], function () use ($app) {

    });
    $app->group(['prefix' => 'exchangetype'], function () use($app){
        //$app->get('/', 'ExchangeTypeController@index');
        $app->get('/', 'ExchangeTypeController@show');
    });
    $app->group(['prefix' => 'ubigeo'], function () use($app){
        //$app->get('/', 'ExchangeTypeController@index');
        $app->get('/departamentos', 'UbigeoController@departamentList');
        $app->get('/provincias', 'UbigeoController@provinceList');
        $app->get('/distritos', 'UbigeoController@districtList');
    });
    $app->group(['prefix' => 'settings'], function () use($app){
        $app->get('/', 'SettingController@settingList');
    });

    //grupo de rutas para catalogos de sunat
    $app->group(['prefix' => 'catalogos_sunat'], function () use ($app) {
        $app->get('tipo_afectacion', ['uses' => 'AffectationTypeController@index']);
        $app->get('tipo_afectacion/{id}', ['uses' => 'AffectationTypeController@show']);
    });
});