<?php
namespace App\Repositories\Interfaces;

use App\Models\Supplier;
use App\DTOs\Supplier\SupplierCreateDto;
use App\DTOs\Supplier\SupplierUpdateDto;

interface ISupplierRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Supplier;
    public function store(SupplierCreateDto $store): Supplier;
    public function update(SupplierUpdateDto $store): void;
    public function destroy(int $id): void;
}
