<?php
namespace App\Repositories\Interfaces;

use App\Models\PurchaseOrderHeader;
use App\DTOs\PurchaseOrder\PurchaseOrderCreateDto;
use App\DTOs\PurchaseOrder\PurchaseOrderUpdateDto;

interface IPurchaseOrderRepository
{
    public function paginate(array $request);
    public function find(int $id, string $ruc): ?PurchaseOrderHeader;
    public function store(PurchaseOrderCreateDto $store): PurchaseOrderHeader;
    public function update(PurchaseOrderUpdateDto $store): void;
    public function change_estado(int $id): void;
    public function destroy(int $id): void;
}
