<?php
namespace App\Providers;

use App\Repositories\Interfaces\IPurchaseOrderRepository;
use App\Repositories\SupplierRepository;
use Illuminate\Support\ServiceProvider;
use App\Repositories\Interfaces\ISupplierRepository;
use App\Repositories\PurchaseOrderRepository;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(ISupplierRepository::class, SupplierRepository::class);
        $this->app->bind(IPurchaseOrderRepository::class, PurchaseOrderRepository::class);
    }
}
