<?php
namespace App\Repositories;

use Exception;
use App\Models\Supplier;
use App\DTOs\Supplier\SupplierCreateDto;
use App\DTOs\Supplier\SupplierUpdateDto;
use App\Repositories\Interfaces\ISupplierRepository;

class SupplierRepository implements ISupplierRepository
{
    public function paginate(array $request)
    {
        if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];

            if (isset($request['search'])) {
                $search = $request['search'];
    
                return Supplier::orderBy($orderBy, $orderDir)
                    //->where('warehouse', 'like', '%'.$search.'%')
                    ->skip($start)
                    ->take($length)
                    ->get();
            } else {
                return Supplier::orderBy($orderBy, $orderDir)
                    ->skip($start)
                    ->take($length)
                    ->get();
            }            
        } else {
            return Supplier::get();
        }               
    }

    public function find(int $id): ?Supplier
    {
        return Supplier::find($id);
    }

    public function store(SupplierCreateDto $store): Supplier
    {
        $entry = new Supplier();

        /*$entry->code = $store->code;*/

        $entry->save();

        return $entry;
    }

    public function update(SupplierUpdateDto $store): void
    {
        $entry = Supplier::find($store->id);

        /*$entry->code = $store->code;*/

        $entry->save();
    }

    public function destroy(int $id): void
    {
        Supplier::destroy($id);
    }
}
