<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTecWarehouseguideDetailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tec_warehouseguide_detail', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->integer("warehouseguide_id")->unsigned();
            $table->integer("product_id")->unsigned();
            $table->string('name')->nullable();
            $table->integer('quantity')->unsigned()->nullable();
            $table->decimal('price', 10, 2)->default(0)->nullable();
            $table->decimal('price_inc', 10, 2)->default(0)->nullable();
            $table->decimal('total', 10, 2)->default(0)->nullable();
            $table->decimal('avgdiscount', 8, 2)->default(0)->nullable();
            $table->string('lote')->nullable();
            $table->text('observation')->nullable();
            $table->date('production_date')->nullable();
            $table->date('expiration_date')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tec_warehouseguide_detail');
    }
}
