<?php
namespace App\Repositories;

use App\DTOs\PriceProduct\PriceProductCreateDto;
use Exception;
use App\Models\Product;
use App\DTOs\Products\ProductCreateDto;
use App\DTOs\Products\ProductUpdateDto;
use App\Models\PrecioProductoPorTipoCliente;
use App\Repositories\Interfaces\IProductRepository;
use Illuminate\Support\Facades\DB;

class ProductRepository implements IProductRepository
{
    public function paginate(array $request)
    {
        if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length'])) || (isset($request['filters']))) {
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];

            $orderBy = "id";
            if (isset($request['orderby']) && !empty($request['orderby'])) {
                $orderBy = $request['orderby'];
            }

            $orderDir = "asc";
            if (isset($request['orderdir']) && !empty($request['orderdir'])) {
                $orderDir = $request['orderdir'];
            }

            $start = "";
            if (isset($request['start']) && !empty($request['start'])) {
                $start = $request['start'];
            }

            $length = "";
            if (isset($request['length']) && !empty($request['length'])) {
                $length = $request['length'];
            }

            $search = '';

            if (isset($request['search'])) {
                $search = $request['search'];
            }
            $query = Product::select("tec_products.id","tec_products.code","tec_products.name","tec_products.category_id","tec_products.currency","tec_products.price","tec_products.image","tec_products.cost","tec_products.tax_method","tec_products.quantity","tec_products.type","tec_products.alert_quantity","tec_products.maker_id","tec_products.presentation","tec_products.barcode_symbology")
                ->orderBy('tec_products.'.$orderBy, $orderDir)
                ->leftJoin('tec_categories','tec_products.category_id', '=', 'tec_categories.id');

                if (isset($request['filters'])) {
                if (!empty($request['filters']['werehouse_id'])) {
                    $query->where('tec_products.werehouse_id', '=', $request['filters']['werehouse_id']);
                }

                if (!empty($request['filters']['category_id'])) {
                    $query->where('tec_products.category_id', '=', $request['filters']['category_id']);
                }
            }
            if (!empty($search)) {
                $query->where(function ($subquery) use ($search) {
                    $subquery->where('tec_products.code', 'like', '%'.$search.'%')
                    ->orWhere('tec_products.name', 'like', '%'.$search.'%')
                    ->orWhere('tec_categories.name', 'like', '%'.$search.'%');
                });
            }

            $product_count = $query->where('tec_products.estado', '=', 1)->count();
            if (!empty($start)) {
                $query->skip($start);
            }
            if (!empty($length)) {
                $query->take($length);
            }

            $rs = $query->where('tec_products.estado',1)->get();

            $result['list']=$rs;
            $result['total']=$product_count;
            return $result;
        } else {
            return Product::get();
        }
    }

    public function find(int $id): ?Product
    {
        return Product::find($id);
    }

    public function store(ProductCreateDto $store): Product
    {
        $entry = new Product();

        $entry->code = $store->code;
        $entry->name = $store->name;
        $entry->short_name = $store->short_name;
        $entry->requires_lot_number = $store->requires_lot_number;
        $entry->requires_serial_number = $store->requires_serial_number;
        $entry->brand_id = $store->brand_id;
        $entry->model_id = $store->model_id;
        $entry->unit_measure_id = $store->unit_measure_id;
        $entry->category_id = $store->category_id;
        $entry->currency = $store->currency;
        $entry->price = $store->price;
        $entry->image = $store->image;
        $entry->tax = $store->tax;
        $entry->cost = $store->cost;
        $entry->tax_method = $store->tax_method;
        $entry->quantity = $store->quantity;
        $entry->barcode_symbology = $store->barcode_symbology;
        $entry->type = $store->type;
        $entry->details = $store->details;
        $entry->alert_quantity = $store->alert_quantity;
        $entry->maker_id = $store->maker_id;
        $entry->custom_field_1 = $store->custom_field_1;
        $entry->custom_field_2 = $store->custom_field_2;
        $entry->custom_field_3 = $store->custom_field_3;
        $entry->presentation = $store->presentation;
        $entry->estado = $store->estado;
        $entry->uCrea = $store->uCrea;
        $entry->fCrea = $store->fCrea;

        $entry->save();

        return $entry;
    }

    public function update(ProductUpdateDto $store): void
    {
        $entry = Product::find($store->id);

        $entry->code = $store->code;
        $entry->name = $store->name;
        $entry->short_name = $store->short_name;
        $entry->requires_lot_number = $store->requires_lot_number;
        $entry->requires_serial_number = $store->requires_serial_number;
        $entry->brand_id = $store->brand_id;
        $entry->model_id = $store->model_id;
        $entry->unit_measure_id = $store->unit_measure_id;
        // $entry->category_id = $store->category_id;
        $entry->currency = $store->currency;
        $entry->price = $store->price;
        $entry->image = $store->image;
        $entry->tax = $store->tax;
        $entry->cost = $store->cost;
        $entry->tax_method = $store->tax_method;
        $entry->quantity = $store->quantity;
        $entry->barcode_symbology = $store->barcode_symbology;
        $entry->type = $store->type;
        $entry->details = $store->details;
        $entry->alert_quantity = $store->alert_quantity;
        $entry->maker_id = $store->maker_id;
        $entry->custom_field_1 = $store->custom_field_1;
        $entry->custom_field_2 = $store->custom_field_2;
        $entry->custom_field_3 = $store->custom_field_3;
        $entry->presentation = $store->presentation;
        $entry->estado = $store->estado;
        $entry->uActualiza = $store->uActualiza;
        $entry->fActualiza = $store->fActualiza;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        Product::destroy($id);
    }
    public function  priceProductByCustomersTypeList(array $request, string $ruc){

        $producto_id = $request['product_id']; // Reemplaza 1 por el ID del producto que tengas como parámetro
        $result = DB::connection('mysql_client')
            ->table('tec_customers_type')
            ->select(
                'tec_products.id as producto_id',
                'tec_products.name as producto_nombre',
                'tec_customers_type.id as customer_type_id',
                'tec_customers_type.customers_type as tipo_cliente',
                DB::raw('COALESCE(tec_price_product_by_customer_type.price, tec_products.price) as price')
            )
            ->leftJoin('tec_price_product_by_customer_type', function ($join) use ($producto_id) {
                $join->on('tec_customers_type.id', '=', 'tec_price_product_by_customer_type.customer_type_id')
                    ->on('tec_price_product_by_customer_type.product_id', '=', DB::raw($producto_id));
            })
            ->join('tec_products', 'tec_products.id', '=', DB::raw($producto_id))
            ->where('tec_customers_type.ruc',$ruc)
            ->where('tec_customers_type.status',1)
            ->orderBy('tec_customers_type.customers_type','ASC')
            ->get();

        return $result;

    }


    public function  priceProductByCustomersTypeStore(PriceProductCreateDto $storePrice): PrecioProductoPorTipoCliente
    {
        $product_id = $storePrice->product_id;
        $customer_type_id = $storePrice->customer_type_id;

        // Verifica si ya existe un registro con el mismo product_id y customer_type_id
        $entry = PrecioProductoPorTipoCliente::where('product_id', $product_id)
                        ->where('customer_type_id', $customer_type_id)
                        ->first();
        if(!$entry){
            $entry = new PrecioProductoPorTipoCliente();
            $entry->created_by = $storePrice->created_by;
            $entry->created_at = $storePrice->created_at;
        }else{
            $entry->updated_by = $storePrice->created_by;
            $entry->updated_at = $storePrice->created_at;
        }
        $entry->ruc = $storePrice->ruc;
        $entry->product_id = $storePrice->product_id;
        $entry->customer_type_id = $storePrice->customer_type_id;
        $entry->price = $storePrice->price;
        $entry->status = $storePrice->status;

        $entry->save();

        return $entry;
    }
    public function priceProductByCustomersTypeFind(int $product_id,int $customer_type_id,string $ruc_business){
        $result = DB::connection('mysql_client')
            ->table('tec_customers_type')
            ->select(
                'tec_products.id as producto_id',
                'tec_products.name as producto_nombre',
                'tec_customers_type.id as customer_type_id',
                'tec_customers_type.customers_type as tipo_cliente',
                DB::raw('COALESCE(tec_price_product_by_customer_type.price, tec_products.price) as price')
            )
            ->leftJoin('tec_price_product_by_customer_type', function ($join) use ($product_id) {
                $join->on('tec_customers_type.id', '=', 'tec_price_product_by_customer_type.customer_type_id')
                    ->on('tec_price_product_by_customer_type.product_id', '=', DB::raw($product_id));
            })
            ->join('tec_products', 'tec_products.id', '=', DB::raw($product_id))
            ->where('tec_customers_type.ruc',$ruc_business)
            ->where('tec_customers_type.id',$customer_type_id)
            ->where('tec_customers_type.status',1)
            ->orderBy('tec_customers_type.customers_type','ASC')
            ->first();

        return $result;

    }
}
