<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\DTOs\WarehouseGuide\WarehouseGuideDetailCreateDto;
use App\DTOs\WarehouseGuide\WarehouseGuideDetailUpdateDto;
use App\Repositories\Interfaces\IWarehouseGuideDetailRepository;
use Illuminate\Support\Facades\Log;

class WarehouseGuideDetailController extends Controller
{

    private $warehouseguidedetailRepository;
    private $errorConnection = "";

    public function __construct(Request $request, IWarehouseGuideDetailRepository $warehouseguidedetailRepository)
    {
        if (isset($request['business_information'])) {
            $business_information = $request['business_information'];
            $ruc = $business_information['ruc_number'];

            $existe_conexion = $this->setDBClient($ruc);

            if($existe_conexion['error']){
                $this->errorConnection=$existe_conexion['message'];
                return $this->messageError("Se espera un número de RUC válido.", 201); 
            } else {
                $this->warehouseguidedetailRepository = $warehouseguidedetailRepository;
            }
        } else {
            $this->errorConnection='Error en la conexión. Se espera número de RUC';
        }
    }

    public function index(Request $request)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }

        $result = $this->warehouseguidedetailRepository->paginate($request->all());    

        if ($result) {
            return $this->successResponse($result, "Detalle de guía encontrados correctamente", 201);
        } else {
            return $this->errorResponse("No hay detalle de la guía", 201);
        }
    }

    public function show(int $id)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }

        $result = $this->warehouseguidedetailRepository->find($id);

        if ($result) {
            return $this->successResponse($result, "Detalle de la guía fue encontrado correctamente", 201);
        } else {
            return $this->errorResponse("Detalle de la guía no fue encontrado", 201);
        }
    }

    public function store(Request $request)
    {
        try {
            if($this->errorConnection != ''){
                return $this->messageError($this->errorConnection, 201); 
            }

            $this->validate($request, [
                /*'code' => 'required|unique:tec_warehouses|max:10',
                'warehouse' => 'required|max:250',
                'address' => 'required|max:200',
                'location' => 'required|max:6',
                'external_guide_serie' => 'required|max:4',
                'external_guide_number' => 'required|max:8',
                'internal_guide_serie' => 'required|max:4',
                'internal_guide_number' => 'required|max:8'*/
            ]);

            Log::debug(json_encode($request->all()));
            $store = new WarehouseGuideDetailCreateDto($request->except('business_information'));
            $result = $this->warehouseguidedetailRepository->store($store);
    
            return $this->successResponse($result, "Detalle de la guía creada correctamente", 201);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        }
    }

    public function update(int $id, Request $request)
    {
        try {
            if($this->errorConnection != ''){
                return $this->messageError($this->errorConnection, 201); 
            }

            $this->validate($request, [
                /*'code' => [
                    'required',
                    Rule::unique('tec_warehouses')->ignore($id),
                    'max:10'
                ],
                'warehouse' => 'required|max:250',
                'address' => 'required|max:200',
                'location' => 'required|max:6',
                'external_guide_serie' => 'required|max:4',
                'external_guide_number' => 'required|max:8',
                'internal_guide_serie' => 'required|max:4',
                'internal_guide_number' => 'required|max:8'*/
            ]);
    
            $data = $request->except('business_information');
            $data['id'] = $id;
    
            $entry = new WarehouseGuideDetailUpdateDto($data);
    
            $this->warehouseguidedetailRepository->update($entry);

            $result = $this->warehouseguidedetailRepository->find($id);

            return $this->successResponse($result, "Detalle de la guía fue actualizado correctamente", 201);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        }
    }

    public function destroy(int $id)
    {
        if($this->errorConnection != ''){
            return $this->messageError($this->errorConnection, 201); 
        }
        
        $result = $this->warehouseguidedetailRepository->find($id);

        if ($result) {
            $this->warehouseguidedetailRepository->destroy($id);

            return $this->successResponse($id, "Detalle de la guía fue eliminado correctamente", 201);    
        } else {
            return $this->errorResponse("Detalle de la guía ingresado no existe", 201);
        }
        
    }    
}
