<?php
namespace App\Repositories\Interfaces;

use App\Models\Warehouse;
use App\DTOs\Warehouses\WarehouseCreateDto;
use App\DTOs\Warehouses\WarehouseUpdateDto;

interface IWarehouseRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Warehouse;
    public function store(WarehouseCreateDto $store): Warehouse;
    public function update(WarehouseUpdateDto $store): void;
    public function destroy(int $id): void;
}
