<?php
namespace App\Repositories\Interfaces;

use App\Models\Product;
use App\DTOs\Products\ProductCreateDto;
use App\DTOs\Products\ProductUpdateDto;

interface IProductRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Product;
    public function store(ProductCreateDto $store): Product;
    public function update(ProductUpdateDto $store): void;
    public function destroy(int $id): void;
}
