<?php
namespace App\Repositories;

use Exception;
use App\Models\Product;
use App\DTOs\Products\ProductCreateDto;
use App\DTOs\Products\ProductUpdateDto;
use App\Repositories\Interfaces\IProductRepository;

class ProductRepository implements IProductRepository
{
    public function paginate(array $request)
    {
        if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];

            if (isset($request['search'])) {
                $search = $request['search'];
    
                return Product::orderBy($orderBy, $orderDir)
                    ->where('code', 'like', '%' . $search . '%')
                    ->orWhere('name', 'like', '%' . $search. '%')
                    ->skip($start)
                    ->take($length)
                    ->get();
            } else {
                return Product::orderBy($orderBy, $orderDir)
                    ->skip($start)
                    ->take($length)
                    ->get();
            }            
        } else {
            return Product::get();
        }               
    }

    public function find(int $id): ?Product
    {
        return Product::find($id);
    }

    public function store(ProductCreateDto $store): Product
    {
        $entry = new Product();

        $entry->code = $store->code;
        $entry->name = $store->name;
        $entry->short_name = $store->short_name;
        $entry->requires_lot_number = $store->requires_lot_number;
        $entry->requires_serial_number = $store->requires_serial_number;
        $entry->brand_id = $store->brand_id;
        $entry->model_id = $store->model_id;
        $entry->unit_measure_id = $store->unit_measure_id;
        $entry->category_id = $store->category_id;
        $entry->currency = $store->currency;
        $entry->price = $store->price;
        $entry->image = $store->image;
        $entry->tax = $store->tax;
        $entry->cost = $store->cost;
        $entry->tax_method = $store->tax_method;
        $entry->quantity = $store->quantity;
        $entry->barcode_symbology = $store->barcode_symbology;
        $entry->type = $store->type;
        $entry->details = $store->details;
        $entry->alert_quantity = $store->alert_quantity;
        $entry->maker_id = $store->maker_id;
        $entry->custom_field_1 = $store->custom_field_1;
        $entry->custom_field_2 = $store->custom_field_2;
        $entry->custom_field_3 = $store->custom_field_3;
        $entry->presentation = $store->presentation;
        $entry->estado = $store->estado;
        $entry->uCrea = $store->uCrea;
        $entry->fCrea = $store->fCrea;

        $entry->save();

        return $entry;
    }

    public function update(ProductUpdateDto $store): void
    {
        $entry = Product::find($store->id);

        $entry->code = $store->code;
        $entry->name = $store->name;
        $entry->short_name = $store->short_name;
        $entry->requires_lot_number = $store->requires_lot_number;
        $entry->requires_serial_number = $store->requires_serial_number;
        $entry->brand_id = $store->brand_id;
        $entry->model_id = $store->model_id;
        $entry->unit_measure_id = $store->unit_measure_id;
        $entry->category_id = $store->category_id;
        $entry->currency = $store->currency;
        $entry->price = $store->price;
        $entry->image = $store->image;
        $entry->tax = $store->tax;
        $entry->cost = $store->cost;
        $entry->tax_method = $store->tax_method;
        $entry->quantity = $store->quantity;
        $entry->barcode_symbology = $store->barcode_symbology;
        $entry->type = $store->type;
        $entry->details = $store->details;
        $entry->alert_quantity = $store->alert_quantity;
        $entry->maker_id = $store->maker_id;
        $entry->custom_field_1 = $store->custom_field_1;
        $entry->custom_field_2 = $store->custom_field_2;
        $entry->custom_field_3 = $store->custom_field_3;
        $entry->presentation = $store->presentation;
        $entry->estado = $store->estado;
        $entry->uActualiza = $store->uActualiza;
        $entry->fActualiza = $store->fActualiza;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        Product::destroy($id);
    }
}
